/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final long ZERO_TIME = System.currentTimeMillis();
    private String resultFile;
    private String nameOfRuns;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final double resolutionInMS;
    private ConcurrentHashMap<RunConfig, Double> startTime = new ConcurrentHashMap();
    private ConcurrentHashMap<AlgorithmRun, Double> endTime = new ConcurrentHashMap();

    public OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae, String resultFile, double resolutionInSeconds, String nameOfRuns) {
        super(tae);
        this.resultFile = resultFile;
        this.nameOfRuns = nameOfRuns;
        this.resolutionInMS = resolutionInSeconds * 1000.0;
    }

    @Override
    public final List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorRunObserver wrappedObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                obs.currentStatus(runs);
                OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.processRuns(runs);
            }
        };
        return this.processRuns(this.tae.evaluateRun(this.processRunConfigs(runConfigs), wrappedObs));
    }

    private final long bucketTime(long time) {
        return (long)((double)((long)((double)time / this.resolutionInMS)) * this.resolutionInMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K extends AlgorithmRun> K processRun(K run) {
        if (run.isRunCompleted()) {
            RunConfig runConfig = run.getRunConfig();
            synchronized (runConfig) {
                if (this.endTime.get(run) == null) {
                    this.endTime.put(run, Math.max(0.0, (double)(this.bucketTime(System.currentTimeMillis()) - this.ZERO_TIME) / 1000.0));
                }
            }
        }
        return run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunConfig processRun(RunConfig rc) {
        RunConfig runConfig = rc;
        synchronized (runConfig) {
            if (this.startTime.get(rc) == null) {
                this.startTime.put(rc, Math.max(0.0, (double)(this.bucketTime(System.currentTimeMillis()) - this.ZERO_TIME) / 1000.0));
            }
        }
        return rc;
    }

    protected final <K extends AlgorithmRun> List<K> processRuns(List<K> runs) {
        for (int i = 0; i < runs.size(); ++i) {
            runs.set(i, this.processRun((AlgorithmRun)runs.get(i)));
        }
        return runs;
    }

    protected final List<RunConfig> processRunConfigs(List<RunConfig> runConfigs) {
        runConfigs = new ArrayList<RunConfig>(runConfigs);
        for (int i = 0; i < runConfigs.size(); ++i) {
            runConfigs.set(i, this.processRun(runConfigs.get(i)));
        }
        return runConfigs;
    }

    @Override
    public final void evaluateRunsAsync(List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback oHandler, final TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){
            private final TargetAlgorithmEvaluatorCallback handler;
            {
                this.handler = oHandler;
            }

            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                runs = OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.processRuns(runs);
                this.handler.onSuccess(runs);
            }

            @Override
            public void onFailure(RuntimeException t) {
                this.handler.onFailure(t);
            }
        };
        TargetAlgorithmEvaluatorRunObserver wrappedObs = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                OutstandingRunLoggingTargetAlgorithmEvaluatorDecorator.this.processRuns(runs);
                if (obs != null) {
                    obs.currentStatus(runs);
                }
            }
        };
        this.tae.evaluateRunsAsync(this.processRunConfigs(runConfigs), myHandler, wrappedObs);
    }

    @Override
    public void notifyShutdown() {
        StartEnd e;
        this.tae.notifyShutdown();
        this.log.debug("Processing detailed run statistics to {} ", (Object)this.resultFile);
        if (this.startTime.size() > this.endTime.size()) {
            this.log.warn("Some runs are still outstanding, it is possible that we are shutting down prematurely, started: {} , finished: {}", (Object)this.startTime.size(), (Object)this.endTime.size());
        }
        if (this.startTime.size() < this.endTime.size()) {
            for (Map.Entry<RunConfig, Double> entry : this.startTime.entrySet()) {
                this.log.error("At " + entry.getValue() + " : " + entry.getKey() + " started.");
            }
            for (Map.Entry<Serializable, Double> entry : this.endTime.entrySet()) {
                this.log.error("At " + entry.getValue() + " : " + ((AlgorithmRun)entry.getKey()).getRunConfig() + " ended. ");
            }
            throw new IllegalStateException("[BUG]: Determined that more algorithms ended " + this.endTime.size() + " than started " + this.startTime.size());
        }
        ConcurrentSkipListMap<Double, StartEnd> startEndMap = new ConcurrentSkipListMap<Double, StartEnd>();
        for (Double d : this.startTime.values()) {
            e = (StartEnd)startEndMap.get(d);
            if (e != null) continue;
            startEndMap.put(d, new StartEnd());
        }
        for (Double d : this.endTime.values()) {
            e = (StartEnd)startEndMap.get(d);
            if (e != null) continue;
            startEndMap.put(d, new StartEnd());
        }
        for (Map.Entry<RunConfig, Double> entry : this.startTime.entrySet()) {
            ++((StartEnd)startEndMap.get((Object)entry.getValue())).start;
        }
        for (Map.Entry<AlgorithmRun, Double> entry : this.endTime.entrySet()) {
            ++((StartEnd)startEndMap.get((Object)entry.getValue())).end;
        }
        File file = new File(this.resultFile);
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("Time, Started, Ending, Number of " + this.nameOfRuns + "  Runs\n");
            int outstanding = 0;
            for (Map.Entry ent : startEndMap.entrySet()) {
                fileWriter.write(ent.getKey() + "," + ((StartEnd)ent.getValue()).start + "," + ((StartEnd)ent.getValue()).end + "," + (outstanding += ((StartEnd)ent.getValue()).start - ((StartEnd)ent.getValue()).end) + ",\n");
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        this.log.debug("Processing complete");
    }

    private static class StartEnd {
        public int start = 0;
        public int end = 0;

        private StartEnd() {
        }
    }
}

