/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.concurrent.ReducableSemaphore;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final ReducableSemaphore outstandingRunBlocks = new ReducableSemaphore(1);
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        try {
            this.logReduce(runConfigs);
            this.preRun(runConfigs);
            List<AlgorithmRun> runs = this.tae.evaluateRun(runConfigs, obs);
            this.postRun(runConfigs);
            List<AlgorithmRun> list = runs;
            return list;
        }
        finally {
            this.logRelease(runConfigs);
        }
    }

    private void logReduce(List<RunConfig> runConfigs) {
        this.outstandingRunBlocks.reducePermits();
        if (this.log.isTraceEnabled()) {
            RunConfig rc = null;
            if (runConfigs.size() > 0) {
                rc = runConfigs.get(0);
            }
            this.log.trace("Reducing Permits by 1 now for {}, Dirty Read: {}", (Object)rc, (Object)this.outstandingRunBlocks.availablePermits());
        }
    }

    private void logRelease(List<RunConfig> runConfigs) {
        this.outstandingRunBlocks.release();
        if (this.log.isTraceEnabled()) {
            RunConfig rc = null;
            if (runConfigs.size() > 0) {
                rc = runConfigs.get(0);
            }
            this.log.trace("Releasing Permits by 1 now for {}, Dirty Read: {}", (Object)rc, (Object)this.outstandingRunBlocks.availablePermits());
        }
    }

    @Override
    public void evaluateRunsAsync(final List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        this.logReduce(runConfigs);
        this.preRun(runConfigs);
        TargetAlgorithmEvaluatorCallback callback = new TargetAlgorithmEvaluatorCallback(){
            AtomicBoolean bool = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.postRun(runConfigs);
                handler.onSuccess(runs);
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (!this.bool.get()) {
                        this.bool.set(true);
                        OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.logRelease(runConfigs);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(RuntimeException t) {
                try {
                    OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.postRun(runConfigs);
                    handler.onFailure(t);
                }
                finally {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (!this.bool.get()) {
                            this.bool.set(true);
                            OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.this.logRelease(runConfigs);
                        }
                    }
                }
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, callback, obs);
    }

    @Override
    public synchronized void waitForOutstandingEvaluations() {
        try {
            this.outstandingRunBlocks.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        this.outstandingRunBlocks.release();
    }

    @Override
    public synchronized int getNumberOfOutstandingEvaluations() {
        return 1 - this.outstandingRunBlocks.availablePermits();
    }

    protected void preRun(List<RunConfig> runConfigs) {
    }

    protected void postRun(List<RunConfig> runConfigs) {
    }
}

