/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.preloaded;

import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.associatedvalue.AssociatedValue;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractTargetAlgorithmEvaluatorFactory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.preloaded.PreloadedResponseTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.preloaded.PreloadedResponseTargetAlgorithmEvaluatorOptions;
import java.util.LinkedList;

public class PreloadedResponseTargetAlgorithmEvaluatorFactory
extends AbstractTargetAlgorithmEvaluatorFactory {
    @Override
    public String getName() {
        return "PRELOADED";
    }

    @Override
    public TargetAlgorithmEvaluator getTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, AbstractOptions obs) {
        LinkedList<AssociatedValue<RunResult, Double>> myQueue = new LinkedList<AssociatedValue<RunResult, Double>>();
        PreloadedResponseTargetAlgorithmEvaluatorOptions opts = (PreloadedResponseTargetAlgorithmEvaluatorOptions)obs;
        for (String response : opts.preloadedResponses.split(",")) {
            if ((response = response.trim()).length() == 0) continue;
            if (response.length() < 2) {
                throw new IllegalArgumentException("Invalid Preloaded Response: " + response);
            }
            if (!response.substring(0, 1).equals("[")) {
                throw new IllegalArgumentException("Invalid Preloaded Response: " + response);
            }
            if (!response.substring(response.length() - 1).equals("]")) {
                throw new IllegalArgumentException("Invalid Preloaded Response: " + response);
            }
            String[] val = (response = response.substring(1, response.length() - 1)).split("=");
            if (val.length != 2) {
                throw new IllegalArgumentException("Invalid Preloaded Response: " + response);
            }
            RunResult result = RunResult.getAutomaticConfiguratorResultForKey(val[0].trim());
            double value = Double.valueOf(val[1].trim());
            myQueue.add(new AssociatedValue<RunResult, Double>(result, value));
        }
        return new PreloadedResponseTargetAlgorithmEvaluator(execConfig, myQueue, opts);
    }

    @Override
    public AbstractOptions getOptionObject() {
        return new PreloadedResponseTargetAlgorithmEvaluatorOptions();
    }
}

