/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TestCase {
    public static void main(String[] args) throws Exception, InterruptedException {
        final Process p = Runtime.getRuntime().exec("/home/sjr/git/AutomaticConfiguratorLibrary/test-files/runsolver/system");
        final Semaphore stdErrorDone = new Semaphore(0);
        final CountDownLatch stdErrorStarted = new CountDownLatch(0);
        stdErrorStarted.countDown();
        Runnable standardErrorReader = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    stdErrorStarted.countDown();
                    Scanner procErr = new Scanner(p.getErrorStream());
                    while (procErr.hasNext()) {
                        System.out.println("[PROCESS-ERR] " + procErr.nextLine());
                    }
                    procErr.close();
                }
                finally {
                    stdErrorDone.release();
                }
            }
        };
        ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
        ExecutorService se = Executors.newCachedThreadPool();
        final AtomicBoolean shutdown = new AtomicBoolean(false);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    stdErrorStarted.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                System.out.println("Calling destroy");
                p.destroy();
                shutdown.set(true);
                System.out.println("Process destroyed return value " + p.exitValue());
                System.out.println("Streams closed");
            }
        };
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        se.submit(standardErrorReader);
        ses.schedule(run, 4L, TimeUnit.SECONDS);
        System.out.println("Starting input reading ");
        try {
            String line;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
            while (!shutdown.get()) {
                if (in.ready()) {
                    line = in.readLine();
                    System.out.println(line);
                    continue;
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        in.readLine();
        System.out.println("Done reading input");
        System.out.println("Standard Error Closed");
        se.shutdownNow();
        ses.shutdownNow();
        se.awaitTermination(24L, TimeUnit.HOURS);
        System.out.println("DONE");
    }
}

