/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.blackhole;

import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractAsyncTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.blackhole.BlackHoleTargetAlgorithmEvaluatorOptions;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BlackHoleTargetAlgorithmEvaluator
extends AbstractAsyncTargetAlgorithmEvaluator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BlackHoleTargetAlgorithmEvaluatorOptions options;

    public BlackHoleTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, BlackHoleTargetAlgorithmEvaluatorOptions options) {
        super(execConfig);
        this.options = options;
        if (options.warnings) {
            this.log.warn("Blackhole Target Algorithm Evaluator actually just drops runs so your application is probably just going to hang. ");
        }
    }

    @Override
    public void notifyShutdown() {
    }

    @Override
    public boolean isRunFinal() {
        return false;
    }

    @Override
    public boolean areRunsPersisted() {
        return false;
    }

    @Override
    public boolean areRunsObservable() {
        return false;
    }

    @Override
    public void evaluateRunsAsync(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorCallback taeCallback, TargetAlgorithmEvaluatorRunObserver runStatusObserver) {
        if (this.options.warnings) {
            this.log.warn("Blackhole has silently dropped a set of {} runs ", (Object)runConfigs.size());
        }
    }
}

