/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.analytic;

import java.util.List;

public enum AnalyticFunctions {
    ZERO("xN in R for all N, y = 0"),
    ADD("xN = 0, for all N, y = 0"),
    CAMELBACK("(x0,x1) = (-0.0898, 0.7126) & (0,0898, -0.7126), xN , N > 2 are all ignored,y=3.9684 (because it is shifted by 5)"),
    BRANINS("(x0,x1) = (-pi, 12.275) & (pi , 2.275) & (9,42478, 2.475), xN, N > 2 are all ignored, y = 0.397887");

    double BRANIN_A = 1.0;
    double BRANIN_B = 0.12918450914398066;
    double BRANIN_C = 1.5915494309189535;
    double BRANIN_D = 6.0;
    double BRANIN_E = 10.0;
    double BRANIN_F = 0.039788735772973836;
    private String minima;

    private AnalyticFunctions(String minima) {
        this.minima = minima;
    }

    public double evaluate(List<Double> xVals) {
        double[] myXVals = new double[xVals.size()];
        for (int i = 0; i < xVals.size(); ++i) {
            myXVals[i] = xVals.get(i);
        }
        return this.evaluate(myXVals);
    }

    public double evaluate(double[] xVals) {
        switch (this) {
            case CAMELBACK: {
                if (xVals.length < 2) {
                    throw new IllegalArgumentException((Object)((Object)this) + " function requires at least two parameters, x0, x1");
                }
                double x = xVals[0];
                double y = xVals[1];
                return (4.0 - 2.1 * Math.pow(x, 2.0) + Math.pow(x, 4.0) / 3.0) * Math.pow(x, 2.0) + x * y + (-4.0 + 4.0 * Math.pow(y, 2.0)) * Math.pow(y, 2.0) + 5.0;
            }
            case BRANINS: {
                if (xVals.length < 2) {
                    throw new IllegalArgumentException((Object)((Object)this) + " function requires at least two parameters, x0, x1");
                }
                double x = xVals[0];
                double y = xVals[1];
                return this.BRANIN_A * Math.pow(y - this.BRANIN_B * x * x * this.BRANIN_C * x - this.BRANIN_D, 2.0) + this.BRANIN_E * (1.0 - this.BRANIN_F) * Math.cos(x) + this.BRANIN_E;
            }
            case ADD: {
                double sum = 0.0;
                for (double d : xVals) {
                    sum += d;
                }
                return sum;
            }
            case ZERO: {
                return 0.0;
            }
        }
        throw new IllegalStateException((Object)((Object)this) + " not implemented currently");
    }

    public String getMinima() {
        return this.minima;
    }
}

