/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality.OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class AbstractTargetAlgorithmEvaluator
implements TargetAlgorithmEvaluator {
    protected final AlgorithmExecutionConfig execConfig;
    protected final AtomicInteger runCount = new AtomicInteger(0);

    public AbstractTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig) {
        this.execConfig = execConfig;
    }

    @Override
    public abstract List<AlgorithmRun> evaluateRun(List<RunConfig> var1, TargetAlgorithmEvaluatorRunObserver var2);

    @Override
    public abstract void evaluateRunsAsync(List<RunConfig> var1, TargetAlgorithmEvaluatorCallback var2, TargetAlgorithmEvaluatorRunObserver var3);

    @Override
    public final List<AlgorithmRun> evaluateRun(RunConfig run) {
        return this.evaluateRun(Collections.singletonList(run), null);
    }

    @Override
    public final List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        return this.evaluateRun(runConfigs, null);
    }

    @Override
    public final void evaluateRunsAsync(RunConfig runConfig, TargetAlgorithmEvaluatorCallback handler) {
        this.evaluateRunsAsync(Collections.singletonList(runConfig), handler);
    }

    @Override
    public final void evaluateRunsAsync(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorCallback handler) {
        this.evaluateRunsAsync(runConfigs, handler, null);
    }

    @Override
    public int getRunCount() {
        return this.runCount.get();
    }

    @Override
    public int getRunHash() {
        return 0;
    }

    @Override
    public void seek(List<AlgorithmRun> runs) {
        this.runCount.set(runs.size());
    }

    protected void addRuns(List<AlgorithmRun> runs) {
        this.runCount.addAndGet(runs.size());
    }

    @Override
    public String getManualCallString(RunConfig runConfig) {
        StringBuilder sb = new StringBuilder();
        String commandSeparator = ";";
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            commandSeparator = "&";
        }
        if (this.execConfig.getAlgorithmExecutionDirectory().matches(".*\\s.*")) {
            sb.append("cd \"").append(this.execConfig.getAlgorithmExecutionDirectory()).append("\"" + commandSeparator + " ");
        } else {
            sb.append("cd ").append(this.execConfig.getAlgorithmExecutionDirectory()).append(commandSeparator + " ");
        }
        sb.append(CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.execConfig, runConfig));
        sb.append("");
        return sb.toString();
    }

    @Override
    public void waitForOutstandingEvaluations() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    @Override
    public int getNumberOfOutstandingEvaluations() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }
}

