/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.runconfig;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import java.io.Serializable;

public class RunConfig
implements Serializable {
    private static final long serialVersionUID = 7749039021874017859L;
    private final ProblemInstanceSeedPair pisp;
    private final double cutoffTime;
    private final ParamConfiguration params;
    private final boolean cutoffLessThanMax;

    public RunConfig(ProblemInstanceSeedPair pisp, double cutoffTime, ParamConfiguration config) {
        if (pisp == null) {
            throw new IllegalArgumentException("AlgorithmInstanceSeedPair cannot be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Params cannot be null");
        }
        if (cutoffTime < 0.0) {
            throw new IllegalArgumentException("Cutoff time must be non-negative positive");
        }
        this.pisp = pisp;
        this.cutoffTime = cutoffTime;
        this.params = config;
        this.cutoffLessThanMax = false;
    }

    public RunConfig(ProblemInstanceSeedPair pisp, double cutoffTime, ParamConfiguration params, boolean cutoffLessThanMax) {
        if (pisp == null) {
            throw new IllegalArgumentException("ProblemInstanceSeedPair Name cannot be null");
        }
        if (cutoffTime < 0.0) {
            throw new IllegalArgumentException("Cutoff time must be non-negative positive");
        }
        if (params == null) {
            throw new IllegalArgumentException("ParamString cannot be null");
        }
        this.pisp = pisp;
        this.cutoffTime = cutoffTime;
        this.params = params;
        this.cutoffLessThanMax = cutoffLessThanMax;
    }

    public ProblemInstanceSeedPair getProblemInstanceSeedPair() {
        return this.pisp;
    }

    public double getCutoffTime() {
        return this.cutoffTime;
    }

    public ParamConfiguration getParamConfiguration() {
        return new ParamConfiguration(this.params);
    }

    public boolean hasCutoffLessThanMax() {
        return this.cutoffLessThanMax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RunConfig) {
            RunConfig oar = (RunConfig)o;
            return this.pisp.equals(oar.pisp) && this.cutoffTime == oar.cutoffTime && this.params.equals(oar.params);
        }
        return false;
    }

    public int hashCode() {
        return this.pisp.hashCode() ^ this.params.hashCode();
    }

    public String toString() {
        int instID = this.getProblemInstanceSeedPair().getInstance().getInstanceID();
        long seed = this.getProblemInstanceSeedPair().getSeed();
        String confID = this.params.getFriendlyIDHex();
        StringBuilder sb = new StringBuilder();
        sb.append("<Instance:" + instID + ", Seed:" + seed + ", Config:" + confID + ", Kappa:" + this.cutoffTime + ">");
        return sb.toString();
    }

    public String getFriendlyRunInfo() {
        int instID = this.getProblemInstanceSeedPair().getInstance().getInstanceID();
        long seed = this.getProblemInstanceSeedPair().getSeed();
        String confID = this.params.getFriendlyIDHex();
        return "Run for Instance (" + instID + ") Config (" + confID + ") Seed: (" + seed + ")";
    }
}

