/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.objectives;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;

public enum RunObjective {
    RUNTIME,
    QUALITY;


    public double getObjective(AlgorithmRun r) {
        switch (this) {
            case RUNTIME: {
                switch (r.getRunResult()) {
                    case TIMEOUT: {
                        return r.getRunConfig().getCutoffTime();
                    }
                    case KILLED: 
                    case RUNNING: 
                    case SAT: 
                    case UNSAT: {
                        return r.getRuntime();
                    }
                    case ABORT: 
                    case CRASHED: {
                        return r.getExecutionConfig().getAlgorithmCutoffTime();
                    }
                }
                throw new IllegalStateException("Unsure how to compute the " + (Object)((Object)this) + " RunOjective for a run with result type " + (Object)((Object)r.getRunResult()));
            }
            case QUALITY: {
                return r.getQuality();
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this) + ": Run Objective Not Implemented");
    }

    public void validateInstanceSpecificInformation(ProblemInstance pi) {
        switch (this) {
            case RUNTIME: 
            case QUALITY: {
                return;
            }
        }
        throw new UnsupportedOperationException(this.toString() + " Run Objective Not Implemented");
    }
}

