/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.options;

import ca.ubc.cs.beta.aclib.misc.options.NoArgumentHandler;
import ca.ubc.cs.beta.aclib.misc.options.OptionLevel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class UsageSection
implements Iterable<String> {
    private final String sectionName;
    private final String sectionBanner;
    private final String sectionDescription;
    private final Map<String, String> attributesToDescriptionMap = new TreeMap<String, String>();
    private final Set<String> requiredAttributes = new HashSet<String>();
    private final Map<String, String> defaultValues = new HashMap<String, String>();
    private final Map<String, String> domainMap = new HashMap<String, String>();
    private final Map<String, String> aliasMap = new HashMap<String, String>();
    private final Map<String, Boolean> hiddenMap = new HashMap<String, Boolean>();
    private final Object object;
    private final boolean hidden;
    private final NoArgumentHandler noargHandler;
    private final boolean converterFileOption;
    private final Map<String, OptionLevel> levelMap = new HashMap<String, OptionLevel>();

    public UsageSection(String sectionName, String sectionBanner, String sectionDescription, boolean hidden, Object object, NoArgumentHandler handler, boolean converterFileOption) {
        this.sectionName = sectionName;
        this.sectionBanner = sectionBanner;
        this.sectionDescription = sectionDescription;
        this.hidden = hidden;
        this.object = object;
        this.noargHandler = handler;
        this.converterFileOption = converterFileOption;
    }

    public Object getObject() {
        return this.object;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public String getSectionBanner() {
        return this.sectionBanner;
    }

    public String getSectionDescription() {
        return this.sectionDescription;
    }

    public void addAttribute(String name, String description, String defaultValue, boolean required, String domain, String allAliases, boolean hidden, OptionLevel level) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        name = name.trim();
        if (description != null) {
            description = description.trim();
        }
        if (defaultValue != null) {
            defaultValue = defaultValue.trim();
        }
        this.attributesToDescriptionMap.put(name, description);
        this.defaultValues.put(name, defaultValue);
        if (required) {
            this.requiredAttributes.add(name);
        }
        this.domainMap.put(name, domain);
        this.aliasMap.put(name, allAliases);
        this.hiddenMap.put(name, hidden);
        this.levelMap.put(name, level);
    }

    @Override
    public Iterator<String> iterator() {
        return this.attributesToDescriptionMap.keySet().iterator();
    }

    public int getNumberOfAttributes() {
        return this.attributesToDescriptionMap.size();
    }

    public boolean isAttributeRequired(String name) {
        return this.requiredAttributes.contains(name);
    }

    public String getAttributeDescription(String name) {
        return this.attributesToDescriptionMap.get(name);
    }

    public String getAttributeDefaultValues(String name) {
        return this.defaultValues.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name:").append(this.sectionName).append("\n");
        sb.append("Description:").append(this.sectionDescription).append("\n");
        for (String s : this) {
            sb.append("\t").append(s).append(" ").append(this.getAttributeDescription(s)).append("\n");
            sb.append("\t");
            if (this.isAttributeRequired(s)) {
                sb.append("[R] ");
            }
            sb.append("Default Value:").append(this.getAttributeDefaultValues(s)).append("\n");
            sb.append("\tAliases:").append(this.getAttributeAliases(s)).append("\n");
            if (this.getAttributeDomain(s).length() > 0) {
                sb.append("\tDomain:").append(this.getAttributeDomain(s)).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getAttributeAliases(String s) {
        return this.aliasMap.get(s);
    }

    public String getAttributeDomain(String s) {
        return this.domainMap.get(s);
    }

    public boolean isSectionHidden() {
        return this.hidden;
    }

    public OptionLevel getAttributeLevel(String s) {
        return this.levelMap.get(s);
    }

    public boolean isAttributeHidden(String name) {
        return this.hiddenMap.get(name);
    }

    public NoArgumentHandler getHandler() {
        return this.noargHandler;
    }

    public boolean isConverterOptionObject() {
        return this.converterFileOption;
    }
}

