/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.math;

import ca.ubc.cs.beta.aclib.misc.math.ArrayMathOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math.stat.StatUtils;
import org.six11.util.math.PCA;

public class MessyMathHelperClass {
    public double[][] getPCA(double[][] matrix, int n) {
        PCA pca = new PCA(matrix);
        List<PCA.PrincipleComponent> pcaComp = pca.getDominantComponents(pca.getNumComponents());
        Object pcaMatrix = new double[pcaComp.size()][];
        int i = 0;
        for (PCA.PrincipleComponent p : pcaComp) {
            pcaMatrix[i] = p.eigenVector;
            ++i;
        }
        pcaMatrix = this.flipxflipy((double[][])pcaMatrix);
        double[][] pcaMatrixFinal = new double[matrix[0].length][Math.min(n, pcaMatrix[0].length)];
        for (int j = 0; j < Math.min(pcaMatrixFinal.length, ((double[][])pcaMatrix).length); ++j) {
            for (int k = 0; k < Math.min(pcaMatrixFinal[j].length, pcaMatrix[j].length); ++k) {
                pcaMatrixFinal[j][k] = pcaMatrix[j][k];
            }
        }
        return pcaMatrixFinal;
    }

    public double[][] flipxflipy(double[][] matrix) {
        double[][] flippedresult = new double[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                flippedresult[i][j] = matrix[matrix.length - i - 1][matrix[0].length - j - 1];
            }
        }
        return flippedresult;
    }

    public double[] getPCACoeff(double[][] matrix, int n) {
        PCA pca = new PCA(matrix);
        List<PCA.PrincipleComponent> pcaComp = pca.getDominantComponents(n);
        double[] pcaMatrix = new double[pcaComp.size()];
        int i = 0;
        for (PCA.PrincipleComponent p : pcaComp) {
            pcaMatrix[i] = p.eigenValue;
            ++i;
        }
        return pcaMatrix;
    }

    public static void main(String[] args) {
        MessyMathHelperClass pca = new MessyMathHelperClass();
        double[][] testscores = new double[][]{{36.0, 62.0, 31.0, 76.0, 46.0, 12.0, 39.0, 30.0, 22.0, 9.0, 32.0, 40.0, 64.0, 36.0, 24.0, 50.0, 42.0, 2.0, 56.0, 59.0, 28.0, 19.0, 36.0, 54.0, 14.0}, {58.0, 54.0, 42.0, 78.0, 56.0, 42.0, 46.0, 51.0, 32.0, 40.0, 49.0, 62.0, 75.0, 38.0, 46.0, 50.0, 42.0, 35.0, 53.0, 72.0, 50.0, 46.0, 56.0, 57.0, 35.0}, {43.0, 50.0, 41.0, 69.0, 52.0, 38.0, 51.0, 54.0, 43.0, 47.0, 54.0, 51.0, 70.0, 58.0, 44.0, 54.0, 52.0, 32.0, 42.0, 70.0, 50.0, 49.0, 56.0, 59.0, 38.0}, {36.0, 46.0, 40.0, 66.0, 56.0, 38.0, 54.0, 52.0, 28.0, 30.0, 37.0, 40.0, 66.0, 62.0, 55.0, 52.0, 38.0, 22.0, 40.0, 66.0, 42.0, 40.0, 54.0, 62.0, 29.0}, {37.0, 52.0, 29.0, 81.0, 40.0, 28.0, 41.0, 32.0, 22.0, 24.0, 52.0, 49.0, 63.0, 62.0, 49.0, 51.0, 50.0, 16.0, 32.0, 62.0, 63.0, 30.0, 52.0, 58.0, 20.0}};
        double[][] result = pca.getPCA(testscores, 7);
        System.out.println(Arrays.deepToString((Object[])testscores));
        System.out.println(Arrays.deepToString((Object[])result));
        System.out.println(Arrays.toString(pca.getPCACoeff(testscores, 7)));
    }

    public double[][] transpose(double[][] matrix) {
        return ArrayMathOps.transpose(matrix);
    }

    public int[][] transpose(int[][] matrix) {
        int[][] transpose = new int[matrix[0].length][matrix.length];
        for (int i = 0; i < transpose.length; ++i) {
            for (int j = 0; j < transpose[0].length; ++j) {
                transpose[i][j] = matrix[j][i];
            }
        }
        return transpose;
    }

    public double[] getRowStdDev(double[][] matrix) {
        double[] stddev = new double[matrix.length];
        for (int i = 0; i < stddev.length; ++i) {
            stddev[i] = Math.sqrt(StatUtils.variance((double[])matrix[i]));
        }
        return stddev;
    }

    public double[] getRowMeans(double[][] matrix) {
        double[] means = new double[matrix.length];
        for (int i = 0; i < means.length; ++i) {
            means[i] = StatUtils.mean((double[])matrix[i]);
        }
        return means;
    }

    public int[] constantColumnsWithMissingValues(double[][] matrix) {
        ArrayList<Integer> constColumnsList = new ArrayList<Integer>();
        for (int j = 0; j < matrix[0].length; ++j) {
            double[] values = new double[matrix.length];
            for (int i = 0; i < matrix.length; ++i) {
                values[i] = matrix[i][j] == -512.0 || matrix[i][j] == -1024.0 ? Double.NaN : matrix[i][j];
            }
            double stdDev = ArrayMathOps.stdDevIgnoreNaNs(values);
            if (Double.isNaN(stdDev)) {
                stdDev = Double.MIN_VALUE;
            }
            if (!(stdDev < Math.pow(10.0, -6.0))) continue;
            constColumnsList.add(j);
        }
        int[] constColumns = new int[constColumnsList.size()];
        for (int i = 0; i < constColumnsList.size(); ++i) {
            constColumns[i] = (Integer)constColumnsList.get(i);
        }
        return constColumns;
    }

    public int[] constantColumns(double[][] matrix) {
        ArrayList<Integer> constColumnsList = new ArrayList<Integer>();
        for (int j = 0; j < matrix[0].length; ++j) {
            HashSet<Double> columnValues = new HashSet<Double>();
            for (int i = 0; i < matrix.length; ++i) {
                columnValues.add(matrix[i][j]);
            }
            if (columnValues.size() != 1 || columnValues.contains(-512.0) || columnValues.contains(-1024.0)) continue;
            constColumnsList.add(j);
        }
        int[] constColumns = new int[constColumnsList.size()];
        for (int i = 0; i < constColumnsList.size(); ++i) {
            constColumns[i] = (Integer)constColumnsList.get(i);
        }
        return constColumns;
    }

    public Set<Integer> fromArray(int[] arr) {
        HashSet<Integer> vals = new HashSet<Integer>();
        for (int i = 0; i < arr.length; ++i) {
            vals.add(arr[i]);
        }
        return vals;
    }

    public double[][] keepColumns(double[][] matrix, int[] columns) {
        Set<Integer> columnsToKeep = this.fromArray(columns);
        ArrayList<Integer> columnsToRemove = new ArrayList<Integer>(matrix[0].length);
        for (int i = 0; i < matrix[0].length; ++i) {
            if (columnsToKeep.contains(i)) continue;
            columnsToRemove.add(i);
        }
        int[] columnsToRemoveArr = new int[columnsToRemove.size()];
        for (int i = 0; i < columnsToRemove.size(); ++i) {
            columnsToRemoveArr[i] = (Integer)columnsToRemove.get(i);
        }
        return this.removeColumns(matrix, columnsToRemoveArr);
    }

    public double[][] removeColumns(double[][] matrix, int[] columns) {
        Object outputMatrix;
        if (matrix.length == 0) {
            outputMatrix = new double[][]{};
        } else if (matrix[0].length == 0) {
            outputMatrix = new double[matrix.length][0];
        } else {
            outputMatrix = new double[matrix.length][matrix[0].length - columns.length];
            int currentColumn = 0;
            Set<Integer> constantColumns = this.fromArray(columns);
            for (int j = 0; j < matrix[0].length; ++j) {
                if (constantColumns.contains(j)) continue;
                for (int i = 0; i < matrix.length; ++i) {
                    outputMatrix[i][currentColumn] = matrix[i][j];
                }
                ++currentColumn;
            }
        }
        return outputMatrix;
    }

    public void log10(double[] responseValues) {
        for (int i = 0; i < responseValues.length; ++i) {
            responseValues[i] = Math.log10(responseValues[i]);
        }
    }

    public int[] getSub(double[] stdDev) {
        ArrayList<Integer> idxs = new ArrayList<Integer>(stdDev.length);
        for (int i = 0; i < stdDev.length; ++i) {
            if (!(stdDev[i] > Math.pow(10.0, -5.0))) continue;
            idxs.add(i);
        }
        int[] subs = new int[idxs.size()];
        for (int i = 0; i < idxs.size(); ++i) {
            subs[i] = (Integer)idxs.get(i);
        }
        return subs;
    }

    public void perColumnOperation(double[][] matrix, double[] rightop, Operation op) {
        if (matrix.length == 0) {
            return;
        }
        if (matrix[0].length != rightop.length) {
            throw new IllegalStateException("Columns in matrix do not equal number of right operands");
        }
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                matrix[i][j] = op.eval(matrix[i][j], rightop[j]);
            }
        }
    }

    public double[][] matrixMultiply(double[][] d1, double[][] d2) {
        if (d1[0].length != d2.length) {
            throw new IllegalArgumentException("Matrix size mismatch " + d1.length + " x " + d1[0].length + " multiplied with " + d2.length + " x " + d2[0].length);
        }
        double[][] outputMatrix = new double[d1.length][d2[0].length];
        for (int i = 0; i < d1.length; ++i) {
            for (int j = 0; j < d2[0].length; ++j) {
                for (int k = 0; k < d2.length; ++k) {
                    double[] dArray = outputMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + d1[i][k] * d2[k][j];
                }
            }
        }
        return outputMatrix;
    }

    public void max(double[] responseValues, double minimumResponseValue) {
        for (int i = 0; i < responseValues.length; ++i) {
            responseValues[i] = Math.max(responseValues[i], minimumResponseValue);
        }
    }

    public static enum Operation {
        ADD(" + "),
        SUBTRACT(" - "),
        MULTIPLY(" x "),
        DIVIDE(" / ");


        private Operation(String s) {
        }

        public double eval(double lop, double rightop) {
            switch (this) {
                case ADD: {
                    return lop + rightop;
                }
                case SUBTRACT: {
                    return lop - rightop;
                }
                case MULTIPLY: {
                    return lop * rightop;
                }
                case DIVIDE: {
                    return lop / rightop;
                }
            }
            throw new IllegalStateException("Java is really stupid, this is UMPOSSIBLE!");
        }
    }
}

