/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.csvhelpers;

import com.beust.jcommander.ParameterException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConfigCSVFileHelper
implements Serializable {
    private static final long serialVersionUID = -9193977861142611700L;
    private final List<String[]> data;
    private final Map<String, Integer> keyIndexMap = new HashMap<String, Integer>();
    private final boolean header;
    private final int dataOffsetFromTop;
    private final int dataOffsetFromLeft;

    public ConfigCSVFileHelper(List<String[]> data) {
        this(data, true);
    }

    public ConfigCSVFileHelper(List<String[]> data, boolean header) {
        this(data, header ? 1 : 0, 0);
    }

    public ConfigCSVFileHelper(List<String[]> data, int dataOffsetFromTop, int dataOffsetFromLeft) {
        for (String[] arr : data) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = arr[i].trim();
            }
        }
        this.data = data;
        this.dataOffsetFromTop = dataOffsetFromTop;
        this.dataOffsetFromLeft = dataOffsetFromLeft;
        boolean bl = this.header = dataOffsetFromTop == 1;
        if (data.size() == 0) {
            throw new ParameterException("Parameter File empty");
        }
        if (this.header) {
            String[] keys = data.get(0);
            for (int i = 0; i < keys.length; ++i) {
                this.keyIndexMap.put(keys[i], i);
            }
        }
    }

    public int getIntegerRawValue(int row, int column) {
        if (this.data.get(row) == null) {
            throw new IllegalArgumentException("Invalid Row");
        }
        return Integer.valueOf(this.data.get(row)[column]);
    }

    public int getIntegerValue(int row, String key) {
        if (this.keyIndexMap.get(key) == null) {
            throw new IllegalArgumentException("Invalid Key");
        }
        return this.getIntegerRawValue(row, this.keyIndexMap.get(key));
    }

    public double getDoubleRawValue(int row, int column) {
        if (this.data.get(row) == null) {
            throw new IllegalArgumentException("Invalid Row");
        }
        return Double.valueOf(this.data.get(row)[column]);
    }

    public double getDoubleValue(int row, String key) {
        if (this.keyIndexMap.get(key) == null) {
            throw new IllegalArgumentException("Invalid Key");
        }
        return this.getDoubleRawValue(row, this.keyIndexMap.get(key));
    }

    public String getStringValue(int row, String key) {
        if (this.keyIndexMap.get(key) == null) {
            throw new IllegalArgumentException("Invalid Key");
        }
        return this.getStringRawValue(row, this.keyIndexMap.get(key));
    }

    public String getStringRawValue(int row, int column) {
        if (this.data.get(row) == null) {
            throw new IllegalArgumentException("Invalid Row");
        }
        return this.data.get(row)[column].trim();
    }

    public String getStringDataValue(int row, int column) {
        return this.getStringRawValue(row + this.dataOffsetFromTop, column + this.dataOffsetFromLeft);
    }

    public String getStringDataValue(int row, String key) {
        int column = this.keyIndexMap.get(key);
        return this.getStringRawValue(row + this.dataOffsetFromTop, column);
    }

    public Integer getIntegerDataValue(int row, int column) {
        return this.getIntegerRawValue(row + this.dataOffsetFromTop, column + this.dataOffsetFromLeft);
    }

    public Double getDoubleDataValue(int row, int column) {
        return this.getDoubleRawValue(row + this.dataOffsetFromTop, column + this.dataOffsetFromLeft);
    }

    public int getIndexOfFirstData() {
        return this.dataOffsetFromTop;
    }

    public int getNumberOfDataRows() {
        return this.data.size() - this.dataOffsetFromTop;
    }

    public int getNumberOfDataColumns() {
        return this.data.get(0).length - this.dataOffsetFromLeft;
    }

    private List<String> getRawColumn(int column) {
        LinkedList<String> results = new LinkedList<String>();
        for (int i = this.dataOffsetFromTop; i < this.data.size(); ++i) {
            results.add(this.data.get(i)[column]);
        }
        return results;
    }

    private int getKeyColumn(String key) {
        if (!this.keyIndexMap.containsKey(key)) {
            throw new IllegalArgumentException("Invalid Key");
        }
        return this.keyIndexMap.get(key);
    }

    public List<String> getColumn(String key) {
        return this.getRawColumn(this.keyIndexMap.get(key));
    }

    public List<String> getDataColumn(int column) {
        return this.getRawColumn(column + this.dataOffsetFromLeft);
    }

    private String[] get(int index) {
        return this.data.get(index);
    }

    public String[] getDataRow(int index) {
        String[] results = this.get(index + this.dataOffsetFromTop);
        return Arrays.copyOfRange(results, this.dataOffsetFromLeft, results.length);
    }

    public int getNumberOfDataColumns(int row) {
        return this.get(row).length - this.dataOffsetFromLeft;
    }

    public String getDataKeyByIndex(int i) {
        return this.get(0)[i + this.dataOffsetFromLeft];
    }

    public String[] getDataKeyList() {
        ArrayList<String> dataList = new ArrayList<String>(this.get(0).length);
        for (int i = this.dataOffsetFromLeft; i < this.get(0).length; ++i) {
            dataList.add(this.get(0)[i].trim());
        }
        return dataList.toArray(new String[0]);
    }

    public List<String> getRowKeys() {
        return this.getRawColumn(0);
    }

    public String getKeyForDataColumn(int col) {
        return this.get(0)[col + this.dataOffsetFromLeft];
    }

    public String getKeyForDataRow(int i) {
        return this.get(i + this.dataOffsetFromTop)[0];
    }

    public int getDataColumnForKey(String key) {
        return this.getKeyColumn(key) - this.dataOffsetFromLeft;
    }
}

