/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrunner;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.algorithmrunner.AbstractAlgorithmRunner;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConcurrentAlgorithmRunner
extends AbstractAlgorithmRunner {
    private int numberOfConcurrentExecutions;
    private static final Logger log = LoggerFactory.getLogger(ConcurrentAlgorithmRunner.class);

    public ConcurrentAlgorithmRunner(AlgorithmExecutionConfig execConfig, List<RunConfig> runConfigs, int numberOfConcurrentExecutions, TargetAlgorithmEvaluatorRunObserver obs, CommandLineTargetAlgorithmEvaluatorOptions options) {
        super(execConfig, runConfigs, obs, options);
        this.numberOfConcurrentExecutions = numberOfConcurrentExecutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<AlgorithmRun> run() {
        log.debug("Creating Thread Pool Supporting " + this.numberOfConcurrentExecutions);
        ExecutorService p = Executors.newFixedThreadPool(this.numberOfConcurrentExecutions);
        try {
            try {
                p.invokeAll(this.runs);
                for (AlgorithmRun run : this.runs) {
                    if (!run.getRunResult().equals((Object)RunResult.ABORT)) continue;
                    throw new TargetAlgorithmAbortException(run);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            p.shutdown();
        }
        return this.runs;
    }
}

