/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrunner;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.algorithmrun.RunningAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.StatusVariableKillHandler;
import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAlgorithmRunner
implements AlgorithmRunner {
    protected final AlgorithmExecutionConfig execConfig;
    protected final List<RunConfig> runConfigs;
    protected final List<AlgorithmRun> runs;
    private final ExecutorService execService = Executors.newCachedThreadPool();
    private static final Logger log = LoggerFactory.getLogger(AbstractAlgorithmRunner.class);
    private final AtomicBoolean shutdownThreads = new AtomicBoolean(false);
    private final Semaphore shutdownComplete = new Semaphore(0);
    private final Semaphore changes = new Semaphore(0);

    public AbstractAlgorithmRunner(AlgorithmExecutionConfig execConfig, final List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorRunObserver obs, CommandLineTargetAlgorithmEvaluatorOptions options) {
        if (execConfig == null || runConfigs == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.execConfig = execConfig;
        this.runConfigs = runConfigs;
        ArrayList<AlgorithmRun> runs = new ArrayList<AlgorithmRun>(runConfigs.size());
        final ConcurrentHashMap<RunConfig, RunningAlgorithmRun> runStatus = new ConcurrentHashMap<RunConfig, RunningAlgorithmRun>(runConfigs.size());
        final ConcurrentHashMap<RunConfig, Integer> listIndex = new ConcurrentHashMap<RunConfig, Integer>(runConfigs.size());
        final Semaphore changeProcess = new Semaphore(0);
        int i = 0;
        for (RunConfig rc : runConfigs) {
            StatusVariableKillHandler killH = new StatusVariableKillHandler();
            listIndex.put(rc, i);
            runStatus.put(rc, new RunningAlgorithmRun(execConfig, rc, "RUNNING,0.0,0,0," + rc.getProblemInstanceSeedPair().getSeed(), killH));
            TargetAlgorithmEvaluatorRunObserver individualRunObserver = new TargetAlgorithmEvaluatorRunObserver(){

                @Override
                public void currentStatus(List<? extends KillableAlgorithmRun> runs) {
                    if (((KillableAlgorithmRun)runStatus.get(runs.get(0).getRunConfig())).isRunCompleted() && !runs.get(0).isRunCompleted()) {
                        StringBuilder sb = new StringBuilder("Current Run Status being notified: " + runs.get(0).getRunConfig());
                        sb.append("\n Current status in table").append(((KillableAlgorithmRun)runStatus.get(runs.get(0).getRunConfig())).getRunConfig());
                        throw new IllegalStateException("RACE CONDITION: " + sb.toString());
                    }
                    runStatus.put(runs.get(0).getRunConfig(), runs.get(0));
                    AbstractAlgorithmRunner.this.changes.release();
                }
            };
            CommandLineAlgorithmRun run = new CommandLineAlgorithmRun(execConfig, rc, individualRunObserver, killH, options);
            runs.add(run);
            ++i;
        }
        this.runs = runs;
        ++i;
        Runnable runStatusWatchingThread = new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        do {
                            AbstractAlgorithmRunner.this.changes.acquire();
                            AbstractAlgorithmRunner.this.changes.drainPermits();
                            if (AbstractAlgorithmRunner.this.shutdownThreads.get()) {
                                AbstractAlgorithmRunner.this.shutdownComplete.release();
                                break block4;
                            }
                            KillableAlgorithmRun[] runs = new KillableAlgorithmRun[runConfigs.size()];
                            boolean outstandingRuns = false;
                            for (Map.Entry entries : runStatus.entrySet()) {
                                KillableAlgorithmRun run = (KillableAlgorithmRun)entries.getValue();
                                if (run.getRunResult().equals((Object)RunResult.RUNNING)) {
                                    outstandingRuns = true;
                                }
                                runs[((Integer)listIndex.get(entries.getKey())).intValue()] = run;
                            }
                            try {
                                List<KillableAlgorithmRun> runList = Arrays.asList(runs);
                                if (obs != null) {
                                    obs.currentStatus(runList);
                                }
                            }
                            catch (RuntimeException e) {
                                log.error("Error occured while notifying observer ", (Throwable)e);
                                throw e;
                            }
                            if (!outstandingRuns) {
                                AbstractAlgorithmRunner.this.shutdownComplete.release();
                                break block4;
                            }
                            changeProcess.release(runs.length);
                        } while (!AbstractAlgorithmRunner.this.execService.isShutdown());
                        AbstractAlgorithmRunner.this.shutdownComplete.release();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        };
        this.execService.submit(runStatusWatchingThread);
    }

    @Override
    public abstract List<AlgorithmRun> run();

    @Override
    public void shutdownThreadPool() {
        this.execService.shutdown();
        try {
            this.shutdownThreads.set(true);
            this.changes.release();
            this.shutdownComplete.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

