// Embeddable WebFigure widget 

/*
 * CONFIDENTIAL AND CONTAINING PROPRIETARY TRADE SECRETS
 * Copyright 2007 The MathWorks, Inc.
 * The source code contained in this listing contains proprietary and
 * confidential trade secrets of The MathWorks, Inc.  The use, modification,
 * or development of derivative work based on the code or ideas obtained
 * from the code is prohibited without the express written permission of The
 * MathWorks, Inc. The disclosure of this code to any party not authorized
 * by The MathWorks, Inc. is strictly forbidden.
 * CONFIDENTIAL AND CONTAINING PROPRIETARY TRADE SECRETS
 */
mathworks.module({
	
    name: "mathworks/webfigures/WebFigureWidget.jsm",
    
    requires: ["mathworks/loadscheduler/loadscheduler.jsm", 
			   "mathworks/viewmanager/viewmanager.jsm", 
			   "mathworks/cube3d/cube3d.jsm", 
			   "mathworks/mousewheel/mousewheel.jsm",
			   "mathworks/quadtree/quadtree.jsm"],
    
    definition: function(context){
    
        if (!mathworks.webfigures) {
            mathworks.webfigures = {};
        }
		
		var moduleDir = this.name.substring(0,this.name.lastIndexOf('/'));
        
        mathworks.webfigures.WebFigureWidget = function(){
        
            // copies all properties from 'properties' to 'obj' (shallow copy only)
            function applyProperties(obj, properties){
                for (var p in properties) {
                    if (properties.hasOwnProperty(p)) {
                        if (typeof properties[p] === 'object') {
                            if (!(p in obj)) {
                                obj[p] = {};
                            }
                            applyProperties(obj[p], properties[p]);
                        }
                        else {
                            obj[p] = properties[p];
                        }
                    }
                }
            }
            
            // create a new DOM element, optionally attaching it as a child of 'parent'
            function makeElement(elementName, properties, parent){
                var e = document.createElement(elementName);
                if (parent) {
                    parent.appendChild(e);
                }
                applyProperties(e, properties);
                return e;
            }
            
            function makeViewElementCallbackDetacher(viewElement){
                return function(){
                    viewElement.resize = null;
                    viewElement.reveal = null;
                    viewElement.notifyLoaded = null;
                    viewElement.notifyHiding = null;
                    viewElement.cancelAllRequests = null;
                    viewElement.detachCallbacks = null;
                };
            }
            
            function WebFigureView(figure, scheduler){
                var container = makeElement('div', {
                    id: 'mathworks_WebFigureView_container',
                    style: {
                        position: 'relative',
                        width: '100%',
                        height: '100%',
                        padding: '0px',
                        margin: '0px'
                    }
                });
                
                this.container = container;
                
                var viewManager = new mathworks.viewmanager.ViewManager(container);
                var cube = new mathworks.cube3d.Cube3D(container); // Must be after viewManager to appear on top    
                var currentAzimuth = 65;
                var currentElevation = 30;
                var currentlyLoadingView = null;
                var currentlyLoadingViewId = null;
                var cubeTimeoutId = 0;
                var MIN_WIDTH = 120;
                var MIN_HEIGHT = 90;
                var MAX_PIXELS = parseFloat('48000000000000'); // the renderer does strange things beyond this point        

                function getEffectiveAzimuth(){
                    // round to nearest 10 degrees
                    var effectiveAzimuth = (currentAzimuth + 5) - ((currentAzimuth + 5) % 10);
                    if (effectiveAzimuth === 360) {
                        effectiveAzimuth = 0;
                    }
                    return effectiveAzimuth;
                }
                
                function getEffectiveElevation(){
                    // round to nearest 10 degrees
                    var effectiveElevation;
                    if (currentElevation < 0) {
                        effectiveElevation = (-currentElevation) + 5;
                        effectiveElevation = effectiveElevation - (effectiveElevation % 10);
                        effectiveElevation = -effectiveElevation;
                    } else {
                        effectiveElevation = (currentElevation + 5) - ((currentElevation + 5) % 10);
                    }
                    return effectiveElevation;
                }
                
                function getCurrentViewId(){
                    return "angle_" + getEffectiveAzimuth() + "_" + (getEffectiveElevation() + 90);
                }
                
                this.setViewAngle = function(az, el){
                    currentAzimuth = az;
                    currentElevation = el;
                    if (currentElevation > 90) {
                        currentElevation = 90;
                    }
                    if (currentElevation < -90) {
                        currentElevation = -90;
                    }
                    while (currentAzimuth < 0) {
                        currentAzimuth += 360;
                    }
                    currentAzimuth = currentAzimuth % 360;
                    // keep the cube up-to-date wrt current camera angle even if it is hidden
                    cube.setAngle(-getEffectiveAzimuth(), getEffectiveElevation());
                    this.refresh();
                };
                
                this.zoom = function(delta_size){
                    var h = viewManager.viewHeight;
                    var w = viewManager.viewWidth;
                    var dh = (delta_size * h) / 120; // TBD - what is this magic 120?  a scaling factor?
                    var dw = (w * (h + dh)) / h - w;
                    if (((h + dh) > MIN_HEIGHT && (w + dw) > MIN_WIDTH) && ((h + dh) * (w + dw) < MAX_PIXELS)) {
                        viewManager.setViewOffset((viewManager.viewOffsetX * (dw + w)) / w, 
                                                  (viewManager.viewOffsetY * (dh + h)) / h);
                        viewManager.setViewSize(w + dw, h + dh);
                        return true;
                    }
                    else {
                        return false;
                    }
                };
                
                this.pan = function(dx, dy){
                    viewManager.setViewOffset(viewManager.viewOffsetX + dx, viewManager.viewOffsetY + dy);
                };
                
                this.rotate = function(delta_az, delta_el){
                    this.setViewAngle(currentAzimuth + delta_az, currentElevation + delta_el);
                };
                
                this.setBackgroundColor = function(color){
                    container.style.backgroundColor = color;
                    this.refresh();
                };
                
                this.show = function(){
                    viewManager.show();
                    this.refresh();
                };
                
                this.hide = function(){
                    viewManager.hide();
                };
                
                this.getPan = function(){
                    return {
                        left: viewManager.viewOffsetX,
                        top: viewManager.viewOffsetY
                    };
                };
                
                this.setPan = function(p){
                    viewManager.setViewOffset(p.left, p.top);
                    this.refresh();
                };
                
                this.getZoom = function(){
                    return {
                        width: viewManager.viewWidth,
                        height: viewManager.viewHeight
                    };
                };
                
                this.setZoom = function(z){
                    viewManager.setViewSize(z.width, z.height);
                    cube.setAspectRatio(z.width, z.height);
                    this.refresh();
                };
                
                this.setViewportSize = function(viewportRect){
                    viewManager.setViewportRect({ left: 0, top: 0, width: viewportRect.width, height: viewportRect.height });
                    var cubeSize = viewportRect.width / 4;
                    if (cubeSize < 64) {
                        cubeSize = 64;
                    }
                    cube.setSize(cubeSize);
                    cube.setPosition(viewportRect.width / 2, viewportRect.height / 2);
                    this.refresh();
                };
                
                this.getViewportSize = function(){
                    var rect = viewManager.getViewportRect();
                    return { width: rect.width, height: rect.height };
                };
                
                this.refresh = function(){
                    if (0 === viewManager.viewWidth || 0 === viewManager.viewHeight) {
                        // prevent sending requests to the server for zero-sized images
                        return;
                    }
                    
                    var viewId = getCurrentViewId();
                    
                    // if this view has already been cached, simply display it 
                    //  (the viewManager will give the view element a chance to request
                    //  images at the proper resolution via the 'reveal' method)
                    if (viewManager.hasView(viewId)) {
                        viewManager.setActiveView(viewId);
                        clearTimeout(cubeTimeoutId);
                        cubeTimeoutId = setTimeout(function(){
                            cube.hide();
                        }, 250);
                    }
                    else {
                        // if the new view is being loaded in response to user input, show the cube
                        clearTimeout(cubeTimeoutId);
                        cube.show();
                        
                        // set up view parameters for the render operation
						var rotation = getEffectiveAzimuth();
                        var elevation = getEffectiveElevation();
                        
                        // show the cube immediately by releasing the JavaScript thread momentarily
                        setTimeout(function(){
                            if (getCurrentViewId() === viewId) {
                                // if there is another view in progress, cancel it now
                                if (currentlyLoadingView) {
                                    if (currentlyLoadingViewId === viewId) {
                                        return;
                                    }
                                    currentlyLoadingView.cancelAllRequests();
                                    mathworks.util.detachEventHandler(window, 'unload', currentlyLoadingView.detachCallbacks);
                                    currentlyLoadingView.detachCallbacks();
                                    currentlyLoadingView = null;
                                }
                                
                                // create a new view element for the given camera angle

								var getQuadTreeTileURL = function (params) {
									return figure.getImageURL({
										width : params.width,
										height : params.height,
										cropLeft : params.cropLeft,
										cropRight : params.cropRight,
										cropTop : params.cropTop,
										cropBottom : params.cropBottom,
										elevation : elevation,
										rotation : rotation
									});
								};
								
                                var viewElement = mathworks.quadtree.create(getQuadTreeTileURL, 512 * 512, scheduler);
								
                                viewElement.notifyLoaded = function(){
                                    mathworks.util.detachEventHandler(window, 'unload', viewElement.detachCallbacks);
                                    viewElement.notifyLoaded = null;
                                    viewElement.detachCallbacks = null;
                                    if (currentlyLoadingView === viewElement) {
                                        currentlyLoadingView = null;
                                        currentlyLoadingViewId = null;
                                    }
                                    delete mathworks.webfigures.pendingViews[viewId];
                                    viewElement.style.visibility = 'inherit';
                                    viewManager.addView(viewId, viewElement);
                                    if (viewId === getCurrentViewId()) {
                                        viewManager.setActiveView(viewId);
                                        clearTimeout(cubeTimeoutId);
                                        cubeTimeoutId = setTimeout(function(){
                                            cube.hide();
                                        }, 150);
                                    }
                                };
                                
                                viewElement.detachCallbacks = makeViewElementCallbackDetacher(viewElement);
                                mathworks.util.attachEventHandler(window, 'unload', viewElement.detachCallbacks);
                                
                                if (!mathworks.webfigures.pendingViews) {
                                    mathworks.webfigures.pendingViews = {};
                                }
                                mathworks.webfigures.pendingViews[viewId] = viewElement;
                                
                                viewElement.style.visibility = 'hidden';
                                container.appendChild(viewElement);
                                
                                // the newly created view element is the currently loading one.
                                currentlyLoadingView = viewElement;
                                currentlyLoadingViewId = viewId;
                                
                                // start the image tiles loading
                                viewManager.revealElement(viewElement);
                            }
                        }, 0);
                    }
                };
				
				// request WebFigure properties 
				var initParams = figure.getProperties();
				this.setViewAngle(initParams.azimuth, initParams.elevation);
				this.setBackgroundColor(initParams.backgroundcolor);
                
                return this;
            }
            
            function WebFigureController(figure, scheduler){
            
                var view = new WebFigureView(figure, scheduler);
                this.view = view;
                
                var toolbarStyle = {
                    position: 'absolute',
                    left: '0px',
                    top: '0px',
                    width: '100%',
                    height: '22px',
                    textAlign: 'center',
                    padding: '0px',
                    margin: '0px'
                };
                
                var toolbar = makeElement('div', {
                    id: 'mathworks_WebFigureWidget_toolbar',
                    style: toolbarStyle
                });
                toolbar.style.visibility = 'hidden';
                toolbar.style.background = '#CCCCCC';
                this.toolbar = toolbar;
                
                function showToolbar(){
                    toolbar.style.visibility = 'visible';
                }
                
                function hideToolbar(){
                    toolbar.style.visibility = 'hidden';
                }
                
                //----------------------------------------------------------------------
                // make the selection indicator layer
                //----------------------------------------------------------------------
                toolbar.selectionLayer = makeElement('div', {
                    id: 'mathworks_WebFigureWidget_selectionIndicatorLayer',
                    style: toolbarStyle
                }, toolbar);
                
                toolbar.selectionLayer.sizeToFit = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_sizeToFitSelected',
                    style: { visibility: 'hidden' },                    
					src:context.loader.getResource(moduleDir + '/images/selected_icon.gif'),
                    align: 'right'
                }, toolbar.selectionLayer);
                
                toolbar.selectionLayer.zoomMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_zoomModeSelected',
                    style: { visibility: 'hidden' },                    
					src: context.loader.getResource(moduleDir + '/images/selected_icon.gif')
                }, toolbar.selectionLayer);
                
                toolbar.selectionLayer.panMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_panModeSelected',
                    style: { visibility: 'hidden' },                    
					src: context.loader.getResource(moduleDir + '/images/selected_icon.gif')
                }, toolbar.selectionLayer);
                
                toolbar.selectionLayer.rotateMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_rotateModeSelected',
                    style: { visibility: 'hidden' },                    
					src: context.loader.getResource(moduleDir + '/images/selected_icon.gif')
                }, toolbar.selectionLayer);
                
                //----------------------------------------------------------------------
                // make the hover indicator layer
                //----------------------------------------------------------------------
                toolbar.hoverLayer = makeElement('div', {
                    id: 'mathworks_WebFigureWidget_hoverIndicatorLayer',
                    style: toolbarStyle
                }, toolbar);
                
                toolbar.hoverLayer.sizeToFit = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_sizeToFitHover',
                    style: { visibility: 'hidden' },                    
					src: context.loader.getResource(moduleDir + '/images/hover_icon.gif'),
                    align: 'right'
                }, toolbar.hoverLayer);
                
                toolbar.hoverLayer.zoomMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_zoomModeHover',
                    style: { visibility: 'hidden' },                    
					src: context.loader.getResource(moduleDir + '/images/hover_icon.gif')
                }, toolbar.hoverLayer);
                
                toolbar.hoverLayer.panMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_panModeHover',
                    style: { visibility: 'hidden' },                    
					src: context.loader.getResource(moduleDir + '/images/hover_icon.gif')
                }, toolbar.hoverLayer);
                
                toolbar.hoverLayer.rotateMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_rotateModeHover',
                    style: { visibility: 'hidden' },                    
					src: context.loader.getResource(moduleDir + '/images/hover_icon.gif')
                }, toolbar.hoverLayer);
                
                //----------------------------------------------------------------------
                // make the icon layer
                //----------------------------------------------------------------------
                toolbar.iconLayer = makeElement('div', {
                    id: 'mathworks_WebFigureWidget_iconLayer',
                    style: toolbarStyle
                }, toolbar);
                
                toolbar.iconLayer2 = makeElement('div', {
                    id: 'mathworks_WebFigureWidget_iconLayer2',
                    style: toolbarStyle
                }, toolbar);
                
                toolbar.iconLayer.sizeToFitDisabled = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_sizeToFitDisabledIcon',
                    style: { visibility: 'inherit' },                    
					src: context.loader.getResource(moduleDir + '/images/size_to_fit_disabled_icon.gif'),
                    align: 'right'
                }, toolbar.iconLayer2);
                
                toolbar.iconLayer.sizeToFitEnabled = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_sizeToFitEnabledIcon',
                    style: { visibility: 'inherit' },                    
					src: context.loader.getResource(moduleDir + '/images/size_to_fit_icon.gif'),
                    align: 'right'
                }, toolbar.iconLayer);
                
                toolbar.iconLayer.zoomMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_zoomModeIcon',
                    style: { visibility: 'inherit', margin: '3px' },                    
					src: context.loader.getResource(moduleDir + '/images/tool_zoom_in.png')				
                }, toolbar.iconLayer);
                
                toolbar.iconLayer.panMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_panModeIcon',
                    style: { visibility: 'inherit', margin: '3px' },                    
                    src: context.loader.getResource(moduleDir + '/images/tool_hand.png')
                }, toolbar.iconLayer);
                
                toolbar.iconLayer.rotateMode = makeElement('img', {
                    id: 'mathworks_WebFigureWidget_rotateModeIcon',
                    style: { visibility: 'inherit', margin: '3px' },                    
					src: context.loader.getResource(moduleDir + '/images/tool_rotate_3d.png')
                }, toolbar.iconLayer);
                
                //----------------------------------------------------------------------
                // private data
                //----------------------------------------------------------------------
                var mouseIsDown = false;
                var mouseIsOver = false;
                var mouseDownOnToolbar = false;
                var userSpecifiedZoom = false;
                var restorePreviousZoom = false;
                var previousZoom = null;
                var previousPan = null;
                var dragging = false;
                var startX;
                var startY;
                var navMode;
                
                //----------------------------------------------------------------------
                // canvas event helper functions
                //----------------------------------------------------------------------
                
                function startDragging(updateX, updateY){
                    if (mouseDownOnToolbar) {
                        return;
                    }
                    dragging = true;
                    startX = updateX;
                    startY = updateY;
                }
                
                function dragMouse(updateX, updateY){
                    if (dragging) {
                        var dx = (updateX - startX);
                        var dy = (updateY - startY);
                        
                        startX = updateX;
                        startY = updateY;
                        
                        if (navMode === 'rotate') {
                            view.rotate(-dx / 2, dy / 2);
                        }
                        else if (navMode === 'zoom') {
                                if (view.zoom(-dy * 3)) {
                                    restorePreviousZoom = false;
                                }
                                setUserSpecifiedZoom(true);
                            }
                            else if (navMode === 'pan') {
                                    restorePreviousZoom = false;
                                    setUserSpecifiedZoom(true);
                                    view.pan(dx, dy);
                                }
                    }
                }
                
                function stopDragging(){
                    dragging = false;
                }
                
                //----------------------------------------------------------------------
                // toolbar button event helper functions
                //----------------------------------------------------------------------
                
                function setNavMode(mode){
                    var oldModeSelectionIndicator = toolbar.selectionLayer[navMode + 'Mode'];
                    var newModeSelectionIndicator = toolbar.selectionLayer[mode + 'Mode'];
                    if (oldModeSelectionIndicator !== newModeSelectionIndicator) {
                        if (oldModeSelectionIndicator) {
                            oldModeSelectionIndicator.style.visibility = 'hidden';
                        }
                        if (newModeSelectionIndicator) {
                            newModeSelectionIndicator.style.visibility = 'inherit';
                            navMode = mode;
                        }
                    }
                }
                
                function setUserSpecifiedZoom(on){
                    if (on) {
                        userSpecifiedZoom = true;
                        toolbar.selectionLayer.sizeToFit.style.visibility = 'hidden';
                        toolbar.iconLayer.sizeToFitEnabled.style.visibility = 'hidden';
                        toolbar.iconLayer.sizeToFitDisabled.style.visibility = 'inherit';
                    } else {
                        userSpecifiedZoom = false;
                        toolbar.selectionLayer.sizeToFit.style.visibility = 'inherit';
                        toolbar.iconLayer.sizeToFitEnabled.style.visibility = 'inherit';
                        toolbar.iconLayer.sizeToFitDisabled.style.visibility = 'hidden';
                        restorePreviousZoom = true;
                        previousZoom = view.getZoom();
                        previousPan = view.getPan();
                    }
                    if (on && restorePreviousZoom) {
                        view.setZoom(previousZoom);
                        view.setPan(previousPan);
                    } 
                    else if (!userSpecifiedZoom) {
                            view.setZoom(view.getViewportSize());
                            view.setPan({ left: 0, top: 0 });
                        }
                }
                
                //----------------------------------------------------------------------
                // canvas event handler functions
                //----------------------------------------------------------------------
                
                var canvasEventHandlers = {
                    mousedown: function(event, eventCanvas){
                        mouseIsDown = !mouseDownOnToolbar;
                        startDragging(event.clientX, event.clientY);
                        if (eventCanvas.setCapture) {
                            eventCanvas.setCapture();
                        }
                    },
                    dblclick: function(event, eventCanvas){
                        setUserSpecifiedZoom(!userSpecifiedZoom);
                    },
                    mouseup: function(event, eventCanvas){
                        mouseIsDown = false;
                        stopDragging();
                        if (eventCanvas.releaseCapture) {
                            eventCanvas.releaseCapture();
                            if (!mouseIsOver) {
                                hideToolbar();
                            }
                        }
                    },
                    mouseover: function(event, eventCanvas){
                        mouseIsOver = true;
                        showToolbar();
                    },
                    mouseout: function(event, eventCanvas){
                        mouseIsOver = false;
                        hideToolbar();
                        if (!eventCanvas.releaseCapture) {
                            mouseIsDown = false;
                            stopDragging();
                            hideToolbar();
                        }
                    },
                    mousemove: function(event, eventCanvas){
                        if (!mouseIsDown) {
                            mouseIsOver = true;
                        }
                        showToolbar();
                        dragMouse(event.clientX, event.clientY);
                    }
                };
                
                //----------------------------------------------------------------------
                // toolbar button event handler functions
                //----------------------------------------------------------------------
                
                var toolbarButtonEventHandlers = {
                    zoomMode: {
                        mousedown: function(event, buttonEventSink){
                            if (buttonEventSink.setCapture) {
                                buttonEventSink.setCapture();
                            }
                            mouseDownOnToolbar = true;
                            setNavMode('zoom');
                        },
                        mouseup: function(event, buttonEventSink){
                            if (buttonEventSink.releaseCapture) {
                                buttonEventSink.releaseCapture();
                            }
                            mouseDownOnToolbar = false;
                        },
                        mouseover: function(event, buttonEventSink){
                            toolbar.hoverLayer.zoomMode.style.visibility = "inherit";
                        },
                        mouseout: function(event, buttonEventSink){
                            if (buttonEventSink.releaseCapture) {
                                buttonEventSink.releaseCapture();
                            }
                            mouseDownOnToolbar = false;
                            toolbar.hoverLayer.zoomMode.style.visibility = "hidden";
                        }
                    },
                    panMode: {
                        mousedown: function(event, buttonEventSink){
                            if (buttonEventSink.setCapture) {
                                buttonEventSink.setCapture();
                            }
                            mouseDownOnToolbar = true;
                            setNavMode('pan');
                        },
                        mouseup: function(event, buttonEventSink){
                            if (buttonEventSink.releaseCapture) {
                                buttonEventSink.releaseCapture();
                            }
                            mouseDownOnToolbar = false;
                        },
                        mouseover: function(event, buttonEventSink){
                            toolbar.hoverLayer.panMode.style.visibility = "inherit";
                        },
                        mouseout: function(event, buttonEventSink){
                            if (buttonEventSink.releaseCapture) {
                                buttonEventSink.releaseCapture();
                            }
                            mouseDownOnToolbar = false;
                            toolbar.hoverLayer.panMode.style.visibility = "hidden";
                        }
                    },
                    rotateMode: {
                        mousedown: function(event, buttonEventSink){
                            if (buttonEventSink.setCapture) {
                                buttonEventSink.setCapture();
                            }
                            mouseDownOnToolbar = true;
                            setNavMode('rotate');
                        },
                        mouseup: function(event, buttonEventSink){
                            if (buttonEventSink.releaseCapture) {
                                buttonEventSink.releaseCapture();
                            }
                            mouseDownOnToolbar = false;
                        },
                        mouseover: function(event, buttonEventSink){
                            toolbar.hoverLayer.rotateMode.style.visibility = "inherit";
                        },
                        mouseout: function(event, buttonEventSink){
                            if (buttonEventSink.releaseCapture) {
                                buttonEventSink.releaseCapture();
                            }
                            mouseDownOnToolbar = false;
                            toolbar.hoverLayer.rotateMode.style.visibility = "hidden";
                        }
                    },
                    sizeToFit: {
                        click: function(event, buttonEventSink){
                            setUserSpecifiedZoom(!userSpecifiedZoom);
                        },
                        mousedown: function(event, buttonEventSink){
                            if (buttonEventSink.setCapture) {
                                buttonEventSink.setCapture();
                            }
                            mouseDownOnToolbar = true;
                        },
                        mouseup: function(even, buttonEventSink){
                            if (buttonEventSink.releaseCapture) {
                                buttonEventSink.releaseCapture();
                            }
                            mouseDownOnToolbar = false;
                        },
                        mouseover: function(event, buttonEventSink){
                            toolbar.hoverLayer.sizeToFit.style.visibility = "inherit";
                        },
                        mouseout: function(even, buttonEventSink){
                            if (buttonEventSink.releaseCapture) {
                                buttonEventSink.releaseCapture();
                            }
                            toolbar.hoverLayer.sizeToFit.style.visibility = "hidden";
                            mouseDownOnToolbar = false;
                        }
                    }
                };
                
                //----------------------------------------------------------------------
                // public methods
                //----------------------------------------------------------------------
                
                this.buttonEvent = function(buttonId, eventType, eventObject, buttonEventSink){
                    if (buttonId in toolbarButtonEventHandlers) {
                        if (eventType in toolbarButtonEventHandlers[buttonId]) {
                            return toolbarButtonEventHandlers[buttonId][eventType](eventObject, buttonEventSink);
                        }
                    }
                };
                
                this.canvasEvent = function(eventType, eventObject, eventCanvas){
                    if (eventType in canvasEventHandlers) {
                        return canvasEventHandlers[eventType](eventObject, eventCanvas);
                    }
                };
                
                this.resizeEvent = function(w, h){
                    var containerWidth = view.container.offsetWidth;
                    var containerHeight = view.container.offsetHeight;
                    view.setViewportSize({ width: containerWidth, height: containerHeight });
                    if (!userSpecifiedZoom) {
                        view.setPan({ left: 0, top: 0 });
                        view.setZoom({ width: containerWidth, height: containerHeight });
                    }
                };
                
                this.mouseWheelEvent = function(delta){
                    if (view.zoom(delta * 32)) {
                        restorePreviousZoom = false;
                    }
                    setUserSpecifiedZoom(true);
                };
                
                setNavMode('rotate');
                setUserSpecifiedZoom(false);
                
                // work-around for clicking size-to-fit button for the first time 
                restorePreviousZoom = false;				
				
				view.show();
				                
                return this;
            }
            
            function makeCanvasEventHandler(controller, eventType){
                return function(e){
                    var event = e || window.event;
                    controller.canvasEvent(eventType, event, this);
                };
            }
            
            function makeEventCanvas(controller){
                var eventCanvas = document.createElement('div');
                eventCanvas.id = mathworks.util.getNextUniqueId('mathworks_WebFigureWidget_eventCanvas');
                eventCanvas.style.position = 'absolute';
                eventCanvas.style.left = '0px';
                eventCanvas.style.top = '0px';
                eventCanvas.style.width = '100%';
                eventCanvas.style.height = '100%';
                eventCanvas.style.overflow = 'hidden';                
				eventCanvas.style.backgroundImage = 'url(' + context.loader.getResource(moduleDir + '/images/transparent_pixel.gif') + ')';
                eventCanvas.onmousedown = makeCanvasEventHandler(controller, 'mousedown');
                eventCanvas.onmouseup = makeCanvasEventHandler(controller, 'mouseup');
                eventCanvas.onmouseover = makeCanvasEventHandler(controller, 'mouseover');
                eventCanvas.onmouseout = makeCanvasEventHandler(controller, 'mouseout');
                eventCanvas.onmousemove = makeCanvasEventHandler(controller, 'mousemove');
                eventCanvas.ondblclick = makeCanvasEventHandler(controller, 'dblclick');
                return eventCanvas;
            }
            
            function makeToolbarButtonEventHandler(controller, eventType, buttonId){
                return function(e){
                    var event = e || window.event;
                    controller.buttonEvent(buttonId, eventType, event, this);
                };
            }
            
            function makeToolbarEventSinkLayer(controller){
                var toolbarEventSinkLayer = document.createElement('div');
                toolbarEventSinkLayer.id = mathworks.util.getNextUniqueId('mathworks_WebFigureWidget_toolbarEventSinkLayer');
                toolbarEventSinkLayer.style.position = 'absolute';
                toolbarEventSinkLayer.style.left = '0px';
                toolbarEventSinkLayer.style.top = '0px';
                toolbarEventSinkLayer.style.width = '100%';
                toolbarEventSinkLayer.style.height = '22px';
                toolbarEventSinkLayer.style.textAlign = 'center';
                
                // -------------------------------------------------------------------------
                // Create size-to-fit mode button icon
                // -------------------------------------------------------------------------
                var sizeToFit = document.createElement('img');
                sizeToFit.id = mathworks.util.getNextUniqueId('mathworks_WebFigureWidget_sizeToFitEventSink');
                sizeToFit.style.width = '22px';
                sizeToFit.style.height = '22px';
                sizeToFit.style.visibility = 'inherit';
                sizeToFit.align = 'right';                
				sizeToFit.src = context.loader.getResource(moduleDir + '/images/transparent_pixel.gif');
                sizeToFit.onclick = makeToolbarButtonEventHandler(controller, 'click', 'sizeToFit');
                sizeToFit.onmousedown = makeToolbarButtonEventHandler(controller, 'mousedown', 'sizeToFit');
                sizeToFit.onmouseup = makeToolbarButtonEventHandler(controller, 'mouseup', 'sizeToFit');
                sizeToFit.onmouseover = makeToolbarButtonEventHandler(controller, 'mouseover', 'sizeToFit');
                sizeToFit.onmouseout = makeToolbarButtonEventHandler(controller, 'mouseout', 'sizeToFit');
                toolbarEventSinkLayer.appendChild(sizeToFit);
                
                // -------------------------------------------------------------------------
                // Create zoom mode button icon
                // -------------------------------------------------------------------------
                var zoomMode = document.createElement('img');
                zoomMode.id = mathworks.util.getNextUniqueId('mathworks_WebFigureWidget_zoomModeEventSink');
                zoomMode.style.width = '22px';
                zoomMode.style.height = '22px';
                zoomMode.style.visibility = 'inherit';                
				zoomMode.src = context.loader.getResource(moduleDir + '/images/transparent_pixel.gif');
                zoomMode.onmousedown = makeToolbarButtonEventHandler(controller, 'mousedown', 'zoomMode');
                zoomMode.onmouseup = makeToolbarButtonEventHandler(controller, 'mouseup', 'zoomMode');
                zoomMode.onmouseover = makeToolbarButtonEventHandler(controller, 'mouseover', 'zoomMode');
                zoomMode.onmouseout = makeToolbarButtonEventHandler(controller, 'mouseout', 'zoomMode');
                toolbarEventSinkLayer.appendChild(zoomMode);
                
                // -------------------------------------------------------------------------
                // Create pan mode button icon
                // -------------------------------------------------------------------------
                var panMode = document.createElement('img');
                panMode.id = mathworks.util.getNextUniqueId('mathworks_WebFigureWidget_panModeEventSink');
                panMode.style.width = '22px';
                panMode.style.height = '22px';
                panMode.style.visibility = 'inherit';                
				panMode.src = context.loader.getResource(moduleDir + '/images/transparent_pixel.gif');
                panMode.onmousedown = makeToolbarButtonEventHandler(controller, 'mousedown', 'panMode');
                panMode.onmouseup = makeToolbarButtonEventHandler(controller, 'mouseup', 'panMode');
                panMode.onmouseover = makeToolbarButtonEventHandler(controller, 'mouseover', 'panMode');
                panMode.onmouseout = makeToolbarButtonEventHandler(controller, 'mouseout', 'panMode');
                toolbarEventSinkLayer.appendChild(panMode);
                
                // -------------------------------------------------------------------------
                // Create rotate mode button icon
                // -------------------------------------------------------------------------
                var rotateMode = document.createElement('img');
                rotateMode.id = mathworks.util.getNextUniqueId('mathworks_WebFigureWidget_rotateModeEventSink');
                rotateMode.style.width = '22px';
                rotateMode.style.height = '22px';
                rotateMode.style.visibility = 'inherit';                
				rotateMode.src = context.loader.getResource(moduleDir + '/images/transparent_pixel.gif');
                rotateMode.onmousedown = makeToolbarButtonEventHandler(controller, 'mousedown', 'rotateMode');
                rotateMode.onmouseup = makeToolbarButtonEventHandler(controller, 'mouseup', 'rotateMode');
                rotateMode.onmouseover = makeToolbarButtonEventHandler(controller, 'mouseover', 'rotateMode');
                rotateMode.onmouseout = makeToolbarButtonEventHandler(controller, 'mouseout', 'rotateMode');
                toolbarEventSinkLayer.appendChild(rotateMode);
                
                return toolbarEventSinkLayer;
            }
            
            function makeResizeHandler(controller){
                return function(e){
                    var event = e || window.event;
                    var element = event.target || event.srcElement;
                    controller.resizeEvent(element.offsetWidth, element.offsetHeight);
                };
            }
            
            function makeMouseWheelHandler(controller){
                return function(delta){
                    return controller.mouseWheelEvent(delta);
                };
            }
            
            function makeSchedulerStatus(scheduler){
                var schedulerStatus = document.createElement('div');
                schedulerStatus.displayed = false;
                schedulerStatus.position = 'absolute';
                schedulerStatus.style.left = '0px';
                schedulerStatus.style.top = '0px';
                schedulerStatus.style.width = '128px';
                schedulerStatus.style.border = '1px solid black';
                schedulerStatus.style.display = 'none';
                schedulerStatus.style.backgroundColor = 'white';
                
                // display the scheduler status box
                schedulerStatus.displayed = true;
                schedulerStatus.style.display = 'block';
                scheduler.onchange = function(){
                    schedulerStatus.innerHTML = 
                            'Queued: '      + this.queue.length     + '<br>' +
                            'Started: '     + this.numStarted       + '<br>' +
                            'Cancelled: '   + this.numCancelled     + '<br>' +
                            'TimedOut: '    + this.numTimedout      + '<br>' +
                            'Overrides: '   + this.requestOverrides + '<br>' +
                            'TMO Set: '     + this.timeoutsSet      + '<br>' +
                            'TMO Cleared: ' + this.timeoutsCleared;
                };
                scheduler.onchange();
                
                return schedulerStatus;
            }
            
            function focusHolderOnBlur(){
                var eventCanvas = this.parentNode;
                mathworks.mousewheel.clearMouseWheelEventHandler(eventCanvas, eventCanvas.wheelHandler);
            }
            
            function eventCanvasOnClick(){
                var eventCanvas = this;
                mathworks.mousewheel.setMouseWheelEventHandler(eventCanvas, eventCanvas.wheelHandler);
                this.focusHolder.focus();
            }
            
            function WebFigureWidget(container, figure, scheduler){
                if (!scheduler) {
                    scheduler = new mathworks.loadscheduler.LoadScheduler();
                }
                
                var controller = new WebFigureController(figure, scheduler);
                var eventCanvas = makeEventCanvas(controller);
                var toolbarEventSinkLayer = makeToolbarEventSinkLayer(controller);
                
                eventCanvas.appendChild(toolbarEventSinkLayer);
                container.appendChild(controller.view.container);
                container.appendChild(controller.toolbar);
                container.appendChild(eventCanvas);
                
                // Some final initialization    
                controller.resizeEvent(container.offsetWidth, container.offsetHeight);
                
                // Listen for mouse wheel events
                eventCanvas.wheelHandler = makeMouseWheelHandler(controller);
                
                // Create a textarea element that can hold focus on behalf of the eventCanvas
                eventCanvas.focusHolder = document.createElement('textarea');
                eventCanvas.focusHolder.style.position = 'absolute';
                eventCanvas.focusHolder.style.left = '-500px';
                eventCanvas.focusHolder.onblur = focusHolderOnBlur;
                
                // Add the focusHolder to the eventCanvas
                eventCanvas.appendChild(eventCanvas.focusHolder);
                
                // Move focus to the focus holder when the user clicks on the event canvas
                eventCanvas.onclick = eventCanvasOnClick;
                
                // Listen for resize events
                if (window.attachEvent) {
                    // listen just on container if IE
                    mathworks.util.attachEventHandler(container, 'resize', makeResizeHandler(controller));
                }
                else {
                    mathworks.util.attachEventHandler(window, 'resize', makeResizeHandler(controller));
                }
                
                this.controller = controller;
                
                return this;
            }
            
            return WebFigureWidget;
            
        }();
    }
});
