/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures.service.request;

import com.mathworks.toolbox.javabuilder.io.Streams;
import com.mathworks.toolbox.javabuilder.services.ServiceException;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerActionDispatcher;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerContext;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerException;
import com.mathworks.toolbox.javabuilder.web.util.ContentType;
import com.mathworks.toolbox.javabuilder.webfigures.internal.WebFigureResources;
import com.mathworks.toolbox.javabuilder.webfigures.service.request.WebFigureServiceRequest;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureBinaryResourceResult;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureServiceResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WebFigureResourceRequest
implements WebFigureServiceRequest {
    private String fResourcePath;

    public WebFigureResourceRequest(String string) {
        if (null == string) {
            throw new IllegalArgumentException("resourcePath is null");
        }
        this.fResourcePath = string;
    }

    public String getResourcePath() {
        return this.fResourcePath;
    }

    public void setResourcePath(String string) {
        if (null == string) {
            throw new IllegalArgumentException("resourcePath is null");
        }
        this.fResourcePath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebFigureServiceResult process(StateManagerContext stateManagerContext, StatefulServicePeerActionDispatcher statefulServicePeerActionDispatcher) throws ServiceException {
        WebFigureBinaryResourceResult webFigureBinaryResourceResult;
        String string = ContentType.fromExtension(this.fResourcePath).getName();
        InputStream inputStream = WebFigureResources.getResourceAsStream(this.fResourcePath, stateManagerContext);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Streams.copyAllAvailable(inputStream, byteArrayOutputStream);
            webFigureBinaryResourceResult = new WebFigureBinaryResourceResult(byteArrayOutputStream.toByteArray(), string);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ServiceException(iOException);
            }
            catch (StateManagerException stateManagerException) {
                throw new ServiceException(stateManagerException);
            }
        }
        inputStream.close();
        return webFigureBinaryResourceResult;
    }
}

