/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures.service.http;

import com.mathworks.toolbox.javabuilder.external.org.json.JSONException;
import com.mathworks.toolbox.javabuilder.external.org.json.JSONObject;
import com.mathworks.toolbox.javabuilder.services.ServiceException;
import com.mathworks.toolbox.javabuilder.webfigures.service.http.WebFigureServiceResultHttpResponseWriter;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureBinaryResourceResult;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureGetPropertiesResult;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureServiceResult;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureServiceResultVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class WebFigureServiceResultJSONHttpResponseWriter
implements WebFigureServiceResultHttpResponseWriter {
    public void write(final HttpServletResponse httpServletResponse, WebFigureServiceResult webFigureServiceResult) throws ServiceException {
        webFigureServiceResult.visit(new WebFigureServiceResultVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visit(WebFigureBinaryResourceResult webFigureBinaryResourceResult) throws ServiceException {
                httpServletResponse.setContentType(webFigureBinaryResourceResult.getContentType());
                httpServletResponse.setContentLength(webFigureBinaryResourceResult.getContentLength());
                if (webFigureBinaryResourceResult.getContentEncoding() != null) {
                    httpServletResponse.setHeader("Content-Encoding", webFigureBinaryResourceResult.getContentEncoding());
                }
                try {
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    try {
                        webFigureBinaryResourceResult.writeData((OutputStream)servletOutputStream);
                    }
                    finally {
                        servletOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    throw new ServiceException(iOException);
                }
            }

            public void visit(WebFigureGetPropertiesResult webFigureGetPropertiesResult) throws ServiceException {
                try {
                    int[] nArray = webFigureGetPropertiesResult.getBackgroundColor();
                    String string = String.format(Locale.US, "#%02x%02x%02x", nArray[0], nArray[1], nArray[2]);
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("backgroundColor", string);
                    jSONObject.put("width", webFigureGetPropertiesResult.getWidth());
                    jSONObject.put("height", webFigureGetPropertiesResult.getHeight());
                    jSONObject.put("azimuth", webFigureGetPropertiesResult.getAzimuth());
                    jSONObject.put("elevation", webFigureGetPropertiesResult.getElevation());
                    httpServletResponse.setContentType("application/javascript");
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    ((Writer)printWriter).write("jsoncallback(" + jSONObject.toString() + ");\n");
                }
                catch (JSONException jSONException) {
                    throw new ServiceException(jSONException);
                }
                catch (IOException iOException) {
                    throw new ServiceException(iOException);
                }
            }
        });
    }
}

