/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.services;

import com.mathworks.toolbox.javabuilder.Disposable;
import com.mathworks.toolbox.javabuilder.services.ServiceDispatchTargetException;
import com.mathworks.toolbox.javabuilder.services.ServicePeerCreationError;
import com.mathworks.toolbox.javabuilder.services.ServiceResourceMismatchException;
import com.mathworks.toolbox.javabuilder.services.StatefulResource;
import com.mathworks.toolbox.javabuilder.services.StatefulServiceBinder;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeer;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerAction;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerActionDispatcher;
import com.mathworks.toolbox.javabuilder.statemanager.ObjectNotFoundException;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerContext;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulServicePeerCache<R extends StatefulResource, P extends StatefulServicePeer>
implements Disposable,
StatefulServicePeerActionDispatcher<P> {
    private static final boolean ASSUME_RESOURCE_BINDINGS_ARE_IMMUTABLE = false;
    private final int MAX_CACHE_SIZE;
    private StatefulServiceBinder<R, P> fStatefulServiceBinder;
    private Map<Object, Future<P>> fCache = new HashMap<Object, Future<P>>();
    private Vector<Object> fLeastRecentlyUsed = new Vector();

    public StatefulServicePeerCache(StatefulServiceBinder<R, P> statefulServiceBinder, int n) {
        this.MAX_CACHE_SIZE = n;
        this.fStatefulServiceBinder = statefulServiceBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P getServicePeer(StateManagerContext stateManagerContext, String string, String string2) throws RemoteException, ServiceResourceMismatchException, ServicePeerCreationError, StateManagerException {
        StatefulResource statefulResource = (StatefulResource)stateManagerContext.getContextScope(string).get(string2);
        if (null == statefulResource) {
            throw new ObjectNotFoundException("The resource named '" + string2 + "' at scope '" + string + "' could not be found");
        }
        StatefulResource statefulResource2 = statefulResource;
        Future<P> future = null;
        FutureTask<P> futureTask = null;
        try {
            StatefulServicePeerCache statefulServicePeerCache = this;
            synchronized (statefulServicePeerCache) {
                future = this.fCache.get(statefulResource2);
                if (null == future) {
                    Object object;
                    if (this.fLeastRecentlyUsed.size() >= this.MAX_CACHE_SIZE) {
                        object = this.fCache.get(this.fLeastRecentlyUsed.get(0));
                        this.fCache.remove(this.fLeastRecentlyUsed.get(0));
                        try {
                            ((StatefulServicePeer)object.get()).dispose();
                        }
                        catch (RemoteException remoteException) {
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        this.fLeastRecentlyUsed.remove(0);
                    }
                    object = statefulResource;
                    futureTask = new FutureTask<P>(new Callable<P>((StatefulResource)object){
                        final /* synthetic */ StatefulResource val$finalResource;
                        {
                            this.val$finalResource = statefulResource;
                        }

                        @Override
                        public P call() throws Exception {
                            return StatefulServicePeerCache.this.fStatefulServiceBinder.bindResource(this.val$finalResource);
                        }
                    });
                    future = futureTask;
                    this.fCache.put(statefulResource2, future);
                } else {
                    this.fLeastRecentlyUsed.remove(this.fLeastRecentlyUsed.indexOf(statefulResource2));
                }
                this.fLeastRecentlyUsed.add(statefulResource2);
            }
            if (futureTask != null) {
                futureTask.run();
            }
            return (P)((StatefulServicePeer)future.get());
        }
        catch (InterruptedException interruptedException) {
            throw new ServicePeerCreationError(interruptedException);
        }
        catch (ExecutionException executionException) {
            StatefulServicePeerCache statefulServicePeerCache = this;
            synchronized (statefulServicePeerCache) {
                if (this.fCache.get(statefulResource2) == future) {
                    this.fCache.remove(statefulResource2);
                    this.fLeastRecentlyUsed.remove(statefulResource2);
                }
            }
            throw new ServicePeerCreationError(executionException);
        }
    }

    @Override
    public <R> R dispatch(StatefulServicePeerAction<P, R> statefulServicePeerAction, StateManagerContext stateManagerContext, String string, String string2) throws ServiceDispatchTargetException, ServiceResourceMismatchException, ServicePeerCreationError, RemoteException, StateManagerException {
        P p = this.getServicePeer(stateManagerContext, string, string2);
        try {
            return statefulServicePeerAction.execute(p);
        }
        catch (Throwable throwable) {
            throw new ServiceDispatchTargetException(throwable);
        }
    }

    @Override
    public synchronized void dispose() {
        for (Future<P> future : this.fCache.values()) {
            try {
                ((StatefulServicePeer)future.get()).dispose();
            }
            catch (RemoteException remoteException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {}
        }
        this.fCache.clear();
        this.fLeastRecentlyUsed.clear();
        this.fStatefulServiceBinder.dispose();
    }

    private static class StatefulResourceKey {
        private StateManagerContext context;
        private String scope;
        private String name;

        public StatefulResourceKey(StateManagerContext stateManagerContext, String string, String string2) {
            this.context = stateManagerContext;
            this.scope = string;
            this.name = string2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StatefulResourceKey statefulResourceKey = (StatefulResourceKey)object;
            return this.context.equals(statefulResourceKey.context) && this.name.equals(statefulResourceKey.name) && this.scope.equals(statefulResourceKey.scope);
        }

        public int hashCode() {
            int n = this.context.hashCode();
            n = 31 * n + this.scope.hashCode();
            n = 31 * n + this.name.hashCode();
            return n;
        }
    }
}

