/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder;

import com.mathworks.toolbox.javabuilder.MWBuiltinArray;
import com.mathworks.toolbox.javabuilder.MWClassID;
import com.mathworks.toolbox.javabuilder.MWComplexity;
import com.mathworks.toolbox.javabuilder.MWUtil;
import com.mathworks.toolbox.javabuilder.NativeArray;
import com.mathworks.toolbox.javabuilder.internal.MWMCR;
import com.mathworks.toolbox.javabuilder.internal.NativePtr;
import com.mathworks.toolbox.javabuilder.remoting.AbstractMWArrayVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWNumericArray
extends MWBuiltinArray {
    public MWNumericArray() {
        super(MWUtil.CreateEmptyArray(MWClassID.DOUBLE));
    }

    public MWNumericArray(MWClassID mWClassID) {
        super(MWUtil.CreateEmptyArray(mWClassID));
    }

    public MWNumericArray(double d, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(d, 0.0, mWClassID, MWComplexity.REAL));
    }

    public MWNumericArray(double d) {
        super(MWUtil.Scalar2mxArray(d, 0.0, MWClassID.DOUBLE, MWComplexity.REAL));
    }

    public MWNumericArray(double d, double d2, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(d, d2, mWClassID, MWComplexity.COMPLEX));
    }

    public MWNumericArray(double d, double d2) {
        super(MWUtil.Scalar2mxArray(d, d2, MWClassID.DOUBLE, MWComplexity.COMPLEX));
    }

    public MWNumericArray(float f, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(f, 0.0f, mWClassID, MWComplexity.REAL));
    }

    public MWNumericArray(float f) {
        super(MWUtil.Scalar2mxArray(f, 0.0f, MWClassID.SINGLE, MWComplexity.REAL));
    }

    public MWNumericArray(float f, float f2, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(f, f2, mWClassID, MWComplexity.COMPLEX));
    }

    public MWNumericArray(float f, float f2) {
        super(MWUtil.Scalar2mxArray(f, f2, MWClassID.SINGLE, MWComplexity.COMPLEX));
    }

    public MWNumericArray(byte by, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray((int)by, 0, mWClassID, MWComplexity.REAL));
    }

    public MWNumericArray(byte by) {
        super(MWUtil.Scalar2mxArray((int)by, 0, MWClassID.INT8, MWComplexity.REAL));
    }

    public MWNumericArray(byte by, byte by2, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(by, by2, mWClassID, MWComplexity.COMPLEX));
    }

    public MWNumericArray(byte by, byte by2) {
        super(MWUtil.Scalar2mxArray(by, by2, MWClassID.INT8, MWComplexity.COMPLEX));
    }

    public MWNumericArray(int n, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(n, 0, mWClassID, MWComplexity.REAL));
    }

    public MWNumericArray(int n) {
        super(MWUtil.Scalar2mxArray(n, 0, MWClassID.INT32, MWComplexity.REAL));
    }

    public MWNumericArray(int n, int n2, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(n, n2, mWClassID, MWComplexity.COMPLEX));
    }

    public MWNumericArray(int n, int n2) {
        super(MWUtil.Scalar2mxArray(n, n2, MWClassID.INT32, MWComplexity.COMPLEX));
    }

    public MWNumericArray(short s, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray((int)s, 0, mWClassID, MWComplexity.REAL));
    }

    public MWNumericArray(short s) {
        super(MWUtil.Scalar2mxArray((int)s, 0, MWClassID.INT16, MWComplexity.REAL));
    }

    public MWNumericArray(short s, short s2, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(s, s2, mWClassID, MWComplexity.COMPLEX));
    }

    public MWNumericArray(short s, short s2) {
        super(MWUtil.Scalar2mxArray(s, s2, MWClassID.INT16, MWComplexity.COMPLEX));
    }

    public MWNumericArray(long l) {
        super(MWUtil.Scalar2mxArray(l, 0L, MWClassID.INT64, MWComplexity.REAL));
    }

    public MWNumericArray(long l, long l2, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(l, l2, mWClassID, MWComplexity.COMPLEX));
    }

    public MWNumericArray(long l, long l2) {
        super(MWUtil.Scalar2mxArray(l, l2, MWClassID.INT64, MWComplexity.COMPLEX));
    }

    public MWNumericArray(boolean bl, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(bl, false, mWClassID, MWComplexity.REAL));
    }

    public MWNumericArray(boolean bl, boolean bl2, MWClassID mWClassID) {
        super(MWUtil.Scalar2mxArray(bl, bl2, mWClassID, MWComplexity.COMPLEX));
    }

    public MWNumericArray(Object object, MWClassID mWClassID) {
        super(MWUtil.Object2mxArray(object, null, mWClassID, MWComplexity.REAL));
    }

    public MWNumericArray(Object object, Object object2, MWClassID mWClassID) {
        super(MWUtil.Object2mxArray(object, object2, mWClassID, MWComplexity.COMPLEX));
    }

    private static NativeArray createNumericArray(Object object) {
        NativeArray nativeArray = MWUtil.Object2mxArray(object, null, MWClassID.UNKNOWN, MWComplexity.REAL);
        if (!nativeArray.classID().isNumeric()) {
            nativeArray.dispose();
            nativeArray = MWUtil.Object2mxArray(object, null, MWClassID.DOUBLE, MWComplexity.REAL);
        }
        return nativeArray;
    }

    private static NativeArray createNumericArray(Object object, Object object2) {
        NativeArray nativeArray = MWUtil.Object2mxArray(object, object2, MWClassID.UNKNOWN, MWComplexity.COMPLEX);
        if (!nativeArray.classID().isNumeric()) {
            nativeArray.dispose();
            nativeArray = MWUtil.Object2mxArray(object, object2, MWClassID.DOUBLE, MWComplexity.COMPLEX);
        }
        return nativeArray;
    }

    public MWNumericArray(Object object) {
        super(MWNumericArray.createNumericArray(object));
    }

    public MWNumericArray(Object object, Object object2) {
        super(MWNumericArray.createNumericArray(object, object2));
    }

    MWNumericArray(NativeArray nativeArray) {
        super(nativeArray);
    }

    MWNumericArray(NativePtr nativePtr) {
        super(nativePtr);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Object sharedCopy() {
        return new MWNumericArray(this.getNativeArray().sharedCopy());
    }

    public MWComplexity complexity() {
        if (this.isEmpty()) {
            return MWComplexity.REAL;
        }
        return MWMCR.getNativeMCR().mxIsComplex(this.getNativeArray()) ? MWComplexity.COMPLEX : MWComplexity.REAL;
    }

    public void set(int n, double d) {
        MWUtil.setAt(this.getNativeArray(), n, d, true);
    }

    public void set(int n, float f) {
        MWUtil.setAt(this.getNativeArray(), n, f, true);
    }

    public void set(int n, byte by) {
        MWUtil.setAt(this.getNativeArray(), n, by, true);
    }

    public void set(int n, int n2) {
        MWUtil.setAt(this.getNativeArray(), n, n2, true);
    }

    public void set(int n, short s) {
        MWUtil.setAt(this.getNativeArray(), n, s, true);
    }

    public void set(int n, long l) {
        MWUtil.setAt(this.getNativeArray(), n, l, true);
    }

    public void set(int[] nArray, double d) {
        MWUtil.setAt(this.getNativeArray(), nArray, d, true);
    }

    public void set(int[] nArray, float f) {
        MWUtil.setAt(this.getNativeArray(), nArray, f, true);
    }

    public void set(int[] nArray, byte by) {
        MWUtil.setAt(this.getNativeArray(), nArray, by, true);
    }

    public void set(int[] nArray, int n) {
        MWUtil.setAt(this.getNativeArray(), nArray, n, true);
    }

    public void set(int[] nArray, short s) {
        MWUtil.setAt(this.getNativeArray(), nArray, s, true);
    }

    public void set(int[] nArray, long l) {
        MWUtil.setAt(this.getNativeArray(), nArray, l, true);
    }

    public void setImag(int n, Object object) {
        MWUtil.setAt(this.getNativeArray(), n, object, false);
    }

    public void setImag(int n, double d) {
        MWUtil.setAt(this.getNativeArray(), n, d, false);
    }

    public void setImag(int n, float f) {
        MWUtil.setAt(this.getNativeArray(), n, f, false);
    }

    public void setImag(int n, byte by) {
        MWUtil.setAt(this.getNativeArray(), n, by, false);
    }

    public void setImag(int n, int n2) {
        MWUtil.setAt(this.getNativeArray(), n, n2, false);
    }

    public void setImag(int n, short s) {
        MWUtil.setAt(this.getNativeArray(), n, s, false);
    }

    public void setImag(int n, long l) {
        MWUtil.setAt(this.getNativeArray(), n, l, false);
    }

    public void setImag(int[] nArray, Object object) {
        MWUtil.setAt(this.getNativeArray(), nArray, object, false);
    }

    public void setImag(int[] nArray, double d) {
        MWUtil.setAt(this.getNativeArray(), nArray, d, false);
    }

    public void setImag(int[] nArray, float f) {
        MWUtil.setAt(this.getNativeArray(), nArray, f, false);
    }

    public void setImag(int[] nArray, byte by) {
        MWUtil.setAt(this.getNativeArray(), nArray, by, false);
    }

    public void setImag(int[] nArray, int n) {
        MWUtil.setAt(this.getNativeArray(), nArray, n, false);
    }

    public void setImag(int[] nArray, short s) {
        MWUtil.setAt(this.getNativeArray(), nArray, s, false);
    }

    public void setImag(int[] nArray, long l) {
        MWUtil.setAt(this.getNativeArray(), nArray, l, false);
    }

    public double getDouble() {
        return this.getDouble(1);
    }

    public double getDouble(int n) {
        return MWUtil.getDoubleAt(this.getNativeArray(), n, true);
    }

    public double getDouble(int[] nArray) {
        return MWUtil.getDoubleAt(this.getNativeArray(), nArray, true);
    }

    public double getImagDouble() {
        return this.getImagDouble(1);
    }

    public double getImagDouble(int n) {
        return MWUtil.getDoubleAt(this.getNativeArray(), n, false);
    }

    public double getImagDouble(int[] nArray) {
        return MWUtil.getDoubleAt(this.getNativeArray(), nArray, false);
    }

    public float getFloat() {
        return this.getFloat(1);
    }

    public float getFloat(int n) {
        return MWUtil.getFloatAt(this.getNativeArray(), n, true);
    }

    public float getFloat(int[] nArray) {
        return MWUtil.getFloatAt(this.getNativeArray(), nArray, true);
    }

    public float getImagFloat() {
        return this.getImagFloat(1);
    }

    public float getImagFloat(int n) {
        return MWUtil.getFloatAt(this.getNativeArray(), n, false);
    }

    public float getImagFloat(int[] nArray) {
        return MWUtil.getFloatAt(this.getNativeArray(), nArray, false);
    }

    public byte getByte() {
        return this.getByte(1);
    }

    public byte getByte(int n) {
        return MWUtil.getByteAt(this.getNativeArray(), n, true);
    }

    public byte getByte(int[] nArray) {
        return MWUtil.getByteAt(this.getNativeArray(), nArray, true);
    }

    public byte getImagByte() {
        return this.getImagByte(1);
    }

    public byte getImagByte(int n) {
        return MWUtil.getByteAt(this.getNativeArray(), n, false);
    }

    public byte getImagByte(int[] nArray) {
        return MWUtil.getByteAt(this.getNativeArray(), nArray, false);
    }

    public int getInt() {
        return this.getInt(1);
    }

    public int getInt(int n) {
        return MWUtil.getIntAt(this.getNativeArray(), n, true);
    }

    public int getInt(int[] nArray) {
        return MWUtil.getIntAt(this.getNativeArray(), nArray, true);
    }

    public int getImagInt() {
        return this.getImagInt(1);
    }

    public int getImagInt(int n) {
        return MWUtil.getIntAt(this.getNativeArray(), n, false);
    }

    public int getImagInt(int[] nArray) {
        return MWUtil.getIntAt(this.getNativeArray(), nArray, false);
    }

    public short getShort() {
        return this.getShort(1);
    }

    public short getShort(int n) {
        return MWUtil.getShortAt(this.getNativeArray(), n, true);
    }

    public short getShort(int[] nArray) {
        return MWUtil.getShortAt(this.getNativeArray(), nArray, true);
    }

    public short getImagShort() {
        return this.getImagShort(1);
    }

    public short getImagShort(int n) {
        return MWUtil.getShortAt(this.getNativeArray(), n, false);
    }

    public short getImagShort(int[] nArray) {
        return MWUtil.getShortAt(this.getNativeArray(), nArray, false);
    }

    public long getLong() {
        return this.getLong(1);
    }

    public long getLong(int n) {
        return MWUtil.getLongAt(this.getNativeArray(), n, true);
    }

    public long getLong(int[] nArray) {
        return MWUtil.getLongAt(this.getNativeArray(), nArray, true);
    }

    public long getImagLong() {
        return this.getImagLong(1);
    }

    public long getImagLong(int n) {
        return MWUtil.getLongAt(this.getNativeArray(), n, false);
    }

    public long getImagLong(int[] nArray) {
        return MWUtil.getLongAt(this.getNativeArray(), nArray, false);
    }

    public Object getImag(int n) {
        return MWUtil.getObjectAt(this.getNativeArray(), n, false);
    }

    public Object getImag(int[] nArray) {
        return MWUtil.getObjectAt(this.getNativeArray(), nArray, false);
    }

    public Object toByteArray() {
        return MWUtil.getByteArray(this.getNativeArray(), true);
    }

    public Object toDoubleArray() {
        return MWUtil.getDoubleArray(this.getNativeArray(), true);
    }

    public Object toFloatArray() {
        return MWUtil.getFloatArray(this.getNativeArray(), true);
    }

    public Object toIntArray() {
        return MWUtil.getIntArray(this.getNativeArray(), true);
    }

    public Object toLongArray() {
        return MWUtil.getLongArray(this.getNativeArray(), true);
    }

    public Object toShortArray() {
        return MWUtil.getShortArray(this.getNativeArray(), true);
    }

    public Object toImagByteArray() {
        return MWUtil.getByteArray(this.getNativeArray(), false);
    }

    public Object toImagDoubleArray() {
        return MWUtil.getDoubleArray(this.getNativeArray(), false);
    }

    public Object toImagFloatArray() {
        return MWUtil.getFloatArray(this.getNativeArray(), false);
    }

    public Object toImagIntArray() {
        return MWUtil.getIntArray(this.getNativeArray(), false);
    }

    public Object toImagLongArray() {
        return MWUtil.getLongArray(this.getNativeArray(), false);
    }

    public Object toImagShortArray() {
        return MWUtil.getShortArray(this.getNativeArray(), false);
    }

    public Object toImagArray() {
        return MWUtil.getArray(this.getNativeArray(), false);
    }

    public byte[] getByteData() {
        return (byte[])MWUtil.getByteData(this.getNativeArray(), true);
    }

    public double[] getDoubleData() {
        return (double[])MWUtil.getDoubleData(this.getNativeArray(), true);
    }

    public float[] getFloatData() {
        return (float[])MWUtil.getFloatData(this.getNativeArray(), true);
    }

    public int[] getIntData() {
        return (int[])MWUtil.getIntData(this.getNativeArray(), true);
    }

    public long[] getLongData() {
        return (long[])MWUtil.getLongData(this.getNativeArray(), true);
    }

    public short[] getShortData() {
        return (short[])MWUtil.getShortData(this.getNativeArray(), true);
    }

    public byte[] getImagByteData() {
        return (byte[])MWUtil.getByteData(this.getNativeArray(), false);
    }

    public double[] getImagDoubleData() {
        return (double[])MWUtil.getDoubleData(this.getNativeArray(), false);
    }

    public float[] getImagFloatData() {
        return (float[])MWUtil.getFloatData(this.getNativeArray(), false);
    }

    public int[] getImagIntData() {
        return (int[])MWUtil.getIntData(this.getNativeArray(), false);
    }

    public long[] getImagLongData() {
        return (long[])MWUtil.getLongData(this.getNativeArray(), false);
    }

    public short[] getImagShortData() {
        return (short[])MWUtil.getShortData(this.getNativeArray(), false);
    }

    public Object getImagData() {
        return MWUtil.getData(this.getNativeArray(), false);
    }

    public void setImagData(Object object) {
        MWUtil.setData(this.getNativeArray(), object, false);
    }

    @Override
    public <T> T applyVisitor(AbstractMWArrayVisitor<T> abstractMWArrayVisitor) {
        return abstractMWArrayVisitor.visit(this);
    }

    @Override
    protected void validate() {
        super.validate();
        if (!this.getNativeArray().classID().isNumeric()) {
            this.dispose();
            throw new ArrayStoreException("Cannot initialize numeric array with type: " + this.getNativeArray().classID().toString());
        }
    }

    public static MWNumericArray newInstance(int[] nArray, MWClassID mWClassID, MWComplexity mWComplexity) {
        return new MWNumericArray(MWUtil.CreateArray(nArray, mWClassID, mWComplexity));
    }

    public static MWNumericArray newInstance(int[] nArray, Object object, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateArray(nArray, object, null, mWClassID, MWComplexity.REAL));
    }

    public static MWNumericArray newInstance(int[] nArray, Object object, Object object2, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateArray(nArray, object, object2, mWClassID, MWComplexity.COMPLEX));
    }

    public static MWNumericArray newSparse(int[] nArray, int[] nArray2, Object object, int n, int n2, int n3, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(nArray, nArray2, object, null, n, n2, n3, mWClassID, MWComplexity.REAL));
    }

    public static MWNumericArray newSparse(int[] nArray, int[] nArray2, Object object, int n, int n2, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(nArray, nArray2, object, null, n, n2, -1, mWClassID, MWComplexity.REAL));
    }

    public static MWNumericArray newSparse(int[] nArray, int[] nArray2, Object object, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(nArray, nArray2, object, null, -1, -1, -1, mWClassID, MWComplexity.REAL));
    }

    public static MWNumericArray newSparse(Object object, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(object, null, mWClassID, MWComplexity.REAL));
    }

    public static MWNumericArray newSparse(int[] nArray, int[] nArray2, Object object, Object object2, int n, int n2, int n3, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(nArray, nArray2, object, object2, n, n2, n3, mWClassID, MWComplexity.COMPLEX));
    }

    public static MWNumericArray newSparse(int[] nArray, int[] nArray2, Object object, Object object2, int n, int n2, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(nArray, nArray2, object, object2, n, n2, -1, mWClassID, MWComplexity.COMPLEX));
    }

    public static MWNumericArray newSparse(int[] nArray, int[] nArray2, Object object, Object object2, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(nArray, nArray2, object, object2, -1, -1, -1, mWClassID, MWComplexity.COMPLEX));
    }

    public static MWNumericArray newSparse(Object object, Object object2, MWClassID mWClassID) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(object, object2, mWClassID, MWComplexity.REAL));
    }

    public static MWNumericArray newSparse(int n, int n2, int n3, MWClassID mWClassID, MWComplexity mWComplexity) {
        return new MWNumericArray(MWUtil.CreateSparseMatrix(null, null, null, null, n, n2, n3, mWClassID, mWComplexity));
    }

    public static double getNaN() {
        return MWUtil.getNaN();
    }

    public static double getEps() {
        return MWUtil.getEps();
    }

    public static double getInf() {
        return MWUtil.getInf();
    }

    public static boolean isFinite(double d) {
        return MWUtil.isFinite(d);
    }

    public static boolean isInf(double d) {
        return MWUtil.isInf(d);
    }

    public static boolean isNaN(double d) {
        return MWUtil.isNaN(d);
    }
}

