/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.extern.java;

import java.io.Serializable;
import java.util.Arrays;

public abstract class MWArray
implements Serializable {
    protected Object[] flatArray;
    private int[] dims;
    private int[] axisWtArr;
    private int numOfElem;
    private int maxValidIndex;

    public abstract String toString();

    protected MWArray() {
        this.dims = new int[]{0, 0};
        this.flatArray = new Object[0];
        this.axisWtArr = new int[0];
        this.numOfElem = 0;
        this.setMaxValidIndex(0);
    }

    protected MWArray(int n, int n2) {
        this(new int[]{n, n2});
    }

    protected MWArray(int[] nArray) {
        this.setNumOfElem(nArray);
        this.dims = nArray.length > 1 ? (int[])nArray.clone() : (nArray.length == 1 ? new int[]{1, nArray[0]} : new int[]{0, 0});
        this.createAxisWeightArray();
        this.initNativeArray(this.numOfElem);
    }

    public int numberOfDimensions() {
        return this.dims.length;
    }

    public int[] getDimensions() {
        return (int[])this.dims.clone();
    }

    public int numberOfElements() {
        return this.numOfElem;
    }

    public Object get(int n) {
        if (n < 1 || n > this.getMaxValidIndex()) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        return this.flatArray[n - 1];
    }

    public Object get(int[] nArray) {
        int n = this.getOneBasedIndexForArray(nArray);
        return this.get(n);
    }

    public void set(int n, Object object) {
        if (n < 1 || n > this.getMaxValidIndex()) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        this.flatArray[n - 1] = object;
    }

    public void set(int[] nArray, Object object) {
        int n = this.getOneBasedIndexForArray(nArray);
        this.set(n, object);
    }

    public Object getData() {
        return this.flatArray.clone();
    }

    public boolean isEmpty() {
        return this.numOfElem == 0;
    }

    public int hashCode() {
        int n = 17;
        if (!this.isEmpty()) {
            for (int n3 : this.dims) {
                n = n * 7 + n3;
            }
            if (this.flatArray.length > 0) {
                for (Object object : this.flatArray) {
                    n = null == object ? n : n * 7 + object.hashCode();
                }
            }
        }
        return n < 0 ? n * -1 : n;
    }

    public boolean equals(Object object) {
        MWArray mWArray = (MWArray)object;
        return Arrays.equals(mWArray.getDimensions(), this.getDimensions()) && Arrays.equals(mWArray.flatArray, this.flatArray);
    }

    private void setNumOfElem(int[] nArray) {
        if (nArray.length == 0) {
            this.numOfElem = 0;
        } else {
            int n = 1;
            for (int n2 : nArray) {
                if (n2 < 0) {
                    throw new NegativeArraySizeException("Negative index value provided : " + n2);
                }
                n *= n2;
            }
            this.numOfElem = n;
        }
    }

    private void createAxisWeightArray() {
        this.axisWtArr = new int[this.dims.length];
        this.axisWtArr[0] = this.dims[1];
        this.axisWtArr[1] = this.dims[0];
        if (this.dims.length > 2) {
            this.axisWtArr[2] = this.axisWtArr[0] * this.axisWtArr[1];
            for (int i = 3; i < this.dims.length; ++i) {
                this.axisWtArr[i] = this.axisWtArr[i - 1] * this.dims[i - 1];
            }
        }
    }

    private Object[] getFlatArray() {
        return this.flatArray;
    }

    protected int getMaxValidIndex() {
        return this.maxValidIndex;
    }

    protected void setMaxValidIndex(int n) {
        this.maxValidIndex = n;
    }

    protected void initNativeArray(int n) {
        this.flatArray = new Object[n];
        this.setMaxValidIndex(n);
    }

    protected int getOneBasedIndexForArray(int[] nArray) {
        int n;
        if (nArray.length != this.dims.length) {
            throw new IllegalArgumentException("Invalid number of elements in the index array");
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 1 && nArray[n] <= this.dims[n]) continue;
            throw new ArrayIndexOutOfBoundsException("Invalid array index");
        }
        n = this.getPageBasedIndex(nArray[0], nArray[1]);
        if (nArray.length > 2) {
            for (int i = nArray.length - 1; i > 1; --i) {
                n += (nArray[i] - 1) * this.axisWtArr[i];
            }
        }
        return n;
    }

    private int getPageBasedIndex(int n, int n2) {
        return --n2 * this.dims[0] + --n + 1;
    }

    protected String getDimsStr() {
        String string = "";
        for (int i = 0; i < this.dims.length; ++i) {
            string = string + this.dims[i];
            if (i == this.dims.length - 1) continue;
            string = string + "x";
        }
        return string;
    }
}

