/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.rf;

import ca.ubc.cs.beta.models.rf.Regtree;
import ca.ubc.cs.beta.models.rf.RegtreeBuildParams;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;

public class RegtreeFitNoCensFix {
    private static int seed;
    private static final int RAND_MAX = 0x7FFFFFFE;
    private static int[] t;
    private static double[] B;
    private static int[] diff_t;
    private static double[] catmeans;
    private static double[] Ysplit1;
    private static int[] n1;
    private static double[] allx;
    private static double[] mu1;
    private static double[] mu2;
    private static int[] maxlocs;
    private static double[] ssx;
    private static double[] y_km;
    private static double[] c_km;
    private static int[] rows_km;
    private static double[] y_in;
    private static double[] c_in;
    private static double[] km_mean;
    private static int[] N_1;
    private static int[] O_1;
    private static int[] N_add;
    private static double[] logrank_stat;
    private static double[] E;
    private static double[] V;
    private static int[] sorder;

    private static int rand(Random r) {
        int retn = r.nextInt(Integer.MAX_VALUE);
        return retn;
    }

    public static Regtree fit(int[] dataIdxs, RegtreeBuildParams params) {
        int idx;
        int N = dataIdxs.length;
        assert (N > 0);
        int nvars = params.X[0].length;
        double[][] X = new double[N][nvars];
        double[] y = new double[N];
        boolean[] cens = new boolean[N];
        int i = 0;
        while (i < N) {
            idx = dataIdxs[i];
            X[i] = params.X[idx];
            y[i] = params.y[idx];
            ++i;
        }
        if (params.cens != null) {
            i = 0;
            while (i < N) {
                idx = dataIdxs[i];
                cens[i] = params.cens[idx];
                ++i;
            }
        }
        int[] catDomainSizes = params.catDomainSizes;
        int[][] condParents = params.condParents;
        int[][][] condParentVals = params.condParentVals;
        double ratioFeatures = params.ratioFeatures;
        double kappa = params.kappa;
        int splitMin = params.splitMin;
        Random r = params.random;
        if (r == null) {
            r = new Random();
            if (params.seed != -1) {
                r.setSeed(params.seed);
            }
        }
        if (catDomainSizes.length != nvars) {
            throw new RuntimeException("catDomainSizes must be of the same length as size(X, 2)");
        }
        Vector assignedtonode = new Vector(2 * N);
        assignedtonode.add(new Vector(N));
        int i2 = 0;
        while (i2 < N) {
            ((Vector)assignedtonode.get(0)).add(i2);
            ++i2;
        }
        int[] noderows = new int[N];
        double[] ynode = new double[N];
        boolean[] censnode = new boolean[N];
        double[] xvars = new double[N];
        double[] x = new double[N];
        int[] rows = new int[N];
        double[] ycum = new double[N];
        int[] randomPermutation = new int[nvars];
        double resuberr = 0.0;
        int[] nodenumber = new int[2 * N];
        nodenumber[0] = 0;
        int[] nodesize = new int[2 * N];
        int[] cutvar = new int[2 * N];
        double[] cutpoint = new double[2 * N];
        int[] leftchildren = new int[2 * N];
        int[] rightchildren = new int[2 * N];
        int[] parent = new int[2 * N];
        double[][] ysub = new double[2 * N][];
        boolean[][] censsub = new boolean[2 * N][];
        int[] period = new int[N];
        double[] period_time = new double[N + 1];
        int[] N_all = new int[N];
        int[] C_all = new int[N];
        int[] O_all = new int[N];
        double[] ynode_idx = new double[N];
        boolean[] censnode_idx = new boolean[N];
        int[] period_idx = new int[N];
        int[] xleft = new int[N];
        int[] xright = new int[N];
        int[] numLeftPointer = new int[1];
        int[] numRightPointer = new int[1];
        double[] cutvalPointer = new double[1];
        double[] critvalPointer = new double[1];
        int[] bestleft = new int[N];
        int[] bestright = new int[N];
        int[] leftside = new int[N];
        int[] rightside = new int[N];
        int ncatsplit = 0;
        int[][] catsplit = new int[2 * N][];
        boolean hascens = false;
        int i3 = 0;
        while (i3 < N) {
            if (cens[i3]) {
                hascens = true;
                break;
            }
            ++i3;
        }
        if (!hascens) {
            t = new int[N];
            B = new double[N];
            diff_t = new int[N];
            catmeans = new double[N];
            Ysplit1 = new double[N - 1];
            n1 = new int[N - 1];
            allx = new double[N];
            mu1 = new double[N - 1];
            mu2 = new double[N - 1];
            maxlocs = new int[N - 1];
            ssx = new double[N - 1];
        } else {
            y_in = new double[N];
            c_in = new double[N];
            km_mean = new double[N];
            N_1 = new int[N];
            O_1 = new int[N];
            N_add = new int[N];
            logrank_stat = new double[N - 1];
            E = new double[N];
            V = new double[N];
            allx = new double[N];
            maxlocs = new int[N - 1];
            y_km = new double[N];
            c_km = new double[N];
            rows_km = new int[N];
        }
        sorder = new int[N];
        int[] stack = new int[N];
        stack[0] = 0;
        int stacktop = 0;
        int numNodes = 1;
        while (stacktop >= 0) {
            boolean impure;
            int tnode;
            int Nnode;
            if ((Nnode = ((Vector)assignedtonode.get(tnode = stack[stacktop--])).size()) == 0) {
                throw new RuntimeException("Nnode is 0!!");
            }
            int numUncensNode = 0;
            double ysum = 0.0;
            double ysumOfSq = 0.0;
            int i4 = 0;
            while (i4 < Nnode) {
                int idx2;
                noderows[i4] = idx2 = ((Integer)((Vector)assignedtonode.get(tnode)).get(i4)).intValue();
                ynode[i4] = y[idx2];
                ysum += y[idx2];
                ysumOfSq += y[idx2] * y[idx2];
                censnode[i4] = cens[idx2];
                if (!cens[idx2]) {
                    ++numUncensNode;
                }
                ++i4;
            }
            double ybar = ysum / (double)Nnode;
            double mincost = Nnode == 1 ? 0.0 : (ysumOfSq - ysum * ysum / (double)Nnode) / (double)(Nnode - 1);
            boolean bl = impure = mincost > 1.0E-20 * resuberr;
            if (tnode == 0) {
                resuberr = mincost;
            }
            nodesize[tnode] = Nnode;
            cutvar[tnode] = 0;
            cutpoint[tnode] = 0.0;
            leftchildren[tnode] = 0;
            rightchildren[tnode] = 0;
            double bestcrit = -1.0E12;
            int numBestLeft = 0;
            int numBestRight = 0;
            if (impure && numUncensNode >= splitMin) {
                int i5;
                int bestvar = -1;
                double bestcut = 0.0;
                int nvarshere = 0;
                if (condParents == null) {
                    nvarshere = nvars;
                    i5 = 0;
                    while (i5 < nvars) {
                        randomPermutation[i5] = i5;
                        ++i5;
                    }
                } else {
                    i5 = 0;
                    while (i5 < nvars) {
                        boolean isenabled = true;
                        if (condParents[i5] != null) {
                            int j = 0;
                            while (j < condParents[i5].length) {
                                int[] compatibleValues = RegtreeFitNoCensFix.getCompatibleValues(tnode, condParents[i5][j], N, parent, cutvar, cutpoint, leftchildren, rightchildren, catsplit, catDomainSizes);
                                int k = 0;
                                while (k < compatibleValues.length) {
                                    boolean isokvalue = false;
                                    int l = 0;
                                    while (l < condParentVals[i5][j].length) {
                                        if (compatibleValues[k] == condParentVals[i5][j][l]) {
                                            isokvalue = true;
                                            break;
                                        }
                                        ++l;
                                    }
                                    if (!isokvalue) {
                                        isenabled = false;
                                        break;
                                    }
                                    ++k;
                                }
                                if (!isenabled) break;
                                ++j;
                            }
                        }
                        if (isenabled) {
                            randomPermutation[nvarshere++] = i5;
                        }
                        ++i5;
                    }
                }
                RegtreeFitNoCensFix.shuffle(randomPermutation, nvarshere, r);
                int num_periods = 0;
                if (hascens) {
                    RegtreeFitNoCensFix.rankSort(ynode, Nnode);
                    int j = 0;
                    while (j < Nnode) {
                        period[j] = 0;
                        ++j;
                    }
                    double last_time = -1.0E10;
                    int j2 = 0;
                    while (j2 < Nnode) {
                        int i6 = sorder[j2];
                        if (!censnode[i6]) {
                            if (ynode[i6] > last_time + 1.0E-6) {
                                period_time[++num_periods] = ynode[i6];
                                last_time = ynode[i6];
                            }
                            period[i6] = num_periods;
                        }
                        ++j2;
                    }
                    int curr_period = 0;
                    double this_time = 0.0;
                    int i7 = 0;
                    while (i7 < Nnode) {
                        if (censnode[i7]) {
                            this_time = curr_period == num_periods ? 1.0E9 : period_time[curr_period + 1];
                            while (ynode[i7] > this_time - 1.0E-6) {
                                this_time = ++curr_period == num_periods ? 1.0E9 : period_time[curr_period + 1];
                            }
                            period[i7] = curr_period;
                        }
                        ++i7;
                    }
                    int p = 0;
                    while (p < num_periods) {
                        O_all[p] = 0;
                        C_all[p] = 0;
                        ++p;
                    }
                    i7 = 0;
                    while (i7 < Nnode) {
                        int p2 = period[i7];
                        if (!censnode[i7]) {
                            int n = p2 - 1;
                            O_all[n] = O_all[n] + 1;
                        } else if (p2 > 0) {
                            int n = p2 - 1;
                            C_all[n] = C_all[n] + 1;
                        }
                        ++i7;
                    }
                    N_all[0] = Nnode;
                    p = 1;
                    while (p < num_periods) {
                        N_all[p] = N_all[p - 1] - O_all[p - 1] - C_all[p - 1];
                        ++p;
                    }
                }
                int i8 = 0;
                while (i8 < nvarshere) {
                    int nextvar = randomPermutation[i8];
                    boolean xcat = catDomainSizes[nextvar] != 0;
                    int j = 0;
                    while (j < Nnode) {
                        xvars[j] = X[noderows[j]][nextvar];
                        ++j;
                    }
                    RegtreeFitNoCensFix.rankSort(xvars, Nnode);
                    j = 0;
                    while (j < Nnode) {
                        x[j] = xvars[sorder[j]];
                        ++j;
                    }
                    if (!(x[Nnode - 1] - x[0] < 1.0E-10)) {
                        int numrows = 0;
                        int j3 = 0;
                        while (j3 < Nnode - 1) {
                            if (x[j3] + 1.0E-10 < x[j3 + 1]) {
                                rows[numrows++] = j3 + 1;
                            }
                            ++j3;
                        }
                        if (numrows != 0) {
                            if (hascens) {
                                j3 = 0;
                                while (j3 < Nnode) {
                                    ynode_idx[j3] = ynode[sorder[j3]];
                                    censnode_idx[j3] = censnode[sorder[j3]];
                                    period_idx[j3] = period[sorder[j3]];
                                    ++j3;
                                }
                                if (xcat) {
                                    RegtreeFitNoCensFix.Rcritval_cat_logrank(x, Nnode, ynode_idx, censnode_idx, rows, numrows, period_idx, num_periods, N_all, O_all, kappa, critvalPointer, xleft, xright, numLeftPointer, numRightPointer, r);
                                } else {
                                    RegtreeFitNoCensFix.Rcritval_cont_logrank(x, Nnode, censnode_idx, rows, numrows, period_idx, num_periods, N_all, O_all, critvalPointer, cutvalPointer, r);
                                }
                            } else {
                                ycum[0] = ynode[sorder[0]] - ybar;
                                j3 = 1;
                                while (j3 < Nnode) {
                                    ycum[j3] = ycum[j3 - 1] + ynode[sorder[j3]] - ybar;
                                    ++j3;
                                }
                                if (xcat) {
                                    RegtreeFitNoCensFix.Rcritval_cat(x, ycum, rows, Nnode, numrows, critvalPointer, xleft, xright, numLeftPointer, numRightPointer, r);
                                } else {
                                    RegtreeFitNoCensFix.Rcritval_cont(x, ycum, rows, Nnode, numrows, critvalPointer, cutvalPointer, r);
                                }
                            }
                            if (critvalPointer[0] > bestcrit + 1.0E-10) {
                                bestcrit = critvalPointer[0];
                                bestvar = nextvar;
                                if (xcat) {
                                    numBestLeft = numLeftPointer[0];
                                    numBestRight = numRightPointer[0];
                                    j3 = 0;
                                    while (j3 < numBestLeft) {
                                        bestleft[j3] = xleft[j3];
                                        ++j3;
                                    }
                                    j3 = 0;
                                    while (j3 < numBestRight) {
                                        bestright[j3] = xright[j3];
                                        ++j3;
                                    }
                                } else {
                                    bestcut = cutvalPointer[0];
                                }
                            }
                            if (i8 >= Math.max(1, (int)Math.floor(ratioFeatures * (double)nvarshere)) - 1 && bestcrit > -1.0E11) break;
                        }
                    }
                    ++i8;
                }
                int nleft = 0;
                int nright = 0;
                if (bestvar != -1) {
                    int i9 = 0;
                    while (i9 < Nnode) {
                        x[i9] = X[noderows[i9]][bestvar];
                        ++i9;
                    }
                    if (catDomainSizes[bestvar] != 0) {
                        int j;
                        cutvar[tnode] = -(bestvar + 1);
                        cutpoint[tnode] = ncatsplit;
                        int[] compatibleValues = RegtreeFitNoCensFix.getCompatibleValues(tnode, bestvar, N, parent, cutvar, cutpoint, leftchildren, rightchildren, catsplit, catDomainSizes);
                        int[] missing_values_for_left = new int[compatibleValues.length];
                        int[] missing_values_for_right = new int[compatibleValues.length];
                        int num_missing_to_left = 0;
                        int num_missing_to_right = 0;
                        int i10 = 0;
                        while (i10 < compatibleValues.length) {
                            int nextValue = compatibleValues[i10];
                            j = 0;
                            while (j < numBestLeft) {
                                if (nextValue == bestleft[j]) break;
                                ++j;
                            }
                            if (j == numBestLeft) {
                                j = 0;
                                while (j < numBestRight) {
                                    if (nextValue == bestright[j]) break;
                                    ++j;
                                }
                                if (j == numBestRight) {
                                    if (RegtreeFitNoCensFix.rand(r) % 2 == 0) {
                                        missing_values_for_left[num_missing_to_left++] = nextValue;
                                    } else {
                                        missing_values_for_right[num_missing_to_right++] = nextValue;
                                    }
                                }
                            }
                            ++i10;
                        }
                        i10 = num_missing_to_left;
                        while (i10 < num_missing_to_left + numBestLeft) {
                            missing_values_for_left[i10] = bestleft[i10 - num_missing_to_left];
                            ++i10;
                        }
                        RegtreeFitNoCensFix.sort(missing_values_for_left, num_missing_to_left + numBestLeft);
                        i10 = num_missing_to_right;
                        while (i10 < num_missing_to_right + numBestRight) {
                            missing_values_for_right[i10] = bestright[i10 - num_missing_to_right];
                            ++i10;
                        }
                        RegtreeFitNoCensFix.sort(missing_values_for_right, num_missing_to_right + numBestRight);
                        catsplit[ncatsplit] = new int[num_missing_to_left + numBestLeft];
                        i10 = 0;
                        while (i10 < num_missing_to_left + numBestLeft) {
                            catsplit[ncatsplit][i10] = missing_values_for_left[i10];
                            ++i10;
                        }
                        catsplit[ncatsplit + N] = new int[num_missing_to_right + numBestRight];
                        i10 = 0;
                        while (i10 < num_missing_to_right + numBestRight) {
                            catsplit[ncatsplit + N][i10] = missing_values_for_right[i10];
                            ++i10;
                        }
                        ++ncatsplit;
                        i10 = 0;
                        while (i10 < Nnode) {
                            boolean onleft = false;
                            j = 0;
                            while (j < numBestLeft) {
                                if ((int)Math.floor(x[i10] + 0.5) == bestleft[j]) {
                                    onleft = true;
                                    break;
                                }
                                ++j;
                            }
                            if (onleft) {
                                leftside[nleft++] = i10;
                            } else {
                                rightside[nright++] = i10;
                            }
                            ++i10;
                        }
                    } else {
                        cutvar[tnode] = bestvar + 1;
                        cutpoint[tnode] = bestcut;
                        i9 = 0;
                        while (i9 < Nnode) {
                            if (x[i9] <= bestcut) {
                                leftside[nleft++] = i9;
                            } else {
                                rightside[nright++] = i9;
                            }
                            ++i9;
                        }
                    }
                    if (nleft == 0 || nright == 0) {
                        throw new RuntimeException("Empty side after splitting!");
                    }
                    leftchildren[tnode] = numNodes;
                    rightchildren[tnode] = numNodes + 1;
                    parent[numNodes] = tnode;
                    parent[numNodes + 1] = tnode;
                    nodenumber[numNodes] = numNodes;
                    nodenumber[numNodes + 1] = numNodes + 1;
                    assignedtonode.add(new Vector(nleft));
                    Vector leftchildnode = (Vector)assignedtonode.get(numNodes);
                    int i11 = 0;
                    while (i11 < nleft) {
                        leftchildnode.add(noderows[leftside[i11]]);
                        ++i11;
                    }
                    assignedtonode.add(new Vector(nright));
                    Vector rightchildnode = (Vector)assignedtonode.get(numNodes + 1);
                    int i12 = 0;
                    while (i12 < nright) {
                        rightchildnode.add(noderows[rightside[i12]]);
                        ++i12;
                    }
                    stack[++stacktop] = numNodes;
                    stack[++stacktop] = numNodes + 1;
                    numNodes += 2;
                }
            }
            if (leftchildren[tnode] == 0) {
                ysub[tnode] = new double[Nnode];
                censsub[tnode] = new boolean[Nnode];
                System.arraycopy(ynode, 0, ysub[tnode], 0, Nnode);
                System.arraycopy(censnode, 0, censsub[tnode], 0, Nnode);
            }
            ++tnode;
        }
        Regtree tree = new Regtree(numNodes, ncatsplit, params.storeResponses, params.logModel);
        System.arraycopy(nodenumber, 0, tree.node, 0, numNodes);
        System.arraycopy(parent, 0, tree.parent, 0, numNodes);
        System.arraycopy(cutvar, 0, tree.var, 0, numNodes);
        System.arraycopy(cutpoint, 0, tree.cut, 0, numNodes);
        System.arraycopy(nodesize, 0, tree.nodesize, 0, numNodes);
        tree.npred = nvars;
        int nextnode = -1;
        int i13 = 0;
        while (i13 < ncatsplit) {
            while (cutvar[++nextnode] >= 0) {
            }
            int[] tmp = new int[catDomainSizes[-cutvar[nextnode] - 1]];
            Arrays.fill(tmp, -1);
            int[] cs = catsplit[(int)cutpoint[nextnode]];
            int j = 0;
            while (j < cs.length) {
                tmp[cs[j] - 1] = 0;
                ++j;
            }
            cs = catsplit[(int)cutpoint[nextnode] + N];
            j = 0;
            while (j < cs.length) {
                tmp[cs[j] - 1] = 1;
                ++j;
            }
            tree.catsplit[(int)cutpoint[nextnode]] = tmp;
            ++i13;
        }
        i13 = 0;
        while (i13 < numNodes) {
            int Nnode;
            tree.children[i13][0] = leftchildren[i13];
            tree.children[i13][1] = rightchildren[i13];
            int n = Nnode = leftchildren[i13] == 0 ? nodesize[i13] : 0;
            if (params.logModel == 1 || params.logModel == 2) {
                int j = 0;
                while (j < Nnode) {
                    ysub[i13][j] = Math.pow(10.0, ysub[i13][j]);
                    ++j;
                }
            }
            if (Nnode != 0) {
                if (params.storeResponses) {
                    tree.ysub[i13] = new double[Nnode];
                    tree.is_censored[i13] = new boolean[Nnode];
                    System.arraycopy(ysub[i13], 0, tree.ysub[i13], 0, Nnode);
                    System.arraycopy(censsub[i13], 0, tree.is_censored[i13], 0, Nnode);
                } else {
                    double sum = 0.0;
                    double sumOfSq = 0.0;
                    double sumOfLog = 0.0;
                    double sumOfLogSq = 0.0;
                    int j = 0;
                    while (j < Nnode) {
                        double next = ysub[i13][j];
                        sum += next;
                        sumOfSq += next * next;
                        ++j;
                    }
                    tree.ysub[i13][0] = sum;
                    tree.ysub[i13][1] = sumOfSq;
                }
            }
            ++i13;
        }
        tree.recalculateStats();
        t = null;
        B = null;
        diff_t = null;
        catmeans = null;
        Ysplit1 = null;
        n1 = null;
        allx = null;
        mu1 = null;
        mu2 = null;
        maxlocs = null;
        ssx = null;
        y_in = null;
        c_in = null;
        km_mean = null;
        N_1 = null;
        O_1 = null;
        N_add = null;
        logrank_stat = null;
        E = null;
        V = null;
        allx = null;
        maxlocs = null;
        y_km = null;
        c_km = null;
        rows_km = null;
        sorder = null;
        return tree;
    }

    private static int[] getCompatibleValues(int currnode, int var, int N, int[] parent, int[] cutvar, double[] cutpoint, int[] leftchildren, int[] rightchildren, int[][] catsplit, int[] catDomainSizes) {
        int[] compatibleValues = null;
        while (currnode > 0) {
            int parent_node = parent[currnode];
            if (-cutvar[parent_node] - 1 == var) {
                int catsplit_index = (int)cutpoint[parent_node];
                if (leftchildren[parent_node] == currnode) {
                    compatibleValues = catsplit[catsplit_index];
                    break;
                }
                if (rightchildren[parent_node] == currnode) {
                    compatibleValues = catsplit[catsplit_index + N];
                    break;
                }
                throw new RuntimeException("currnode must be either left or right child of its parent.");
            }
            currnode = parent_node;
        }
        if (currnode == 0) {
            compatibleValues = new int[catDomainSizes[var]];
            int i = 0;
            while (i < compatibleValues.length) {
                compatibleValues[i] = i + 1;
                ++i;
            }
        }
        return compatibleValues;
    }

    private static void Rcritval_cat(double[] x, double[] Ycum, int[] rows, int nX, int nrows, double[] critval_res, int[] xleft, int[] xright, int[] numLeftPointer, int[] numRightPointer, Random r) {
        int n = nrows + 1;
        int i = 0;
        while (i < n - 1) {
            RegtreeFitNoCensFix.t[i] = rows[i] - 1;
            ++i;
        }
        RegtreeFitNoCensFix.t[n - 1] = nX - 1;
        RegtreeFitNoCensFix.B[0] = Ycum[t[0]];
        i = 1;
        while (i < n) {
            RegtreeFitNoCensFix.B[i] = Ycum[t[i]] - Ycum[t[i - 1]];
            ++i;
        }
        RegtreeFitNoCensFix.diff_t[0] = t[0] + 1;
        i = 1;
        while (i < n) {
            RegtreeFitNoCensFix.diff_t[i] = t[i] - t[i - 1];
            ++i;
        }
        i = 0;
        while (i < n) {
            RegtreeFitNoCensFix.catmeans[i] = B[i] / (double)Math.max(1, diff_t[i]);
            ++i;
        }
        RegtreeFitNoCensFix.rankSort(catmeans, n);
        Arrays.fill(Ysplit1, 0, n - 1, 0.0);
        Arrays.fill(n1, 0, n - 1, 0);
        i = 0;
        while (i < n - 1) {
            int j = 0;
            while (j <= i) {
                RegtreeFitNoCensFix.Ysplit1[i] = Ysplit1[i] + B[sorder[j]];
                RegtreeFitNoCensFix.n1[i] = n1[i] + diff_t[sorder[j]];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            RegtreeFitNoCensFix.allx[i] = x[t[i]];
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            RegtreeFitNoCensFix.mu1[i] = Ysplit1[i] / (double)n1[i];
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            RegtreeFitNoCensFix.mu2[i] = (Ycum[nX - 1] - Ysplit1[i]) / (double)(nX - n1[i]);
            ++i;
        }
        int maxnumlocs = 0;
        critval_res[0] = -1.0E13;
        int i2 = 0;
        while (i2 < n - 1) {
            RegtreeFitNoCensFix.ssx[i2] = (double)n1[i2] * mu1[i2] * mu1[i2] + (double)(nX - n1[i2]) * mu2[i2] * mu2[i2];
            if (ssx[i2] > critval_res[0] - 1.0E-10) {
                if (ssx[i2] > critval_res[0] + 1.0E-10) {
                    critval_res[0] = ssx[i2];
                    maxnumlocs = 0;
                }
                RegtreeFitNoCensFix.maxlocs[maxnumlocs] = i2;
                ++maxnumlocs;
            }
            ++i2;
        }
        int maxloc = maxlocs[RegtreeFitNoCensFix.rand(r) % maxnumlocs];
        numLeftPointer[0] = maxloc + 1;
        numRightPointer[0] = n - numLeftPointer[0];
        int i3 = 0;
        while (i3 < maxloc + 1) {
            xleft[i3] = (int)allx[sorder[i3]];
            ++i3;
        }
        RegtreeFitNoCensFix.sort(xleft, maxloc + 1);
        i3 = maxloc + 1;
        while (i3 < n) {
            xright[i3 - (maxloc + 1)] = (int)allx[sorder[i3]];
            ++i3;
        }
        RegtreeFitNoCensFix.sort(xright, n - (maxloc + 1));
    }

    private static void Rcritval_cont(double[] x, double[] Ycum, int[] rows, int nX, int nrows, double[] critval_res, double[] cutval_res, Random r) {
        int i = 0;
        while (i < nrows) {
            RegtreeFitNoCensFix.Ysplit1[i] = Ycum[rows[i] - 1];
            ++i;
        }
        i = 0;
        while (i < nrows) {
            RegtreeFitNoCensFix.mu1[i] = Ysplit1[i] / (double)rows[i];
            ++i;
        }
        i = 0;
        while (i < nrows) {
            RegtreeFitNoCensFix.mu2[i] = (Ycum[nX - 1] - Ysplit1[i]) / (double)(nX - rows[i]);
            ++i;
        }
        int maxnumlocs = 0;
        critval_res[0] = -1.0E13;
        int i2 = 0;
        while (i2 < nrows) {
            RegtreeFitNoCensFix.ssx[i2] = (double)rows[i2] * mu1[i2] * mu1[i2] + (double)(nX - rows[i2]) * mu2[i2] * mu2[i2];
            if (ssx[i2] > critval_res[0] - 1.0E-10) {
                if (ssx[i2] > critval_res[0] + 1.0E-10) {
                    critval_res[0] = ssx[i2];
                    maxnumlocs = 0;
                }
                RegtreeFitNoCensFix.maxlocs[maxnumlocs] = i2;
                ++maxnumlocs;
            }
            ++i2;
        }
        int maxloc = maxlocs[RegtreeFitNoCensFix.rand(r) % maxnumlocs];
        int cutloc = rows[maxloc] - 1;
        double u = (double)RegtreeFitNoCensFix.rand(r) * 1.0 / 2.147483646E9;
        if (x[cutloc + 1] - x[cutloc] < 1.8999999999999998E-6) {
            cutval_res[0] = (x[cutloc] + x[cutloc + 1]) / 2.0;
        } else {
            cutval_res[0] = (1.0 - u) * (x[cutloc] + 1.0E-6) + u * (x[cutloc + 1] - 1.0E-6);
            if (cutval_res[0] < x[cutloc] + 1.0E-8 || cutval_res[0] > x[cutloc + 1] - 1.0E-8) {
                throw new RuntimeException("random splitpoint has to lie in between the upper and lower limit");
            }
        }
    }

    private static double kaplan_meier_mean(int N, int M, double[] y_in, double[] c_in, double upper_bound) {
        int N_i = N + M;
        if (N_i == 0) {
            throw new RuntimeException("Kaplan-Meier estimator undefined for empty population.");
        }
        int i = 0;
        while (i < N) {
            RegtreeFitNoCensFix.y_km[i] = y_in[i];
            ++i;
        }
        i = 0;
        while (i < M) {
            RegtreeFitNoCensFix.c_km[i] = c_in[i];
            ++i;
        }
        RegtreeFitNoCensFix.sort(y_km, N);
        RegtreeFitNoCensFix.sort(c_km, M);
        double km_mean = 0.0;
        if (N > 0) {
            int num_rows = 0;
            int i2 = 0;
            while (i2 < N - 1) {
                if (y_km[i2] + 1.0E-10 < y_km[i2 + 1]) {
                    RegtreeFitNoCensFix.rows_km[num_rows++] = i2;
                }
                ++i2;
            }
            RegtreeFitNoCensFix.rows_km[num_rows++] = N - 1;
            double prod = 1.0;
            int c_idx = 0;
            int i3 = 0;
            while (i3 < num_rows) {
                int d_i;
                double t_i = y_km[rows_km[i3]];
                while (c_idx < M && c_km[c_idx] < t_i) {
                    --N_i;
                    ++c_idx;
                }
                if (i3 == 0) {
                    d_i = rows_km[i3] + 1;
                    km_mean += prod * y_km[rows_km[i3]];
                } else {
                    d_i = rows_km[i3] - rows_km[i3 - 1];
                    km_mean += prod * (y_km[rows_km[i3]] - y_km[rows_km[i3 - 1]]);
                }
                prod *= ((double)(N_i - d_i) + 0.0) / ((double)N_i + 0.0);
                N_i -= d_i;
                ++i3;
            }
            km_mean += prod * (upper_bound - y_km[N - 1]) / 2.0;
        } else {
            km_mean = upper_bound;
        }
        return km_mean;
    }

    private static double logrank_statistic(int num_periods, int[] N, int[] O, int[] N_1, int[] O_1, double[] E, double[] V) {
        double sum_V = 0.0;
        double numerator = 0.0;
        int p = 0;
        while (p < num_periods) {
            E[p] = (double)O[p] * (((double)N_1[p] + 0.0) / (double)N[p]);
            if (N[p] <= 1) {
                V[p] = 0.0;
            } else {
                V[p] = E[p] * (1.0 - ((double)N_1[p] + 0.0) / (double)N[p]) * (double)(N[p] - O[p]) / ((double)N[p] - 1.0);
                sum_V += V[p];
                numerator += (double)O_1[p] - E[p];
            }
            ++p;
        }
        double denominator = Math.sqrt(sum_V);
        if (Math.abs(denominator) < 1.0E-6) {
            if (Math.abs(numerator) < 1.0E-6) {
                return 0.0;
            }
            throw new RuntimeException("Division by zero in function logrank_statistic.");
        }
        return numerator / denominator;
    }

    private static void Rcritval_cat_logrank(double[] x, int nX, double[] y, boolean[] cens, int[] rows, int nRows, int[] period, int num_periods, int[] N_all, int[] O_all, double kappa, double[] critval_res, int[] xleft, int[] xright, int[] numLeftPointer, int[] numRightPointer, Random r) {
        int i = 0;
        while (i <= nRows) {
            int low = i == 0 ? 0 : rows[i - 1];
            int high = i == nRows ? nX : rows[i];
            int numNonCens = 0;
            int numCens = 0;
            int j = low;
            while (j < high) {
                if (cens[j]) {
                    RegtreeFitNoCensFix.c_in[numCens++] = y[j];
                } else {
                    RegtreeFitNoCensFix.y_in[numNonCens++] = y[j];
                }
                ++j;
            }
            RegtreeFitNoCensFix.km_mean[i] = RegtreeFitNoCensFix.kaplan_meier_mean(numNonCens, numCens, y_in, c_in, kappa);
            ++i;
        }
        RegtreeFitNoCensFix.rankSort(km_mean, nRows + 1);
        i = 0;
        while (i < num_periods) {
            RegtreeFitNoCensFix.N_1[i] = 0;
            RegtreeFitNoCensFix.O_1[i] = 0;
            ++i;
        }
        int s = 0;
        while (s < nRows) {
            int p;
            int group_no = sorder[s];
            int low = group_no == 0 ? 0 : rows[group_no - 1];
            int high = group_no == nRows ? nX : rows[group_no];
            int maxperiod = -1;
            int i2 = low;
            while (i2 < high) {
                maxperiod = Math.max(maxperiod, period[i2]);
                ++i2;
            }
            int p2 = 0;
            while (p2 < num_periods) {
                RegtreeFitNoCensFix.N_add[p2] = 0;
                ++p2;
            }
            i2 = low;
            while (i2 < high) {
                p = period[i2] - 1;
                if (p >= 0) {
                    if (!cens[i2]) {
                        int n = p;
                        O_1[n] = O_1[n] + 1;
                    }
                    int n = p;
                    N_add[n] = N_add[n] + 1;
                }
                ++i2;
            }
            int N_scalar = 0;
            p = num_periods - 1;
            while (p >= 0) {
                int n = p;
                N_1[n] = N_1[n] + (N_scalar += N_add[p]);
                if (N_1[p] < O_1[p]) {
                    throw new RuntimeException("O_1[p] > N_1[p] -- should be impossible");
                }
                --p;
            }
            RegtreeFitNoCensFix.logrank_stat[s] = RegtreeFitNoCensFix.logrank_statistic(num_periods, N_all, O_all, N_1, O_1, E, V);
            ++s;
        }
        critval_res[0] = -1.0;
        int maxnumlocs = 0;
        int i3 = 0;
        while (i3 < nRows) {
            if (Math.abs(logrank_stat[i3]) > critval_res[0] - 1.0E-6) {
                if (Math.abs(logrank_stat[i3]) > critval_res[0] + 1.0E-6) {
                    critval_res[0] = Math.abs(logrank_stat[i3]);
                    maxnumlocs = 0;
                }
                RegtreeFitNoCensFix.maxlocs[maxnumlocs] = i3;
                ++maxnumlocs;
            }
            ++i3;
        }
        int maxloc = maxlocs[RegtreeFitNoCensFix.rand(r) % maxnumlocs];
        int i4 = 0;
        while (i4 < nRows) {
            RegtreeFitNoCensFix.allx[i4] = x[rows[i4] - 1];
            ++i4;
        }
        RegtreeFitNoCensFix.allx[nRows] = x[nX - 1];
        numLeftPointer[0] = maxloc + 1;
        numRightPointer[0] = nRows + 1 - maxloc - 1;
        i4 = 0;
        while (i4 < maxloc + 1) {
            xleft[i4] = (int)allx[sorder[i4]];
            ++i4;
        }
        RegtreeFitNoCensFix.sort(xleft, maxloc + 1);
        i4 = maxloc + 1;
        while (i4 < nRows + 1) {
            xright[i4 - (maxloc + 1)] = (int)allx[sorder[i4]];
            ++i4;
        }
        RegtreeFitNoCensFix.sort(xright, nRows + 1 - (maxloc + 1));
    }

    private static void Rcritval_cont_logrank(double[] x, int nX, boolean[] cens, int[] rows, int nRows, int[] period, int num_periods, int[] N_all, int[] O_all, double[] critval_res, double[] cutval_res, Random r) {
        int i = 0;
        while (i < num_periods) {
            RegtreeFitNoCensFix.N_1[i] = 0;
            RegtreeFitNoCensFix.O_1[i] = 0;
            ++i;
        }
        int group_no = 0;
        while (group_no < nRows) {
            int p;
            int low = group_no == 0 ? 0 : rows[group_no - 1];
            int high = group_no == nRows ? nX : rows[group_no];
            int maxperiod = -1;
            int i2 = low;
            while (i2 < high) {
                maxperiod = Math.max(maxperiod, period[i2]);
                ++i2;
            }
            int p2 = 0;
            while (p2 < maxperiod) {
                RegtreeFitNoCensFix.N_add[p2] = 0;
                ++p2;
            }
            i2 = low;
            while (i2 < high) {
                p = period[i2] - 1;
                if (p >= 0) {
                    if (!cens[i2]) {
                        int n = p;
                        O_1[n] = O_1[n] + 1;
                    }
                    int n = p;
                    N_add[n] = N_add[n] + 1;
                }
                ++i2;
            }
            int N_scalar = 0;
            p = maxperiod - 1;
            while (p >= 0) {
                int n = p--;
                N_1[n] = N_1[n] + (N_scalar += N_add[p]);
            }
            RegtreeFitNoCensFix.logrank_stat[group_no] = RegtreeFitNoCensFix.logrank_statistic(num_periods, N_all, O_all, N_1, O_1, E, V);
            ++group_no;
        }
        critval_res[0] = -1.0;
        int maxnumlocs = 0;
        int i3 = 0;
        while (i3 < nRows) {
            if (Math.abs(logrank_stat[i3]) > critval_res[0] - 1.0E-10) {
                if (Math.abs(logrank_stat[i3]) > critval_res[0] + 1.0E-10) {
                    critval_res[0] = Math.abs(logrank_stat[i3]);
                    maxnumlocs = 0;
                }
                RegtreeFitNoCensFix.maxlocs[maxnumlocs] = i3;
                ++maxnumlocs;
            }
            ++i3;
        }
        int maxloc = maxlocs[RegtreeFitNoCensFix.rand(r) % maxnumlocs];
        int cutloc = rows[maxloc] - 1;
        double u = (double)RegtreeFitNoCensFix.rand(r) * 1.0 / 2.147483646E9;
        if (x[cutloc + 1] - x[cutloc] < 1.8999999999999998E-6) {
            cutval_res[0] = (x[cutloc] + x[cutloc + 1]) / 2.0;
        } else {
            cutval_res[0] = (1.0 - u) * (x[cutloc] + 1.0E-6) + u * (x[cutloc + 1] - 1.0E-6);
            if (cutval_res[0] < x[cutloc] + 1.0E-8 || cutval_res[0] > x[cutloc + 1] - 1.0E-8) {
                throw new RuntimeException("random splitpoint has to lie in between the upper and lower limit");
            }
        }
    }

    private static void shuffle(int[] arr, int n, Random r) {
        int i = 0;
        while (i < n - 1) {
            int j = i + RegtreeFitNoCensFix.rand(r) / (0x7FFFFFFE / (n - i) + 1);
            int t = arr[j];
            arr[j] = arr[i];
            arr[i] = t;
            ++i;
        }
    }

    private static void rankSort(double[] arr, int len) {
        int i = 0;
        while (i < len) {
            RegtreeFitNoCensFix.sorder[i] = i;
            ++i;
        }
        RegtreeFitNoCensFix.dp_quick(arr, sorder, 0, len - 1);
    }

    private static void dp_quick(double[] input, int[] sorder, int min, int max) {
        if (max - min > 0) {
            int i = min;
            int j = max;
            double pivot = input[sorder[i + j >> 1]];
            while (true) {
                if (input[sorder[i]] < pivot) {
                    ++i;
                    continue;
                }
                while (input[sorder[j]] > pivot) {
                    --j;
                }
                if (i >= j) break;
                int t = sorder[i];
                sorder[i] = sorder[j];
                sorder[j] = t;
                if (++i >= --j) break;
            }
            while (min < j && input[sorder[j]] == pivot) {
                --j;
            }
            if (min < j) {
                RegtreeFitNoCensFix.dp_quick(input, sorder, min, j);
            }
            while (i < max && input[sorder[i]] == pivot) {
                ++i;
            }
            if (i < max) {
                RegtreeFitNoCensFix.dp_quick(input, sorder, i, max);
            }
        }
    }

    private static void sort(double[] arr, int len) {
        RegtreeFitNoCensFix.quickSort(arr, 0, len - 1);
    }

    private static void quickSort(double[] input, int min, int max) {
        if (max - min > 0) {
            int i = min;
            int j = max;
            double pivot = input[i + j >> 1];
            while (true) {
                if (input[i] < pivot) {
                    ++i;
                    continue;
                }
                while (input[j] > pivot) {
                    --j;
                }
                if (i >= j) break;
                double t = input[i];
                input[i] = input[j];
                input[j] = t;
                if (++i >= --j) break;
            }
            while (min < j && input[j] == pivot) {
                --j;
            }
            if (min < j) {
                RegtreeFitNoCensFix.quickSort(input, min, j);
            }
            while (i < max && input[i] == pivot) {
                ++i;
            }
            if (i < max) {
                RegtreeFitNoCensFix.quickSort(input, i, max);
            }
        }
    }

    private static void sort(int[] arr, int len) {
        RegtreeFitNoCensFix.quickSort(arr, 0, len - 1);
    }

    private static void quickSort(int[] input, int min, int max) {
        if (max - min > 0) {
            int i = min;
            int j = max;
            int pivot = input[i + j >> 1];
            while (true) {
                if (input[i] < pivot) {
                    ++i;
                    continue;
                }
                while (input[j] > pivot) {
                    --j;
                }
                if (i >= j) break;
                int t = input[i];
                input[i] = input[j];
                input[j] = t;
                if (++i >= --j) break;
            }
            while (min < j && input[j] == pivot) {
                --j;
            }
            if (min < j) {
                RegtreeFitNoCensFix.quickSort(input, min, j);
            }
            while (i < max && input[i] == pivot) {
                ++i;
            }
            if (i < max) {
                RegtreeFitNoCensFix.quickSort(input, i, max);
            }
        }
    }
}

