/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf;

import ca.ubc.cs.beta.models.fastrf.Regtree;
import ca.ubc.cs.beta.models.fastrf.RegtreeBuildParams;
import ca.ubc.cs.beta.models.fastrf.Utils;
import java.util.Arrays;
import java.util.Random;

public class RegtreeFit {
    private static final int RAND_MAX = 0x7FFFFFFE;
    private static Random r;
    private static int[] rows_km;

    private static int rand() {
        int retn = r.nextInt(Integer.MAX_VALUE);
        return retn;
    }

    public static Regtree fit(double[][] allTheta, double[][] allX, double[] y, boolean[] cens, RegtreeBuildParams params) {
        Random r = params.random;
        if (r == null) {
            r = new Random();
            if (params.seed != -1L) {
                r.setSeed(params.seed);
            }
        }
        int N = y.length;
        int numTheta = allTheta.length;
        int numX = allX == null ? 0 : allX.length;
        int[][] dataIdxs = new int[N][2];
        int i = 0;
        while (i < N) {
            dataIdxs[i][0] = r.nextInt(numTheta);
            dataIdxs[i][1] = numX == 0 ? 0 : r.nextInt(numX);
            ++i;
        }
        return RegtreeFit.fit(allTheta, allX, dataIdxs, y, cens, params);
    }

    public static Regtree fit(double[][] allTheta, double[][] allX, int[][] dataIdxs, double[] y, boolean[] cens, RegtreeBuildParams params) {
        Object ynodeX;
        int i;
        Object ynodeTheta;
        int j;
        int N = dataIdxs.length;
        if (N == 0) {
            throw new RuntimeException("Cannot build a tree with no data.");
        }
        if (dataIdxs.length != y.length) {
            throw new RuntimeException("The number of data points and the number of responses must be the same.");
        }
        r = params.random;
        if (r == null) {
            r = new Random();
            if (params.seed != -1L) {
                r.setSeed(params.seed);
            }
        }
        int numTheta = ((double[][])allTheta).length;
        int numX = allX == null ? 0 : ((double[][])allX).length;
        int numThetavars = allTheta[0].length;
        int numXvars = allX == null ? 0 : allX[0].length;
        int nvars = numThetavars + numXvars;
        boolean[] hasThetaIdx = new boolean[numTheta + 1];
        boolean[] hasXIdx = new boolean[numX + 1];
        int i2 = 0;
        while (i2 < N) {
            hasThetaIdx[dataIdxs[i2][0]] = true;
            hasXIdx[dataIdxs[i2][1]] = true;
            ++i2;
        }
        int[] numMissingThetaIdxsBeforeThis = new int[numTheta + 1];
        int[] numMissingXIdxsBeforeThis = new int[numX + 1];
        int numMissing = 0;
        int i3 = 0;
        while (i3 <= numTheta) {
            numMissingThetaIdxsBeforeThis[i3] = numMissing++;
            if (!hasThetaIdx[i3]) {
                // empty if block
            }
            ++i3;
        }
        numMissing = 0;
        i3 = 0;
        while (i3 <= numX) {
            numMissingXIdxsBeforeThis[i3] = numMissing++;
            if (!hasXIdx[i3]) {
                // empty if block
            }
            ++i3;
        }
        double[][] actualAllTheta = new double[numTheta - numMissingThetaIdxsBeforeThis[numTheta]][];
        int i4 = 0;
        int counter = 0;
        while (i4 < numTheta) {
            if (hasThetaIdx[i4]) {
                actualAllTheta[counter++] = allTheta[i4];
            }
            ++i4;
        }
        allTheta = actualAllTheta;
        numTheta = ((double[][])allTheta).length;
        double[][] actualAllX = new double[numX - numMissingXIdxsBeforeThis[numX]][];
        int i5 = 0;
        int counter2 = 0;
        while (i5 < numX) {
            if (hasXIdx[i5]) {
                actualAllX[counter2++] = allX[i5];
            }
            ++i5;
        }
        allX = actualAllX;
        numX = ((double[][])allX).length;
        int[][] newDataIdxs = new int[N][2];
        int i6 = 0;
        while (i6 < N) {
            int thetaIdx = dataIdxs[i6][0];
            int xIdx = dataIdxs[i6][1];
            newDataIdxs[i6][0] = thetaIdx - numMissingThetaIdxsBeforeThis[thetaIdx];
            newDataIdxs[i6][1] = xIdx - numMissingXIdxsBeforeThis[xIdx];
            ++i6;
        }
        dataIdxs = newDataIdxs;
        int[] catDomainSizes = params.catDomainSizes;
        if (catDomainSizes.length != nvars) {
            throw new RuntimeException("catDomainSizes must be of the same length as size(X, 2)");
        }
        int maxDomSize = 0;
        int i7 = 0;
        while (i7 < nvars) {
            if (catDomainSizes[i7] > maxDomSize) {
                maxDomSize = catDomainSizes[i7];
            }
            ++i7;
        }
        int[][] condParents = params.condParents;
        int[][][] condParentVals = params.condParentVals;
        double kappa = params.kappa;
        double ratioFeatures = params.ratioFeatures;
        int splitMin = params.splitMin;
        boolean hascens = false;
        int i8 = 0;
        while (i8 < N) {
            if (cens[i8]) {
                hascens = true;
                break;
            }
            ++i8;
        }
        int[] nodenumber = new int[2 * N];
        int[] nodesize = new int[2 * N];
        int[] cutvar = new int[2 * N];
        double[] cutpoint = new double[2 * N];
        int[] leftchildren = new int[2 * N];
        int[] rightchildren = new int[2 * N];
        int[] parent = new int[2 * N];
        double[][] ysub = new double[2 * N][];
        boolean[][] censsub = new boolean[2 * N][];
        int ncatsplit = 0;
        int[][] catsplit = new int[2 * N][];
        int[] randomPermutation = new int[nvars];
        double[] variableValuesHere = new double[N];
        int[] dataRowsHere = new int[Math.max(N, maxDomSize)];
        int[] uniqueIdxs = new int[N];
        rows_km = uniqueIdxs;
        double[] catmeans = new double[maxDomSize];
        int[] catcounts = new int[maxDomSize];
        int numBestLeft = 0;
        int numBestRight = 0;
        int[] bestLeft = new int[maxDomSize];
        int[] bestRight = new int[maxDomSize];
        int[] leftside = new int[maxDomSize];
        int[] rightside = new int[maxDomSize];
        int[] maxlocs = new int[Math.max(N, maxDomSize) - 1];
        int[] period = null;
        double[] period_time = null;
        int[] N_all = null;
        int[] O_all = null;
        int[] C_all = null;
        int[] N_1 = null;
        int[] O_1 = null;
        int[] N_add = null;
        if (hascens) {
            period = new int[N];
            period_time = new double[N + 1];
            N_all = new int[N];
            O_all = new int[N];
            C_all = new int[N];
            N_1 = new int[N];
            O_1 = new int[N];
            N_add = new int[N + 1];
        }
        double[] ycum = new double[Math.max(N, maxDomSize) + 1];
        int[] ycountcum = new int[Math.max(N, maxDomSize) + 1];
        boolean[] yGoesLeft = new boolean[N];
        boolean[] primaryGoesLeft = new boolean[Math.max(numTheta, numX)];
        double ystd = Utils.var(y);
        int[][] sortedTheta = new int[numThetavars][];
        int[][] sortedX = new int[numXvars][];
        int[] ynode = new int[N];
        double[] temp = new double[Math.max(numTheta, numX)];
        int i9 = 0;
        while (i9 < numThetavars) {
            if (catDomainSizes[i9] == 0) {
                j = 0;
                while (j < numTheta) {
                    temp[j] = allTheta[j][i9];
                    ++j;
                }
                sortedTheta[i9] = new int[numTheta];
                RegtreeFit.rankSort(temp, numTheta, sortedTheta[i9]);
            }
            ++i9;
        }
        i9 = 0;
        while (i9 < numXvars) {
            if (catDomainSizes[i9 + numThetavars] == 0) {
                j = 0;
                while (j < numX) {
                    temp[j] = allX[j][i9];
                    ++j;
                }
                sortedX[i9] = new int[numX];
                RegtreeFit.rankSort(temp, numX, sortedX[i9]);
            }
            ++i9;
        }
        RegtreeFit.rankSort(y, N, ynode);
        temp = null;
        int[][] y_node = new int[2 * N][];
        int[][][] y_Theta = new int[2 * N][][];
        int[][][] y_X = new int[2 * N][][];
        y_node[0] = ynode;
        if ((double)N * Math.log10(N) < (double)numTheta) {
            y_Theta[0] = null;
        } else {
            ynodeTheta = new int[numTheta][];
            int[] Thetacount = new int[numTheta];
            i = 0;
            while (i < N) {
                int n = dataIdxs[i][0];
                Thetacount[n] = Thetacount[n] + 1;
                ++i;
            }
            i = 0;
            while (i < numTheta) {
                ynodeTheta[i] = new int[Thetacount[i]];
                ++i;
            }
            i = 0;
            while (i < N) {
                int idx;
                int dataIdx = ynode[i];
                int n = idx = dataIdxs[dataIdx][0];
                int n2 = Thetacount[n] - 1;
                Thetacount[n] = n2;
                ynodeTheta[idx][n2] = i++;
            }
            y_Theta[0] = ynodeTheta;
            Thetacount = null;
        }
        if ((double)N * Math.log10(N) < (double)numX || numX == 0) {
            y_X[0] = null;
        } else {
            ynodeX = new int[numX][];
            int[] Xcount = new int[numX];
            i = 0;
            while (i < N) {
                int n = dataIdxs[i][1];
                Xcount[n] = Xcount[n] + 1;
                ++i;
            }
            i = 0;
            while (i < numX) {
                ynodeX[i] = new int[Xcount[i]];
                ++i;
            }
            i = 0;
            while (i < N) {
                int idx;
                int n = idx = dataIdxs[ynode[i]][1];
                int n3 = Xcount[n] - 1;
                Xcount[n] = n3;
                ynodeX[idx][n3] = i++;
            }
            y_X[0] = ynodeX;
            Xcount = null;
        }
        int[] sorder = new int[Math.max(N, maxDomSize)];
        nodesize[0] = N;
        int[] stack = new int[N];
        stack[0] = 0;
        int stacktop = 0;
        int numNodes = 1;
        while (stacktop >= 0) {
            int Nnode;
            int tnode;
            block221: {
                int i10;
                int i11;
                tnode = stack[stacktop--];
                ynode = y_node[tnode];
                ynodeTheta = y_Theta[tnode];
                ynodeX = y_X[tnode];
                y_node[tnode] = null;
                y_Theta[tnode] = null;
                y_X[tnode] = null;
                Nnode = nodesize[tnode];
                if (Nnode == 0) {
                    throw new RuntimeException("ERROR! Nnode is 0 (split gave zero data points to this node!?)");
                }
                int NnodeUncens = 0;
                double ysum = 0.0;
                double ysumOfSq = 0.0;
                int i12 = 0;
                while (i12 < Nnode) {
                    int idx = ynode[i12];
                    ysum += y[idx];
                    ysumOfSq += y[idx] * y[idx];
                    if (!cens[idx]) {
                        ++NnodeUncens;
                    }
                    ++i12;
                }
                double ybar = ysum / (double)Nnode;
                double mincost = Nnode == 1 ? 0.0 : (ysumOfSq - ysum * ysum / (double)Nnode) / (double)(Nnode - 1);
                boolean impure = mincost > 1.0E-20 * ystd;
                cutvar[tnode] = 0;
                if (!impure || NnodeUncens < splitMin) break block221;
                int nvarsenabled = 0;
                if (condParents == null) {
                    nvarsenabled = nvars;
                    i11 = 0;
                    while (i11 < nvars) {
                        randomPermutation[i11] = i11;
                        ++i11;
                    }
                } else {
                    i11 = 0;
                    while (i11 < nvars) {
                        boolean isenabled = true;
                        if (condParents[i11] != null) {
                            int j2 = 0;
                            while (j2 < condParents[i11].length) {
                                int[] compatibleValues = RegtreeFit.getCompatibleValues(tnode, condParents[i11][j2], N, parent, cutvar, cutpoint, leftchildren, rightchildren, catsplit, catDomainSizes);
                                int k = 0;
                                while (k < compatibleValues.length) {
                                    boolean isokvalue = false;
                                    int l = 0;
                                    while (l < condParentVals[i11][j2].length) {
                                        if (compatibleValues[k] == condParentVals[i11][j2][l]) {
                                            isokvalue = true;
                                            break;
                                        }
                                        ++l;
                                    }
                                    if (!isokvalue) {
                                        isenabled = false;
                                        break;
                                    }
                                    ++k;
                                }
                                if (!isenabled) break;
                                ++j2;
                            }
                        }
                        if (isenabled) {
                            randomPermutation[nvarsenabled++] = i11;
                        }
                        ++i11;
                    }
                }
                RegtreeFit.shuffle(randomPermutation, nvarsenabled);
                int num_periods = 0;
                if (hascens) {
                    Arrays.fill(period, 0, Nnode, 0);
                    double last_time = -1.0E10;
                    int i13 = 0;
                    while (i13 < Nnode) {
                        int idx = ynode[i13];
                        if (!cens[idx]) {
                            if (y[idx] > last_time + 1.0E-6) {
                                period_time[++num_periods] = y[idx];
                                last_time = y[idx];
                            }
                            period[i13] = num_periods;
                        }
                        ++i13;
                    }
                    Arrays.fill(O_all, 0, num_periods, 0);
                    Arrays.fill(C_all, 0, num_periods, 0);
                    int curr_period = 0;
                    double this_time = 0.0;
                    i10 = 0;
                    while (i10 < Nnode) {
                        int idx = ynode[i10];
                        if (cens[idx]) {
                            this_time = curr_period == num_periods ? 1.0E9 : period_time[curr_period + 1];
                            while (y[idx] > this_time - 1.0E-6) {
                                this_time = ++curr_period == num_periods ? 1.0E9 : period_time[curr_period + 1];
                            }
                            period[i10] = curr_period;
                            if (curr_period > 0) {
                                int n = curr_period - 1;
                                C_all[n] = C_all[n] + 1;
                            }
                        } else {
                            int n = period[i10] - 1;
                            O_all[n] = O_all[n] + 1;
                        }
                        ++i10;
                    }
                    N_all[0] = Nnode;
                    int p = 1;
                    while (p < num_periods) {
                        N_all[p] = N_all[p - 1] - O_all[p - 1] - C_all[p - 1];
                        ++p;
                    }
                }
                int bestvar = -1;
                double bestcut = 0.0;
                double bestcrit = -1.0E12;
                i10 = 0;
                while (i10 < nvarsenabled) {
                    block224: {
                        block226: {
                            double next;
                            double prev;
                            int j3;
                            double prevValue;
                            int low;
                            int numlocs_with_max_crit;
                            double cutval;
                            double critval;
                            int is_X;
                            Object allData;
                            Object ynodeData;
                            int[][] sortedData;
                            int numData;
                            int varIdx;
                            int nextvar;
                            block222: {
                                int maxloc;
                                int numtotal;
                                int numright;
                                int numleft;
                                block225: {
                                    int j4;
                                    int domSize;
                                    block223: {
                                        int category;
                                        int idx;
                                        boolean is_nextvar_cat;
                                        nextvar = randomPermutation[i10];
                                        boolean bl = is_nextvar_cat = catDomainSizes[nextvar] != 0;
                                        if (nextvar < numThetavars) {
                                            varIdx = nextvar;
                                            numData = numTheta;
                                            sortedData = sortedTheta;
                                            ynodeData = ynodeTheta;
                                            allData = allTheta;
                                            is_X = 0;
                                        } else {
                                            varIdx = nextvar - numThetavars;
                                            numData = numX;
                                            sortedData = sortedX;
                                            ynodeData = ynodeX;
                                            allData = allX;
                                            is_X = 1;
                                        }
                                        critval = -1.0E13;
                                        cutval = 0.0;
                                        numlocs_with_max_crit = 0;
                                        if (!is_nextvar_cat) break block222;
                                        domSize = catDomainSizes[nextvar];
                                        numleft = 0;
                                        numright = 0;
                                        numtotal = 0;
                                        if (!hascens) break block223;
                                        double[] km_mean = catmeans;
                                        int[] numUptoCategory = ycountcum;
                                        Arrays.fill(numUptoCategory, 0, domSize + 1, 0);
                                        int j5 = 0;
                                        while (j5 < Nnode) {
                                            idx = ynode[j5];
                                            int n = category = (int)Math.floor(allData[dataIdxs[idx][is_X]][varIdx] - 0.5);
                                            numUptoCategory[n] = numUptoCategory[n] + 1;
                                            ++j5;
                                        }
                                        j5 = 1;
                                        while (j5 <= domSize) {
                                            int n = j5;
                                            numUptoCategory[n] = numUptoCategory[n] + numUptoCategory[j5 - 1];
                                            ++j5;
                                        }
                                        j5 = 0;
                                        while (j5 < Nnode) {
                                            idx = ynode[j5];
                                            int n = category = (int)Math.floor(allData[dataIdxs[idx][is_X]][varIdx] - 0.5);
                                            int n4 = numUptoCategory[n] - 1;
                                            numUptoCategory[n] = n4;
                                            dataRowsHere[n4] = j5++;
                                        }
                                        int[] categoryStartIdx = numUptoCategory;
                                        j4 = 0;
                                        while (j4 < domSize) {
                                            int low2 = categoryStartIdx[j4];
                                            int high = categoryStartIdx[j4 + 1];
                                            int numUncens = 0;
                                            int numCens = 0;
                                            double[] y_in = ycum;
                                            double[] c_in = variableValuesHere;
                                            int k = high - 1;
                                            while (k >= low2) {
                                                int idx2 = ynode[dataRowsHere[k]];
                                                if (cens[idx2]) {
                                                    c_in[numCens++] = y[idx2];
                                                } else {
                                                    y_in[numUncens++] = y[idx2];
                                                }
                                                --k;
                                            }
                                            if (high - low2 == 0) {
                                                km_mean[j4] = Double.POSITIVE_INFINITY;
                                            } else {
                                                km_mean[j4] = RegtreeFit.kaplan_meier_mean(numUncens, numCens, y_in, c_in, kappa);
                                                ++numtotal;
                                            }
                                            ++j4;
                                        }
                                        if (numtotal <= 1) break block224;
                                        RegtreeFit.rankSort(km_mean, domSize, sorder);
                                        Arrays.fill(N_1, 0, num_periods, 0);
                                        Arrays.fill(O_1, 0, num_periods, 0);
                                        j4 = 1;
                                        while (j4 < numtotal) {
                                            category = sorder[j4 - 1];
                                            low = categoryStartIdx[category];
                                            int high = categoryStartIdx[category + 1];
                                            int maxperiod = -1;
                                            int k = low;
                                            while (k < high) {
                                                int idx3 = dataRowsHere[k];
                                                maxperiod = Math.max(maxperiod, period[idx3]);
                                                ++k;
                                            }
                                            Arrays.fill(N_add, 0, maxperiod, 0);
                                            k = low;
                                            while (k < high) {
                                                int idx4 = dataRowsHere[k];
                                                int p = period[idx4] - 1;
                                                if (p >= 0) {
                                                    if (!cens[ynode[idx4]]) {
                                                        int n = p;
                                                        O_1[n] = O_1[n] + 1;
                                                    }
                                                    int n = p;
                                                    N_add[n] = N_add[n] + 1;
                                                }
                                                ++k;
                                            }
                                            int N_cumul = 0;
                                            int p = maxperiod - 1;
                                            while (p >= 0) {
                                                int n = p--;
                                                N_1[n] = N_1[n] + (N_cumul += N_add[p]);
                                            }
                                            double logrank = Math.abs(RegtreeFit.logrank_statistic(num_periods, N_all, O_all, N_1, O_1));
                                            if (logrank > critval - 1.0E-10) {
                                                if (logrank > critval + 1.0E-10) {
                                                    critval = logrank;
                                                    numlocs_with_max_crit = 0;
                                                }
                                                maxlocs[numlocs_with_max_crit++] = j4;
                                            }
                                            ++j4;
                                        }
                                        break block225;
                                    }
                                    Arrays.fill(catmeans, 0, domSize, 0.0);
                                    Arrays.fill(catcounts, 0, domSize, 0);
                                    int j6 = 0;
                                    while (j6 < Nnode) {
                                        int category;
                                        int idx = ynode[j6];
                                        int n = category = (int)Math.floor(allData[dataIdxs[idx][is_X]][varIdx] - 0.5);
                                        catmeans[n] = catmeans[n] + y[idx];
                                        int n5 = category;
                                        catcounts[n5] = catcounts[n5] + 1;
                                        ++j6;
                                    }
                                    j6 = 0;
                                    while (j6 < domSize) {
                                        if (catcounts[j6] != 0) {
                                            ++numtotal;
                                            int n = j6;
                                            catmeans[n] = catmeans[n] / (double)catcounts[j6];
                                        } else {
                                            catmeans[j6] = Double.POSITIVE_INFINITY;
                                        }
                                        ++j6;
                                    }
                                    if (numtotal > 1) {
                                        RegtreeFit.rankSort(catmeans, domSize, sorder);
                                        ycum[0] = 0.0;
                                        ycountcum[0] = 0;
                                        j6 = 1;
                                        while (j6 <= numtotal) {
                                            int idx = sorder[j6 - 1];
                                            ycum[j6] = ycum[j6 - 1] + (double)catcounts[idx] * (catmeans[idx] - ybar);
                                            ycountcum[j6] = ycountcum[j6 - 1] + catcounts[idx];
                                            ++j6;
                                        }
                                        double ytotal = ycum[numtotal];
                                        int numytotal = ycountcum[numtotal];
                                        j4 = 1;
                                        while (j4 < numtotal) {
                                            double ssx = ycum[j4] * ycum[j4] / (double)ycountcum[j4] + (ytotal - ycum[j4]) * (ytotal - ycum[j4]) / (double)(numytotal - ycountcum[j4]);
                                            if (ssx > critval - 1.0E-10) {
                                                if (ssx > critval + 1.0E-10) {
                                                    critval = ssx;
                                                    numlocs_with_max_crit = 0;
                                                }
                                                maxlocs[numlocs_with_max_crit++] = j4;
                                            }
                                            ++j4;
                                        }
                                    }
                                    break block224;
                                }
                                numleft = maxloc = maxlocs[RegtreeFit.rand() % numlocs_with_max_crit];
                                numright = numtotal - numleft;
                                int j7 = 0;
                                while (j7 < numleft) {
                                    leftside[j7] = sorder[j7] + 1;
                                    ++j7;
                                }
                                j7 = 0;
                                while (j7 < numright) {
                                    rightside[j7] = sorder[j7 + numleft] + 1;
                                    ++j7;
                                }
                                if (critval > bestcrit + 1.0E-10) {
                                    bestcrit = critval;
                                    bestvar = nextvar;
                                    numBestLeft = numleft;
                                    numBestRight = numright;
                                    j7 = 0;
                                    while (j7 < numBestLeft) {
                                        bestLeft[j7] = leftside[j7];
                                        ++j7;
                                    }
                                    j7 = 0;
                                    while (j7 < numBestRight) {
                                        bestRight[j7] = rightside[j7];
                                        ++j7;
                                    }
                                }
                                break block226;
                            }
                            int numUniqData = 0;
                            int numUniqValues = 0;
                            if (ynodeData == null) {
                                int j8 = 0;
                                while (j8 < Nnode) {
                                    int idx = ynode[j8];
                                    variableValuesHere[j8] = allData[dataIdxs[idx][is_X]][varIdx];
                                    ++j8;
                                }
                                RegtreeFit.rankSort(variableValuesHere, Nnode, sorder);
                                prevValue = variableValuesHere[sorder[0]];
                                uniqueIdxs[numUniqValues++] = 0;
                                j3 = 1;
                                while (j3 < Nnode) {
                                    double nextValue = variableValuesHere[sorder[j3]];
                                    if (prevValue + 1.0E-10 < nextValue) {
                                        uniqueIdxs[numUniqValues++] = j3;
                                        prevValue = nextValue;
                                    }
                                    ++j3;
                                }
                                numUniqData = Nnode;
                            } else {
                                prevValue = 0.0;
                                j3 = 0;
                                while (j3 < numData) {
                                    int nextIdx = sortedData[varIdx][j3];
                                    int[] yhere = ynodeData[nextIdx];
                                    if (yhere != null) {
                                        double nextValue = allData[nextIdx][varIdx];
                                        if (numUniqValues == 0 || prevValue + 1.0E-10 < nextValue) {
                                            uniqueIdxs[numUniqValues] = numUniqData;
                                            variableValuesHere[numUniqValues] = nextValue;
                                            ++numUniqValues;
                                        }
                                        prevValue = nextValue;
                                        dataRowsHere[numUniqData++] = nextIdx;
                                    }
                                    ++j3;
                                }
                            }
                            if (numUniqValues <= 1) break block224;
                            if (hascens) {
                                Arrays.fill(N_1, 0, num_periods, 0);
                                Arrays.fill(O_1, 0, num_periods, 0);
                                int j9 = 1;
                                while (j9 < numUniqValues) {
                                    int l;
                                    int high;
                                    int[] maxperiod;
                                    int k;
                                    int low3 = uniqueIdxs[j9 - 1];
                                    int high2 = uniqueIdxs[j9];
                                    int maxperiod2 = -1;
                                    if (ynodeData == null) {
                                        k = low3;
                                        while (k < high2) {
                                            maxperiod2 = Math.max(maxperiod2, period[sorder[k]]);
                                            ++k;
                                        }
                                    } else {
                                        k = low3;
                                        while (k < high2) {
                                            int[] ynodeIdxsHere;
                                            maxperiod = ynodeIdxsHere = ynodeData[dataRowsHere[k]];
                                            high = ynodeIdxsHere.length;
                                            low = 0;
                                            while (low < high) {
                                                l = maxperiod[low];
                                                maxperiod2 = Math.max(maxperiod2, period[l]);
                                                ++low;
                                            }
                                            ++k;
                                        }
                                    }
                                    Arrays.fill(N_add, 0, maxperiod2, 0);
                                    if (ynodeData == null) {
                                        k = low3;
                                        while (k < high2) {
                                            int idx = sorder[k];
                                            int p = period[idx] - 1;
                                            if (p >= 0) {
                                                if (!cens[ynode[idx]]) {
                                                    int n = p;
                                                    O_1[n] = O_1[n] + 1;
                                                }
                                                int n = p;
                                                N_add[n] = N_add[n] + 1;
                                            }
                                            ++k;
                                        }
                                    } else {
                                        k = low3;
                                        while (k < high2) {
                                            int[] ynodeIdxsHere;
                                            maxperiod = ynodeIdxsHere = ynodeData[dataRowsHere[k]];
                                            high = ynodeIdxsHere.length;
                                            low = 0;
                                            while (low < high) {
                                                l = maxperiod[low];
                                                int p = period[l] - 1;
                                                if (p >= 0) {
                                                    if (!cens[ynode[l]]) {
                                                        int n = p;
                                                        O_1[n] = O_1[n] + 1;
                                                    }
                                                    int n = p;
                                                    N_add[n] = N_add[n] + 1;
                                                }
                                                ++low;
                                            }
                                            ++k;
                                        }
                                    }
                                    int N_cumul = 0;
                                    int p = maxperiod2 - 1;
                                    while (p >= 0) {
                                        int n = p--;
                                        N_1[n] = N_1[n] + (N_cumul += N_add[p]);
                                    }
                                    double logrank = Math.abs(RegtreeFit.logrank_statistic(num_periods, N_all, O_all, N_1, O_1));
                                    if (logrank > critval - 1.0E-10) {
                                        if (logrank > critval + 1.0E-10) {
                                            critval = logrank;
                                            numlocs_with_max_crit = 0;
                                        }
                                        maxlocs[numlocs_with_max_crit++] = j9 - 1;
                                    }
                                    ++j9;
                                }
                            } else {
                                int j10;
                                ycum[0] = 0.0;
                                ycountcum[0] = 0;
                                if (ynodeData == null) {
                                    j10 = 1;
                                    while (j10 <= numUniqData) {
                                        ycum[j10] = ycum[j10 - 1] + y[ynode[sorder[j10 - 1]]] - ybar;
                                        ycountcum[j10] = ycountcum[j10 - 1] + 1;
                                        ++j10;
                                    }
                                } else {
                                    j10 = 1;
                                    while (j10 <= numUniqData) {
                                        int[] ynodeIdxsHere = ynodeData[dataRowsHere[j10 - 1]];
                                        int numYValuesHere = ynodeIdxsHere.length;
                                        double sumYValuesHere = 0.0;
                                        int[] high = ynodeIdxsHere;
                                        low = ynodeIdxsHere.length;
                                        int l = 0;
                                        while (l < low) {
                                            int k = high[l];
                                            sumYValuesHere += y[ynode[k]];
                                            ++l;
                                        }
                                        ycum[j10] = ycum[j10 - 1] + sumYValuesHere - (double)numYValuesHere * ybar;
                                        ycountcum[j10] = ycountcum[j10 - 1] + numYValuesHere;
                                        ++j10;
                                    }
                                }
                                double ytotal = ycum[numUniqData];
                                int numytotal = ycountcum[numUniqData];
                                int j11 = 1;
                                while (j11 < numUniqValues) {
                                    int idx = uniqueIdxs[j11];
                                    double yc = ycum[idx];
                                    double ssx = yc * yc / (double)ycountcum[idx] + (ytotal - yc) * (ytotal - yc) / (double)(numytotal - ycountcum[idx]);
                                    if (ssx > critval - 1.0E-10) {
                                        if (ssx > critval + 1.0E-10) {
                                            critval = ssx;
                                            numlocs_with_max_crit = 0;
                                        }
                                        maxlocs[numlocs_with_max_crit++] = j11 - 1;
                                    }
                                    ++j11;
                                }
                            }
                            int maxloc = maxlocs[RegtreeFit.rand() % numlocs_with_max_crit];
                            double u = (double)RegtreeFit.rand() * 1.0 / 2.147483646E9;
                            if (ynodeData == null) {
                                prev = variableValuesHere[sorder[maxloc]];
                                next = variableValuesHere[sorder[maxloc + 1]];
                            } else {
                                prev = variableValuesHere[maxloc];
                                next = variableValuesHere[maxloc + 1];
                            }
                            if (next - prev < 1.8999999999999998E-6) {
                                cutval = (next + prev) / 2.0;
                            } else {
                                cutval = (1.0 - u) * (prev + 1.0E-6) + u * (next - 1.0E-6);
                                if (cutval < prev + 1.0E-8 || cutval > next - 1.0E-8) {
                                    throw new RuntimeException("random splitpoint has to lie in between the upper and lower limit");
                                }
                            }
                            if (critval > bestcrit + 1.0E-10) {
                                bestcrit = critval;
                                bestvar = nextvar;
                                bestcut = cutval;
                            }
                        }
                        if (i10 >= Math.max(1, (int)Math.floor(ratioFeatures * (double)nvarsenabled)) - 1 && bestcrit > -1.0E11) break;
                    }
                    ++i10;
                }
                if (bestvar != -1) {
                    int[][] ySecondaryRight;
                    int[][] yPrimaryRight;
                    int[][][] y_Secondary;
                    int[][][] y_Primary;
                    Object ynodeSecondary;
                    int numSecondary;
                    int is_X;
                    Object allPrimary;
                    int[][] sortedPrimary;
                    Object ynodePrimary;
                    int numPrimary;
                    int varIdx;
                    if (bestvar < numThetavars) {
                        varIdx = bestvar;
                        numPrimary = numTheta;
                        ynodePrimary = ynodeTheta;
                        sortedPrimary = sortedTheta;
                        allPrimary = allTheta;
                        is_X = 0;
                    } else {
                        varIdx = bestvar - numThetavars;
                        numPrimary = numX;
                        ynodePrimary = ynodeX;
                        sortedPrimary = sortedX;
                        allPrimary = allX;
                        is_X = 1;
                    }
                    int nleft = 0;
                    int nright = 0;
                    if (catDomainSizes[bestvar] != 0) {
                        cutvar[tnode] = -(bestvar + 1);
                        cutpoint[tnode] = ncatsplit;
                        int[] compatibleValues = RegtreeFit.getCompatibleValues(tnode, bestvar, N, parent, cutvar, cutpoint, leftchildren, rightchildren, catsplit, catDomainSizes);
                        int[] missing_values_for_left = new int[compatibleValues.length];
                        int[] missing_values_for_right = new int[compatibleValues.length];
                        int num_missing_to_left = 0;
                        int num_missing_to_right = 0;
                        int i14 = 0;
                        while (i14 < compatibleValues.length) {
                            int nextValue = compatibleValues[i14];
                            int j12 = 0;
                            while (j12 < numBestLeft) {
                                if (nextValue == bestLeft[j12]) break;
                                ++j12;
                            }
                            if (j12 == numBestLeft) {
                                j12 = 0;
                                while (j12 < numBestRight) {
                                    if (nextValue == bestRight[j12]) break;
                                    ++j12;
                                }
                                if (j12 == numBestRight) {
                                    if (RegtreeFit.rand() % 2 == 0) {
                                        missing_values_for_left[num_missing_to_left++] = nextValue;
                                    } else {
                                        missing_values_for_right[num_missing_to_right++] = nextValue;
                                    }
                                }
                            }
                            ++i14;
                        }
                        int missingCounter = 0;
                        int bestCounter = 0;
                        int nextval = 0;
                        catsplit[ncatsplit] = new int[num_missing_to_left + numBestLeft];
                        int i15 = 0;
                        while (i15 < num_missing_to_left + numBestLeft) {
                            nextval = missingCounter == num_missing_to_left ? bestLeft[bestCounter++] : (bestCounter == numBestLeft ? missing_values_for_left[missingCounter++] : (bestLeft[bestCounter] < missing_values_for_left[missingCounter] ? bestLeft[bestCounter++] : missing_values_for_left[missingCounter++]));
                            leftside[nextval - 1] = 1;
                            catsplit[ncatsplit][i15] = nextval;
                            ++i15;
                        }
                        missingCounter = 0;
                        bestCounter = 0;
                        catsplit[ncatsplit + N] = new int[num_missing_to_right + numBestRight];
                        i15 = 0;
                        while (i15 < num_missing_to_right + numBestRight) {
                            nextval = missingCounter == num_missing_to_right ? bestRight[bestCounter++] : (bestCounter == numBestRight ? missing_values_for_right[missingCounter++] : (bestRight[bestCounter] < missing_values_for_right[missingCounter] ? bestRight[bestCounter++] : missing_values_for_right[missingCounter++]));
                            leftside[nextval - 1] = 0;
                            catsplit[ncatsplit + N][i15] = nextval;
                            ++i15;
                        }
                        ++ncatsplit;
                        if (ynodePrimary == null) {
                            i15 = 0;
                            while (i15 < Nnode) {
                                int idx = ynode[i15];
                                double xVal = allPrimary[dataIdxs[idx][is_X]][varIdx];
                                boolean onleft = false;
                                int j13 = 0;
                                while (j13 < numBestLeft) {
                                    if ((int)Math.floor(xVal + 0.5) == bestLeft[j13]) {
                                        onleft = true;
                                        break;
                                    }
                                    ++j13;
                                }
                                if (onleft) {
                                    ++nleft;
                                } else {
                                    ++nright;
                                }
                                yGoesLeft[i15] = onleft;
                                ++i15;
                            }
                        } else {
                            i15 = 0;
                            while (i15 < numPrimary) {
                                if (leftside[(int)Math.floor(allPrimary[i15][varIdx] - 0.5)] == 1) {
                                    primaryGoesLeft[i15] = true;
                                    if (ynodePrimary[i15] != null) {
                                        int j14 = 0;
                                        while (j14 < ynodePrimary[i15].length) {
                                            ++nleft;
                                            yGoesLeft[ynodePrimary[i15][j14]] = true;
                                            ++j14;
                                        }
                                    }
                                } else {
                                    primaryGoesLeft[i15] = false;
                                    if (ynodePrimary[i15] != null) {
                                        int j15 = 0;
                                        while (j15 < ynodePrimary[i15].length) {
                                            ++nright;
                                            yGoesLeft[ynodePrimary[i15][j15]] = false;
                                            ++j15;
                                        }
                                    }
                                }
                                ++i15;
                            }
                        }
                    } else {
                        int i16;
                        cutvar[tnode] = bestvar + 1;
                        cutpoint[tnode] = bestcut;
                        if (ynodePrimary == null) {
                            i16 = 0;
                            while (i16 < Nnode) {
                                int idx = ynode[i16];
                                double xVal = allPrimary[dataIdxs[idx][is_X]][varIdx];
                                if (xVal <= bestcut) {
                                    ++nleft;
                                    yGoesLeft[i16] = true;
                                } else {
                                    ++nright;
                                    yGoesLeft[i16] = false;
                                }
                                ++i16;
                            }
                        } else {
                            i16 = 0;
                            while (i16 < numPrimary) {
                                if (allPrimary[i16][varIdx] <= bestcut) {
                                    primaryGoesLeft[i16] = true;
                                    if (ynodePrimary[i16] != null) {
                                        int j16 = 0;
                                        while (j16 < ynodePrimary[i16].length) {
                                            ++nleft;
                                            yGoesLeft[ynodePrimary[i16][j16]] = true;
                                            ++j16;
                                        }
                                    }
                                } else {
                                    primaryGoesLeft[i16] = false;
                                    if (ynodePrimary[i16] != null) {
                                        int j17 = 0;
                                        while (j17 < ynodePrimary[i16].length) {
                                            ++nright;
                                            yGoesLeft[ynodePrimary[i16][j17]] = false;
                                            ++j17;
                                        }
                                    }
                                }
                                ++i16;
                            }
                        }
                    }
                    if (nleft == 0 || nright == 0) {
                        throw new RuntimeException("Empty side after splitting!");
                    }
                    if (bestvar < numThetavars) {
                        numSecondary = numX;
                        ynodeSecondary = ynodeX;
                        y_Primary = y_Theta;
                        y_Secondary = y_X;
                    } else {
                        numSecondary = numTheta;
                        ynodeSecondary = ynodeTheta;
                        y_Primary = y_X;
                        y_Secondary = y_Theta;
                    }
                    int[] ynodeLeft = new int[nleft];
                    int[] ynodeRight = new int[nright];
                    int i17 = 0;
                    int leftCounter = 0;
                    int rightCounter = 0;
                    while (i17 < Nnode) {
                        if (yGoesLeft[i17]) {
                            ynodeLeft[leftCounter] = ynode[i17];
                            ynode[i17] = leftCounter++;
                        } else {
                            ynodeRight[rightCounter] = ynode[i17];
                            ynode[i17] = rightCounter++;
                        }
                        ++i17;
                    }
                    y_node[numNodes] = ynodeLeft;
                    y_node[numNodes + 1] = ynodeRight;
                    boolean naiveSortPrimaryLeft = ynodePrimary == null || (double)nleft * Math.log10(nleft) < (double)numPrimary;
                    boolean naiveSortPrimaryRight = ynodePrimary == null || (double)nright * Math.log10(nright) < (double)numPrimary;
                    int[][] yPrimaryLeft = naiveSortPrimaryLeft ? null : new int[numPrimary][];
                    int[][] nArrayArray = yPrimaryRight = naiveSortPrimaryRight ? null : new int[numPrimary][];
                    if (!naiveSortPrimaryLeft || !naiveSortPrimaryRight) {
                        int i18 = 0;
                        while (i18 < numPrimary) {
                            if (primaryGoesLeft[i18]) {
                                if (!naiveSortPrimaryLeft) {
                                    yPrimaryLeft[i18] = ynodePrimary[i18];
                                    if (yPrimaryLeft[i18] != null) {
                                        int j18 = 0;
                                        while (j18 < yPrimaryLeft[i18].length) {
                                            yPrimaryLeft[i18][j18] = ynode[yPrimaryLeft[i18][j18]];
                                            ++j18;
                                        }
                                    }
                                }
                            } else if (!naiveSortPrimaryRight) {
                                yPrimaryRight[i18] = ynodePrimary[i18];
                                if (yPrimaryRight[i18] != null) {
                                    int j19 = 0;
                                    while (j19 < yPrimaryRight[i18].length) {
                                        yPrimaryRight[i18][j19] = ynode[yPrimaryRight[i18][j19]];
                                        ++j19;
                                    }
                                }
                            }
                            ++i18;
                        }
                    }
                    y_Primary[numNodes] = yPrimaryLeft;
                    y_Primary[numNodes + 1] = yPrimaryRight;
                    boolean naiveSortSecondaryLeft = ynodeSecondary == null || (double)nleft * Math.log10(nleft) < (double)numSecondary;
                    boolean naiveSortSecondaryRight = ynodeSecondary == null || (double)nright * Math.log10(nright) < (double)numSecondary;
                    int[][] ySecondaryLeft = naiveSortSecondaryLeft ? null : new int[numSecondary][];
                    int[][] nArrayArray2 = ySecondaryRight = naiveSortSecondaryRight ? null : new int[numSecondary][];
                    if (!naiveSortSecondaryLeft || !naiveSortSecondaryRight) {
                        int i19 = 0;
                        while (i19 < numSecondary) {
                            if (ynodeSecondary[i19] != null) {
                                int[] thisynodeSecondary = ynodeSecondary[i19];
                                int numySecondaryLeft = 0;
                                int numySecondaryRight = 0;
                                int j20 = 0;
                                while (j20 < thisynodeSecondary.length) {
                                    if (yGoesLeft[thisynodeSecondary[j20]]) {
                                        ++numySecondaryLeft;
                                    } else {
                                        ++numySecondaryRight;
                                    }
                                    ++j20;
                                }
                                int[] ySecondaryLeft_i = naiveSortSecondaryLeft ? null : new int[numySecondaryLeft];
                                int[] ySecondaryRight_i = naiveSortSecondaryRight ? null : new int[numySecondaryRight];
                                numySecondaryLeft = 0;
                                numySecondaryRight = 0;
                                int j21 = 0;
                                while (j21 < thisynodeSecondary.length) {
                                    if (yGoesLeft[thisynodeSecondary[j21]]) {
                                        if (!naiveSortSecondaryLeft) {
                                            ySecondaryLeft_i[numySecondaryLeft++] = ynode[thisynodeSecondary[j21]];
                                        }
                                    } else if (!naiveSortSecondaryRight) {
                                        ySecondaryRight_i[numySecondaryRight++] = ynode[thisynodeSecondary[j21]];
                                    }
                                    ++j21;
                                }
                                if (numySecondaryLeft != 0) {
                                    ySecondaryLeft[i19] = ySecondaryLeft_i;
                                }
                                if (numySecondaryRight != 0) {
                                    ySecondaryRight[i19] = ySecondaryRight_i;
                                }
                            }
                            ++i19;
                        }
                    }
                    y_Secondary[numNodes] = ySecondaryLeft;
                    y_Secondary[numNodes + 1] = ySecondaryRight;
                    leftchildren[tnode] = numNodes;
                    rightchildren[tnode] = numNodes + 1;
                    nodenumber[numNodes] = numNodes;
                    nodenumber[numNodes + 1] = numNodes + 1;
                    parent[numNodes] = tnode;
                    parent[numNodes + 1] = tnode;
                    nodesize[numNodes] = nleft;
                    nodesize[numNodes + 1] = nright;
                    stack[++stacktop] = numNodes;
                    stack[++stacktop] = numNodes + 1;
                    numNodes += 2;
                }
            }
            if (cutvar[tnode] != 0) continue;
            ysub[tnode] = new double[Nnode];
            censsub[tnode] = new boolean[Nnode];
            int i20 = 0;
            while (i20 < Nnode) {
                int idx = ynode[i20];
                ysub[tnode][i20] = y[idx];
                censsub[tnode][i20] = cens[idx];
                ++i20;
            }
        }
        Regtree tree = new Regtree(numNodes, ncatsplit, params.storeResponses, params.logModel);
        System.arraycopy(nodenumber, 0, tree.node, 0, numNodes);
        System.arraycopy(parent, 0, tree.parent, 0, numNodes);
        System.arraycopy(cutvar, 0, tree.var, 0, numNodes);
        System.arraycopy(cutpoint, 0, tree.cut, 0, numNodes);
        System.arraycopy(nodesize, 0, tree.nodesize, 0, numNodes);
        tree.npred = nvars;
        int nextnode = -1;
        int i21 = 0;
        while (i21 < ncatsplit) {
            while (cutvar[++nextnode] >= 0) {
            }
            int[] tmp = new int[catDomainSizes[-cutvar[nextnode] - 1]];
            Arrays.fill(tmp, -1);
            int[] cs = catsplit[(int)cutpoint[nextnode]];
            int j22 = 0;
            while (j22 < cs.length) {
                tmp[cs[j22] - 1] = 0;
                ++j22;
            }
            cs = catsplit[(int)cutpoint[nextnode] + N];
            j22 = 0;
            while (j22 < cs.length) {
                tmp[cs[j22] - 1] = 1;
                ++j22;
            }
            tree.catsplit[(int)cutpoint[nextnode]] = tmp;
            ++i21;
        }
        i21 = 0;
        while (i21 < numNodes) {
            int Nnode;
            tree.children[i21][0] = leftchildren[i21];
            tree.children[i21][1] = rightchildren[i21];
            int n = Nnode = cutvar[i21] == 0 ? nodesize[i21] : 0;
            if (Nnode != 0) {
                if (params.logModel == 1 || params.logModel == 2) {
                    int j23 = 0;
                    while (j23 < Nnode) {
                        ysub[i21][j23] = Math.pow(10.0, ysub[i21][j23]);
                        ++j23;
                    }
                }
                if (params.storeResponses) {
                    tree.ysub[i21] = new double[Nnode];
                    tree.is_censored[i21] = new boolean[Nnode];
                    System.arraycopy(ysub[i21], 0, tree.ysub[i21], 0, Nnode);
                    System.arraycopy(censsub[i21], 0, tree.is_censored[i21], 0, Nnode);
                } else {
                    double sum = 0.0;
                    double sumOfSq = 0.0;
                    int j24 = 0;
                    while (j24 < Nnode) {
                        double next = ysub[i21][j24];
                        sum += next;
                        sumOfSq += next * next;
                        ++j24;
                    }
                    tree.ysub[i21][0] = sum;
                    tree.ysub[i21][1] = sumOfSq;
                }
            }
            ++i21;
        }
        tree.recalculateStats();
        return tree;
    }

    private static double kaplan_meier_mean(int numUncens, int numCens, double[] y_km, double[] c_km, double upper_bound) {
        int N_i = numUncens + numCens;
        if (N_i == 0) {
            throw new RuntimeException("Kaplan-Meier estimator undefined for empty population.");
        }
        double km_mean = 0.0;
        if (numUncens == 0) {
            km_mean = upper_bound;
        } else {
            int num_rows = 0;
            int i = 0;
            while (i < numUncens - 1) {
                if (y_km[i] + 1.0E-10 < y_km[i + 1]) {
                    RegtreeFit.rows_km[num_rows++] = i;
                }
                ++i;
            }
            RegtreeFit.rows_km[num_rows++] = numUncens - 1;
            double prod = 1.0;
            int c_idx = 0;
            int i2 = 0;
            while (i2 < num_rows) {
                int d_i;
                double t_i = y_km[rows_km[i2]];
                while (c_idx < numCens && c_km[c_idx] < t_i) {
                    --N_i;
                    ++c_idx;
                }
                if (i2 == 0) {
                    d_i = rows_km[i2] + 1;
                    km_mean += prod * y_km[rows_km[i2]];
                } else {
                    d_i = rows_km[i2] - rows_km[i2 - 1];
                    km_mean += prod * (y_km[rows_km[i2]] - y_km[rows_km[i2 - 1]]);
                }
                prod *= (double)(N_i - d_i) * 1.0 / (double)N_i;
                N_i -= d_i;
                ++i2;
            }
            km_mean += prod * (upper_bound - y_km[numUncens - 1]) / 2.0;
        }
        return km_mean;
    }

    private static double logrank_statistic(int num_periods, int[] N, int[] O, int[] N_1, int[] O_1) {
        double sum_V = 0.0;
        double numerator = 0.0;
        int p = 0;
        while (p < num_periods) {
            int Np = N[p];
            if (Np > 1) {
                int N1p = N_1[p];
                double E = (double)O[p] * (((double)N1p + 0.0) / (double)Np);
                double V = E * (1.0 - ((double)N1p + 0.0) / (double)Np) * (double)(Np - O[p]) / ((double)Np - 1.0);
                sum_V += V;
                numerator += (double)O_1[p] - E;
            }
            ++p;
        }
        double denominator = Math.sqrt(sum_V);
        if (Math.abs(denominator) < 1.0E-6) {
            if (Math.abs(numerator) < 1.0E-6) {
                return 0.0;
            }
            throw new RuntimeException("Division by zero in function logrank_statistic.");
        }
        return numerator / denominator;
    }

    private static int[] getCompatibleValues(int currnode, int var, int N, int[] parent, int[] cutvar, double[] cutpoint, int[] leftchildren, int[] rightchildren, int[][] catsplit, int[] catDomainSizes) {
        int[] compatibleValues = null;
        while (currnode > 0) {
            int parent_node = parent[currnode];
            if (-cutvar[parent_node] - 1 == var) {
                int catsplit_index = (int)cutpoint[parent_node];
                if (leftchildren[parent_node] == currnode) {
                    compatibleValues = catsplit[catsplit_index];
                    break;
                }
                if (rightchildren[parent_node] == currnode) {
                    compatibleValues = catsplit[catsplit_index + N];
                    break;
                }
                throw new RuntimeException("currnode must be either left or right child of its parent.");
            }
            currnode = parent_node;
        }
        if (currnode == 0) {
            compatibleValues = new int[catDomainSizes[var]];
            int i = 0;
            while (i < compatibleValues.length) {
                compatibleValues[i] = i + 1;
                ++i;
            }
        }
        return compatibleValues;
    }

    private static void rankSort(double[] arr, int len, int[] sorder) {
        int i = 0;
        while (i < len) {
            sorder[i] = i;
            ++i;
        }
        RegtreeFit.dp_quick(arr, sorder, 0, len - 1);
    }

    private static void shuffle(int[] arr, int n) {
        int i = 0;
        while (i < n - 1) {
            int j = i + RegtreeFit.rand() / (0x7FFFFFFE / (n - i) + 1);
            int t = arr[j];
            arr[j] = arr[i];
            arr[i] = t;
            ++i;
        }
    }

    private static void dp_quick(double[] input, int[] sorder, int min, int max) {
        while (max - min > 0) {
            int i = min;
            int j = max;
            double pivot = input[sorder[i + j >> 1]];
            while (true) {
                if (input[sorder[i]] < pivot) {
                    ++i;
                    continue;
                }
                while (input[sorder[j]] > pivot) {
                    --j;
                }
                if (i >= j) break;
                int t = sorder[i];
                sorder[i] = sorder[j];
                sorder[j] = t;
                if (++i >= --j) break;
            }
            while (min < j && input[sorder[j]] == pivot) {
                --j;
            }
            if (min < j) {
                RegtreeFit.dp_quick(input, sorder, min, j);
            }
            while (i < max && input[sorder[i]] == pivot) {
                ++i;
            }
            min = i;
        }
    }
}

