/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf;

import ca.ubc.cs.beta.models.fastrf.RegtreeFwd;
import ca.ubc.cs.beta.models.fastrf.Utils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;

public class Regtree
implements Serializable {
    private static final long serialVersionUID = -7861532246973394126L;
    public int numNodes;
    public int[] node;
    public int[] parent;
    public double[][] ysub;
    public boolean[][] is_censored;
    public int[] var;
    public double[] cut;
    public int[][] children;
    public int[] nodesize;
    public int npred;
    public int[][] catsplit;
    public double[] nodepred;
    public double[] nodevar;
    public boolean resultsStoredInLeaves;
    public boolean preprocessed;
    public double[] weightedpred;
    public double[] weights;
    public int logModel;

    public Regtree(int numNodes, int logModel) {
        this.numNodes = numNodes;
        this.logModel = logModel;
        this.preprocessed = false;
    }

    public Regtree(int numNodes, int ncatsplit, boolean storeResultsInLeaves, int logModel) {
        this(numNodes, logModel);
        this.resultsStoredInLeaves = storeResultsInLeaves;
        this.node = new int[numNodes];
        this.parent = new int[numNodes];
        this.var = new int[numNodes];
        this.cut = new double[numNodes];
        this.children = new int[numNodes][2];
        this.nodesize = new int[numNodes];
        this.catsplit = new int[ncatsplit][];
        if (this.resultsStoredInLeaves) {
            this.ysub = new double[numNodes][];
            this.is_censored = new boolean[numNodes][];
        } else {
            this.ysub = new double[numNodes][2];
        }
    }

    public Regtree(Regtree t) {
        this(t.numNodes, t.catsplit.length, t.resultsStoredInLeaves, t.logModel);
        this.npred = t.npred;
        System.arraycopy(t.node, 0, this.node, 0, this.numNodes);
        System.arraycopy(t.parent, 0, this.parent, 0, this.numNodes);
        System.arraycopy(t.var, 0, this.var, 0, this.numNodes);
        System.arraycopy(t.cut, 0, this.cut, 0, this.numNodes);
        System.arraycopy(t.nodesize, 0, this.nodesize, 0, this.numNodes);
        int i = 0;
        while (i < t.catsplit.length) {
            this.catsplit[i] = new int[t.catsplit[i].length];
            this.catsplit[i] = new int[t.catsplit[i].length];
            System.arraycopy(t.catsplit[i], 0, this.catsplit[i], 0, t.catsplit[i].length);
            ++i;
        }
        i = 0;
        while (i < this.numNodes) {
            this.children[i][0] = t.children[i][0];
            this.children[i][1] = t.children[i][1];
            if (this.resultsStoredInLeaves) {
                int Nnode;
                int n = Nnode = this.children[i][0] == 0 ? this.nodesize[i] : 0;
                if (Nnode != 0) {
                    this.ysub[i] = new double[Nnode];
                    this.is_censored[i] = new boolean[Nnode];
                    System.arraycopy(t.ysub[i], 0, this.ysub[i], 0, Nnode);
                    System.arraycopy(t.is_censored[i], 0, this.is_censored[i], 0, Nnode);
                }
            } else {
                System.arraycopy(t.ysub[i], 0, this.ysub[i], 0, t.ysub[i].length);
            }
            ++i;
        }
        this.preprocessed = t.preprocessed;
        if (this.preprocessed) {
            this.weights = new double[this.numNodes];
            this.weightedpred = new double[this.numNodes];
            System.arraycopy(t.weights, 0, this.weights, 0, this.numNodes);
            System.arraycopy(t.weightedpred, 0, this.weightedpred, 0, this.numNodes);
        }
        this.recalculateStats();
    }

    public static double[][] apply(Regtree tree, double[][] X) {
        int[] nodes = RegtreeFwd.fwd(tree, X);
        double[][] retn = new double[X.length][2];
        int i = 0;
        while (i < X.length) {
            retn[i][0] = tree.nodepred[nodes[i]];
            retn[i][1] = tree.nodevar[nodes[i]];
            ++i;
        }
        return retn;
    }

    public static double[] applyMarginal(Regtree tree, double[][] Theta, double[][] X) {
        return RegtreeFwd.marginalFwd(tree, Theta, X);
    }

    public void recalculateStats() {
        this.nodepred = new double[this.numNodes];
        this.nodevar = new double[this.numNodes];
        int i = 0;
        while (i < this.numNodes) {
            this.recalculateStats(i);
            ++i;
        }
    }

    public void recalculateStats(int node) {
        if (this.children[node][0] != 0) {
            return;
        }
        if (this.resultsStoredInLeaves) {
            double[] results = Arrays.copyOf(this.ysub[node], this.ysub[node].length);
            if (this.logModel == 1) {
                this.nodepred[node] = Math.log10(Utils.mean(results));
                this.nodevar[node] = 0.0;
            } else {
                this.nodepred[node] = Utils.mean(results);
                this.nodevar[node] = Utils.var(results);
            }
        } else {
            double sum = this.ysub[node][0];
            double sumOfSq = this.ysub[node][1];
            int N = this.nodesize[node];
            if (this.logModel == 1) {
                this.nodepred[node] = Math.log10(sum / (double)N);
                this.nodevar[node] = 0.0;
            } else {
                this.nodepred[node] = sum / (double)N;
                this.nodevar[node] = (sumOfSq - sum * sum / (double)N) / (double)(N - 1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static double[] getMarginal(Regtree tree, double[][] allvars, int[] variablesToKeep) {
        if (variablesToKeep == null) {
            variablesToKeep = new int[]{};
        }
        if (allvars.length != tree.npred) {
            throw new RuntimeException("variable domains for all variables must be provided");
        }
        toBeMarginalizedVariables = new int[tree.npred - variablesToKeep.length];
        variablesToKeep_IndexOf = new int[tree.npred + 1];
        Arrays.fill(variablesToKeep_IndexOf, -1);
        counter = 0;
        next = 1;
        i = 0;
        ** GOTO lbl18
        {
            toBeMarginalizedVariables[counter++] = next++;
            do {
                if (variablesToKeep[i] != next) continue block0;
                variablesToKeep_IndexOf[variablesToKeep[i]] = i;
                ++next;
                ++i;
lbl18:
                // 2 sources

            } while (i < variablesToKeep.length);
        }
        while (next <= tree.npred) {
            toBeMarginalizedVariables[counter++] = next++;
        }
        logModel = tree.logModel;
        queue = new LinkedList<Integer>();
        weights = new double[tree.numNodes];
        Arrays.fill(weights, 1.0);
        i = 0;
        while (i < toBeMarginalizedVariables.length) {
            nextvar = toBeMarginalizedVariables[i];
            counts = new int[tree.numNodes];
            numValues = allvars[nextvar].length;
            j = 0;
            while (j < numValues) {
                queue.add(0);
                block5: while (!queue.isEmpty()) {
                    thisnode = (Integer)queue.poll();
                    while (true) {
                        splitvar = tree.var[thisnode];
                        cutoff = tree.cut[thisnode];
                        left_kid = tree.children[thisnode][0];
                        right_kid = tree.children[thisnode][1];
                        if (splitvar == 0) {
                            v0 = thisnode;
                            counts[v0] = counts[v0] + 1;
                            continue block5;
                        }
                        if (Math.abs(splitvar) != nextvar) {
                            queue.add(right_kid);
                            thisnode = left_kid;
                            continue;
                        }
                        if (splitvar > 0) {
                            thisnode = allvars[nextvar][j] <= cutoff ? left_kid : right_kid;
                            continue;
                        }
                        x = (int)allvars[nextvar][j];
                        split = tree.catsplit[(int)cutoff][x - 1];
                        if (split == 0) {
                            thisnode = left_kid;
                            continue;
                        }
                        if (split != 1) break;
                        thisnode = right_kid;
                    }
                    throw new RuntimeException("Missing value -- not allowed in this implementation.");
                }
                ++j;
            }
            j = 0;
            while (j < tree.numNodes) {
                v1 = j;
                weights[v1] = weights[v1] * ((double)counts[j] * 1.0 / (double)numValues);
                ++j;
            }
            ++i;
        }
        if (variablesToKeep.length == 0) {
            retn = new double[1];
            sum = 0.0;
            i = 0;
            while (i < weights.length) {
                sum += weights[i];
                ++i;
            }
            if (sum - 1.0 > 1.0E-6) {
                throw new RuntimeException("Something is wrong. Sum: " + sum + "(" + Arrays.toString(weights) + ")");
            }
            i = 0;
            while (i < weights.length) {
                pred = logModel == 1 ? Math.pow(10.0, tree.nodepred[i]) : tree.nodepred[i];
                retn[0] = retn[0] + weights[i] * pred;
                ++i;
            }
        } else {
            state = new int[variablesToKeep.length];
            numData = 1;
            i = 0;
            while (i < variablesToKeep.length) {
                state[i] = 0;
                numData *= allvars[variablesToKeep[i]].length;
                ++i;
            }
            if (numData == 0) {
                throw new RuntimeException("Cannot have a variable with an empty domain!");
            }
            retn = new double[numData];
            i = 0;
            while (i < numData) {
                queue.add(0);
                block12: while (!queue.isEmpty()) {
                    thisnode = (Integer)queue.poll();
                    while (true) {
                        splitvar = tree.var[thisnode];
                        cutoff = tree.cut[thisnode];
                        left_kid = tree.children[thisnode][0];
                        right_kid = tree.children[thisnode][1];
                        varidx = variablesToKeep_IndexOf[Math.abs(splitvar)];
                        if (splitvar == 0) {
                            pred = logModel == 1 ? Math.pow(10.0, tree.nodepred[thisnode]) : tree.nodepred[thisnode];
                            v2 = i;
                            retn[v2] = retn[v2] + weights[thisnode] * pred;
                            continue block12;
                        }
                        if (varidx == -1) {
                            queue.add(right_kid);
                            thisnode = left_kid;
                            continue;
                        }
                        if (splitvar > 0) {
                            thisnode = allvars[variablesToKeep[varidx]][state[varidx]] <= cutoff ? left_kid : right_kid;
                            continue;
                        }
                        x = (int)allvars[variablesToKeep[varidx]][state[varidx]];
                        split = tree.catsplit[(int)cutoff][x - 1];
                        if (split == 0) {
                            thisnode = left_kid;
                            continue;
                        }
                        if (split != 1) break;
                        thisnode = right_kid;
                    }
                    throw new RuntimeException("Missing value -- not allowed in this implementation.");
                }
                ++i;
            }
            j = variablesToKeep.length - 1;
            while (j >= 0) {
                v3 = j;
                state[v3] = state[v3] + 1;
                if (state[j] == allvars[variablesToKeep[j]].length) {
                    state[j] = 0;
                    --j;
                    continue;
                }
                break;
            }
        }
        i = 0;
        while (i < retn.length) {
            if (logModel == 1) {
                retn[i] = Math.log10(retn[i]);
            }
            ++i;
        }
        return retn;
    }
}

