function model = single_smac_bbob_experiment(num_exp, dimfactor, dim, ifun, iinstance)
% This performs a single run of SMAC-BBOB on a single noise-free BBOB function, with a single dimensionality.
% fgeneric.m and benchmarks.m must be on the Matlab path.
% num_exp select between different versions of SMAC we ran preliminary experiments with. 
% 0 and 1 are RFs (noiseless and noisy)
% 2-11 are GP variants
% One generated PDF results file for each of the variants (for a budget of 10*D) is included in the all_results/ folder.
% 2-5 just start from the default, as normal in SMAC, 6-9 start from a random LHD. Both of those versions perform similarly, so no need for an LHD.
% In the end, the winner is the Matern kernel, either Matern3 or Matern5, with or without an LHD. We chose Matern3 without LHD (the first of these we tried).
%
% Here in more detail:
% 2 has a noisy GP with suared exponential kernel and performs rather poorly
% 3 is the same as 2, except no noise; it's very good
% 4 is an automatic relevance detection kernel, i.e. every length scale is a parameter; it does not scale very well to 20-dim
% 5 is a Matern kernel; it is similar to 3 for 5-dim, and quite a bit better for 20-dim
% 
% Comparing 5 vs. CMAES based on only 10D function evaluations shows that 5 is a bit better for most functions, much better for the two separable functions.

if isdeployed
    dim = str2double(dim);
    ifun = str2double(ifun);
    num_exp = str2double(num_exp);
    dimfactor = str2num(dimfactor);
    iinstance = str2num(iinstance);
end

options = [];
switch num_exp
    case 0
        % nothing: rf det, splitmin=1
        options.modelType = 'rf';
        options.Splitmin_init = 1;
        options.orig_rf = 0;
        options.nInit = -1;
    case 1
        options.modelType = 'rf';
        options.nInit = -1;
    case 2
        options.modelType = 'GPML';
        options.nInit = -1;
    case 3
        options.modelType = 'GP-SEiso';
        options.nInit = -1;
        options.trainSubSize = 0; % approximate would require noise in covfunc
    case 4
        options.modelType = 'GP-SEard';
        options.nInit = -1;
        options.trainSubSize = 0; % approximate would require noise in covfunc
    case 5
        options.modelType = 'GP-matern3';
        options.nInit = -1;        
        options.trainSubSize = 0; % approximate would require noise in covfunc
    case 6 
        options.modelType = 'GPML';
    case 7
        options.modelType = 'GP-SEiso';
        options.trainSubSize = 0; % approximate would require noise in covfunc
    case 8
        options.modelType = 'GP-SEard';
        options.trainSubSize = 0; % approximate would require noise in covfunc
    case 9
        options.modelType = 'GP-matern3';
        options.trainSubSize = 0; % approximate would require noise in covfunc
    case 10
        options.modelType = 'GP-matern5';
        options.nInit = -1;
        options.trainSubSize = 0; % approximate would require noise in covfunc
    case 11
        options.modelType = 'GP-matern5';
        options.trainSubSize = 0; % approximate would require noise in covfunc        
end

%addpath(genpath('/ubc/cs/project/arrow/hutter/altuning/matlab/SMAC_capping_dev'));  % should point to fgeneric.m etc.
%datapath = '/homes/51/mosb/Code/GP/optimization/bbob.v10.61/data';  % different folder for each experiment
datapath = strcat('smboApr6_data', '-ver', num2str(num_exp), '/dim', num2str(dim), '-factor', num2str(dimfactor), 'iinstance', num2str(iinstance));

opt.algName = 'SMBO';
opt.comments = '';
maxfunevals = strcat(num2str(dimfactor), ' * dim'); % 10*dim is a short test-experiment taking a few minutes 
                          % INCREMENT maxfunevals successively to larger value(s)
minfunevals = 'dim + 2';  % PUT MINIMAL SENSIBLE NUMBER OF EVALUATIONS for a restart
maxrestarts = 0;        % SET to zero for an entirely deterministic algorithm

more off;  % in octave pagination is on by default

t0 = clock;
rand('state', sum(100 * t0));

% for dim = [40,20,10,5,3,2]  % small dimensions first, for CPU reasons
%   for ifun = 1:24%benchmarks('FunctionIndices')  % or benchmarksnoisy(...)
%       fprintf(strcat(['./smbo_cluster_experiment ', num2str(dim), ' ', num2str(ifun), '\n']));
%   end
% end

% for dim = 2;%40;%[2,3,5,10,20,40]  % small dimensions first, for CPU reasons
%   for ifun = 1:24%benchmarks('FunctionIndices')  % or benchmarksnoisy(...)
%    for iinstance = [1:15]  % first 15 function instances
      fgeneric('initialize', ifun, iinstance, datapath, opt); 

      % independent restarts until maxfunevals or ftarget is reached
      for restarts = 0:maxrestarts
          model = smac_bbob('fgeneric', dim, fgeneric('ftarget'), ...
                     eval(maxfunevals) - fgeneric('evaluations'), options);
        if fgeneric('fbest') < fgeneric('ftarget') || ...
           fgeneric('evaluations') + eval(minfunevals) > eval(maxfunevals)
          break;
        end  
      end

      disp(sprintf(['  f%d in %d-D, instance %d: FEs=%d with %d restarts,' ...
                    ' fbest-ftarget=%.4e, elapsed time [h]: %.2f'], ...
                   ifun, dim, iinstance, ...
                   fgeneric('evaluations'), ...
                   restarts, ...
                   fgeneric('fbest') - fgeneric('ftarget'), ...
                   etime(clock, t0)/60/60));

      fgeneric('finalize');
      pause(1) % give it some time to finalize
      disp(['    after iinstance ', num2str(iinstance), ':  date and time is ' num2str(clock, ' %.0f')]);
%    end
%   end
%   disp(sprintf('---- dimension %d-D done ----', dim));
% end


%% DECLARATION OF ALL ANONYMOUS FUNCTIONS FOR MCC.
%#function neg_ei_of_model_for_cmaes
%#function covSum
%#function covDIFFard
%#function covDIFFiso
%#function covHybridSE_DIFFard
%#function covHybridSE_DIFFiso
%#function covHybridSE_DIFFiso_OnlyLen
%#function covHybridSE_DIFFiso_NoLen
%#function covHybridSE_DIFFiso_algo
%#function covMatern3iso
%#function covMatern5iso
%#function covNoise
%#function covSEard
%#function covSEiso
%#function covSum
%#function gpr
%#function gprCensor
%#function negLogCensoredConditional
%#function branin.m
%#function disc_bnet_ll
%#function disc_test_fun2
%#function disc_test_fun
%#function griewank
%#function hart6
%#function hartman6
%#function hartman6_marginalized
%#function hartman6_marginalized_t
%#function mixed_disc_cont_testfun
%#function prod_of_branins
%#function saved_saps_swgcp_first100train
%#function simplest_discrete
%#function sixHumpCamelBack
%#function eval_algo
%#function eval
%#function nmllModel
%#function crossValLL
%#function sample_exp_imp_forest
%#function gaussian_exp_imp_forest_m
%#function cmaes_fsphere
%#function cmaes_rastrigin
%#function cmaes_griewank
%#function cmaes_ackley
%#function cmaes323_sphere_10
%#function cmaes323_ackley_10
%#function cmaes323_griewank_10
%#function cmaes323_rastrigin_10
%#function cmaes323_bf1_10
%#function cmaes323_bf2_10
%#function cmaes323_bf3_10
%#function cmaes323_bf4_10
%#function cmaes323_bf5_10
%#function cmaes323_bf6_10
%#function cmaes323_bf7_10
%#function cmaes323_bf8_10
%#function cmaes323_bf9_10
%#function cmaes323_bf10_10
%#function cmaes323_bf11_10
%#function cmaes323_bf12_10
%#function benchmark_func
%#function benchmark_func_1
%#function benchmark_func_2
%#function benchmark_func_3
%#function benchmark_func_4
%#function benchmark_func_5
%#function benchmark_func_6
%#function benchmark_func_7
%#function benchmark_func_8
%#function benchmark_func_9
%#function benchmark_func_10
%#function benchmark_func_11
%#function benchmark_func_12
%#function regpoly0
%#function corrgauss
%#function cmaes
