function [XMIN, FMIN, COUNTEVAL, STOPFLAG, OUT, BESTEVER] = ...
            runcmaes(FUN, DIM, ftarget, maxfunevals)
% MY_OPTIMIZER(FUN, DIM, ftarget, maxfunevals)

  % termination 
  opts.maxfunevals = maxfunevals; 
  opts.stopfitness = ftarget;
  opts.tolupx = inf;  % allow sigma to increase, only relevant with small sigma0

  opts.cma.active = 1;  % negative matrix update

  opts.restarts = 9;  % 2^9 == 512
  opts.maxiter = '100 + 50 * (N+3)^2 / sqrt(popsize)';
  
  % speed and output options
  opts.evalpar = 1;
  if 1 < 3  % run silently
    opts.savevar = 'off'; 
    opts.dispfinal = 0;
    opts.dispmod = 0;
    opts.logmod = 0;
  end

  if 11 < 3  % prepend a non-restart run with x0 = zeros
    opts.restarts = 0;
    [XMIN, FMIN, COUNTEVAL, STOPFLAG, OUT, BESTEVER] = ...
        cmaes(FUN, zeros(DIM,1), 2, opts);
    opts.restarts = 9;  % 2^9 == 512
  end
  
  [XMIN, FMIN, COUNTEVAL, STOPFLAG, OUT, BESTEVER] = ...
    cmaes(FUN, ['8*rand(' num2str(DIM) ', 1) - 4'], 2, opts);
  
