function [XMIN, FMIN, COUNTEVAL, STOPFLAG, OUT, BESTEVER] = ...
            cmaes_wrapper(FUN, DIM, xStart, maxfunevals, varargin)

  % termination 
  opts.maxfunevals = maxfunevals; 
  opts.stopfitness = -inf;
  opts.tolupx = inf;  % allow sigma to increase, only relevant with small sigma0

  opts.cma.active = 1;  % negative matrix update

  opts.restarts = 9;  % 2^9 == 512
  opts.maxiter = '100 + 50 * (N+3)^2 / sqrt(popsize)';
  
  % speed and output options
  opts.evalpar = 1;
  if 1 < 3  % run silently
    opts.savevar = 'off'; 
    opts.dispfinal = 0;
    opts.dispmod = 0;
    opts.logmod = 0;
    
    opts.LBounds = 0;%zeros(DIM,1);
    opts.UBounds = 1;%ones(DIM,1);

  end

  if 11 < 3  % prepend a non-restart run with x0 = zeros
    opts.restarts = 0;
    [XMIN, FMIN, COUNTEVAL, STOPFLAG, OUT, BESTEVER] = ...
        cmaes(FUN, zeros(DIM,1), 0.3, opts, varargin{:});
    opts.restarts = 9;  % 2^9 == 512
  end
  
%   xStart = [8*rand(DIM, 1) - 4']; % FH: error when calling inside
  %cmaes(FUN, ['8*rand(' num2str(DIM) ', 1) - 4'], 2, opts);
% xStart = [rand(DIM, 1)]; % FH: bounds normalized to [0,1]
  
  [XMIN, FMIN, COUNTEVAL, STOPFLAG, OUT, BESTEVER] = ...
    cmaes(FUN, xStart, 0.3, opts, varargin{:});
  
