/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.rf;

import ca.ubc.cs.beta.models.rf.RegtreeFwd;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;

public class Regtree
implements Serializable {
    private static final long serialVersionUID = -7861532246973394126L;
    public int numNodes;
    public int[] node;
    public int[] parent;
    public double[][] ysub;
    public boolean[][] is_censored;
    public int[] var;
    public double[] cut;
    public int[][] children;
    public int[] nodesize;
    public int npred;
    public int[][] catsplit;
    public String method = "regression";
    public double[] nodepred;
    public double[] nodevar;
    public boolean resultsStoredInLeaves;
    public boolean preprocessed;
    public double[] weightedpred;
    public double[] weights;
    public int logModel;

    public Regtree(int numNodes, int logModel) {
        this.numNodes = numNodes;
        this.logModel = logModel;
        this.preprocessed = false;
    }

    public Regtree(int numNodes, int ncatsplit, boolean storeResultsInLeaves, int logModel) {
        this(numNodes, logModel);
        this.resultsStoredInLeaves = storeResultsInLeaves;
        this.node = new int[numNodes];
        this.parent = new int[numNodes];
        this.var = new int[numNodes];
        this.cut = new double[numNodes];
        this.children = new int[numNodes][2];
        this.nodesize = new int[numNodes];
        this.catsplit = new int[ncatsplit][];
        if (this.resultsStoredInLeaves) {
            this.ysub = new double[numNodes][];
            this.is_censored = new boolean[numNodes][];
        } else {
            this.ysub = new double[numNodes][2];
        }
    }

    public Regtree(Regtree t) {
        this(t.numNodes, t.catsplit.length, t.resultsStoredInLeaves, t.logModel);
        this.npred = t.npred;
        this.method = t.method;
        System.arraycopy(t.node, 0, this.node, 0, this.numNodes);
        System.arraycopy(t.parent, 0, this.parent, 0, this.numNodes);
        System.arraycopy(t.var, 0, this.var, 0, this.numNodes);
        System.arraycopy(t.cut, 0, this.cut, 0, this.numNodes);
        System.arraycopy(t.nodesize, 0, this.nodesize, 0, this.numNodes);
        int i = 0;
        while (i < t.catsplit.length) {
            this.catsplit[i] = new int[t.catsplit[i].length];
            this.catsplit[i] = new int[t.catsplit[i].length];
            System.arraycopy(t.catsplit[i], 0, this.catsplit[i], 0, t.catsplit[i].length);
            ++i;
        }
        i = 0;
        while (i < this.numNodes) {
            this.children[i][0] = t.children[i][0];
            this.children[i][1] = t.children[i][1];
            if (this.resultsStoredInLeaves) {
                int Nnode;
                int n = Nnode = this.children[i][0] == 0 ? this.nodesize[i] : 0;
                if (Nnode != 0) {
                    this.ysub[i] = new double[Nnode];
                    this.is_censored[i] = new boolean[Nnode];
                    System.arraycopy(t.ysub[i], 0, this.ysub[i], 0, Nnode);
                    System.arraycopy(t.is_censored[i], 0, this.is_censored[i], 0, Nnode);
                }
            } else {
                System.arraycopy(t.ysub[i], 0, this.ysub[i], 0, t.ysub[i].length);
            }
            ++i;
        }
        this.preprocessed = t.preprocessed;
        if (this.preprocessed) {
            this.weights = new double[this.numNodes];
            this.weightedpred = new double[this.numNodes];
            System.arraycopy(t.weights, 0, this.weights, 0, this.numNodes);
            System.arraycopy(t.weightedpred, 0, this.weightedpred, 0, this.numNodes);
        }
        this.recalculateStats();
    }

    public static double[][] apply(Regtree tree, double[][] X) {
        int[] nodes = RegtreeFwd.fwd(tree, X);
        double[][] retn = new double[X.length][2];
        int i = 0;
        while (i < X.length) {
            retn[i][0] = tree.nodepred[nodes[i]];
            retn[i][1] = tree.nodevar[nodes[i]];
            ++i;
        }
        return retn;
    }

    public static double[] applyMarginal(Regtree tree, double[][] Theta, double[][] X) {
        return RegtreeFwd.marginalFwd(tree, Theta, X);
    }

    public void recalculateStats() {
        this.nodepred = new double[this.numNodes];
        this.nodevar = new double[this.numNodes];
        int i = 0;
        while (i < this.numNodes) {
            this.recalculateStats(i);
            ++i;
        }
    }

    public void recalculateStats(int node) {
        if (this.children[node][0] != 0) {
            return;
        }
        if (this.resultsStoredInLeaves) {
            double[] results = Arrays.copyOf(this.ysub[node], this.ysub[node].length);
            if (this.logModel == 1) {
                this.nodepred[node] = Math.log10(Regtree.mean(results));
                this.nodevar[node] = 0.0;
            } else {
                this.nodepred[node] = Regtree.mean(results);
                this.nodevar[node] = Regtree.var(results);
            }
        } else {
            double sum = this.ysub[node][0];
            double sumOfSq = this.ysub[node][1];
            int N = this.nodesize[node];
            if (this.logModel == 1) {
                this.nodepred[node] = Math.log10(sum / (double)N);
                this.nodevar[node] = 0.0;
            } else {
                this.nodepred[node] = sum / (double)N;
                this.nodevar[node] = (sumOfSq - sum * sum / (double)N) / (double)(N - 1);
            }
        }
    }

    public static double[][] getLeafInfoForANOVA(Regtree tree, Object[] toBeMarginalizedObj) {
        if (toBeMarginalizedObj == null) {
            return null;
        }
        if (toBeMarginalizedObj.length != tree.npred) {
            throw new RuntimeException("toBeMarginalizedObj.length must be equal to numvars.");
        }
        double[][] toBeMarginalized = new double[toBeMarginalizedObj.length][];
        int i = 0;
        while (i < toBeMarginalized.length) {
            if (toBeMarginalizedObj[i] instanceof double[]) {
                toBeMarginalized[i] = (double[])toBeMarginalizedObj[i];
            } else {
                toBeMarginalized[i] = new double[1];
                toBeMarginalized[i][0] = (Double)toBeMarginalizedObj[i];
            }
            ++i;
        }
        int logModel = tree.logModel;
        int[] leafNodeIdx = new int[tree.numNodes];
        int numleaves = 0;
        int i2 = 0;
        while (i2 < tree.numNodes) {
            if (tree.var[i2] == 0) {
                leafNodeIdx[i2] = numleaves++;
            }
            ++i2;
        }
        double[][] retn = new double[numleaves][toBeMarginalized.length + 1];
        int counter = 0;
        int i3 = 0;
        while (i3 < tree.numNodes) {
            if (tree.var[i3] == 0) {
                retn[counter++][0] = logModel == 1 ? Math.pow(10.0, tree.nodepred[i3]) : tree.nodepred[i3];
            }
            ++i3;
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        int i4 = 0;
        while (i4 < toBeMarginalized.length) {
            int nextvar = i4 + 1;
            int numValues = toBeMarginalized[i4].length;
            counter = 0;
            int j = 0;
            while (j < numValues) {
                queue.add(0);
                block5: while (!queue.isEmpty()) {
                    int thisnode = (Integer)queue.poll();
                    while (true) {
                        int splitvar = tree.var[thisnode];
                        double cutoff = tree.cut[thisnode];
                        int left_kid = tree.children[thisnode][0];
                        int right_kid = tree.children[thisnode][1];
                        if (splitvar == 0) {
                            int leaf = leafNodeIdx[thisnode];
                            double[] dArray = retn[leaf];
                            int n = nextvar;
                            dArray[n] = dArray[n] + 1.0;
                            continue block5;
                        }
                        if (Math.abs(splitvar) != nextvar) {
                            queue.add(right_kid);
                            thisnode = left_kid;
                            continue;
                        }
                        if (splitvar > 0) {
                            thisnode = toBeMarginalized[i4][j] <= cutoff ? left_kid : right_kid;
                            continue;
                        }
                        int x = (int)toBeMarginalized[i4][j];
                        int split = tree.catsplit[(int)cutoff][x - 1];
                        if (split == 0) {
                            thisnode = left_kid;
                            continue;
                        }
                        if (split != 1) break;
                        thisnode = right_kid;
                    }
                    throw new RuntimeException("Missing value -- not allowed in this implementation.");
                }
                ++j;
            }
            j = 0;
            while (j < numleaves) {
                double[] dArray = retn[j];
                int n = nextvar;
                dArray[n] = dArray[n] / (double)numValues;
                ++j;
            }
            ++i4;
        }
        return retn;
    }

    public void setysub(Object[][] y, Object[][] cens) {
        Object[] t;
        this.numNodes = y.length;
        this.ysub = new double[this.numNodes][];
        this.is_censored = new boolean[this.numNodes][];
        int i = 0;
        while (i < this.numNodes) {
            Object censsub = cens[i][0];
            if (censsub != null) {
                if (censsub instanceof int[]) {
                    t = (int[])censsub;
                    this.is_censored[i] = new boolean[t.length];
                    int j = 0;
                    while (j < t.length) {
                        this.is_censored[i][j] = t[j] == 1;
                        ++j;
                    }
                } else {
                    this.is_censored[i] = new boolean[1];
                    this.is_censored[i][0] = (Integer)censsub == 1;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.numNodes) {
            Object ysub = y[i][0];
            if (ysub != null) {
                if (ysub instanceof double[]) {
                    t = (double[])ysub;
                    this.ysub[i] = new double[t.length];
                    System.arraycopy(t, 0, this.ysub[i], 0, t.length);
                } else {
                    this.ysub[i] = new double[1];
                    this.ysub[i][0] = (Double)ysub;
                }
            }
            ++i;
        }
        this.recalculateStats();
    }

    public void setcatsplit(int[] splitvars, Object[][] catsplit, int[] domain_sizes) {
        this.catsplit = new int[catsplit.length][];
        int nextcatsplit = -1;
        int i = 0;
        while (i < catsplit.length) {
            while (splitvars[++nextcatsplit] >= 0) {
            }
            int[] cs = new int[domain_sizes[-splitvars[nextcatsplit] - 1]];
            Arrays.fill(cs, -1);
            int a = 0;
            while (a <= 1) {
                Object c = catsplit[i][a];
                int[] t = c instanceof int[][] ? ((int[][])c)[0] : (c instanceof int[] ? (int[])c : new int[]{(Integer)c});
                int j = 0;
                while (j < t.length) {
                    cs[t[j] - 1] = a;
                    ++j;
                }
                ++a;
            }
            this.catsplit[i] = cs;
            ++i;
        }
    }

    public static double mean(double[] arr) {
        if (arr == null) {
            return 0.0;
        }
        int l = arr.length;
        double res = 0.0;
        int i = 0;
        while (i < l) {
            res += arr[i] / (double)l;
            ++i;
        }
        return res;
    }

    public static double var(double[] arr) {
        if (arr == null) {
            return 0.0;
        }
        int l = arr.length;
        if (l <= 1) {
            return 0.0;
        }
        double m = Regtree.mean(arr);
        double res = 0.0;
        int i = 0;
        while (i < l) {
            res += (arr[i] - m) * (arr[i] - m) / (double)(l - 1);
            ++i;
        }
        return res;
    }

    public static double median(double[] arr) {
        if (arr == null) {
            return Double.NaN;
        }
        int l = arr.length;
        if (l == 0) {
            return Double.NaN;
        }
        Arrays.sort(arr);
        return arr[(int)Math.floor((double)l / 2.0)] / 2.0 + arr[(int)Math.ceil((double)l / 2.0)] / 2.0;
    }
}

