/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf;

import Weibull.WeibullDist;
import com.mathworks.toolbox.javabuilder.MWException;
import com.mathworks.toolbox.javabuilder.MWNumericArray;
import java.util.Arrays;

public class WeibullFit {
    private static WeibullDist weibullDist = null;

    static double[] fit_dist_and_sample(double[] y_pred, boolean[] cens_pred, double[] weights, int numSamples, double lowerBoundForSamples, double maxValueForAllCens) {
        try {
            WeibullDist weibullDist = WeibullFit.getWeibullDist();
            y_pred = Arrays.copyOf(y_pred, y_pred.length);
            int i = 0;
            while (i < y_pred.length) {
                if (y_pred[i] == 0.0) {
                    y_pred[i] = 0.001;
                }
                ++i;
            }
            double ALPHA = 0.05;
            Object[] result = weibullDist.wblfit(1, new Object[]{y_pred, ALPHA, cens_pred, weights});
            MWNumericArray output = (MWNumericArray)result[0];
            double[] parmhat = output.getDoubleData();
            output.dispose();
            int i2 = 0;
            while (i2 < parmhat.length) {
                if (Double.isNaN(parmhat[i2])) {
                    int numcensored = 0;
                    int j = 0;
                    while (j < cens_pred.length) {
                        if (cens_pred[j]) {
                            ++numcensored;
                        }
                        ++j;
                    }
                    int numuncensored = cens_pred.length - numcensored;
                    System.out.println("WARNING: cannot fit Weibull to " + numuncensored + " uncensored points and " + numcensored + " censored points.");
                    double[] samples = new double[numSamples];
                    if (numuncensored > 0) {
                        double[] y_uncensored = new double[numuncensored];
                        int j2 = 0;
                        int k = 0;
                        while (j2 < cens_pred.length) {
                            if (!cens_pred[j2]) {
                                y_uncensored[k++] = y_pred[j2];
                            }
                            ++j2;
                        }
                        j2 = 0;
                        while (j2 < numSamples) {
                            samples[j2] = y_uncensored[(int)Math.floor(Math.random() * (double)numuncensored)];
                            ++j2;
                        }
                    } else {
                        int j3 = 0;
                        while (j3 < numSamples) {
                            samples[j3] = maxValueForAllCens;
                            ++j3;
                        }
                    }
                    return samples;
                }
                ++i2;
            }
            result = weibullDist.wblcdf(1, new Object[]{lowerBoundForSamples, parmhat[0], parmhat[1]});
            output = (MWNumericArray)result[0];
            double lb_quantile = output.getDouble();
            output.dispose();
            double[] u = new double[numSamples];
            int i3 = 0;
            while (i3 < numSamples) {
                u[i3] = lb_quantile + (1.0 - lb_quantile) * Math.random();
                ++i3;
            }
            result = weibullDist.wblinv(1, new Object[]{u, parmhat[0], parmhat[1]});
            output = (MWNumericArray)result[0];
            double[] samples = output.getDoubleData();
            output.dispose();
            boolean badSamples = false;
            int i4 = 0;
            while (i4 < numSamples) {
                if (Double.isNaN(samples[i4])) {
                    badSamples = true;
                    break;
                }
                ++i4;
            }
            if (badSamples) {
                System.out.println("WARNING: inverse sampling did not work - sampling directly.");
                int j = 0;
                while (j < numSamples) {
                    double new_lb_quantile;
                    if (lb_quantile > 0.99999) {
                        samples[j] = maxValueForAllCens;
                    }
                    do {
                        result = weibullDist.wblrnd(1, new Object[]{parmhat[0], parmhat[1], 1, 1});
                        output = (MWNumericArray)result[0];
                        samples[j] = output.getDouble();
                        output.dispose();
                        output = (MWNumericArray)weibullDist.wblcdf(1, new Object[]{samples[j], parmhat[0], parmhat[1]})[0];
                        new_lb_quantile = output.getDouble();
                        output.dispose();
                    } while (!(new_lb_quantile >= lb_quantile));
                    ++j;
                }
            }
            i4 = 0;
            while (i4 < numSamples) {
                if (samples[i4] < lowerBoundForSamples) {
                    throw new RuntimeException("Hallucinated samples below lower bound!");
                }
                ++i4;
            }
            return samples;
        }
        catch (MWException e) {
            throw new RuntimeException(e);
        }
    }

    private static WeibullDist getWeibullDist() throws MWException {
        if (weibullDist == null) {
            weibullDist = new WeibullDist();
        }
        return weibullDist;
    }
}

