/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf;

import java.util.Arrays;

public class Utils {
    public static int sum(int[] arr) {
        if (arr == null) {
            return 0;
        }
        int l = arr.length;
        int res = 0;
        int i = 0;
        while (i < l) {
            res += arr[i];
            ++i;
        }
        return res;
    }

    public static double sum(double[] arr) {
        if (arr == null) {
            return 0.0;
        }
        int l = arr.length;
        double res = 0.0;
        int i = 0;
        while (i < l) {
            res += arr[i];
            ++i;
        }
        return res;
    }

    public static double mean(double[] arr) {
        if (arr == null) {
            return 0.0;
        }
        return Utils.sum(arr) / (double)arr.length;
    }

    public static double var(double[] arr) {
        if (arr == null) {
            return 0.0;
        }
        int l = arr.length;
        if (l <= 1) {
            return 0.0;
        }
        double sum = 0.0;
        double sumSq = 0.0;
        int i = 0;
        while (i < l) {
            sum += arr[i];
            sumSq += arr[i] * arr[i];
            ++i;
        }
        return (sumSq - sum * sum / (double)l) / (double)(l - 1);
    }

    public static double median(double[] arr) {
        if (arr == null) {
            return Double.NaN;
        }
        int l = arr.length;
        if (l == 0) {
            return Double.NaN;
        }
        Arrays.sort(arr);
        return arr[(int)Math.floor((double)l / 2.0)] / 2.0 + arr[(int)Math.ceil((double)l / 2.0)] / 2.0;
    }

    public static double prod(double[] arr, int start, int end) {
        double result = 1.0;
        int i = start;
        while (i < end) {
            result *= arr[i];
            ++i;
        }
        return result;
    }
}

