/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf;

import ca.ubc.cs.beta.models.fastrf.Regtree;
import ca.ubc.cs.beta.models.fastrf.Utils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class RegtreeFanova {
    public static Map<String, Object> calculateFValues(Regtree tree, double[][] allvars, int degree) {
        if (allvars == null || allvars.length == 0) {
            throw new RuntimeException("empty X.");
        }
        if (degree > allvars.length) {
            throw new RuntimeException("Cannot analyze to a degree greater than the number of variables there are!");
        }
        double[][] leafInfo = RegtreeFanova.getLeafInfoForANOVA(tree, allvars);
        int numvars = allvars.length;
        int mapsize = Utils.sum(RegtreeFanova.pascalTriangleSlice(numvars, degree));
        HashMap<String, Object> map = new HashMap<String, Object>(mapsize);
        map.put("degree", degree);
        double f0 = 0.0;
        int i = 0;
        while (i < leafInfo.length) {
            double ypred = leafInfo[i][0];
            f0 += Utils.prod(leafInfo[i], 1, leafInfo[i].length) * ypred;
            ++i;
        }
        map.put(RegtreeFanova.stateToString(numvars, new int[0]), f0);
        int[] state = new int[degree];
        int i2 = 0;
        while (i2 < degree) {
            state[i2] = i2;
            ++i2;
        }
        do {
            RegtreeFanova.calcFValue(tree, allvars, state, map);
        } while (RegtreeFanova.incrState(state, degree - 1, numvars));
        return map;
    }

    private static void calcFValue(Regtree tree, double[][] allvars, int[] state, Map<String, Object> map) {
        int numvars = allvars.length;
        String stateString = RegtreeFanova.stateToString(numvars, state);
        if (map.containsKey(stateString)) {
            return;
        }
        double[] ypreds = Regtree.getMarginal(tree, allvars, state);
        double f0 = (Double)map.get(RegtreeFanova.stateToString(numvars, new int[0]));
    }

    public static Map<String, Object> fvals_to_a(Map<String, Object> fvals, int numvars) {
        return null;
    }

    public static String stateToString(int numvars, int[] state) {
        StringBuilder sb = new StringBuilder(numvars);
        int i = 0;
        while (i < numvars) {
            sb.append('0');
            ++i;
        }
        i = 0;
        while (i < state.length) {
            sb.setCharAt(state[i], '1');
            ++i;
        }
        return sb.toString();
    }

    private static boolean incrState(int[] state, int position, int maxVal) {
        boolean retn = true;
        int n = position;
        state[n] = state[n] + 1;
        while (state[position] >= maxVal) {
            if (position == 0) {
                return false;
            }
            retn = RegtreeFanova.incrState(state, position - 1, maxVal);
            state[position] = state[position - 1] + 1;
        }
        return retn;
    }

    public static double getTotalVariance(Regtree tree, double[][] allvars) {
        double[][] leafInfo = RegtreeFanova.getLeafInfoForANOVA(tree, allvars);
        double f0 = 0.0;
        int i = 0;
        while (i < leafInfo.length) {
            double ypred = leafInfo[i][0];
            f0 += Utils.prod(leafInfo[i], 1, leafInfo[i].length) * ypred;
            ++i;
        }
        double total_variance = 0.0;
        int i2 = 0;
        while (i2 < leafInfo.length) {
            double ypred = leafInfo[i2][0];
            total_variance += Utils.prod(leafInfo[i2], 1, leafInfo[i2].length) * (ypred - f0) * (ypred - f0);
            ++i2;
        }
        return total_variance;
    }

    public static double getExplainedVarianceAtdegree(int degree, Map<String, Object> fvals) {
        if ((double)degree > (Double)fvals.get("degree")) {
            throw new RuntimeException("Can only calculate variance up to degree " + (Double)fvals.get("degree"));
        }
        return 0.0;
    }

    public static double getExplainedVarianceUpTodegree(int degree, Map<String, Object> fvals) {
        double retn = 0.0;
        int i = 0;
        while (i < degree) {
            retn += RegtreeFanova.getExplainedVarianceAtdegree(i, fvals);
            ++i;
        }
        return retn;
    }

    public static double[][] getLeafInfoForANOVA(Regtree tree, double[][] allvars) {
        if (allvars == null) {
            return new double[0][];
        }
        if (allvars.length != tree.npred) {
            throw new RuntimeException("allvars.length must be equal to numvars.");
        }
        int logModel = tree.logModel;
        int[] leafNodeIdx = new int[tree.numNodes];
        int numleaves = 0;
        int i = 0;
        while (i < tree.numNodes) {
            if (tree.var[i] == 0) {
                leafNodeIdx[i] = numleaves++;
            }
            ++i;
        }
        double[][] retn = new double[numleaves][allvars.length + 1];
        int counter = 0;
        int i2 = 0;
        while (i2 < tree.numNodes) {
            if (tree.var[i2] == 0) {
                retn[counter++][0] = logModel == 1 ? Math.pow(10.0, tree.nodepred[i2]) : tree.nodepred[i2];
            }
            ++i2;
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        int i3 = 0;
        while (i3 < allvars.length) {
            int nextvar = i3 + 1;
            int numValues = allvars[i3].length;
            counter = 0;
            int j = 0;
            while (j < numValues) {
                queue.add(0);
                block4: while (!queue.isEmpty()) {
                    int thisnode = (Integer)queue.poll();
                    while (true) {
                        int splitvar = tree.var[thisnode];
                        double cutoff = tree.cut[thisnode];
                        int left_kid = tree.children[thisnode][0];
                        int right_kid = tree.children[thisnode][1];
                        if (splitvar == 0) {
                            int leaf = leafNodeIdx[thisnode];
                            double[] dArray = retn[leaf];
                            int n = nextvar;
                            dArray[n] = dArray[n] + 1.0;
                            continue block4;
                        }
                        if (Math.abs(splitvar) != nextvar) {
                            queue.add(right_kid);
                            thisnode = left_kid;
                            continue;
                        }
                        if (splitvar > 0) {
                            thisnode = allvars[i3][j] <= cutoff ? left_kid : right_kid;
                            continue;
                        }
                        int x = (int)allvars[i3][j];
                        int split = tree.catsplit[(int)cutoff][x - 1];
                        if (split == 0) {
                            thisnode = left_kid;
                            continue;
                        }
                        if (split != 1) break;
                        thisnode = right_kid;
                    }
                    throw new RuntimeException("Missing value -- not allowed in this implementation.");
                }
                ++j;
            }
            j = 0;
            while (j < numleaves) {
                double[] dArray = retn[j];
                int n = nextvar;
                dArray[n] = dArray[n] / (double)numValues;
                ++j;
            }
            ++i3;
        }
        return retn;
    }

    public static int[] pascalTriangleSlice(int N, int k) {
        int[] b = new int[N + 1];
        b[0] = 1;
        int i = 1;
        while (i <= N) {
            b[i] = 1;
            int j = i - 1;
            while (j > 0) {
                int n = j;
                b[n] = b[n] + b[j - 1];
                --j;
            }
            ++i;
        }
        int[] retn = new int[k];
        int i2 = 0;
        while (i2 < k) {
            retn[i2] = b[i2];
            ++i2;
        }
        return retn;
    }
}

