/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures.service.request;

import com.mathworks.toolbox.javabuilder.logging.MWLogger;
import com.mathworks.toolbox.javabuilder.services.ServiceException;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerAction;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerActionDispatcher;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerContext;
import com.mathworks.toolbox.javabuilder.webfigures.WebFigure;
import com.mathworks.toolbox.javabuilder.webfigures.service.WebFigurePeer;
import com.mathworks.toolbox.javabuilder.webfigures.service.request.NamedWebFigureServiceRequest;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureBinaryResourceResult;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebFigureRenderRequest
extends NamedWebFigureServiceRequest<WebFigureBinaryResourceResult> {
    private static final double MAX_PIXELS = 6.7108864E7;
    private static final Logger LOGGER = MWLogger.getLogger(WebFigure.class.getPackage().getName());
    private String width = null;
    private String height = null;
    private String imageFormat = "png";
    private String rotation = null;
    private String elevation = null;
    private String cropLeft = null;
    private String cropRight = null;
    private String cropTop = null;
    private String cropBottom = null;

    public WebFigureRenderRequest() {
    }

    private static boolean stringsEqual(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
    }

    private static int hashStrings(String ... stringArray) {
        int n = 0;
        for (String string : stringArray) {
            n = 31 * n + (string == null ? 0 : string.hashCode());
        }
        return n;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + WebFigureRenderRequest.hashStrings(this.width, this.height, this.imageFormat, this.rotation, this.elevation, this.cropLeft, this.cropRight, this.cropTop, this.cropBottom);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof WebFigureRenderRequest) {
            WebFigureRenderRequest webFigureRenderRequest = (WebFigureRenderRequest)object;
            return WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.width, this.width) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.height, this.height) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.imageFormat, this.imageFormat) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.rotation, this.rotation) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.elevation, this.elevation) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.cropLeft, this.cropLeft) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.cropRight, this.cropRight) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.cropTop, this.cropTop) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.cropBottom, this.cropBottom);
        }
        return false;
    }

    public WebFigureRenderRequest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        super(string, string2);
        this.width = string3;
        this.height = string4;
        this.imageFormat = string5;
        this.cropLeft = string8;
        this.cropRight = string9;
        this.cropTop = string10;
        this.cropBottom = string11;
        this.rotation = string6;
        this.elevation = string7;
    }

    private Map<String, Object> getParamsMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        WebFigureRenderRequest.addDoubleParameter(hashMap, "rotation", this.getRotation());
        WebFigureRenderRequest.addDoubleParameter(hashMap, "elevation", this.getElevation());
        WebFigureRenderRequest.addDoubleParameter(hashMap, "width", this.getWidth());
        WebFigureRenderRequest.addDoubleParameter(hashMap, "height", this.getHeight());
        WebFigureRenderRequest.addStringParameter(hashMap, "imageFormat", this.getImageFormat());
        WebFigureRenderRequest.addDoubleParameter(hashMap, "cropLeft", this.getCropLeft());
        WebFigureRenderRequest.addDoubleParameter(hashMap, "cropRight", this.getCropRight());
        WebFigureRenderRequest.addDoubleParameter(hashMap, "cropTop", this.getCropTop());
        WebFigureRenderRequest.addDoubleParameter(hashMap, "cropBottom", this.getCropBottom());
        return hashMap;
    }

    @Override
    public String toString() {
        return super.toString() + " render: " + this.getParamsMap().toString();
    }

    @Override
    public WebFigureBinaryResourceResult process(StateManagerContext stateManagerContext, StatefulServicePeerActionDispatcher<WebFigurePeer> statefulServicePeerActionDispatcher) throws ServiceException {
        final Map<String, Object> map = this.getParamsMap();
        if (map.get("width") != null && (Double)map.get("width") == 0.0) {
            throw new ServiceException("width must not be 0");
        }
        if (map.get("height") != null && (Double)map.get("height") == 0.0) {
            throw new ServiceException("height must not be 0");
        }
        if (null != map.get("width") && null != map.get("height")) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = (Double)map.get("width");
            double d6 = (Double)map.get("height");
            double d7 = d5;
            double d8 = d6;
            if (null != map.get("cropLeft")) {
                d4 = (Double)map.get("cropLeft");
                d7 -= d4;
            } else {
                d4 = 0.0;
            }
            if (null != map.get("cropRight")) {
                d3 = (Double)map.get("cropRight");
                d7 -= d3;
            } else {
                d3 = 0.0;
            }
            if (null != map.get("cropTop")) {
                d2 = (Double)map.get("cropTop");
                d8 -= d2;
            } else {
                d2 = 0.0;
            }
            if (null != map.get("cropBottom")) {
                d = (Double)map.get("cropBottom");
                d8 -= d;
            } else {
                d = 0.0;
            }
            if (d7 * d8 > 6.7108864E7) {
                LOGGER.warning("Clipping to maximum resolution (requested image " + d7 + "," + d8 + ")");
                double d9 = Math.sqrt(6.7108864E7 * d7 / d8);
                double d10 = 6.7108864E7 / d9;
                map.put("width", d5 * d9 / d7);
                map.put("cropLeft", d4 * d9 / d7);
                map.put("cropRight", d3 * d9 / d7);
                map.put("height", d6 * d10 / d8);
                map.put("cropTop", d2 * d10 / d8);
                map.put("cropBottom", d * d10 / d8);
            }
        }
        try {
            byte[] byArray = statefulServicePeerActionDispatcher.dispatch(new StatefulServicePeerAction<WebFigurePeer, byte[]>(){

                @Override
                public byte[] execute(WebFigurePeer webFigurePeer) throws Throwable {
                    return webFigurePeer.render(map);
                }
            }, stateManagerContext, this.getScope(), this.getName());
            String string = "image/" + this.getImageFormat();
            return new WebFigureBinaryResourceResult(byArray, string);
        }
        catch (Throwable throwable) {
            throw new ServiceException(throwable);
        }
    }

    private static void addStringParameter(Map<String, Object> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    private static void addDoubleParameter(Map<String, Object> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, Double.parseDouble(string2));
        }
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String string) {
        this.height = string;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String string) {
        this.imageFormat = string;
    }

    public String getCropLeft() {
        return this.cropLeft;
    }

    public void setCropLeft(String string) {
        this.cropLeft = string;
    }

    public String getCropRight() {
        return this.cropRight;
    }

    public void setCropRight(String string) {
        this.cropRight = string;
    }

    public String getCropTop() {
        return this.cropTop;
    }

    public void setCropTop(String string) {
        this.cropTop = string;
    }

    public String getCropBottom() {
        return this.cropBottom;
    }

    public void setCropBottom(String string) {
        this.cropBottom = string;
    }

    public String getRotation() {
        return this.rotation;
    }

    public void setRotation(String string) {
        this.rotation = string;
    }

    public String getElevation() {
        return this.elevation;
    }

    public void setElevation(String string) {
        this.elevation = string;
    }
}

