/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.web.util;

import java.util.HashMap;
import java.util.Map;

public class ContentType {
    private static final Map<String, ContentType> EXTENSION_TO_CONTENT_TYPE = new HashMap<String, ContentType>();
    private String fName;
    public static final ContentType JAVASCRIPT = new ContentType("application/javascript");
    public static final ContentType BMP = new ContentType("image/bmp");
    public static final ContentType GIF = new ContentType("image/gif");
    public static final ContentType JPEG = new ContentType("image/jpeg");
    public static final ContentType PNG = new ContentType("image/png");
    public static final ContentType HTML = new ContentType("text/html");
    public static final ContentType TEXT = new ContentType("text/plain");

    private ContentType(String string) {
        this.fName = string;
    }

    public String getName() {
        return this.fName;
    }

    public static ContentType fromExtension(String string) {
        if (null == string) {
            throw new IllegalArgumentException("resourceName is null");
        }
        if (string.lastIndexOf(".") == -1) {
            String string2 = "Content type could not be derived from the extension of the following resource :\n" + string + "\n";
            throw new IllegalArgumentException(string2);
        }
        return EXTENSION_TO_CONTENT_TYPE.get(string.substring(string.lastIndexOf(".")));
    }

    static {
        EXTENSION_TO_CONTENT_TYPE.put(".bmp", BMP);
        EXTENSION_TO_CONTENT_TYPE.put(".gif", GIF);
        EXTENSION_TO_CONTENT_TYPE.put(".htm", HTML);
        EXTENSION_TO_CONTENT_TYPE.put(".html", HTML);
        EXTENSION_TO_CONTENT_TYPE.put(".jpe", JPEG);
        EXTENSION_TO_CONTENT_TYPE.put(".jpeg", JPEG);
        EXTENSION_TO_CONTENT_TYPE.put(".jpg", JPEG);
        EXTENSION_TO_CONTENT_TYPE.put(".js", JAVASCRIPT);
        EXTENSION_TO_CONTENT_TYPE.put(".jsm", JAVASCRIPT);
        EXTENSION_TO_CONTENT_TYPE.put(".png", PNG);
        EXTENSION_TO_CONTENT_TYPE.put(".txt", TEXT);
    }
}

