/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.remoting.debug;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.toolbox.javabuilder.MWArray;
import com.mathworks.toolbox.javabuilder.internal.MWFunctionSignature;
import com.mathworks.toolbox.javabuilder.internal.MWMCR;
import com.mathworks.toolbox.javabuilder.internal.NativePtr;
import com.mathworks.toolbox.javabuilder.remoting.debug.MCRRemote;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.List;

public class MatlabMCRRemote
implements MCRRemote {
    private static PrintStream sOut = new PrintStream(new NullOutputStream());
    private boolean fRunning = false;
    private String fName = null;

    public static void setOutputStream(PrintStream printStream) {
        if (null == printStream) {
            sOut = new PrintStream(new NullOutputStream());
        } else {
            sOut.flush();
            sOut = printStream;
        }
    }

    public int getRegistryPort() {
        return MatlabRMIRegistry.getPort();
    }

    public boolean export(String string) {
        try {
            sOut.println("Exporting object and binding to the registry");
            Remote remote = UnicastRemoteObject.exportObject((Remote)this, 0);
            try {
                MatlabRMIRegistry.getInstance().rebind(string, remote);
                sOut.println("Export succeeded");
                this.fName = string;
                return true;
            }
            catch (Exception exception) {
                UnicastRemoteObject.unexportObject(this, true);
                sOut.println("Could not create or access the registry");
                return false;
            }
        }
        catch (RemoteException remoteException) {
            sOut.println("Export failed");
            remoteException.printStackTrace(sOut);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unexport() {
        try {
            if (null != this.fName) {
                MatlabRMIRegistry.getInstance().unbind(this.fName);
                this.fName = null;
            }
        }
        catch (NotBoundException notBoundException) {
            sOut.println("Error unbinding object: not bound");
            boolean bl = false;
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            sOut.println("Could not create or access the registry");
            boolean bl = false;
            return bl;
        }
        catch (RemoteException remoteException) {
            sOut.println("Error unbinding object");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (RemoteException remoteException) {
                sOut.println("Error unexporting object");
                return false;
            }
        }
        return true;
    }

    public synchronized void run() throws InterruptedException {
        this.fRunning = true;
        while (this.fRunning) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws RemoteException {
        MatlabMCRRemote matlabMCRRemote = this;
        synchronized (matlabMCRRemote) {
            this.fRunning = false;
            this.notifyAll();
        }
    }

    public void invoke(MCRRemote.ResultSink resultSink, List list, MWFunctionSignature mWFunctionSignature) throws RemoteException {
        InvokeWorker invokeWorker = new InvokeWorker(mWFunctionSignature.name, list, resultSink);
        if (NativeMatlab.nativeIsMatlabThread()) {
            invokeWorker.run();
        } else {
            Matlab.whenMatlabIdle((Runnable)invokeWorker);
        }
        try {
            invokeWorker.waitForResult();
        }
        catch (InterruptedException interruptedException) {
            throw new RemoteException("The MATLAB function invocation was interrupted before completion");
        }
        if (invokeWorker.getException() != null) {
            throw new RemoteException(invokeWorker.getException().getMessage());
        }
    }

    private static class InvokeWorker
    implements Runnable {
        private String iFunction;
        private List iInputs;
        private MCRRemote.ResultSink iResultSink;
        private Exception iException = null;
        private boolean iDone = false;

        public InvokeWorker(String string, List list, MCRRemote.ResultSink resultSink) {
            this.iFunction = string;
            this.iInputs = list;
            this.iResultSink = resultSink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = new Object[this.iResultSink.getNargout()];
                MWMCR.getNativeMCR().mclFeval(NativePtr.NULL, this.iFunction, ((Object[])object).length, Arrays.asList(object).listIterator(), this.iInputs.size(), this.iInputs.listIterator());
                try {
                    this.iResultSink.put(Arrays.asList(object));
                }
                finally {
                    MWArray.disposeArray(object);
                }
            }
            catch (Exception exception) {
                this.iException = new RemoteException(exception.getMessage());
            }
            finally {
                InvokeWorker invokeWorker = this;
                synchronized (invokeWorker) {
                    this.iDone = true;
                    this.notifyAll();
                }
            }
        }

        public Exception getException() {
            return this.iException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForResult() throws InterruptedException {
            InvokeWorker invokeWorker = this;
            synchronized (invokeWorker) {
                while (!this.iDone) {
                    this.wait();
                }
            }
        }
    }

    private static class MatlabRMIRegistry {
        private static final int DEFAULT_REGISTRY_PORT = 5543;
        private static final int MAX_REGISTRY_PORTS = 100;
        private static int sPort = 5543;
        private static Registry sRegistry = null;
        private static String sHostName = null;

        private MatlabRMIRegistry() {
        }

        public static synchronized Registry getInstance() {
            if (null == sRegistry) {
                for (sPort = 5543; sPort < 5643; ++sPort) {
                    try {
                        sOut.println("Attempting to create registry on port " + sPort);
                        sRegistry = LocateRegistry.createRegistry(sPort);
                        if (null == sRegistry) continue;
                        return sRegistry;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                sOut.println("Creation failed - no available port could be found.");
                return null;
            }
            return sRegistry;
        }

        public static synchronized int getPort() {
            return sPort;
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int n) {
        }
    }
}

