/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.remoting;

import com.mathworks.toolbox.javabuilder.MWArray;
import com.mathworks.toolbox.javabuilder.MWCellArray;
import com.mathworks.toolbox.javabuilder.MWJavaObjectRef;
import com.mathworks.toolbox.javabuilder.MWStructArray;
import com.mathworks.toolbox.javabuilder.pooling.Poolable;
import com.mathworks.toolbox.javabuilder.remoting.AbstractMWArrayVisitor;
import com.mathworks.toolbox.javabuilder.remoting.DisposeListener;
import com.mathworks.toolbox.javabuilder.remoting.NativeArrayContainer;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteProxy {
    private static final int DEFAULT_GRACE_TIMEOUT = 5;
    private static final TimeUnit DEFAULT_GRACE_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static ScheduledThreadPoolExecutor sThreadPool = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });

    private RemoteProxy() {
        throw new AssertionError((Object)"com.mathworks.toolbox.javabuilder.RemoteProxy should never be instantiated directly!");
    }

    public static <T extends Remote> T newProxyFor(Object object, Class<T> clazz, boolean bl) throws RemoteException {
        return RemoteProxy.newProxyFor(object, clazz, bl, null);
    }

    public static <T extends Remote> T newProxyFor(Object object, Class<T> clazz, boolean bl, DisposeListener disposeListener) throws RemoteException {
        return RemoteProxy.newProxyFor(object, clazz, bl, disposeListener, 5, DEFAULT_GRACE_TIMEOUT_UNIT);
    }

    public static <T extends Remote> T newProxyFor(Object object, Class<T> clazz, boolean bl, DisposeListener disposeListener, int n, TimeUnit timeUnit) throws RemoteException {
        Method method = null;
        try {
            method = clazz.getMethod("dispose", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("remoteInterface.dispose method not found!  remoteInterface MUST have a dispose method.");
        }
        ProxyInvocationHandler proxyInvocationHandler = new ProxyInvocationHandler(object, bl, disposeListener, method);
        final Remote remote = (Remote)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)proxyInvocationHandler);
        if (n > 0) {
            sThreadPool.schedule(new Runnable(){
                private Remote iProxy;
                {
                    this.iProxy = remote;
                }

                public void run() {
                    if (null != this.iProxy) {
                        this.iProxy = null;
                    }
                }
            }, (long)n, timeUnit);
        }
        Remote remote2 = UnicastRemoteObject.exportObject(remote, 0);
        return (T)((Remote)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new StrongReferenceInvocationHandler(remote, remote2)));
    }

    private static class ProxyInvocationHandler
    implements InvocationHandler {
        private Object iImpl;
        private DisposeListener iListener = null;
        private boolean iMarshalOutputs = false;
        private Method iDisposeMethod = null;
        private Method iLastProxyMethod = null;
        private Method iLastImplMethod = null;
        private Method iPoolableAliveMethod = null;

        public ProxyInvocationHandler(Object object, boolean bl, DisposeListener disposeListener, Method method) {
            this.iImpl = object;
            this.iMarshalOutputs = bl;
            this.iListener = disposeListener;
            this.iDisposeMethod = method;
            try {
                this.iPoolableAliveMethod = Poolable.class.getMethod("alive", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        private static Object marshalMWArrayToObject(Object object) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof MWArray)) continue;
                    objectArray[i] = ProxyInvocationHandler.marshalMWArrayToObject(objectArray[i]);
                }
                return objectArray;
            }
            if (object instanceof MWArray) {
                object = ((MWArray)object).applyVisitor(new AbstractMWArrayVisitor<Object>(){

                    @Override
                    public Object visit(MWStructArray mWStructArray) {
                        String[] stringArray = mWStructArray.fieldNames();
                        int[] nArray = mWStructArray.getDimensions();
                        com.mathworks.extern.java.MWStructArray mWStructArray2 = new com.mathworks.extern.java.MWStructArray(nArray, stringArray);
                        int n = mWStructArray.numberOfFields() * mWStructArray.numberOfElements();
                        for (int i = 1; i <= n; ++i) {
                            mWStructArray2.set(i, ProxyInvocationHandler.marshalMWArrayToObject(mWStructArray.getField(i)));
                        }
                        return mWStructArray2;
                    }

                    @Override
                    public Object visit(MWCellArray mWCellArray) {
                        com.mathworks.extern.java.MWCellArray mWCellArray2 = new com.mathworks.extern.java.MWCellArray(mWCellArray.getDimensions());
                        for (int i = 1; i <= mWCellArray.numberOfElements(); ++i) {
                            mWCellArray2.set(i, ProxyInvocationHandler.marshalMWArrayToObject(mWCellArray.getCell(i)));
                        }
                        return mWCellArray2;
                    }

                    @Override
                    public Object visit(MWJavaObjectRef mWJavaObjectRef) {
                        return mWJavaObjectRef.get();
                    }

                    @Override
                    public Object defaultVisit(MWArray mWArray) {
                        return mWArray.toArray();
                    }
                });
                return object;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                Object object2;
                block15: {
                    if (null != this.iDisposeMethod && this.iDisposeMethod.equals(method)) {
                        if (null != this.iListener) {
                            this.iListener.notifyDisposed((Remote)object);
                        }
                    } else if (this.iPoolableAliveMethod.equals(method)) {
                        Boolean bl = true;
                        return bl;
                    }
                    if (null == this.iLastProxyMethod || !this.iLastProxyMethod.equals(method)) {
                        this.iLastProxyMethod = method;
                        this.iLastImplMethod = this.iImpl.getClass().getMethod(method.getName(), method.getParameterTypes());
                    }
                    object2 = this.iLastImplMethod.invoke(this.iImpl, objectArray);
                    if (this.iMarshalOutputs) {
                        object2 = ProxyInvocationHandler.marshalMWArrayToObject(object2);
                    }
                    if (null != this.iDisposeMethod && this.iDisposeMethod.equals(method)) {
                        try {
                            UnicastRemoteObject.unexportObject((Remote)object, true);
                        }
                        catch (NoSuchObjectException noSuchObjectException) {
                            if (!"VERBOSE".equals(System.getProperty("mathworks.javabuilder.remoting.debugLevel"))) break block15;
                            noSuchObjectException.printStackTrace();
                        }
                    }
                }
                if (method.getReturnType().equals(Object[].class)) {
                    Object[] objectArray2 = new Object[]{new NativeArrayContainer(object2)};
                    return objectArray2;
                }
                Object object3 = object2;
                return object3;
            }
            finally {
                MWArray.disposeArray(objectArray);
            }
        }
    }

    private static class StrongReferenceInvocationHandler
    implements InvocationHandler,
    Serializable {
        private transient Remote iRemoteProxy = null;
        private Remote iStub;
        static final long serialVersionUID = -699737191887982174L;

        public StrongReferenceInvocationHandler(Remote remote, Remote remote2) {
            this.iRemoteProxy = remote;
            this.iStub = remote2;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2 = method.invoke((Object)this.iStub, objectArray);
            if (object2 instanceof Object[] && ((Object[])object2).length > 0 && ((Object[])object2)[0] instanceof NativeArrayContainer) {
                return ((NativeArrayContainer)((Object[])object2)[0]).get();
            }
            return object2;
        }
    }
}

