/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.internal;

import com.mathworks.toolbox.javabuilder.internal.MCRConfiguration;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicLibraryUtils {
    private DynamicLibraryUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LibraryHandle loadLibraryAndBindNativeMethods(File file, Class<?> clazz) {
        boolean bl = false;
        File file2 = new File(file.getParent(), System.mapLibraryName("mwfl"));
        File file3 = new File(file.getParent(), System.mapLibraryName("libmwfl"));
        File file4 = file2.exists() ? file2 : (file3.exists() ? file3 : null);
        long l = null == file4 ? 0L : DynamicLibraryUtils.dlopen(file4.toString(), true);
        try {
            LibraryHandle libraryHandle;
            block15: {
                long l2 = DynamicLibraryUtils.dlopen(file.toString(), true);
                try {
                    LibraryHandle libraryHandle2;
                    HashSet<String> hashSet = new HashSet<String>();
                    HashSet<String> hashSet2 = new HashSet<String>();
                    ArrayList<Method> arrayList = new ArrayList<Method>();
                    for (Method object2 : clazz.getDeclaredMethods()) {
                        if ((object2.getModifiers() & 0x100) != 256) continue;
                        arrayList.add(object2);
                        if (hashSet.contains(object2.getName())) {
                            hashSet2.add(object2.getName());
                            continue;
                        }
                        hashSet.add(object2.getName());
                    }
                    int n = arrayList.size();
                    String[] stringArray = new String[n];
                    String[] stringArray2 = new String[n];
                    long[] lArray = new long[n];
                    int l3 = 0;
                    for (Method method : arrayList) {
                        stringArray[l3] = method.getName();
                        stringArray2[l3] = DynamicLibraryUtils.getMethodSignature(method);
                        boolean bl2 = (method.getModifiers() & 8) == 8;
                        String string = DynamicLibraryUtils.nativeMethodPrefix(stringArray2[l3], bl2);
                        String string2 = DynamicLibraryUtils.nativeMethodSuffix(stringArray2[l3], bl2);
                        String string3 = string + DynamicLibraryUtils.getNativeSymbolName(method, hashSet2) + string2;
                        lArray[l3] = DynamicLibraryUtils.dlsym(l2, string3);
                        ++l3;
                    }
                    DynamicLibraryUtils.bindNativeMethods(clazz, stringArray, stringArray2, lArray);
                    try {
                        long unsatisfiedLinkError = DynamicLibraryUtils.dlsym(l2, "JNI_" + clazz.getName().replace(".", "_") + "_OnLoad");
                        DynamicLibraryUtils.callOnLoadHandler(unsatisfiedLinkError);
                    }
                    catch (UnsatisfiedLinkError libraryHandle22) {
                        // empty catch block
                    }
                    try {
                        long unsatisfiedLinkError = DynamicLibraryUtils.dlsym(l2, "JNI_" + clazz.getName().replace(".", "_") + "_OnUnload");
                        libraryHandle2 = new LibraryHandle(l2, unsatisfiedLinkError);
                    }
                    catch (UnsatisfiedLinkError libraryHandle3) {
                        libraryHandle2 = new LibraryHandle(l2);
                    }
                    bl = true;
                    libraryHandle = libraryHandle2;
                    if (bl) break block15;
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        DynamicLibraryUtils.dlclose(l2);
                    }
                    throw throwable;
                }
                DynamicLibraryUtils.dlclose(l2);
            }
            return libraryHandle;
        }
        finally {
            if (null != file4) {
                DynamicLibraryUtils.dlclose(l);
            }
        }
    }

    private static String getNativeSymbolName(Method method, Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder("Java_");
        stringBuilder.append(DynamicLibraryUtils.mangle(method.getDeclaringClass().getName().replace(".", "/")));
        stringBuilder.append('_');
        stringBuilder.append(DynamicLibraryUtils.mangle(method.getName()));
        if (set.contains(method.getName())) {
            stringBuilder.append("__");
            stringBuilder.append(DynamicLibraryUtils.mangle(DynamicLibraryUtils.getArgumentSignature(method.getParameterTypes())));
        }
        return stringBuilder.toString();
    }

    private static String mangle(String string) {
        string = string.replace("_", "_1").replace(";", "_2").replace("[", "_3").replace("/", "_");
        Matcher matcher = Pattern.compile("[^\\p{ASCII}]").matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (matcher.find()) {
            stringBuilder.append(string.substring(n, matcher.toMatchResult().start() - n));
            stringBuilder.append(String.format("_0%1$4x", string.charAt(matcher.toMatchResult().start())));
            n = matcher.toMatchResult().start() + 1;
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private static String getArgumentSignature(Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> clazz : classArray) {
            stringBuilder.append(DynamicLibraryUtils.getTypeSignature(clazz, false));
        }
        return stringBuilder.toString();
    }

    private static String getTypeSignature(Class<?> clazz, boolean bl) {
        if (null == clazz || Void.TYPE.equals(clazz)) {
            return bl ? "V" : "";
        }
        return Array.newInstance(clazz, 0).getClass().getName().substring(1).replace(".", "/");
    }

    private static String getMethodSignature(Method method) {
        return "(" + DynamicLibraryUtils.getArgumentSignature(method.getParameterTypes()) + ")" + DynamicLibraryUtils.getTypeSignature(method.getReturnType(), true);
    }

    private static native long dlopen(String var0, boolean var1);

    private static native long dlsym(long var0, String var2);

    private static native void dlclose(long var0);

    private static native void bindNativeMethods(Class<?> var0, String[] var1, String[] var2, long[] var3);

    private static native int callOnLoadHandler(long var0);

    private static native void callOnUnloadHandler(long var0);

    private static native String nativeMethodPrefix(String var0, boolean var1);

    private static native String nativeMethodSuffix(String var0, boolean var1);

    static {
        File file = new File(MCRConfiguration.getModuleDir(), System.mapLibraryName("nativedl"));
        System.load(file.toString());
    }

    public static class LibraryHandle {
        private final long handle;
        private final boolean hasUnloadHandler;
        private final long onUnloadFcnPtr;

        LibraryHandle(long l) {
            this.handle = l;
            this.hasUnloadHandler = false;
            this.onUnloadFcnPtr = 0L;
        }

        LibraryHandle(long l, long l2) {
            this.handle = l;
            this.hasUnloadHandler = true;
            this.onUnloadFcnPtr = l2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LibraryHandle libraryHandle = (LibraryHandle)object;
            return this.handle == libraryHandle.handle;
        }

        public int hashCode() {
            return (int)(this.handle ^ this.handle >>> 32);
        }

        public void close() {
            if (this.hasUnloadHandler) {
                DynamicLibraryUtils.callOnUnloadHandler(this.onUnloadFcnPtr);
            }
            DynamicLibraryUtils.dlclose(this.handle);
        }
    }
}

