/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder;

import com.mathworks.toolbox.javabuilder.Disposable;
import com.mathworks.toolbox.javabuilder.MWClassID;
import com.mathworks.toolbox.javabuilder.remoting.AbstractMWArrayVisitor;
import java.io.ObjectStreamException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MWArray
implements Cloneable,
Comparable,
Serializable,
Disposable {
    public static final MWArray EMPTY_ARRAY = new EmptyArray();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public abstract Object sharedCopy();

    public abstract MWClassID classID();

    public abstract int numberOfDimensions();

    public abstract int[] getDimensions();

    public abstract boolean isEmpty();

    public abstract boolean isSparse();

    public abstract boolean equals(Object var1);

    public abstract int compareTo(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public abstract int numberOfElements();

    public abstract int numberOfNonZeros();

    public abstract int maximumNonZeros();

    @Override
    public abstract void dispose();

    public abstract Object get(int var1);

    public abstract Object get(int[] var1);

    public abstract void set(int var1, Object var2);

    public abstract void set(int[] var1, Object var2);

    public abstract Object[] toArray();

    public abstract Object getData();

    public abstract void setData(Object var1);

    public abstract int[] rowIndex();

    public abstract int[] columnIndex();

    public abstract <T> T applyVisitor(AbstractMWArrayVisitor<T> var1);

    public static void disposeArray(Object object) {
        block4: {
            block5: {
                Object[] objectArray;
                block3: {
                    if (object == null) {
                        return;
                    }
                    if (!(object instanceof Disposable)) break block3;
                    ((Disposable)object).dispose();
                    break block4;
                }
                if (!(object instanceof Object[])) break block5;
                for (Object object2 : objectArray = (Object[])object) {
                    MWArray.disposeArray(object2);
                }
                break block4;
            }
            if (!(object instanceof Iterable)) break block4;
            Iterable iterable = (Iterable)object;
            for (Object t : iterable) {
                MWArray.disposeArray(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyArray
    extends MWArray {
        private EmptyArray() {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return this;
        }

        @Override
        public Object sharedCopy() {
            return this;
        }

        @Override
        public MWClassID classID() {
            return MWClassID.UNKNOWN;
        }

        @Override
        public int numberOfDimensions() {
            return 2;
        }

        @Override
        public int[] getDimensions() {
            return new int[]{0, 0};
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isSparse() {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            return null != object && object instanceof MWArray && ((MWArray)object).isEmpty() && this.classID() == ((MWArray)object).classID();
        }

        @Override
        public int compareTo(Object object) {
            return this.equals(object) ? 0 : -1;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public int numberOfElements() {
            return 0;
        }

        @Override
        public int numberOfNonZeros() {
            return 0;
        }

        @Override
        public int maximumNonZeros() {
            return 0;
        }

        @Override
        public void dispose() {
        }

        @Override
        public Object get(int n) {
            return null;
        }

        @Override
        public Object get(int[] nArray) {
            return null;
        }

        @Override
        public void set(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int[] nArray, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public Object getData() {
            return null;
        }

        @Override
        public void setData(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int[] rowIndex() {
            return new int[0];
        }

        @Override
        public int[] columnIndex() {
            return new int[0];
        }

        protected Object readResolve() throws ObjectStreamException {
            return EMPTY_ARRAY;
        }

        @Override
        public <T> T applyVisitor(AbstractMWArrayVisitor<T> abstractMWArrayVisitor) {
            throw new UnsupportedOperationException();
        }
    }
}

