/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder;

import com.mathworks.toolbox.javabuilder.MWMCROption;
import com.mathworks.toolbox.javabuilder.internal.MWMCR;
import com.mathworks.toolbox.javabuilder.internal.PlatformInfo;
import java.io.PrintStream;
import java.util.Vector;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWApplication {
    private static volatile Callable<PrintStream> defaultOutStream = new Callable<PrintStream>(){

        @Override
        public PrintStream call() {
            return System.out;
        }
    };
    private static volatile Callable<PrintStream> defaultErrStream = new Callable<PrintStream>(){

        @Override
        public PrintStream call() {
            return System.err;
        }
    };

    public static void initializeApplication(MWMCROption ... mWMCROptionArray) {
        if (MWApplication.isMCRInitialized()) {
            String string = "MWApplication.initializeApplication should be called before initializing a component.\n";
            string = string + "MCR is already initialized with following options:\n";
            string = string + "JVM enabled : ";
            string = string + MWApplication.isMCRJVMEnabled();
            string = string + "\nLogfile name : ";
            string = string + "\"";
            string = string + MWApplication.getMCRLogfileName();
            string = string + "\"\n";
            if (!PlatformInfo.isWindows()) {
                string = string + "nodisplay set : ";
                string = string + MWApplication.isMCRNoDisplaySet();
                string = string + "\n";
            }
            throw new RuntimeException(string);
        }
        Vector<String> vector = new Vector<String>();
        for (MWMCROption mWMCROption : mWMCROptionArray) {
            String[] stringArray = mWMCROption.toStringArray();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        Object[] objectArray = vector.toArray(new String[vector.size()]);
        if (!MWMCR.getNativeMCR().mclInitializeApplication((String[])objectArray)) {
            throw new RuntimeException("Application initialization failed.");
        }
    }

    public static boolean isMCRInitialized() {
        return MWMCR.getNativeMCR().mclIsMCRInitialized();
    }

    public static boolean isMCRJVMEnabled() {
        return MWMCR.getNativeMCR().mclIsJVMEnabled();
    }

    public static boolean isMCRNoDisplaySet() {
        return MWMCR.getNativeMCR().mclIsNoDisplaySet();
    }

    public static String getMCRLogfileName() {
        return MWMCR.getNativeMCR().mclGetLogFileName();
    }

    public static void setDefaultPrintStream(PrintStream printStream) {
        MWApplication.setDefaultPrintStreams(printStream, printStream);
    }

    public static void setDefaultPrintStreams(final PrintStream printStream, final PrintStream printStream2) {
        MWApplication.setDefaultPrintStreams(new Callable<PrintStream>(){

            @Override
            public PrintStream call() throws Exception {
                return printStream;
            }
        }, new Callable<PrintStream>(){

            @Override
            public PrintStream call() throws Exception {
                return printStream2;
            }
        });
    }

    public static void setDefaultPrintStreams(Callable<PrintStream> callable, Callable<PrintStream> callable2) {
        defaultOutStream = callable;
        defaultErrStream = callable2;
        MWMCR.getNativeMCR().mclSetDefaultPrintHandlers(callable, callable2);
    }

    public static Callable<PrintStream> getDefaultOutputStream() {
        return defaultOutStream;
    }

    public static Callable<PrintStream> getDefaultErrorStream() {
        return defaultErrStream;
    }
}

