function plot_Scaling_N(numTrains, data_avg, data_std, options_vec, dataname, model_names, domain, legendPos, y_log)
if nargin < 9
    y_log = 0;
    if nargin < 8
        legendPos = 'SouthEast';
    end
end

legend_entries = {};
hE = [];
figure
hold off
if y_log
    h = loglog(numTrains, data_avg(:,1));
else
    h = semilogx(numTrains, data_avg(:,1));
end
hold on
for i=1:length(model_names)
    model_names{i} = fix_modelname(model_names{i});
end

for model_idx=1:length(options_vec)
    %hE(end+1) = errorbar(numTrains*(1.03^(model_idx-1)), data_avg(:,model_idx), data_std(:,model_idx), 'r');
    hE(end+1) = plot(numTrains*(1.03^(model_idx-1)), data_avg(:,model_idx), 'r');
    legend_entries{end+1} = model_names(model_idx);
    hXLabel = xlabel('Number of training data points, n');
    hYLabel = ylabel(dataname);
end

mintime = min(numTrains)/1.3;
maxtime = max(numTrains)*1.3;

set(h, 'Color' , [1 1 1]);
set([hXLabel, hYLabel], 'FontSize', 22);

set(hE(1)                      , ...
  'LineStyle'       , '-'      , ...
  'LineWidth'       , 1           , ...
  'Color'           , 'k'  , ...
  'MarkerSize'      , 6           , ...
  'Marker'          , 'o'         , ...
  'MarkerFaceColor' , [.7 .7 .7]  , ...
  'MarkerEdgeColor' , 'k'); %[.4 .4 .4]

if length(hE) > 1
    set([hE(2)]                            , ...
        'Color'           , 'b'  , ...
        'Marker'          , 'x'         , ...
        'LineStyle'       , ':'      , ...
        'MarkerSize'      , 15, ...        
        'LineWidth'       , 2);

    if length(hE) > 2
        set([hE(3)]                            , ...
            'Color'           , 'r'  , ...
            'Marker'          , '+'         , ...
            'MarkerSize'      , 10, ...        
            'LineWidth'       , 2, ...
            'LineStyle', ':');
        
        if length(hE) > 3
            set([hE(4)]                            , ...
                'Color'           , 'g'  , ...
                'Marker'          , 'd'         , ...
                'LineStyle'       , '-'      , ...
                'MarkerSize'      , 9, ...        
                'LineWidth'       , 1);

%                    'Color'           , [.4 .4 .4]  , ...            
            if length(hE) > 4
                set([hE(5)]                            , ...
                    'Color'           , 'm'  , ...
                    'Marker'          , 's'         , ...
                    'LineStyle'       , '-'      , ...
                    'MarkerSize'      , 10, ...        
                    'LineWidth'       , 1);
            
                if length(hE) > 5
                    set([hE(6)]                            , ...
                        'Color'           , 'k'  , ...
                        'Marker'          , 'o'         , ...
                        'LineStyle'       , ':'      , ...
                        'MarkerSize'      , 10, ...        
                        'LineWidth'       , 1);

                    if length(hE) > 6
                        set([hE(7)]                            , ...
                            'Color'           , [.4 .4 .4]  , ...
                            'Marker'          , 'h'         , ...
                            'LineStyle'       , '-'      , ...
                            'MarkerSize'      , 10, ...        
                            'LineWidth'       , 2);
                    end
                end
            end            
        end
    end
end

numTrainsTick = numTrains;
if max(numTrains)>=100000
    numTrainsTick = [10,100,1000,10000,100000];
end
set(gca, ...
    'XTick'       , unique(numTrainsTick), ...
    'FontName'   , 'Helvetica' , ...
    'FontSize'   , 16);
%    'YTick'       , -1:0.1:1   , ...

max_data = max(max(data_avg+data_std + 0.03));
min_data = min(min(data_avg-data_std - 0.03));

%axis([mintime, maxtime, min_data, max_data])
% axis([mintime, maxtime, -0.2, 1.0001])
axis([mintime, maxtime, 0, 1.0001])

legend_str = legend_entries{1};
for i=2:length(legend_entries)
    legend_str = strcat([legend_str, legend_entries{i}]);
end
legend(hE, legend_str, 'location', legendPos);
% legend(hE, legend_str, 'location', 'SouthEast');
% legend(hE, legend_str, 'location', 'East');
% legend(hE, legend_str, 'location', legendPos);
dataname = regexprep(dataname, ' ', '_');
filename = strcat([domain, '_', dataname]);
pdf_filename = strcat(filename, '.pdf');
if exist(pdf_filename, 'file');
    delete(pdf_filename);
end
export_fig(pdf_filename);    
saveas(gca, strcat(filename, '.fig'), 'fig');