function options = get_spore_options
options.modelType = 'spore';
options.logModel = 1;
options.pca = 0; % do no PCA here
options.only_one_in_k_and_y_trans = 1;
options.error_metric = 'spore_default';

% Tuning parameters (original SPORE-Foba defaults)
threshold_def = 0.01;
delta_def = 0.001;
max_terms_def = 10;

options.paramsLowerBound = 0;
options.paramsUpperBound = 1;

options.threshold_max = 1;
options.threshold_min = 1e-6;
options.delta_min = 1e-6;
options.delta_max = 1;
options.max_terms_min = 1;
options.max_terms_max = 64;

threshold = (log(threshold_def)-log(options.threshold_min)) / (log(options.threshold_max)-log(options.threshold_min));
delta = (log(delta_def)-log(options.delta_min)) / (log(options.delta_max)-log(options.delta_min)); 
max_terms = (log(max_terms_def)-log(options.max_terms_min)) / (log(options.max_terms_max)-log(options.max_terms_min)); 

options.tuning_params = [threshold, delta, max_terms];
options.unique_model_name = 'SPORE-Foba';

options.opt = 0;
