function options = get_nn_cv_options
options.modelType = 'nn';
options.logModel = 1;
options.pca = 0; % do no PCA here
options.scg_iter = 100;             % Number of training cycles. Left at default.
% options.scg_iter = 1000;             % Number of training cycles. The longer the better (but slower).

% Tuning parameters:
nhidden_def = 28; % default from Kate Smith-Miles' paper.
alpha_def = 0.01; % Coefficient of weight-decay prior. Left at default.

options.paramsLowerBound = 0;
options.paramsUpperBound = 1;

options.nhidden_max = 1024;
options.nhidden_min = 1;
options.alpha_min = 1e-6;
options.alpha_max = 1;

nhidden = (log(nhidden_def)-log(options.nhidden_min)) / (log(options.nhidden_max)-log(options.nhidden_min));
alpha = (log(alpha_def)-log(options.alpha_min)) / (log(options.alpha_max)-log(options.alpha_min)); 

options.tuning_params = [nhidden, alpha];
options.unique_model_name = 'NN-cv';

options.opt = 1;
options.hyp_opt_obj = 'cv-rmse';
options.hyp_opt_algorithm = 'direct';
options.hyp_opt_steps = 30;
options.crossVal_ll_k = 2;