function options = get_lr_default_options

options.modelType = 'LR';
options.pca = 0;
options.logModel = 1;
options.linearSize = 20; % Changed by FH June 29; 30 gave out of memory error for 100000 data points.
options.doQuadratic = 1;
options.one_in_k_encoding = 1;

% Tuning parameters:
maxModelSize_def = 20;
delta_def = 1e-2;

options.paramsLowerBound = 0;
options.paramsUpperBound = 1;

options.maxModelSize_max = 64;
options.maxModelSize_min = 1;
options.delta_min = 1e-6;
options.delta_max = 1;

maxModelSize = (log(maxModelSize_def)-log(options.maxModelSize_min)) / (log(options.maxModelSize_max)-log(options.maxModelSize_min));
delta = (log(delta_def)-log(options.delta_min)) / (log(options.delta_max)-log(options.delta_min)); 

options.tuning_params = [maxModelSize, delta];
options.unique_model_name = 'RR-copy';

options.opt = 0;
