function epm_matrix_experiments(idx, exps, single_exps)
% Run experiment(s) for benchmark with index idx
% exps: matrix experiments for joint configuration/feature space (1: basic
% plots; 2: scaling experiments)
% single_exps: experiments for configuration space only (1: basic plots; 2:
% scaling experiments)
%
% Call this from the root directory.

% A new benchmark set can be added by setting the following below:
% tuningScenarios{end+1}: name of the scenario
% dist_files{end+1}: filename of a comma-separated Nx(M+1) runtime matrix, 
% where each of the N rows represents an instance, the first column holds 
% the instance name, and the remaining columns hold the runtimes of M
% configurations
% random_config_files{end+1}: filename holding the M configurations
% config_space_files{end+1}: description of the parameter configuration
% space, in the same format as for ParamILS
% feature_files{end+1}: filename containing the features for the
% benchmark's instances

% Define the models for the experiment.

% Ordering for scaling experiments:
% options_vec = {get_rf_default_options,get_regtree_default_options,get_gp_default_options,get_nn_options,get_lr_default_options,get_spore_options_rmse};

% Ordering for tables:
options_vec = {get_lr_default_options,get_spore_options_rmse,get_nn_options,get_gp_default_options,get_regtree_default_options,get_rf_default_options};
% options_vec = {get_lr_default_options,get_rf_default_options};
% options_vec = {get_rf_default_options};

% % C/V version, ordering for tables
% options_vec = {get_lr_cv_options,get_spore_cv_options_rmse,get_nn_cv_options,get_gp_default_options,get_regtree_default_options,get_rf_default_options,get_rf_cv_options}%,get_rf_default_options}
% 
% % C/V version, ordering for scaling experiments:
% % options_vec = {get_rf_cv_options,get_regtree_default_options,get_gp_default_options,get_nn_cv_options,get_spore_cv_options_rmse,get_lr_cv_options}%,get_rf_cv_options}
% 
% % options_vec = {get_rf_default_options}
% 
% % For censoring experiment
% options_vec = {get_rf_default_options_dropcensdata,get_rf_default_options_ignorecensinfo,get_rf_default_options_cens,get_rf_default_options_fill_in_samples};
% 
% options_vec = {get_rf_default_options};

if 0% reverse order for plotting
    tmp = options_vec;
    options_vec = {};
    for i=length(tmp):-1:1
        options_vec{end+1} = tmp{i};
    end
end

do_exp = 1;
do_plots = 1;
show_results_of_matrix_exps = 1;
capping_type = 'capslack'; 
capping_type = 'fixed'; 


mkdir('results');
if nargin < 3
    exps = [1,2,3,6];
    single_exps = [1,2,3,4];
end
if isdeployed
    idx = str2double(idx);
    exps = str2double(exps);
    single_exps = str2double(single_exps);
end

rootdir = '';
tuningScenarios = {};
dist_files = {};
random_config_files = {};
config_space_files = {};
feature_files = {};

tuningScenarios{end+1} = 'CPLEX12-cat-BIGMIX';
dist_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-CPLEX-BIGMIX-all1510inst-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-algocplex12-milp-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/MIP/cplex12-params-CPAIOR-space.txt');
feature_files{end+1} = strcat(rootdir, 'data/MIP/BIGMIX-train_test-features-withfilename.csv');

tuningScenarios{end+1} = 'CPLEX12-cat-CORLAT';
dist_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-CPLEX-CORLAT-train_test_inst-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-algocplex12-milp-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/MIP/cplex12-params-CPAIOR-space.txt');
feature_files{end+1} = strcat(rootdir, 'data/MIP/CORLAT-train_test-features-withfilename.csv');

tuningScenarios{end+1} = 'CPLEX12-cat-REG';
dist_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-CPLEX-CATS_REG-1000train-1000test-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-algocplex12-milp-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/MIP/cplex12-params-CPAIOR-space.txt');
feature_files{end+1} = strcat(rootdir, 'data/MIP/REG-train_test-features-withfilename.csv');

tuningScenarios{end+1} = 'CPLEX12-cat-RCW';
dist_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-CPLEX-RCW-990train-990test-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-algocplex12-milp-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/MIP/cplex12-params-CPAIOR-space.txt');
feature_files{end+1} = strcat(rootdir, 'data/MIP/RCW-train_test-features-withfilename.csv');

tuningScenarios{end+1} = 'CPLEX12-cat-CORLAT-REG';
dist_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-CPLEX-CORLAT-REG-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-algocplex12-milp-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/MIP/cplex12-params-CPAIOR-space.txt');
feature_files{end+1} = strcat(rootdir, 'data/MIP/CORLAT-REG-features.csv');

tuningScenarios{end+1} = 'CPLEX12-cat-CORLAT-REG-RCW';
dist_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-CPLEX-CORLAT-REG-RCW-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/MIP/1000samples-algocplex12-milp-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/MIP/cplex12-params-CPAIOR-space.txt');
feature_files{end+1} = strcat(rootdir, 'data/MIP/CORLAT-REG-RCW-features.csv');

tuningScenarios{end+1} = 'SPEAR-ibm-al';
dist_files{end+1} = strcat(rootdir, 'data/SAT/1000samples-SPEAR-IBM-all765inst-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/SAT/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/SAT/spear-params.txt');
feature_files{end+1} = strcat(rootdir, 'data/SAT/IBM-ALL-feat.csv');

tuningScenarios{end+1} = 'SPEAR-swv-al';
dist_files{end+1} = strcat(rootdir, 'data/SAT/1000samples-SPEAR-SWV-all604inst-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/SAT/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/SAT/spear-params.txt');
feature_files{end+1} = strcat(rootdir, 'data/SAT/SWV-feat.csv');

tuningScenarios{end+1} = 'SPEAR-ibm-swv-al';
dist_files{end+1} = strcat(rootdir, 'data/SAT/1000samples-SPEAR-IBM-SWV-results.txt');
random_config_files{end+1} = strcat(rootdir, 'data/SAT/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt');
config_space_files{end+1} = strcat(rootdir, 'data/SAT/spear-params.txt');
feature_files{end+1} = strcat(rootdir, 'data/SAT/IBM-SWV-feat.csv');

tuningScenarios{end+1} = 'LKH-TSPLIB';
%dist_files{end+1} = strcat(rootdir, 'data/TSP/1000-randomsamples-LKH-runobjruntime-overallobjmean10-time300-algowrapper5.pl-traj-matrix-results.txt');
dist_files{end+1} = strcat(rootdir, 'data/TSP/1000-randomsamples-LKH-runobjruntime-overallobjmean10-time300-algoLKHWrapper.pl-traj-matrix-both-ok-results.csv');
random_config_files{end+1} = strcat(rootdir, 'data/TSP/1000-randomsamples-LKH-runobjruntime-overallobjmean10-time300-algoLKHWrapper.pl-traj.txt');
config_space_files{end+1} = strcat(rootdir, 'data/TSP/LKH-params.txt');
% feature_files{end+1} = strcat(rootdir, 'data/TSP/TSPLIB_feat_all.csv');
feature_files{end+1} = strcat(rootdir, 'data/TSP/TSPLIB_feat_both_ok.csv');

tuningScenarios{end+1} = 'LKH-TSPLIB';
dist_files{end+1} = strcat(rootdir, 'data/TSP/1000-randomsamples-LKH-runobjruntime-overallobjmean10-time300-algowrapper5.pl-traj-matrix-ours-ok-results.csv');
random_config_files{end+1} = strcat(rootdir, 'data/TSP/1000-randomsamples-LKH-runobjruntime-overallobjmean10-time300-algowrapper5.pl-traj.txt');
config_space_files{end+1} = strcat(rootdir, 'data/TSP/LKH-params.txt');
feature_files{end+1} = strcat(rootdir, 'data/TSP/TSPLIB_feat_ours_ok.csv');

if do_exp
    for i=idx
        for exp=exps
            model_perf_scenario_clean(options_vec, dist_files{i}, random_config_files{i}, feature_files{i}, tuningScenarios{i}, config_space_files{i}, 300, exp, -1, capping_type);
        end
        for singleExp=single_exps
            model_perf_scenario_clean(options_vec, dist_files{i}, random_config_files{i}, feature_files{i}, tuningScenarios{i}, config_space_files{i}, 300, 0, singleExp, capping_type);
        end
        close all;
    end
end

if do_plots
    if length(exps) == 1 && exps(1) == 7
        for i = idx
            plot_model_perf_capslack(tuningScenarios{i}, capping_type)
        end
        return
    end
    is_first_idx = 1;
    for num_tuningScenario=idx
        tuningScenario = tuningScenarios{num_tuningScenario};
        outdomain = strcat('results/matrix/', tuningScenarios{num_tuningScenario}, '/');
        
        for singleExp=single_exps
            plot_ehm_results(options_vec, strcat('params-',tuningScenarios{num_tuningScenario}), singleExp, num_tuningScenario);
        end
        
        for exp = exps
            if exp == 1
                tuningScenParams = strcat('params-', tuningScenario);
                timesToLearn = [];
                for model_idx = 1:length(options_vec)
                    options = options_vec{model_idx};
                    
                    %% Detailed matrix experiments.
                    nTrain = 100;
                    tuningScen_with_numtrain = strcat(tuningScenario,'-',num2str(nTrain));
                    if show_results_of_matrix_exps
                        filename = ['results/matrix/2d/', tuningScen_with_numtrain, '-', options.unique_model_name, '-preds'];
                        load(filename);
                        tuningScenario = tuningScenarios{num_tuningScenario}; % to undo load.
                         
                        fprintf('Overall performance in matrix prediction: RMSE = %f, LL=%f, CC=%f, CC_rank=%f\n', [rmse, ll, cc, cc_rank]);
                        % 4 sub-experiments
                        learnTime = timeToLearn;
                        % subplot(2,2,1);
                        results{end+1} = predict_submatrix(matrix, fullpredmatrix, fullpredmatrixvar, ind1(find(ind1 <= nInstTrain)), ind2(find(ind2 <= nThetaTrain)), tuningScenario, '-trainC_trainI', options.unique_model_name, learnTime, plotMatrices);
                        close all;
                        
                        %subplot(2,2,2);
                        results{end+1} = predict_submatrix(matrix, fullpredmatrix, fullpredmatrixvar, ind1(find(ind1 <= nInstTrain)), ind2(find(ind2 > nThetaTrain)), tuningScenario, '-testC_trainI', options.unique_model_name, learnTime, plotMatrices);
                        close all;
                        
                        %subplot(2,2,3);
                        results{end+1} = predict_submatrix(matrix, fullpredmatrix, fullpredmatrixvar, ind1(find(ind1 >  nInstTrain)), ind2(find(ind2 <= nThetaTrain)), tuningScenario, '-trainC_testI', options.unique_model_name, learnTime, plotMatrices);
                        close all;
                        
                        %subplot(2,2,4);
                        results{end+1} = predict_submatrix(matrix, fullpredmatrix, fullpredmatrixvar, ind1(find(ind1 > nInstTrain)), ind2(find(ind2 > nThetaTrain)), tuningScenario, '-testC_testI', options.unique_model_name, learnTime, plotMatrices);
                        close all;
                    end
                end
                
                %% Load statistics of matrix experiments.
                for model_idx = 1:length(options_vec)
                    options = options_vec{model_idx};
                    filename = strcat(outdomain, options.unique_model_name, '_matrix_preds.mat');
                    %             fprintf(strcat(['Loading results for model ', options.unique_model_name, ' from file ', filename, '\n']));
                    load(filename, 'results', 'timeToLearn', 'timeToPredict', 'nTrain');
                    all_results{model_idx} = results;
                    all_timeToLearn{model_idx} = timeToLearn;
                    all_timeToPredict{model_idx} = timeToPredict;
                end
                
                stats_format = 2;
                switch stats_format
                    case 1 
                        fprintf('\\hline\n');
                        fprintf(strcat([' & & & CC']));
                        for quadr=1:4
                            fprintf(' & ');
                            values = [];
                            for model_idx = 1:length(options_vec)
                                values(end+1) = all_results{model_idx}{quadr}(3);
                            end
                            n_output(values, 0);
                        end
                        fprintf('\\\\\n');

                        fprintf(strcat([tuningScenario, ' & ']));
                        n_output(all_timeToLearn, 1);

                        fprintf(strcat(['& RMSE']));
                        for quadr=1:4
                            fprintf(' & ');
                            values = [];
                            for model_idx = 1:length(options_vec)
                                values(end+1) = all_results{model_idx}{quadr}(1);
                            end
                            n_output(values, 1);
                        end
                        fprintf('\\\\\n');

                        fprintf(strcat([' & & & LL']));
                        for quadr=1:4
                            fprintf(' & ');
                            values = [];
                            for model_idx = 1:length(options_vec)
                                values(end+1) = all_results{model_idx}{quadr}(2);
                            end
                            n_output(values, 0);
                        end
                        fprintf('\\\\\n');
                
                    case 2
                        rmses = [];
                        lls = [];
                        ccs = [];
                        learnTime = [];

                        modelNames = get_model_names(options_vec,0);
                        if is_first_idx
                            header_output(modelNames, {'RMSE', 'Time to learn [s]'});
%                             header_output(modelNames, {'Pearson correlation coefficient', 'Log-likelihood'});
%                             header_output(modelNames, {'RMSE', 'Pearson correlation coefficient'});
                            is_first_idx = 0;
                        end
                           
                        quadr = 4;
                        model_idx_to_use = 1:length(options_vec);
                        for j=1:length(model_idx_to_use)
                            model_idx = model_idx_to_use(j);
                            rmses(j) = all_results{model_idx}{quadr}(1);
                            lls(j) = all_results{model_idx}{quadr}(2);
                            ccs(j) = all_results{model_idx}{quadr}(3);
                            learnTime(j) = all_timeToLearn{model_idx};
                        end

                        fprintf(strcat(fix_name(tuningScenario), ' & '));
                        n_output(rmses,1);
                        fprintf(' & ');
                        n_output(learnTime,1);

%                         n_output(ccs,0);
%                         fprintf(' & ');
% %                         lls = lls([4,6,7]); % only defined for PP and RF
%                         n_output(lls,0);

%                         n_output(rmses,1);
%                         fprintf(' & ');
%                         n_output(learnTime,1);

                        
                        fprintf('\\\\\n');
                        fprintf('\\hline\n');
                        
                        
                
                    case 3
    %                     fprintf('======= All 4 combinations of training/test insts and configs =======\n\n');
                        modelNames = get_model_names(options_vec,0);
                        if is_first_idx
                            header_output(modelNames, {'Training configurations', 'Test configurations'}, ' Instances & ', ' & ');
                            is_first_idx = 0;
                        end

                        fprintf(strcat([fix_name(tuningScenario), ' & Training & ']));
                        for quadr=1:2
                            outresults = [];
                            for model_idx=1:length(options_vec)
                                outresults(model_idx) = all_results{model_idx}{quadr}(1);%rmse
                            end
                            n_output(outresults, 1);
                            if quadr == 1
                                fprintf(' & ');
                            end
                        end
                        fprintf('\\\\\n');

                        fprintf(strcat(['~ & Test & '])); 
                        for quadr=3:4
                            outresults = [];
                            for model_idx=1:length(options_vec)
                                outresults(model_idx) = all_results{model_idx}{quadr}(1);
                            end
                            n_output(outresults, 1);
                            if quadr == 3
                                fprintf(' & ');
                            end
                        end
                        fprintf('\\\\\n');
                        fprintf('\\hline\n');
                end
            end
        end
    end
end

if exp==2
    for num_tuningScenario=idx
        tuningScenario = tuningScenarios{num_tuningScenario};
        outdomain = strcat('results/matrix/', tuningScenarios{num_tuningScenario}, '/');

        numTrains = [10,10*sqrt(10),100,100*sqrt(10),1000,1000*sqrt(10),10000,10000*sqrt(10),100000];
    %     if isTinyTest
    %         numTrains = [10,10*sqrt(10)];
    %     end

        for model_idx = 1:length(options_vec)
            options = options_vec{model_idx};

            model_names{model_idx} = options.unique_model_name;
            for i=1:length(numTrains)
                numTrain = numTrains(i);
                numTrain = floor(numTrain);
                filename = strcat(outdomain, options_vec{model_idx}.unique_model_name, '-nTrain', num2str(numTrain), '_matrix-pred-scale-result.mat');
                try
                    load(filename, 'results', 'timeToLearn', 'timeToPredict', 'numTrains');            
                    ccs = [];
                    for j=1:10
                        ccs(end+1) = results{i,j}{4}(3);
                    end
                    cc_avg(i,model_idx) = mean(ccs);
                    cc_std(i,model_idx) = std(ccs);
                catch ME
                    cc_avg(i,model_idx) = inf;
                    cc_std(i,model_idx) = inf;
                end
            end            
        end

        numTrains = ceil(numTrains);
%         numTrains = numTrains(3:end);
%         cc_avg = cc_avg(3:end,:);
%         cc_std = cc_std(3:end,:);
%         modelNames = get_model_names(options_vec);
        modelNames = model_names;
%        plot_Scaling_N(numTrains, cc_avg, cc_std, options_vec, 'Correlation Coefficient', modelNames, tuningScenarios{num_tuningScenario}, 'NorthWest', 0)
         plot_Scaling_N(numTrains, cc_avg, cc_std, options_vec, 'Correlation Coefficient', modelNames, tuningScenarios{num_tuningScenario}, 'SouthEast', 0)
    end
end

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% SCALING OF MATRIX PREDICTIONS WITH NUMBER OF TRAINING DATA POINTS
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     if scaling_matrix
%         for i=idx
%             outdomain = strcat('results/matrix/', tuningScenarios{i});
%             savefile = strcat(outdomain, '-matrix-pred-scale');
%             load(savefile);
%             numTrains = floor(numTrains);
%
%     %        model_idx_to_use = 1:length(options_vec);
%             model_idx_to_use = [2,3,4,5];
%             model_names = get_model_names(options_vec(model_idx_to_use));
%             cc_avg = [];
%             cc_std = [];
%             for m=1:length(model_idx_to_use)
%                 for j=1:length(numTrains)
%                     ccs = [];
%                     for k=1:size(results,3)
%                         res = results{model_idx_to_use(m),j,k};
%                         if iscell(res)
%                             ccs(end+1) = res{4}(3);
%                         else
%                             ccs(end+1) = -inf;
%                         end
%                     end
%                     cc_avg(j,m) = mean(ccs);
%                     cc_std(j,m) = std(ccs);
%                 end
%             end
%             numTrains = numTrains(3:end);
%             cc_avg = cc_avg(3:end,:);
%             cc_std = cc_std(3:end,:);
%             plot_Scaling_N(numTrains, cc_avg, cc_std, options_vec(model_idx_to_use), 'Correlation Coefficient', model_names, tuningScenarios{i}, 'SouthEast', 0)
% %         rmse_avg = [];
% %         rmse_std = [];
% %         for m=1:length(model_idx_to_use)
% %             for j=1:length(numTrains)
% %                 rmses = [];
% %                 for k=1:size(results,3)
% %                     rmses(end+1) = results{model_idx_to_use(m),j,k}{4}(1);
% %                 end
% %                 rmse_avg(j,m) = mean(rmses);
% %                 rmse_std(j,m) = std(rmses);
% %             end
% %         end
% %         plot_Scaling_N(numTrains, rmse_avg, rmse_std, options_vec(model_idx_to_use), 'RMSE', model_names, tuningScenarios{i}, 'SouthEast', 0)
%         end
%     end
% end

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% VARIABLE IMPORTANCE: MATRIX AND JUST PARAMETERS (on fixed instance)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     for i=idx
%         outdomain = strcat('results/matrix/', tuningScenarios{i})
%         savefile = strcat('results/matrix/vimp-sel-val-', outdomain);
% %         load(savefile, 'vimp');
% %         output_vimp(vimp, strcat('results/vimp/matrix-',tuningScenarios{i}));
%         output_vimps(savefile, strcat('results/vimp/matrix-',tuningScenarios{i}), 2, 'Feature/parameter subset size');
%
%         savefile = strcat('results/ehm/vimp-sel-val-', strcat('params-',tuningScenarios{i}));
% %         load(savefile, 'vimp');
% %         output_vimp(vimp, strcat('results/vimp/params-',tuningScenarios{i}));
%         output_vimps(savefile, strcat('results/vimp/params-',tuningScenarios{i}), 2, 'Parameter subset size');
%     end


% tuningScenarios{end+1} = 'SAPS-c-SWGCP-PAR1';
% dist_files{end+1} = strcat(rootdir, 'data/SAT/random-SWGCPsat_SAPScont-5s-1000train-1000test.txt');
% random_config_files{end+1} = strcat(rootdir, 'data/SAT/1000samples-algosaps-runobjruntime-overallobjmean10-time300.0-length2147483647_0.txt');
% algos{end+1} = 'saps';
% feature_files{end+1} = strcat(rootdir, 'data/SAT/SWGCP-SAT-feat.csv');


% % %NEW:
% tuningScenario = 'SAPS-SWGCP-cont';
% if isunix
%     dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/saps-sw/random-SW-JAIR-results-1000train-1000test.txt';
%     random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/saps-newqcp/1000random_samples-runobjruntime-overallobjmean10-time5.0-algosaps-later-clean.txt';
% else
%     dist_file = 'Z:\arrowspace\ParamILS\saps-sw\random-SW-JAIR-results-1000train-1000test.txt';
%     random_config_file = 'Z:\arrowspace\ParamILS\saps-newqcp\1000random_samples-runobjruntime-overallobjmean10-time5.0-algosaps-later-clean.txt';
% end
% %analyze_scenario(tuningScenario, dist_file, 5);
% model_perf_scenario(dist_file, random_config_file, tuningScenario, 5);
% %cv_marginal_pred_exploratory('/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/saps-sw/random-SW-JAIR-results-1000train-1000test.txt', '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/saps-newqcp/1000random_samples-runobjruntime-overallobjmean10-time5.0-algosaps-later-clean.txt', 'SAPS-SWGCP-cont', 5);
% clear all;
% close all hidden;
%
%
% if 0
%     %NEW:
%     tuningScenario = 'SPEAR-SWGCP';
%     if isunix
%         dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/random-SPEAR-SWGCP-JAIR-results-1000train-1000test.txt';
%         random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt'
%     else
%         dist_file = 'Z:\arrowspace\ParamILS\spear\random-SPEAR-SWGCP-JAIR-results-1000train-1000test.txt';
%         random_config_file = 'Z:\arrowspace\ParamILS\spear\1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time5.0-length2147483647_0.txt';
%     end
%     %analyze_scenario(tuningScenario, dist_file, 5);
%     model_perf_scenario(dist_file, random_config_file, tuningScenario, 5);
%     %piac_potential(dist_file, random_config_file, tuningScenario); %1000
%     clear all;
%     close all hidden;
%
%
%     tuningScenario = 'SPEAR-QCP';
%     if isunix
%         dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/random-QCP-JAIR-results-1000train-1000test.txt';
%         random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time5.0-length2147483647_0.txt';
%     else
%         dist_file = 'Z:\arrowspace\ParamILS\spear\random-QCP-JAIR-results-1000train-1000test.txt';
%         random_config_file = 'Z:\arrowspace\ParamILS\spear\1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time5.0-length2147483647_0.txt';
%     end
%     %analyze_scenario(tuningScenario, dist_file, 5);
%     model_perf_scenario(dist_file, random_config_file, tuningScenario, 5);
%     clear all;
%     close all hidden;
%
%
%
%
%     % NEW:
%     tuningScenario = 'SPEAR-swv-al';
%     if isunix
%         dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/random-SPEAR-SWV-results-100inst.txt';
%         random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt'
%     else
%         dist_file = 'Z:\arrowspace\ParamILS\spear\random-SPEAR-SWV-results-100inst.txt';
%         random_config_file = 'Z:\arrowspace\ParamILS\spear\1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt';
%     end
%     model_perf_scenario(dist_file, random_config_file, tuningScenario, 300);
%     %model_perf_scenario_single_matrix(dist_file, random_config_file, tuningScenario, 300);
%     clear all;
%     close all hidden;
%
%
%     % NEW:
%     tuningScenario = 'CPLEX-regions100';
%     if isunix
%         dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/cplex/random-CPLEX-CATS100-JAIR-results-1000train-1000test.txt';
%         %random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/cplex/1000-random-configs-early-random-runs1-runobjruntime-overallobjmean-time5.0-tunerTime18000.0-algocplex-stats_0.txt';
%         random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/cplex/1000random-configs-runobjruntime-overallobjmean-time5.0-tunerTime18000.0-algocplex-stats_0.txt';
%     else
%         dist_file = 'Z:\arrowspace\ParamILS\cplex\random-CPLEX-CATS100-JAIR-results-1000train-1000test.txt';
%         %random_config_file = 'Z:\arrowspace\ParamILS\cplex\1000-random-configs-early-random-runs1-runobjruntime-overallobjmean-time5.0-tunerTime18000.0-algocplex-stats_0.txt';
%         random_config_file = 'Z:\arrowspace\ParamILS\cplex\1000random-configs-runobjruntime-overallobjmean-time5.0-tunerTime18000.0-algocplex-stats_0.txt';
%     end
%     %analyze_scenario(tuningScenario, dist_file, 5);
%     model_perf_scenario(dist_file, random_config_file, tuningScenario, 5);
%     %model_perf_scenario_single_matrix(dist_file, random_config_file, tuningScenario, 5);
%     clear all;
%     close all hidden;
%
%     % NEW:
%     tuningScenario = 'SPEAR-ibm-al';
%     if isunix
%         dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/SPEAR-ibm-al-pred_mean_matrix.txt';
%         random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt'
%     else
%         dist_file = 'Z:\arrowspace\ParamILS\spear\random-SPEAR-IBM-results-100inst.txt';
%         random_config_file = 'Z:\arrowspace\ParamILS\spear\1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt';
%     end
%     %analyze_scenario(tuningScenario, dist_file, 300); %1000
%     model_perf_scenario(dist_file, random_config_file, tuningScenario, 300);
%     %model_perf_scenario_single_matrix(dist_file, random_config_file, tuningScenario, 300);
%
%     clear all;
%     close all hidden;
%
%
%     % NEW:
%     tuningScenario = 'CPLEX-OR-al';
%     if isunix
%         dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/cplex/random-CPLEX-Orlib-results.txt';
%         %random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/cplex/1000-random-configs-early-random-runs1-runobjruntime-overallobjmean-time5.0-tunerTime18000.0-algocplex-stats_0.txt';
%         random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/cplex/1000random-configs-runobjruntime-overallobjmean-time300.0-tunerTime18000.0-algocplex-stats_0.txt';
%     else
%         dist_file = 'Z:\arrowspace\ParamILS\cplex\random-CPLEX-Orlib-results.txt';
%         %random_config_file = 'Z:\arrowspace\ParamILS\cplex\1000-random-configs-early-random-runs1-runobjruntime-overallobjmean-time5.0-tunerTime18000.0-algocplex-stats_0.txt';
%         random_config_file = 'Z:\arrowspace\ParamILS\cplex\1000random-configs-runobjruntime-overallobjmean-time300.0-tunerTime18000.0-algocplex-stats_0.txt';
%     end
%     %analyze_scenario(tuningScenario, dist_file, 300); %1000
%     %piac_potential(dist_file, random_config_file, tuningScenario); %1000
%
%     model_perf_scenario(dist_file, random_config_file, tuningScenario, 300);
%     %model_perf_scenario_single_matrix(dist_file, random_config_file, tuningScenario, 300);
%
%     clear all;
%     close all hidden;
%
%
%
%
%
%
%
%
%
%
%
%     tuningScenario = 'SAPS-QCP-cont';
%     if isunix
%         dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/saps-newqcp/non-trivial-random-newQCP-JAIR-results-1000train-1000test.txt';
%     %    random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/saps-newqcp/1000random_samples-runobjruntime-overallobjmean10-time5.0-algosaps-later-clean.txt';
%         random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/saps-newqcp/1000random_samples-runobjruntime-overallobjmean10-time5.0-algosaps-later-clean.txt';
%     else
%         dist_file = 'Z:\arrowspace\ParamILS\saps-newqcp\non-trivial-random-newQCP-JAIR-results-1000train-1000test.txt';
%     %    random_config_file = 'Z:\arrowspace\ParamILS\saps-newqcp\1000random_samples-runobjruntime-overallobjmean10-time5.0-algosaps-later-clean.txt';
%         random_config_file = 'Z:\arrowspace\ParamILS\saps-newqcp\1000random_samples-runobjruntime-overallobjmean10-time5.0-algosaps-later-clean.txt';
%     end
%     %analyze_scenario(tuningScenario, dist_file, 5);
%     model_perf_scenario(dist_file, random_config_file, tuningScenario, 5);
%     clear all;
%     close all hidden;
%
% end
%
% % % NEW:
% % tuningScenario = 'SPEAR-swv-al';
% % if isunix
% %     dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/random-SPEAR-SWV-results-100inst.txt';
% %     random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt'
% % else
% %     dist_file = 'Z:\arrowspace\ParamILS\spear\random-SPEAR-SWV-results-100inst.txt';
% %     random_config_file = 'Z:\arrowspace\ParamILS\spear\1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt';
% % end
% % %analyze_scenario(tuningScenario, dist_file, 300); %1000
% % model_perf_scenario(dist_file, random_config_file, tuningScenario, 300);
% % clear all;
% % close all hidden;
% %
% %
% % % NEW:
% % tuningScenario = 'SPEAR-ibm-al';
% % if isunix
% %     dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/random-SPEAR-IBM-results-100inst.txt';
% %     random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/spear/1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt'
% % else
% %     dist_file = 'Z:\arrowspace\ParamILS\spear\random-SPEAR-IBM-results-100inst.txt';
% %     random_config_file = 'Z:\arrowspace\ParamILS\spear\1000samples-algospear1.2.1.1-runobjruntime-overallobjmean10-runs1000-time300.0-length2147483647_0.txt';
% % end
% % %analyze_scenario(tuningScenario, dist_file, 300); %1000
% % model_perf_scenario(dist_file, random_config_file, tuningScenario, 300);
% %
% % clear all;
% % close all hidden;
% %
% %
% % % NEW:
% % tuningScenario = 'CPLEX-regions100';
% % if isunix
% %     dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/cplex/random-CPLEX-CATS100-JAIR-results-1000train-1000test.txt';
% %     random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/cplex/1000-random-configs-early-random-runs1-runobjruntime-overallobjmean-time5.0-tunerTime18000.0-algocplex-stats_0.txt';
% % else
% %     dist_file = 'Z:\arrowspace\ParamILS\cplex\random-CPLEX-CATS100-JAIR-results-1000train-1000test.txt';
% %     random_config_file = 'Z:\arrowspace\ParamILS\cplex\1000-random-configs-early-random-runs1-runobjruntime-overallobjmean-time5.0-tunerTime18000.0-algocplex-stats_0.txt';
% % end
% % %analyze_scenario(tuningScenario, dist_file, 5);
% % model_perf_scenario(dist_file, random_config_file, tuningScenario, 5);
% % clear all;
% % close all hidden;
% %
% %
% %
% %
% %
% %
% %
% % % NEW:
% % tuningScenario = 'SatComp07-phase2-industrial';
% % if isunix
% %     dist_file = '/.autofs/homes/ubccshome/h/hutter/satcomp_results/SAT07-matrix-industrial-phase2.csv';
% % else
% %     dist_file = 'Z:\satcomp_results\SAT07-matrix-industrial-phase2.csv';
% % end
% % analyze_scenario(tuningScenario, dist_file, 5000); %1000
% % clear all;
% % close all hidden;
%
%
% %
% %
% % % NEW:
% % tuningScenario = 'Satenstein-SWGCP';
% % if isunix
% %     %dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/satenstein/SWGCP-500dls389nondls111firstnondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-firstinstance_list_0-1000train-1000test.txt';
% %     dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/satenstein/SWGCP-500-random-dls-500-random-nondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-firstinstance_list_0-1000train-1000test.txt';
% %     random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/satenstein/500-random-dls_500-random-nondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-cannot-be-evaluated-together-since-different-params-files.txt';
% % else
% %     %dist_file = 'Z:\arrowspace\ParamILS\satenstein\SWGCP-500dls389nondls111firstnondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-firstinstance_list_0-1000train-1000test.txt';
% %     dist_file = 'Z:\arrowspace\ParamILS\satenstein\SWGCP-500-random-dls-500-random-nondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-firstinstance_list_0-1000train-1000test.txt';
% %     random_config_file = 'Z:\arrowspace\ParamILS\satenstein\500-random-dls_500-random-nondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-cannot-be-evaluated-together-since-different-params-files.txt';
% % end
% % analyze_scenario(tuningScenario, dist_file, 5); %1000
% % %piac_potential(dist_file, random_config_file, tuningScenario); %1000
% % clear all;
% % close all hidden;
% %
% % % NEW:
% % tuningScenario = 'Satenstein-QCP';
% % if isunix
% %     %dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/satenstein/QCP-395dls_rep129nondls_repfirst-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-firstinstance_list_0-1000train-1000test.txt';
% %     dist_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/satenstein/QCP-500-random-dls-500-random-nondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-firstinstance_list_0-1000train-1000test.txt';
% %     random_config_file = '/.autofs/csother/ubccsprojectarrow/hutter/ParamILS/satenstein/500-random-dls_500-random-nondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-cannot-be-evaluated-together-since-different-params-files.txt';
% % else
% %     %dist_file = 'Z:\arrowspace\ParamILS\satenstein\QCP-395dls_rep129nondls_repfirst-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-firstinstance_list_0-1000train-1000test.txt';
% %     dist_file = 'Z:\arrowspace\ParamILS\satenstein\QCP-500-random-dls-500-random-nondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-firstinstance_list_0-1000train-1000test.txt';
% %     random_config_file = 'Z:\arrowspace\ParamILS\satenstein\500-random-dls_500-random-nondls-parameters-runobjruntime-overallobjmean10-time5-algosatenstein-stats-cannot-be-evaluated-together-since-different-params-files.txt';
% % end
% % analyze_scenario(tuningScenario, dist_file, 5); %1000
% % %piac_potential(dist_file, random_config_file, tuningScenario); %1000
% % clear all;
% % close all hidden;
% %
% %
% %
% %
% %
% %
% % % % figure
% % % % dist_file = 'Z:\arrowspace\ParamILS\cplex\random-CATS200-test100-dist-ps3-stats-algocplex-runobjruntime-overallobjmean-runs10-time5.0-init1_0.txt';
% % % % traintest_file = 'Z:\arrowspace\ParamILS\cplex\real\real_random-CATS200-ps3-stats-algocplex-runobjruntime-overallobjmean-runs10-time5.0-init1_0-instance_list_0.txt.txt';
% % % % analyze_scenario('CPLEX on regions 200', traintest_file, dist_file)
% % %
% % % figure
% % % dist_file = 'Z:\arrowspace\ParamILS\saps-qcp\random-QCP-test100-dist-ps3-stats-algosaps-runobjruntime-overallobjmean-runs10-time5.0-init1_0.txt';
% % % traintest_file = 'Z:\arrowspace\ParamILS\saps-qcp\real\real_random-ps3-stats-algosaps-runobjruntime-overallobjmean-runs10-time5.0-init1_0-instance_list_0.txt.txt';
% % % analyze_scenario('SAPS on QCP', traintest_file, dist_file, 5)
% % %
% % % figure
% % % dist_file = 'Z:\arrowspace\ParamILS\spear\random-SWGCP-test100-dist-ps3-stats-algospear-runobjruntime-overallobjmean-runs10-time5.0-init1_0.txt';
% % % traintest_file = 'Z:\arrowspace\ParamILS\spear\real\real_random-SWGCP-ps3-stats-algospear1.2.1.1-runobjruntime-overallobjmean-runs10-time5.0-init1_0-instance_list_0.txt.txt';
% % % analyze_scenario('SPEAR on SWGCP', traintest_file, dist_file, 5)
% % %
% % % figure
% % % dist_file = 'Z:\arrowspace\ParamILS\saps-sw\random-SWGCP-test100-dist-ps3-stats-algosaps-runobjruntime-overallobjmean-runs10-time5.0-init1_0.txt';
% % % traintest_file = 'Z:\arrowspace\ParamILS\saps-sw\real\real_random-ps3-stats-algosaps-runobjruntime-overallobjmean-runs10-time5.0-init1_0-instance_list_0.txt.txt';
% % % analyze_scenario('SAPS on SWGCP', traintest_file, dist_file, 5)
% % %
% % %
% % % figure
% % % dist_file = 'Z:\arrowspace\ParamILS\spear\random-QCP-test100-dist-ps3-stats-algospear-runobjruntime-overallobjmean-runs10-time5.0-init1_0.txt';
% % % traintest_file = 'Z:\arrowspace\ParamILS\spear\real\real_random-QCP-ps3-stats-algospear1.2.1.1-runobjruntime-overallobjmean-runs10-time5.0-init1_0-instance_list_0.txt.txt';
% % % analyze_scenario('SPEAR on QCP', traintest_file, dist_file, 5)
% % %
% % %
% % % % %N=100
% % % % figure
% % % % traintest_file = 'Z:\arrowspace\ParamILS\cplex\real\real_random-ps3-stats-algocplex-runobjruntime-overallobjmean-runs100-time5.0-init1_0-instance_list_0.txt.txt';
% % % % analyze_scenario('CPLEX on regions 100, N=100', traintest_file)
% % % %
% % % % figure
% % % % analyze_scenario('SPEAR on SWGCP, N=100', 'Z:\arrowspace\ParamILS\spear\real\real_random-ps3-stats-algospear1.2.1.1-runobjruntime-overallobjmean-runs100-time5.0-init1_0-instance_list_0.txt.txt')
% % % %
% % % % figure
% % % % analyze_scenario('SAPS on SWGCP, N=100',
% % % % 'Z:\arrowspace\ParamILS\saps-sw\real\real_random-ps3-stats-algosaps-runobjruntime-overallobjmean-runs100-time5.0-init1_0-instance_list_0.txt.txt')


%=== DECLARATION OF ALL ANONYMOUS FUNCTIONS FOR MCC.
%#function covSum
%#function covDIFFard
%#function covDIFFiso
%#function covHybridSE_DIFFard
%#function covHybridSE_DIFFiso
%#function covHybridSE_DIFFiso_OnlyLen
%#function covHybridSE_DIFFiso_NoLen
%#function covHybridSE_DIFFiso_algo
%#function covMatern3iso
%#function covMatern5iso
%#function covNoise
%#function covSEard
%#function covSEiso
%#function covSum
%#function gpr
%#function gprCensor
%#function negLogCensoredConditional
%#function branin.m
%#function disc_bnet_ll
%#function disc_test_fun2
%#function disc_test_fun
%#function griewank
%#function hart6
%#function hartman6
%#function hartman6_marginalized
%#function hartman6_marginalized_t
%#function mixed_disc_cont_testfun
%#function prod_of_branins
%#function saved_saps_swgcp_first100train
%#function simplest_discrete
%#function sixHumpCamelBack
%#function neg_log_exp_imp_model
%#function eval_algo
%#function eval
%#function nmllModel
%#function crossValLL
%#function mu_plus_sigma_model_one_inst
%#function neg_sample_exp_imp_model
%#function sample_exp_imp_forest
%#function gaussian_exp_imp_forest_m
%#function avg_minus_sigma_pred_model
%#function mu_minus_k_sigma_pred_model
%#function quantile_pred_model
%#function cmaes_fsphere
%#function cmaes_rastrigin
%#function cmaes_griewank
%#function cmaes_ackley
%#function cmaes323_sphere_10
%#function cmaes323_ackley_10
%#function cmaes323_griewank_10
%#function cmaes323_rastrigin_10
%#function cmaes323_bf1_10
%#function cmaes323_bf2_10
%#function cmaes323_bf3_10
%#function cmaes323_bf4_10
%#function cmaes323_bf5_10
%#function cmaes323_bf6_10
%#function cmaes323_bf7_10
%#function cmaes323_bf8_10
%#function cmaes323_bf9_10
%#function cmaes323_bf10_10
%#function cmaes323_bf11_10
%#function cmaes323_bf12_10
%#function benchmark_func
%#function benchmark_func_1
%#function benchmark_func_2
%#function benchmark_func_3
%#function benchmark_func_4
%#function benchmark_func_5
%#function benchmark_func_6
%#function benchmark_func_7
%#function benchmark_func_8
%#function benchmark_func_9
%#function benchmark_func_10
%#function benchmark_func_11
%#function benchmark_func_12
%#function regpoly0
%#function corrgauss
%#function cmaes
%#function mlppak
%#function mlpunpak
%#function scg
%#function neterr
%#function mlperr
%#function netgrad
%#function mlpgrad
