function epm_experiments(idx,exps)
% Carries out the experiment for simple empirical hardness models
% (i.e., only features vary) for the distribution with index idx.

if isdeployed
    idx = str2double(idx);
    exps = str2double(exps);
end

if ismac
    dir = '/data/';
elseif isunix
    dir = 'data/'; %/ubc/cs/project/arrow/hutter/model_paper/ 
else
    dir = 'data\'; %Z:\arrowspace\model_paper\data\';
end

distributions = {};

% combinations

% Not using: handmade
% distributions{end+1} = {'SAT/QCP-ALL-feat.csv', 'SAT/QCP-ALL-minisat.csv'};
% distributions{end+1} = {'SAT/SWGCP-ALL-feat.csv', % 'SAT/SWGCP-ALL-minisat.csv'};
% distributions{end+1} = {'SAT/QCP-SAT-feat.csv', 'SAT/QCP-SAT-minisat.csv'};
% distributions{end+1} = {'SAT/SWGCP-SAT-feat.csv', 'SAT/SWGCP-SAT-minisat.csv'};
%
% Not using: local search for crafted
% distributions{end+1} = {'SAT/QCP-SAT-feat.csv', 'SAT/QCP-SAT-saps.csv'};
% distributions{end+1} = {'SAT/QCP-SAT-feat.csv', 'SAT/QCP-SAT-tnm.csv'};
% 
% distributions{end+1} = {'SAT/SWGCP-SAT-feat.csv', 'SAT/SWGCP-SAT-saps.csv'};
% distributions{end+1} = {'SAT/SWGCP-SAT-feat.csv', 'SAT/SWGCP-SAT-tnm.csv'};

% distributions{end+1} = {'SAT/IBM-SWV-INDU-feat.csv', 'SAT/IBM-SWV-INDU-minisat.csv'};
% distributions{end+1} = {'SAT/IBM-SWV-INDU-feat.csv', 'SAT/IBM-SWV-INDU-cryptominisat.csv'};
% distributions{end+1} = {'SAT/IBM-SWV-INDU-feat.csv', 'SAT/IBM-SWV-INDU-spear.csv'};


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SAT 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% MiniSAT SATcomp mixes
distributions{end+1} = {'SAT/INDU-HAND-RAND-feat.csv', 'SAT/INDU-HAND-RAND-minisat.csv'};
distributions{end+1} = {'SAT/SAT_Competition_RACE_HAND-feat.csv', 'SAT/SAT_Competition_RACE_HAND-minisat.csv'};
distributions{end+1} = {'SAT/SAT_Competition_RACE_RAND-feat.csv', 'SAT/SAT_Competition_RACE_RAND-minisat.csv'};

% MiniSAT industrial
distributions{end+1} = {'SAT/SAT_Competition_RACE_INDU-feat.csv', 'SAT/SAT_Competition_RACE_INDU-minisat.csv'};
distributions{end+1} = {'SAT/IBM-SWV-feat.csv', 'SAT/IBM-SWV-minisat.csv'};
distributions{end+1} = {'SAT/IBM-ALL-feat.csv', 'SAT/IBM-ALL-minisat.csv'};
distributions{end+1} = {'SAT/SWV-feat.csv', 'SAT/SWV-minisat.csv'};

% Industrial, CryptoMiniSAT + SPEAR
distributions{end+1} = {'SAT/SAT_Competition_RACE_INDU-feat.csv', 'SAT/SAT_Competition_RACE_INDU-cryptominisat.csv'};
distributions{end+1} = {'SAT/IBM-SWV-feat.csv', 'SAT/IBM-SWV-cryptominisat.csv'};
distributions{end+1} = {'SAT/IBM-ALL-feat.csv', 'SAT/IBM-ALL-cryptominisat.csv'};
distributions{end+1} = {'SAT/SWV-feat.csv', 'SAT/SWV-cryptominisat.csv'};

distributions{end+1} = {'SAT/SAT_Competition_RACE_INDU-feat.csv', 'SAT/SAT_Competition_RACE_INDU-spear.csv'};
distributions{end+1} = {'SAT/IBM-SWV-feat.csv', 'SAT/IBM-SWV-spear.csv'};
distributions{end+1} = {'SAT/IBM-ALL-feat.csv', 'SAT/IBM-ALL-spear.csv'};
distributions{end+1} = {'SAT/SWV-feat.csv', 'SAT/SWV-spear.csv'};

% Random satisfiable, local search (TNM + SAPS)
distributions{end+1} = {'SAT/SAT_Competition_RACE_RAND_SAT-feat.csv', 'SAT/SAT_Competition_RACE_RAND_SAT-tnm.csv'};
distributions{end+1} = {'SAT/SAT_Competition_RACE_RAND_SAT-feat.csv', 'SAT/SAT_Competition_RACE_RAND_SAT-saps.csv'};


% % MIP
distributions{end+1} = {'MIP/BIGMIX-train_test-features-withfilename.csv', 'MIP/BIGMIX-cplex.csv', 1e7};
distributions{end+1} = {'MIP/BIGMIX-train_test-features-withfilename.csv', 'MIP/BIGMIX-gurobi.csv', 1e7};
distributions{end+1} = {'MIP/BIGMIX-train_test-features-withfilename.csv', 'MIP/BIGMIX-scip.csv', 1e7};
distributions{end+1} = {'MIP/BIGMIX-train_test-features-withfilename.csv', 'MIP/BIGMIX-lpsolve.csv', 1e7};

distributions{end+1} = {'MIP/CORLAT-train_test-features-withfilename.csv', 'MIP/CORLAT-cplex.csv'};
distributions{end+1} = {'MIP/CORLAT-train_test-features-withfilename.csv', 'MIP/CORLAT-gurobi.csv'};
distributions{end+1} = {'MIP/CORLAT-train_test-features-withfilename.csv', 'MIP/CORLAT-scip.csv'};
distributions{end+1} = {'MIP/CORLAT-train_test-features-withfilename.csv', 'MIP/CORLAT-lpsolve.csv'};

distributions{end+1} = {'MIP/RCW-train_test-features-withfilename.csv', 'MIP/RCW-cplex.csv'};
distributions{end+1} = {'MIP/REG-train_test-features-withfilename.csv', 'MIP/REG-cplex.csv'};
distributions{end+1} = {'MIP/CORLAT-REG-features.csv', 'MIP/CORLAT-REG-cplex.csv'}; 
distributions{end+1} = {'MIP/CORLAT-REG-RCW-features.csv', 'MIP/CORLAT-REG-RCW-cplex.csv'}; 

% % TSP
distributions{end+1} = {'TSP/PORTGEN-feat.csv', 'TSP/PORTGEN-lkh202.csv'};
distributions{end+1} = {'TSP/PORTCGEN-feat.csv', 'TSP/PORTCGEN-lkh202.csv'};
distributions{end+1} = {'TSP/TSPLIB_feat_both_ok.csv', 'TSP/TSPLIB_LKH_default_both_ok.csv'};

distributions{end+1} = {'TSP/PORTGEN-feat.csv', 'TSP/PORTGEN-concorde.csv'};
distributions{end+1} = {'TSP/PORTCGEN-feat.csv', 'TSP/PORTCGEN-concorde.csv'};
distributions{end+1} = {'TSP/TSPLIB_feat_both_ok.csv', 'TSP/TSPLIB_concorde_default_both_ok.csv'};

% distributions{end+1} = {'TSP/PORTGEN-PORTCGEN-feat.csv', 'TSP/PORTGEN-PORTCGEN-lkh202.csv'};
% distributions{end+1} = {'TSP/PORTGEN-PORTCGEN-feat.csv', 'TSP/PORTGEN-PORTCGEN-concorde.csv'};
% distributions{end+1} = {'TSP/TSPLIB_feat_all.csv', 'TSP/TSPLIB_LKH_default_all.csv'};
% distributions{end+1} = {'TSP/TSPLIB_feat_ours_ok.csv', 'TSP/TSPLIB_LKH_default_ours_ok.csv'};


distributions{end+1} = {'dummy-feats.csv', 'dummy-runtime.csv'};

num_folds = inf;
do_exp = 0;
do_plots = 1;

num_folds = 2;

% FOR RUNNING EXPERIMENTS:
% All models we'll ever need (except RR-elim).
% options_vec = {get_lr_default_options,get_spore_options_rmse,get_lr_jacm_options,get_nn_options,get_rf_default_options, get_lr_cv_options,get_spore_cv_options_rmse,get_nn_cv_options,get_gp_default_options,get_regtree_default_options,get_rf_cv_options};

% % RR-elim (takes forever).
% % options_vec = {get_lr_jacm_options};
% 
% % FOR PLOTS (set stats to display in plot_ehm_results.m):
% % First bake-off:
% %options_vec = {get_lr_cv_options,get_lr_jacm_options,get_spore_cv_options_rmse,get_nn_cv_options,get_gp_default_options,get_regtree_default_options,get_rf_default_options,get_rf_cv_options};
% %options_vec = {get_lr_cv_options,get_lr_jacm_options,get_spore_cv_options_rmse,get_nn_cv_options,get_gp_default_options,get_regtree_default_options,get_rf_default_options};
% 
% % First bake-off with defaults:
% options_vec = {get_lr_default_options,get_lr_jacm_options,get_spore_options_rmse,get_nn_options,get_gp_default_options,get_regtree_default_options,get_rf_default_options};
options_vec = {get_lr_default_options,get_lr_jacm_options,get_spore_options_rmse,get_nn_options,get_gp_default_options,get_regtree_default_options,get_rf_default_options};

% % Default vs  hyperparameter optimized version
% % options_vec = {get_lr_default_options,get_lr_cv_options,get_spore_options_rmse, get_spore_cv_options_rmse, get_nn_options, get_nn_cv_options,get_rf_default_options,get_rf_cv_options};%,get_gp_default_options, get_regtree_default_options};
% % 
% % % C/V version, ordering for tables
% % options_vec = {get_lr_cv_options,get_spore_cv_options_rmse,get_nn_cv_options,get_gp_default_options,get_regtree_default_options,get_rf_default_options}%,get_rf_cv_options}

% C/V version, ordering for scaling experiments:
% options_vec = {get_rf_cv_options,get_regtree_default_options,get_gp_default_options,get_nn_cv_options,get_spore_cv_options_rmse,get_lr_cv_options}%,get_rf_cv_options}
% options_vec = {get_regtree_default_options}%,get_rf_cv_options}

% % options_vec = {get_lr_jacm_options}

options_vec = {get_lr_default_options,get_spore_options_rmse,get_nn_options,get_gp_default_options,get_regtree_default_options,get_rf_default_options};
if 1 % reverse order for plotting
    tmp = options_vec;
    options_vec = {};
    for i=length(tmp):-1:1
        options_vec{end+1} = tmp{i};
    end
end

cat = [];
catDomains = [];
algo_deterministic = 0;

domain_names = {};
for dist_idx=idx%1:length(distributions)
    feature_filename = strcat(dir, distributions{dist_idx}{1});
    runtime_filename = strcat(dir, distributions{dist_idx}{2});

    domain_name = regexprep(runtime_filename, '\.', '_');
    domain_name = regexprep(domain_name, '\\', '_');
    domain_name = regexprep(domain_name, '/', '_');

    domain_names{end+1} = domain_name;

   if do_exp
        %=== Read instance names and runtimes from runtime file.
        [instance_names] = textread(runtime_filename,'%s%*[^\n]', 'bufsize', 100000);
        for i=1:length(instance_names)
            instance_names{i} = instance_names{i}(1:end-1);
        end
        y = csvread(runtime_filename, 0, 1);

        %=== Read instance names and features from feature file.
        [instance_names_feat_file] = textread(feature_filename,'%s%*[^\n]', 'bufsize', 100000, 'delimiter',',');
        instance_names_feat_file = instance_names_feat_file(2:end);
%         for i=1:length(instance_names_feat_file)
%             instance_names_feat_file{i} = instance_names_feat_file{i}(1:end-1);
%         end
        all_features = csvread(feature_filename, 1, 1);
        featureNames = textread(feature_filename, '%s', 1, 'whitespace', '\n', 'bufsize', 10000);
        featureNames = strread(featureNames{1},'%s','whitespace',',');
        featureNames = deblank(featureNames);
        featureNames= featureNames(2:end);

        %=== Assert order of instances is the same.
        assert( length(instance_names_feat_file) == length(instance_names) );
        for i=1:length(instance_names_feat_file)
            if ~( strcmp(instance_names_feat_file{i}, instance_names{i}) );
                instance_names_feat_file{i}
                instance_names{i}
                error
            end
        end

sub_idx = 1:size(all_features,1); 
feat_idx = 1:size(all_features,2);
% sub_idx = 1:100;
% feat_idx = [1:30];
all_features = all_features(sub_idx,feat_idx);
y = y(sub_idx);

        axmax = 3600;
        if length(distributions{dist_idx}) > 2
            axmax = distributions{dist_idx}{3};
        end
%         for exp = 1:4
        for exp = exps
            do_ehm_experiments(options_vec, all_features,y,featureNames,exp,domain_name,cat,catDomains,algo_deterministic,0.001,axmax,num_folds);
        end
    %    close all
   end
end

if do_plots
    for exp = exps
        for dom_num=1:length(domain_names)
            domain = domain_names{dom_num};
            plot_ehm_results(options_vec, domain, exp, dom_num);
        end
    end
end

%         savefile = strcat('results/ehm/vimp-sel-val-', domain_names{num_i});
% %         load(savefile, 'vimp');
% %         output_vimp(vimp, strcat('results/vimp/insts-', domain_names{i}));
% %         output_vimps(savefile, strcat('results/vimp/insts-', domain_names{i}));
%     end
%     output_tables(domain_names)
% end



%=== DECLARATION OF ALL ANONYMOUS FUNCTIONS FOR MCC.
%#function covSum
%#function covDIFFard
%#function covDIFFiso
%#function covHybridSE_DIFFard
%#function covHybridSE_DIFFiso
%#function covHybridSE_DIFFiso_OnlyLen
%#function covHybridSE_DIFFiso_NoLen
%#function covHybridSE_DIFFiso_algo
%#function covMatern3iso
%#function covMatern5iso
%#function covNoise
%#function covSEard
%#function covSEiso
%#function covSum
%#function gpr
%#function gprCensor
%#function negLogCensoredConditional
%#function branin.m
%#function disc_bnet_ll
%#function disc_test_fun2
%#function disc_test_fun
%#function griewank
%#function hart6
%#function hartman6
%#function hartman6_marginalized
%#function hartman6_marginalized_t
%#function mixed_disc_cont_testfun
%#function prod_of_branins
%#function saved_saps_swgcp_first100train
%#function simplest_discrete
%#function sixHumpCamelBack
%#function neg_log_exp_imp_model
%#function eval_algo
%#function eval
%#function nmllModel
%#function crossValLL
%#function mu_plus_sigma_model_one_inst
%#function neg_sample_exp_imp_model
%#function sample_exp_imp_forest
%#function gaussian_exp_imp_forest_m
%#function avg_minus_sigma_pred_model
%#function mu_minus_k_sigma_pred_model
%#function quantile_pred_model
%#function cmaes_fsphere
%#function cmaes_rastrigin
%#function cmaes_griewank
%#function cmaes_ackley
%#function cmaes323_sphere_10
%#function cmaes323_ackley_10
%#function cmaes323_griewank_10
%#function cmaes323_rastrigin_10
%#function cmaes323_bf1_10
%#function cmaes323_bf2_10
%#function cmaes323_bf3_10
%#function cmaes323_bf4_10
%#function cmaes323_bf5_10
%#function cmaes323_bf6_10
%#function cmaes323_bf7_10
%#function cmaes323_bf8_10
%#function cmaes323_bf9_10
%#function cmaes323_bf10_10
%#function cmaes323_bf11_10
%#function cmaes323_bf12_10
%#function benchmark_func
%#function benchmark_func_1
%#function benchmark_func_2
%#function benchmark_func_3
%#function benchmark_func_4
%#function benchmark_func_5
%#function benchmark_func_6
%#function benchmark_func_7
%#function benchmark_func_8
%#function benchmark_func_9
%#function benchmark_func_10
%#function benchmark_func_11
%#function benchmark_func_12
%#function regpoly0
%#function corrgauss
%#function cmaes
%#function mlppak
%#function mlpunpak
%#function scg
%#function neterr
%#function mlperr
%#function netgrad
%#function mlpgrad
