function [timeToLearn, timeToPredict, results, model] = do_matrix_exp(func, matrix, Theta, all_features, names, options, seed, plotMatrices, tuningScenario, nTrain, nTest, cap, capping_type)
if nargin < 12
    cap = 1;
    censoring = 0;
else
    censoring = 1;
end
rand('twister',seed);
% Theta = Theta(1:11,:);
% all_features = all_features(1:10,:);
% matrix = matrix(1:10,1:10);
[C,I] = size(matrix); % C: #parameter configurations; I: #instances

%=== Get index of best configuration as basis for capping.
conf_costs = mean(matrix,2);
[tmp, sort_idx] = sort(conf_costs);
incumbent_idx = sort_idx(1);
inc_quals_for_instance = matrix(incumbent_idx, :);
% best_quals_for_instance = min(matrix,[],1);

%=== Construct data: all configs for 1st instance, all for 2nd, etc
nThetaTrain = ceil(C/2);
nInstTrain = ceil(I/2);

[cand_theta_idxs, cand_inst_idxs] = get_idx_pairs(1:nThetaTrain, 1:nInstTrain);
perm = randperm(length(cand_theta_idxs));
actual_nTrain = min(length(perm), nTrain);
train_idx = perm(1:actual_nTrain);
inst_idxs = cand_inst_idxs(train_idx);
% base_cens_thresh_for_train = best_quals_for_instance(inst_idxs)';
base_cens_thresh_for_train = inc_quals_for_instance(inst_idxs)';

%=== Build X and y with light memory footprint.
[Xtrain,ytrain] = getXyForIndices(Theta, all_features, matrix, cand_theta_idxs(train_idx), cand_inst_idxs(train_idx));
assert(all(all(Xtrain - [Theta(cand_theta_idxs(train_idx),:), all_features(cand_inst_idxs(train_idx),:)]<0.001)));

% %=== Assert we're treating categoricals right. 
% for i=1:length(func.cat)
%     for j=1:size(Xtrain,1)
%         assert(check_member(Xtrain(j,i), func.all_values{i}));
%         assert(Xtrain(j,i)>=1);
%     end
% end

% cens = zeros(size(ytrain));
% fprintf(['Testing learning and using of marginal model of type ', options.modelType, ' ... \n']);
% xCat = [];
% xCatDomains = [];
% algo_deterministic = 0;
% model = learnMarginalModel(Theta(cand_inst_idxs(train_idx),:), cand_inst_idxs(train_idx), all_features, ytrain, cens, func.cat, func.all_values, xCat, xCatDomains, 0, algo_deterministic, options, names)
% [marg_mean, marg_var] = applyMarginalModel(model, Theta);

fprintf(['Learning model of type ', options.modelType, ' ... \n']);
tic;

if censoring
    % Sorry, the interface has changed since we introduced censoring. Thus, there is some code duplication.
    % We preface all duplicated methods with "cens_"
    cens = zeros(length(ytrain),1);
%     cens(ytrain>300-1e-4)=1;
    cens(ytrain>300+1e-4)=1;
    names = names(1:size(Theta,2));
    
    isclean = 0;
    ytrain = max(ytrain, 0.005);
    orig_ytrain = ytrain;
    
%     capping_type = 'fixed'; % 'capslack'; %'fixed';
    switch capping_type
        case 'capslack'
            for i=1:length(ytrain)
                if ytrain(i) > base_cens_thresh_for_train(i)*cap
                    ytrain(i) = min(base_cens_thresh_for_train(i)*cap, 300);
                    cens(i) = 1;
                end
                %         if rand < 0.9
                %             ytrain(i) = rand * ytrain(i)/10;
                %             ytrain = max(ytrain, 0.005);
                %             cens(i) = 1;
                %         end
            end
        case 'fixed' % to visualize predictions
            for i=1:length(ytrain)
                if ytrain(i) > cap
                    cens(i) = 1;
                    ytrain(i) = cap;
                end
            end
        case 'random'
            for i=1:length(ytrain)
                this_cap = 10^(-3 + (rand * log10(cap)+3)); % uniform on log scale between 0.001 and cap
                if ytrain(i) > this_cap
                    cens(i) = 1;
                    %                     this_cap = 10^(-3 + (rand * log10(cap)+3)); % uniform on log scale between 0.001 and cap
                    ytrain(i) = this_cap;
                end
            end
        otherwise error 'unknown capping type'
            
    end
    [ytrain, base_cens_thresh_for_train, orig_ytrain, cens];
    switch options.censoring
        case 'fill_in_mean'
            %             options.orig_rf = 0;
            %             options.Splitmin_init = 1;
            model = cens_learnModel([cand_theta_idxs(train_idx), cand_inst_idxs(train_idx)], Theta, all_features, ytrain, cens, func.cat, func.all_values, [], cell(1,size(all_features,2)), {}, {}, {}, isclean, options, names);
        case 'fill_in_samples'
            %             options.orig_rf = 0;
            %             options.Splitmin_init = 1;
            model = cens_learnModel([cand_theta_idxs(train_idx), cand_inst_idxs(train_idx)], Theta, all_features, ytrain, cens, func.cat, func.all_values, [], cell(1,size(all_features,2)), {}, {}, {}, isclean, options, names);
            %             noncens_idx = find(cens==0);
            %             cens_idx = find(cens==1);
            %             model = cens_learnModel([cand_theta_idxs(train_idx(noncens_idx)), cand_inst_idxs(train_idx(noncens_idx))], Theta, all_features, ytrain(noncens_idx), cens(noncens_idx), func.cat, func.all_values, [], cell(1,size(all_features,2)), {}, {}, {}, isclean, options, names);
            %
            %             y_hal = log10(ytrain);
            %             [mu, vars] = applyModel(model, Xtrain(cens_idx,:), 0, 0, 0);
            %             sigma = vars.^0.5;
            %             mean_var = mean(vars)
            %             mean_sigma = mean(sigma)
            %             for i=1:length(mu)
            %                 alpha = (y_hal(cens_idx(i))-mu(i))/sigma(i);
            %                 y_hal(cens_idx(i)) = mu(i) + sigma(i) * normpdf(alpha) / (1-normcdf(alpha));
            %             end
            %             y_hal = min(y_hal, log10(options.kappa_max * options.cutoff_penalty_factor));
            %             mean_y_Hal = mean(y_hal)
            %
            %             model = cens_learnModel([cand_theta_idxs(train_idx), cand_inst_idxs(train_idx)], Theta, all_features, 10.^y_hal, zeros(length(ytrain),1), func.cat, func.all_values, [], cell(1,size(all_features,2)), {}, {}, {}, isclean, options, names);
            
        case 'dropcensdata'
            noncens_idx = find(cens==0);
            model = cens_learnModel([cand_theta_idxs(train_idx(noncens_idx)), cand_inst_idxs(train_idx(noncens_idx))], Theta, all_features, ytrain(noncens_idx), cens(noncens_idx), func.cat, func.all_values, [], cell(1,size(all_features,2)), {}, {}, {}, isclean, options, names);
        case 'ignorecensinfo'
            model = cens_learnModel([cand_theta_idxs(train_idx), cand_inst_idxs(train_idx)], Theta, all_features, ytrain, zeros(length(ytrain),1), func.cat, func.all_values, [], cell(1,size(all_features,2)), {}, {}, {}, isclean, options, names);
    end
else
    model = learnModel(Xtrain, ytrain, zeros(length(train_idx),1), func.cat, func.all_values, 0, func.deterministic, options, names);
end
timeToLearn = toc
results = {};

if plotMatrices
    fprintf(['Doing predictions ...\n']);
    [all_theta_idxs, all_inst_idxs] = get_idx_pairs(1:C, 1:I);

    %=== Light memory footprint for predictions: do it in chunks.
    chunk_size = ceil(10000000/(size(Theta,2)+size(all_features,2)));
    
    ytest = -ones(length(all_theta_idxs),1);
    start_idx = 1;
    tic;
    while start_idx <= length(all_inst_idxs)
        fprintf(['Chunk %d/%d ...\n'], ceil(start_idx/chunk_size), ceil(length(all_inst_idxs)/chunk_size));
        end_idx = min(start_idx+chunk_size, length(all_inst_idxs));
        
        [Xtest,ytest(start_idx:end_idx,1)] = getXyForIndices(Theta, all_features, matrix, all_theta_idxs(start_idx:end_idx), all_inst_idxs(start_idx:end_idx));
        [ypred(start_idx:end_idx,1), ypredvar(start_idx:end_idx,1)] = applyModel(model, Xtest, 0, 0, 0);
        start_idx = end_idx+1;
    end
    timeToPredict = toc

    if model.options.logModel
        [rmse, ll, cc, cc_rank] = measures_of_fit(log10(ytest), ypred, ypredvar);
    else
        [rmse, ll, cc, cc_rank] = measures_of_fit(log10(ytest), log10(ypred), zeros(size(ypred,1),size(ypred,2)));
    end
    fprintf('Overall: RMSE = %f, LL=%f, CC=%f, CC_rank=%f\n', [rmse, ll, cc, cc_rank]);
    title_prefix = '';

%    fullpredmatrix = 10.^(reshape(ypred, [C, I]));
%    fullpredmatrixvar = reshape(ypredvar, [C, I]);
%    assert(all(all( abs(matrix - reshape(ytest, [C, I]))<0.000001 ))); % assert that we're reshaping right.
    fullpredmatrix = 10.^(reshape(ypred, [I, C])');
    fullpredmatrixvar = reshape(ypredvar, [I, C])';
    assert(all(all( abs(matrix - reshape(ytest, [I, C])')<0.000001 ))); % assert that we're reshaping right.

    %=== Compute goodness of each configuration.
    inst_hardness = -ones(1,I);
    for i=1:I
         inst_hardness(i) = combine_performance(log10(matrix(:,i)));
    end
    [tmp,ind1] = sort(inst_hardness);

    %=== Compute goodness of each configuration.
    allscores = -ones(1,C);
    for i=1:C
         allscores(i) = combine_performance(log10(matrix(i,:)'));
    end
    [tmp,ind2] = sort(allscores);

    mkdir(['results/matrix/2d/']);
    filename = ['results/matrix/2d/', tuningScenario, '-', options.unique_model_name, '-preds'];
    fprintf(strcat(['Saving data for generating matrix plots for model ', options.unique_model_name, ' to file ', filename, '\n']));
    save(filename);
    
    % 4 sub-experiments
    learnTime = timeToLearn;
    % subplot(2,2,1);
    results{end+1} = predict_submatrix(matrix, fullpredmatrix, fullpredmatrixvar, ind1(find(ind1 <= nInstTrain)), ind2(find(ind2 <= nThetaTrain)), tuningScenario, '-trainC_trainI', options.unique_model_name, learnTime, plotMatrices);

    %subplot(2,2,2);
    results{end+1} = predict_submatrix(matrix, fullpredmatrix, fullpredmatrixvar, ind1(find(ind1 <= nInstTrain)), ind2(find(ind2 > nThetaTrain)), tuningScenario, '-testC_trainI', options.unique_model_name, learnTime, plotMatrices);

    %subplot(2,2,3);
    results{end+1} = predict_submatrix(matrix, fullpredmatrix, fullpredmatrixvar, ind1(find(ind1 >  nInstTrain)), ind2(find(ind2 <= nThetaTrain)), tuningScenario, '-trainC_testI', options.unique_model_name, learnTime, plotMatrices);

    %subplot(2,2,4);
    results{end+1} = predict_submatrix(matrix, fullpredmatrix, fullpredmatrixvar, ind1(find(ind1 > nInstTrain)), ind2(find(ind2 > nThetaTrain)), tuningScenario, '-testC_testI', options.unique_model_name, learnTime, plotMatrices);
else
    %=== 1st quadrant: if we have enough data to have train and test sets be disjoint, then do that.
    tic;
%     actual_nTest = min(length(perm), nTest);
%     test_idx = perm(end-actual_nTest+1:end); % overlaps with train for small data set
%     [Xtest,ytest] = getXyForIndices(Theta, all_features, matrix, cand_theta_idxs(test_idx), cand_inst_idxs(test_idx));
%     [ypred, ypredvar] = applyModel(model, Xtest, 0, 0, 0);
%     [rmse, ll, cc] = measures_of_fit(log10(ytest), ypred, ypredvar);
%     results{end+1} = [rmse, ll, cc];
%     nTest = nThetaTrain * nInstTrain;
    [rmse, ll, cc] = get_results_for_quadrant( model, Theta, all_features, matrix, nTest, 1:nThetaTrain, 1:nInstTrain);
    results{end+1} = [rmse, ll, cc];
    
    %=== 2nd, 3rd, and 4th quadrant: guaranteed not to overlap with training set.
    [rmse, ll, cc] = get_results_for_quadrant( model, Theta, all_features, matrix, nTest, 1:nThetaTrain, nInstTrain+1:I );
    results{end+1} = [rmse, ll, cc];
    [rmse, ll, cc] = get_results_for_quadrant( model, Theta, all_features, matrix, nTest, nThetaTrain+1:C, 1:nInstTrain );
    results{end+1} = [rmse, ll, cc];
    [rmse, ll, cc] = get_results_for_quadrant( model, Theta, all_features, matrix, nTest, nThetaTrain+1:C, nInstTrain+1:I );
    results{end+1} = [rmse, ll, cc];
    timeToPredict = toc
end

function [rmse, ll, cc] = get_results_for_quadrant( model, Theta, all_features, matrix, nTest, cand_theta_idxs, cand_inst_idxs )
new_cand_theta_idxs = repmat(cand_theta_idxs, [length(cand_inst_idxs), 1]);
new_cand_theta_idxs = new_cand_theta_idxs(:);
new_cand_inst_idxs = repmat(cand_inst_idxs', [length(cand_theta_idxs), 1]);

perm = randperm(length(new_cand_theta_idxs));
actual_nTest = min(length(perm), nTest);
test_idx = perm(end-actual_nTest+1:end);

start_idx = 1;
tic;
chunk_size = 10000;
while start_idx <= length(test_idx)
    end_idx = min(start_idx+chunk_size, length(test_idx));
    this_idxs = test_idx(start_idx:end_idx);
    [Xtest,ytest(start_idx:end_idx,1)] = getXyForIndices(Theta, all_features, matrix, new_cand_theta_idxs(this_idxs), new_cand_inst_idxs(this_idxs));
    [ypred(start_idx:end_idx,1), ypredvar(start_idx:end_idx,1)] = applyModel(model, Xtest, 0, 0, 0);
    start_idx = end_idx+1
end

% [Xtest,ytest] = getXyForIndices(Theta, all_features, matrix, new_cand_theta_idxs(test_idx), new_cand_inst_idxs(test_idx));
% [ypred, ypredvar] = applyModel(model, Xtest, 0, 0, 0);
[rmse, ll, cc, cc_rank] = measures_of_fit(log10(ytest), ypred, ypredvar);
% function [X,y] = sample_Xy_for_cand_idxs(Theta, all_features, matrix, nTest, theta_idx_candidates, inst_idx_candidates)
% [cand_theta_idxs, cand_inst_idxs] = get_idx_pairs(theta_idx_candidates, inst_idx_candidates)
% perm = randperm(1:length(cand_theta_idxs));
% perm = perm(1:nTest);
% theta_idxs = cand_theta_idxs(perm);
% inst_idxs = cand_inst_idxs(perm);
% [X,y] = getXyForIndices(Theta, all_features, matrix, theta_idxs, inst_idxs);





   
function a=combine_performance(scores)
% Other performance metrics, such as median etc could be implemented here.
a=mean(scores,1);