function do_ehm_experiments(options_vec,X,y,featureNames,exp,domain,cat,catDomains,algo_deterministic,axmin,axmax,num_folds)
seed = 1234;
if nargin < 12
    num_folds = inf;
end
if nargin < 10
    axmin = 0.001;
    axmax = 3600;
end
% Given data X and y, experiment with different models.
outdomain = strcat('results/ehm/', domain, '/');
mkdir(outdomain);

y = max(y,0.005);
log_y = log10(y);
mean_log_y = mean(log_y);
std_log_y = std(log_y);
median_log_y = median(log_y);
q25_log_y = quantile(log_y,0.25);
q75_log_y = quantile(log_y,0.75);
min_log_y = min(log_y);
max_log_y = max(log_y);
csvwrite(strcat(outdomain, '-stats.csv'), [mean_log_y,std_log_y,median_log_y,q25_log_y,q75_log_y,min_log_y,max_log_y]);

stats = []
fprintf(strcat([' Statistics of log10-transformed y for domain ', domain, ':\n mean=', num2str(mean_log_y), '\n std = ', num2str(std_log_y), '\n median = ', num2str(median_log_y), '\n q_25 = ', num2str(q25_log_y), '\n q_75 = ', num2str(q75_log_y), '\n min = ', num2str(min_log_y), '\n max = ', num2str(max_log_y), '\n']));
isTinyTest = 0;

if isTinyTest
    %=== Tiny data for debugging.
%     [X,X,cat,catDomains,featureNames] = use_feat_subset(X,X,cat,catDomains,featureNames,1:11);
%     X = X(1:20,:);
%     y = y(1:20);
end

fprintf(strcat(['EHM experiments for domain ', domain, '\n']));

% options_vec = {get_lr_jacm_options}; % completely done.


% options_vec = {get_rf_default_options};
% options_vec = {get_nn_options,get_rf_default_options};
% options_vec = {get_lr_default_options,get_spore_options_rmse,get_spore_options_rel_add,get_spore_options,get_nn_options};
% options_vec = {get_lr_default_options,get_regtree_default_options};

%% Experiment 1: Evaluate performance by cross validation.
if exp==1
    fprintf(strcat(['EHM experiment 1 for domain ', domain, '\n']));
    %options_vec = {get_rf_default_options};
    %options_vec = {get_rf_default_options,get_rf_cv_options};
    %options_vec = {get_lr_default_options};
    %options_vec = {get_rf_cv_options,get_rf_default_options,get_gp_default_options,get_lr_default_options};
%     options_vec = {get_spore_options,get_rf_cv_options,get_rf_default_options,get_regtree_default_options,get_gp_default_options,get_lr_default_options};
    
    for model_idx=1:length(options_vec)
        rand('twister', seed);
        fprintf(strcat([' Model ', num2str(model_idx), '/', num2str(length(options_vec)), ' (', options_vec{model_idx}.unique_model_name, '):\n']));
%        [rmses(model_idx,:), lls(model_idx,:), ccs(model_idx,:), learnTimes(model_idx,:), predTimes(model_idx,:)] = repeated_simple_model_perf(X, y, 1000, options_vec{model_idx}, cat, catDomains, k);
        k = 10; %10; % k-fold crossval.
        if num_folds < k
            k = num_folds;
        end
        [rmses, lls, ccs, cc_ranks, learnTimes, predTimes, y_to_plot, all_y_cross, all_y_cross_var, cens_to_plot] = crossval_model_perf(X, y, k, options_vec{model_idx}, cat, catDomains, algo_deterministic, 1, domain, axmin, axmax);
        filename = strcat(outdomain, options_vec{model_idx}.unique_model_name, '_CV-result.mat');
        mkdir(strcat(outdomain, options_vec{model_idx}.unique_model_name));
        fprintf(strcat(['Saving CV results for model ', options_vec{model_idx}.unique_model_name, ' to file ', filename, '\n']));
        save(filename, 'rmses', 'lls', 'ccs', 'cc_ranks', 'learnTimes', 'predTimes', 'y_to_plot', 'all_y_cross', 'all_y_cross_var', 'cens_to_plot');
    end
%     modelNames=cell(length(options_vec),1);
%     for i=1:length(modelNames)
%         modelNames{i,1} = options_vec{i}.modelType;
%     end
%     csvwrite(strcat(outdomain, '-all_models-rmses.csv'), rmses);
%     csvwrite(strcat(outdomain, '-all_models-ccs.csv'), ccs);
%     csvwrite(strcat(outdomain, '-all_models-lls.csv'), lls);
%     csvwrite(strcat(outdomain, '-all_models-learnTimes.csv'), learnTimes);
%     stats_names = {'RMSE', 'CC', 'LL', 'Time to learn'};
%     header_output(modelNames, stats_names);
%     fprintf(strcat(domain, ' & '));
%     n_output(mean(rmses,2),1);
%     n_output(mean(ccs,2),0);
%     n_output(mean(lls,2),0);
%     n_output(mean(learnTimes,2),1);
%     fprintf('\n');    
end

%% Experiment 2: scaling performance with # data points
if exp==2
%     plot_domain = strcat('results/ehm/scale_N/scale_N_', domain);
    
    fprintf(strcat(['EHM experiment 2 for domain ', domain, '\n']));
%     options_vec = {get_rf_cv_options,get_rf_default_options,get_regtree_default_options,get_gp_default_options,get_lr_default_options};
%     modelNames = {'RF', 'RFdef', 'RTdef','GP', 'RR'};

    maxNumTrain = length(y)*9/10;
    numTicks = 8;
    numTrains = [1];
    for i=1:numTicks-1
        numTrains(end+1) = numTrains(end) * maxNumTrain^(1/(numTicks-1));
    end
    for i=1:numTicks
        numTrains(i) = ceil(numTrains(i));
    end
        
    if isTinyTest
        numTrains = [4,8];
    end
    %numTrains = [4,8,16,32,64,128,256,512,1024];
    for model_idx = 1:length(options_vec)
        fprintf(strcat([' Model ', num2str(model_idx), '/', num2str(length(options_vec)), ' (', options_vec{model_idx}.unique_model_name, '):\n']));
        for i=1:length(numTrains)
            numTrain = numTrains(i);
            fprintf(strcat(['  numTrain = ', num2str(numTrain), '\n']));

            [rmses, lls, ccs, cc_ranks, timesToLearn, timesToPredict] = repeated_simple_model_perf(X, y, numTrain, options_vec{model_idx}, cat, catDomains, algo_deterministic, 10);

            filename = strcat(outdomain, options_vec{model_idx}.unique_model_name, '_scaleN', num2str(numTrain), '-result.mat');
            fprintf(strcat(['Saving scaling results for model ', options_vec{model_idx}.unique_model_name, ' to file ', filename, '\n']));
            save(filename, 'rmses', 'lls', 'ccs', 'cc_ranks', 'timesToLearn', 'timesToPredict');
        end
    end

%             rmse_avg(i,model_idx) = mean(rmses);
%             rmse_std(i,model_idx) = std(rmses);
%             lls_avg(i,model_idx) = mean(lls);
%             lls_std(i,model_idx) = std(lls);
%             cc_avg(i,model_idx) = mean(ccs);
%             cc_std(i,model_idx) = std(ccs);
%             timesToLearn_avg(i,model_idx) = mean(timesToLearn);
%             timesToLearn_std(i,model_idx) = std(timesToLearn);
%             timesToPredict_avg(i,model_idx) = mean(timesToPredict);
%             timesToPredict_std(i,model_idx) = std(timesToPredict);

%     csvwrite(strcat(outdomain, '-scalN-all_models-rmse_avg.csv'), rmse_avg);
%     csvwrite(strcat(outdomain, '-scalN-all_models-rmse_std.csv'), rmse_std);
% 
%     csvwrite(strcat(outdomain, '-scalN-all_models-cc_avg.csv'), cc_avg);
%     csvwrite(strcat(outdomain, '-scalN-all_models-cc_std.csv'), cc_std);
% 
%     csvwrite(strcat(outdomain, '-scalN-all_models-lls_avg.csv'), lls_avg);
%     csvwrite(strcat(outdomain, '-scalN-all_models-lls_std.csv'), lls_std);
% 
%     csvwrite(strcat(outdomain, '-scalN-all_models-timesToLearn_avg.csv'), timesToLearn_avg);
%     csvwrite(strcat(outdomain, '-scalN-all_models-timesToLearn_std.csv'), timesToLearn_std);
% 
%     csvwrite(strcat(outdomain, '-scalN-all_models-timesToPredict_avg.csv'), timesToPredict_avg);
%     csvwrite(strcat(outdomain, '-scalN-all_models-timesToPredict_std.csv'), timesToPredict_std);
% 
% %     stats_names = {'RMSE, N=64', 'RMSE, N=512', 'Time, N=64', 'Time, N=512'};
% %     header_output(modelNames, stats_names);
% %     fprintf(strcat(domain, ' & '));
% %     n_output(rmse_avg(5,:),1);
% %     n_output(rmse_avg(8,:),1);
% %     n_output(timesToLearn_avg(5,:),1);
% %     n_output(timesToLearn_avg(8,:),1);
% %     fprintf('\n');    
%     
%     plot_Scaling_N(numTrains, cc_avg, cc_std, options_vec, 'Correlation coefficient', modelNames, plot_domain, 'NorthWest');
%     plot_Scaling_N(numTrains, rmse_avg, rmse_std, options_vec, 'RMSE', modelNames, plot_domain, 'NorthEast');
%     plot_Scaling_N(numTrains, lls_avg, lls_std, options_vec, 'Test Data Log likelihood', modelNames, plot_domain);
%     plot_Scaling_N(numTrains, timesToLearn_avg, timesToLearn_std, options_vec, 'Learn Time', modelNames, plot_domain, 'NorthWest', 1);
%     plot_Scaling_N(numTrains, timesToPredict_avg, timesToPredict_std, options_vec, 'Prediction Time', modelNames, plot_domain, 'NorthWest', 1);
end



%% Experiment 3: scaling performance with #trees, size of active set, and #features.
if exp==3
%     options_vec = {get_spore_options};
    fprintf(strcat(['EHM experiment 3 for domain ', domain, '\n']));

    numTrain = 1000;
    algo_deterministic = 0;

    for model_idx = 1:length(options_vec)
        options = options_vec{model_idx};
        switch options.modelType
            case 'LR'
                numScal = [1,2,4,8,16,32,64,128];
            case 'rf'
                if strcmp(options.unique_model_name, 'RF-cv')
                    numScal = [1,2,4,8,16,32,64,128];
                else
                    numScal = [1,2,4,8,16,32,64,128,256,512,1024];
                end
            case 'GPML'
                numScal = [1,2,4,8,16,32,64,128,256,512,1024];
            case 'regression-tree'
                numScal = [1];
            case 'spore'
                numScal = [1,2,4,8,16,32,64,128];
            case 'nn'
                numScal = [1,2,4,8,16,32,64,128];
        end
        for i=1:length(numScal)
            fprintf(strcat(['  Version ', num2str(i), '/', num2str(length(numScal)), ' ...\n']));
            switch options.modelType
                case 'LR'
                    maxModelSize = numScal(i);
                    maxModelSize = (log(maxModelSize)-log(options.maxModelSize_min)) / (log(options.maxModelSize_max)-log(options.maxModelSize_min));
                    options.tuning_params(1) = maxModelSize;

                case 'rf'
                    options.nSub = numScal(i);
                case 'GPML'
                    options.ppSize = numScal(i);
                    options.trainSubSize = numScal(i);
                case 'regression-tree'
                    % no-op
                case 'spore'
                    max_terms = numScal(i);
                    max_terms = (log(max_terms)-log(options.max_terms_min)) / (log(options.max_terms_max)-log(options.max_terms_min)); 
                    options.tuning_params(3) = max_terms;
                    
                case 'nn'
                    nhidden = numScal(i);
                    nhidden = (log(nhidden)-log(options.nhidden_min)) / (log(options.nhidden_max)-log(options.nhidden_min));
                    options.tuning_params(1) = nhidden;
            end           
            [rmses, lls, ccs, cc_ranks, timesToLearn, timesToPredict] = repeated_simple_model_perf(X, y, numTrain, options, cat, catDomains, algo_deterministic, 10);
            
            filename = strcat(outdomain, options_vec{model_idx}.unique_model_name, '_scaleC', num2str(numScal(i)), '-result.mat');
            fprintf(strcat(['Saving model complexity scaling results for model ', options_vec{model_idx}.unique_model_name, ' to file ', filename, '\n']));
            save(filename, 'rmses', 'lls', 'ccs', 'cc_ranks', 'timesToLearn', 'timesToPredict');
        end
    end
end

% 
% %% Experiment 3: scaling performance with #trees, size of active set, and #features.
% if exp==3
%     outdomain = strcat('results/ehm/scale_C/', domain);
%     plot_domain = strcat('results/ehm/scale_Compl/scale_Compl_by_time_', domain);
%     clear rmses;
%     clear lls;
%     clear ccs;
%     clear timesToLearn;
%     clear timesToPredict;
%     fprintf(strcat(['EHM experiment 3 for domain ', domain, '\n']));
% 
%    
%     numScal{5} = [1];
%     fprintf(strcat([' Model type 5/5: RegTree ...\n']));
%     regtree_options = get_regtree_default_options;
%     [rmses{5}{1}, lls{5}{1}, ccs{5}{1}, timesToLearn{5}{1}, timesToPredict{5}{1}] = repeated_simple_model_perf(X, y, numTrain, regtree_options, cat, catDomains, algo_deterministic, 10);
% 
%     rmse_avg = {};
%     rmse_std = {};
%     ll_avg = {};
%     ll_std = {};
%     cc_avg = {};
%     cc_std = {};
%     timesToLearn_avg = {};
%     timesToLearn_std = {};
%     timesToPredict_avg = {};
%     timesToPredict_std = {};
%     modelTimesAvg = {};
%     for model_idx=1:5
%         for i=1:length(numScal{model_idx})
%             rmse_avg{model_idx}(i) = mean(rmses{model_idx}{i});
%             rmse_std{model_idx}(i) = std(rmses{model_idx}{i});
%             ll_avg{model_idx}(i) = mean(lls{model_idx}{i});
%             ll_std{model_idx}(i) = std(lls{model_idx}{i});
%             cc_avg{model_idx}(i) = mean(ccs{model_idx}{i});
%             cc_std{model_idx}(i) = std(ccs{model_idx}{i});
%             timesToLearn_avg{model_idx}(i) = mean(timesToLearn{model_idx}{i});
%             timesToLearn_std{model_idx}(i) = std(timesToLearn{model_idx}{i});
%             timesToPredict_avg{model_idx}(i) = mean(timesToPredict{model_idx}{i});
%             timesToPredict_std{model_idx}(i) = std(timesToPredict{model_idx}{i});
%             modelTimesAvg{model_idx}(i) = timesToLearn_avg{model_idx}(i) + timesToPredict_avg{model_idx}(i);
%         end
%         
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-rmse_avg.csv'), rmse_avg{model_idx});
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-rmse_std.csv'), rmse_std{model_idx});
% % 
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-cc_avg.csv'), cc_avg{model_idx});
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-cc_std.csv'), cc_std{model_idx});
% % 
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-lls_avg.csv'), ll_avg{model_idx});
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-lls_std.csv'), ll_std{model_idx});
% % 
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-timesToLearn_avg.csv'), timesToLearn_avg{model_idx});
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-timesToLearn_std.csv'), timesToLearn_std{model_idx});
% % 
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-timesToPredict_avg.csv'), timesToPredict_avg{model_idx});
% %         csvwrite(strcat(outdomain, '-scalComp-model,', num2str(model_idx), '-timesToPredict_std.csv'), timesToPredict_std{model_idx});
%     end
% 
%     save_file = strcat(outdomain, '_scale_C');
%     save(save_file);
% %     model_names = {'RF cv', 'RF', 'PP', 'RR', 'RegTree'};
% %     namesNumScal = {'#trees', '#trees', 'Size of active set', '#features', 'dummy'};
% %     plot_Scaling_Model_Compl(numScal, namesNumScal, cc_avg, cc_std, modelTimesAvg, 'Correlation coefficient', model_names, plot_domain, 'East');
% %     plot_Scaling_Model_Compl(numScal, namesNumScal, rmse_avg, rmse_std, modelTimesAvg, 'RMSE', model_names, plot_domain, 'NorthEast');
% %     plot_Scaling_Model_Compl(numScal, namesNumScal, ll_avg, ll_std, modelTimesAvg, 'Test Data Log likelihood', model_names, plot_domain);
% %     plot_Scaling_Model_Compl(numScal, namesNumScal, timesToLearn_avg, timesToLearn_std, modelTimesAvg, 'Learn Time', model_names, plot_domain, 'NorthWest', 1);
% %     plot_Scaling_Model_Compl(numScal, namesNumScal, timesToPredict_avg, timesToPredict_std, modelTimesAvg, 'Prediction Time', model_names, plot_domain, 'NorthWest', 1);
% end
% 

% No variable importance right now.
% if exp==4
%     fprintf(strcat(['EHM experiment 4 for domain ', domain, '\n']));
%     %=== Set up for simple model.
% %     cat = [];                        % no categorical inputs
% %     catDomains = [];                 % still none
% %     options_vec = {get_rf_default_options,get_gp_default_options,get_lr_default_options};
%     options_vec = {get_rf_default_options,get_regtree_default_options,get_gp_default_options,get_lr_default_options}; 
% 
% % %= Tiny data for debugging.    
% %     options_vec = {get_rf_default_options};
% %     X = X(1:20,1:11);
% %     y = y(1:20);
% 
%     savefilename = strcat('results/ehm/vimp-sel-val-', domain);
%     do_var_imp(options_vec, savefilename, X, y, cat, catDomains, featureNames);
% end