#ifndef __MODEL_H__
#define __MODEL_H__
double EurekaModel[] = {-0.080338, 0.472886, -0.186599, -1.961579, 2.600137, 0.061131, -0.314382, 0.509595, 0.937855, 
0.370877, -0.087093, -0.188811, -0.587693, 0.519095, -0.229859, 0.328850, 0.130302, 1.736854, -1.174155, -0.424543, 
0.274570, -0.269162, -0.928995, -0.715351, 0.358235, -0.651100, -0.489638, -0.230984, -0.383744, -0.232601, 3.152626}; 
double EurekaFeatMean[] = {0.072679, 0.163314, 0.003343, 0.048030, 0.187618, 0.346541, 0.942071, 0.894380, 0.570079, 
6271.066903, 224.240189, 0.158822, 0.032161, 0.596900, 0.035264, 0.000560, 67.486386, 0.469574, 0.373576, 0.119915, 
528.395522, 1146.970033, 0.296797, 0.075741, 0.095889, 0.124536, 0.239038, 1.512373, 0.578607, 0.000157}; 
double EurekaFeatStd[] = {0.084711, 0.212132, 0.005746, 0.048863, 0.113300, 0.444266, 1.185073, 0.884128, 0.388004, 
17972.066600, 512.533968, 0.126303, 0.107726, 0.588493, 0.039636, 0.000784, 542.921315, 1.091752, 0.498017, 0.082992, 
1152.337176, 2216.877508, 0.369688, 0.110663, 0.172975, 0.102141, 0.150696, 1.051137, 0.402682, 0.000311}; 
int EurekaFeatID1[] = {45, 13, 45, 3, 3, 37, 13, 6, 20, 45, 18, 3, 46, 8, 18, 32, 6, 13, 13, 45, 45, 20, 17, 13, 13, 
3, 14, 8, 45, 45}; 
int EurekaFeatID2[] = {17, 22, 12, 3, 0, 8, 28, 42, 20, 2, 40, 23, 7, 47, 47, 31, 2, 13, 15, 14, 40, 40, 16, 3, 45, 
20, 14, 15, 28, 26}; 
int EurekaNumFeat = 30;
double KcnfsModel[] = {-0.077794, -0.214868, -0.381859, -0.258083, -0.074809, -0.362838, 0.101140, 0.191575, 0.566405, 
-0.352178, -0.530846, 0.383658, 0.158236, 0.094245, 0.111603, -0.621035, 0.211587, -0.129706, -0.647069, 0.254992, 
-0.324933, 0.384164, -0.641307, 0.451587, 0.170476, 0.208722, -0.076355, -0.366526, 0.066227, -0.267299, 3.424590}; 
double KcnfsFeatMean[] = {0.000216, 0.000705, 0.023387, 0.001387, 0.000857, 0.193687, 0.000332, 0.003522, 0.003780, 
1.817290, 0.000018, 0.221259, 0.000560, 0.000763, 2.324640, 0.000139, 0.000984, 0.000088, 0.004883, 0.008714, 
0.249071, 0.000017, 0.025085, 0.729438, 0.570079, 30894698.352389, 1123.014462, 0.000811, 0.000625, 0.158822}; 
double KcnfsFeatStd[] = {0.000265, 0.001620, 0.022407, 0.001882, 0.006354, 0.285147, 0.000589, 0.015764, 0.010192, 
1.137599, 0.000152, 0.329634, 0.000784, 0.001411, 1.717655, 0.000453, 0.001246, 0.000180, 0.006339, 0.018059, 
0.247889, 0.000147, 0.093978, 0.398346, 0.388004, 61206668.361483, 1927.288518, 0.001101, 0.002679, 0.126303}; 
int KcnfsFeatID1[] = {24, 26, 3, 30, 9, 26, 18, 26, 9, 23, 9, 22, 31, 3, 30, 9, 9, 31, 23, 32, 23, 30, 9, 23, 20, 40, 
20, 30, 19, 23}; 
int KcnfsFeatID2[] = {18, 0, 18, 3, 36, 42, 32, 43, 14, 28, 34, 22, 32, 32, 42, 30, 3, 26, 30, 43, 17, 34, 28, 23, 20, 
1, 42, 18, 33, 3}; 
int KcnfsNumFeat = 30;
double MarchModel[] = {2.279239, -0.462673, 0.417442, -0.454747, -0.652866, -0.311059, 0.394470, 0.083393, -0.354009, 
0.226973, -0.284978, -0.176257, -0.159868, -0.359051, 0.374497, -1.247616, 0.241502, -0.166193, -0.152483, 0.164765, 
0.275688, 0.169226, 0.185124, 0.105617, 0.157853, -0.087771, -0.081157, 0.220255, -0.206689, -0.338398, 3.046912}; 
double MarchFeatMean[] = {0.272561, 0.001580, 0.082749, 0.004002, 0.135872, 0.002653, 0.000639, 0.076729, 0.008237, 
0.000625, 0.000088, 0.337443, 0.001516, 242.480864, 937.887102, 0.295044, 0.003212, 0.000188, 634.935697, 0.178928, 
0.030135, 0.029890, 12605.896364, 0.072680, 0.004640, 1.550047, 0.000260, 0.006442, 0.167626, 0.003305}; 
double MarchFeatStd[] = {0.358967, 0.002021, 0.092532, 0.005388, 0.239926, 0.016252, 0.001131, 0.401568, 0.021036, 
0.002679, 0.000180, 0.090536, 0.007105, 531.979272, 1747.732729, 0.366443, 0.003037, 0.000394, 1321.928460, 0.346663, 
0.037383, 0.088799, 48899.683376, 0.222418, 0.009947, 1.232800, 0.001296, 0.010976, 0.181787, 0.005758}; 
int MarchFeatID1[] = {22, 24, 45, 21, 22, 7, 32, 7, 36, 19, 31, 14, 19, 41, 41, 22, 14, 27, 45, 45, 37, 36, 14, 23, 
31, 8, 36, 47, 37, 33}; 
int MarchFeatID2[] = {23, 23, 47, 24, 17, 33, 5, 5, 3, 33, 26, 15, 18, 3, 15, 0, 27, 33, 1, 5, 3, 10, 1, 19, 12, 23, 
32, 33, 46, 3}; 
int MarchNumFeat = 30;
double MinisatModel[] = {-0.443475, -0.578077, -0.690745, 0.153507, -0.768900, 1.479091, 0.452834, -1.321271, 
-0.038652, -0.502180, 0.217483, 0.057281, -0.393353, 0.645562, 0.985618, -0.328752, -0.286111, 0.636972, -0.641905, 
-0.253171, -0.314205, -0.143309, 0.019882, -0.186704, 0.511993, -0.280809, 0.136619, 0.176523, -0.251981, 0.494712, 
2.694393}; 
double MinisatFeatMean[] = {0.043495, 2.251459, 0.000098, 3.974596, 0.119915, 0.200245, 1.319359, 0.178928, 0.001048, 
1.109147, 193.275914, 550.796427, 242.480864, 0.016300, 0.002035, 0.017699, 0.003288, 0.010136, 0.003962, 26.630306, 
0.023387, 0.001245, 0.632036, 0.135872, 291.314448, 0.000186, 0.193687, 0.337443, 0.004220, 2.324640}; 
double MinisatFeatStd[] = {0.040785, 1.305702, 0.000564, 2.826644, 0.082992, 0.295085, 1.014018, 0.346663, 0.001771, 
0.816489, 2099.210895, 1170.151486, 531.979272, 0.054496, 0.007890, 0.070318, 0.004160, 0.016293, 0.008598, 81.052283, 
0.022407, 0.007840, 0.347248, 0.239926, 734.530407, 0.000313, 0.285147, 0.090536, 0.013864, 1.717655}; 
int MinisatFeatID1[] = {17, 16, 12, 30, 45, 45, 30, 45, 12, 41, 19, 45, 3, 21, 12, 13, 30, 23, 12, 42, 3, 45, 23, 17, 
45, 26, 42, 15, 7, 42}; 
int MinisatFeatID2[] = {3, 28, 24, 1, 14, 25, 41, 5, 18, 4, 1, 42, 41, 4, 19, 19, 29, 7, 17, 7, 18, 34, 16, 22, 41, 
25, 26, 14, 22, 30}; 
int MinisatNumFeat = 30;
double RsatModel[] = {-0.738411, 0.621315, -0.274862, -0.880537, -0.243880, -0.452055, 1.715608, -1.162964, 0.548301, 
-0.242945, -0.730930, 0.259156, 0.110542, 0.363208, 0.165426, -0.495608, 0.544981, -0.776902, -0.455767, 0.444103, 
-0.216835, 0.340580, -0.297187, 0.194358, -0.132461, -0.449781, 0.623898, 0.534982, 0.196316, 0.357239, 2.625663}; 
double RsatFeatMean[] = {0.072679, 2.324640, 0.002007, 0.050343, 0.205684, 0.001048, 0.251694, 2.009402, 0.058362, 
0.017699, 0.000705, 0.000638, 550.796427, 0.000984, 0.193687, 0.153319, 0.644718, 0.088779, 0.000157, 6759.448430, 
75655788385.831985, 206321674.830381, 0.020896, 0.005251, 5174518.698336, 1.415041, 1.559359, 0.287626, 0.000649, 
0.000003}; 
double RsatFeatStd[] = {0.084711, 1.717655, 0.002933, 0.056035, 0.230369, 0.001771, 0.159507, 1.344832, 0.196411, 
0.070318, 0.001620, 0.001012, 1170.151486, 0.001246, 0.285147, 0.168567, 1.600001, 0.092884, 0.000311, 29931.633770, 
623730137657.478150, 546772294.480000, 0.073500, 0.008198, 20086552.390314, 0.423660, 0.952421, 0.378889, 0.002503, 
0.000020}; 
int RsatFeatID1[] = {17, 42, 16, 3, 13, 12, 45, 42, 19, 13, 26, 18, 45, 3, 42, 17, 21, 45, 45, 3, 1, 42, 19, 12, 41, 
1, 42, 1, 7, 26}; 
int RsatFeatID2[] = {45, 30, 24, 45, 29, 18, 0, 4, 19, 19, 0, 9, 42, 9, 26, 14, 10, 45, 26, 1, 2, 2, 10, 29, 41, 24, 
11, 26, 19, 26}; 
int RsatNumFeat = 30;
double VallstModel[] = {-0.688404, 0.522220, -0.119475, -0.817398, 0.167161, 0.183663, 0.080239, -0.495902, -0.742658, 
-0.212028, 0.880873, -0.084387, 0.941029, -0.032140, -1.264929, 1.172492, -1.427868, 1.015336, 0.418255, -0.642765, 
-0.387552, -0.668580, 0.192889, 0.344539, 0.201422, 0.348618, 0.701343, -0.341880, 0.262969, -0.575981, 3.480770}; 
double VallstFeatMean[] = {0.072679, 2.324640, 0.021583, 0.050343, 0.004706, 550.796427, 0.000560, 0.000266, 0.942071, 
0.000085, 0.237445, 0.010376, 0.469574, 0.575087, 0.495750, 1.024145, 0.217390, 0.010968, 0.261676, 0.039435, 
0.003343, 0.638790, 1343.771868, 0.000455, 6271.066903, 0.221259, 0.491252, 0.063279, 0.112127, 0.031975}; 
double VallstFeatStd[] = {0.084711, 1.717655, 0.056206, 0.056035, 0.010715, 1170.151486, 0.000784, 0.000715, 1.185073, 
0.000184, 0.210701, 0.059357, 1.091752, 0.383701, 0.451159, 0.809562, 0.356993, 0.019550, 0.305552, 0.077276, 
0.005746, 1.080712, 6206.835264, 0.000648, 17972.066600, 0.329634, 0.472168, 0.061483, 0.106304, 0.096738}; 
int VallstFeatID1[] = {17, 42, 12, 45, 12, 45, 31, 33, 13, 5, 45, 7, 13, 23, 45, 8, 13, 33, 13, 33, 12, 22, 33, 6, 45, 
22, 45, 18, 18, 7}; 
int VallstFeatID2[] = {45, 30, 21, 3, 13, 42, 32, 30, 28, 26, 16, 7, 13, 20, 8, 48, 48, 48, 23, 8, 45, 8, 2, 31, 2, 
22, 21, 48, 20, 0}; 
int VallstNumFeat = 30;
double ZchaffModel[] = {-0.627798, 0.563620, -0.264423, -0.728497, -1.016982, 0.602602, -0.564743, -0.125783, 
1.745033, -1.856419, 0.347408, 0.280568, -3.511595, -0.386990, 0.027842, 0.319024, -1.016629, 0.747101, 0.539473, 
-0.116430, 0.331424, -0.077420, 0.301081, -0.268792, 0.067207, 0.418416, 0.413034, 2.801654, 0.170773, 0.224049, 
3.313671}; 
double ZchaffFeatMean[] = {0.072679, 2.324640, 0.001048, 0.050343, 0.906249, 0.836935, 0.004159, 0.017699, 0.058362, 
0.078147, 28355.710147, 1.163417, 0.858524, 0.520892, 105.582337, 0.000560, 0.019531, 0.008945, 1.131782, 15.851540, 
0.179433, 0.002536, 507.587381, 218.560639, 0.112127, 0.704288, 0.003172, 0.806972, 6271.066903, 0.575087}; 
double ZchaffFeatStd[] = {0.084711, 1.717655, 0.001771, 0.056035, 0.125127, 0.343995, 0.008699, 0.070318, 0.196411, 
0.228654, 112653.481966, 5.099197, 1.494429, 0.639591, 413.305272, 0.000784, 0.071991, 0.030206, 2.727555, 209.523718, 
0.206124, 0.003723, 1095.534671, 500.166776, 0.106304, 0.666827, 0.003837, 1.484343, 17972.066600, 0.383701}; 
int ZchaffFeatID1[] = {17, 30, 12, 45, 46, 46, 44, 13, 19, 19, 3, 43, 31, 28, 36, 32, 20, 45, 44, 3, 23, 47, 45, 18, 
18, 6, 30, 44, 45, 23}; 
int ZchaffFeatID2[] = {45, 42, 18, 3, 0, 46, 32, 19, 19, 0, 2, 19, 0, 38, 39, 31, 7, 7, 25, 43, 38, 27, 39, 39, 20, 
39, 25, 31, 2, 20}; 
int ZchaffNumFeat = 30;


double EurekaRSModel[] = {-1.025628, 0.638512, -1.618888, -0.704116, -0.920665, 3.783751, 0.074688, -0.096699, 0.090690, -0.330877, -0.111351, -13.576824, 0.123067, 0.921587, 1.922662, -4.752912, -0.037736, -0.566690, -0.052740, 2.048390, 0.305171, -0.201529, -0.023773, -13.576824, 0.090140, 0.237419, 0.000000, 0.000000, 0.000000, 0.000000, 1.344128}; 
double EurekaRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.008638, -0.001548, 0.001606, 0.000480, 3.256381}; 
double EurekaRSFeatMean[] = {1.717253, 98.528858, 0.017071, 0.079028, 0.176513, 1.832994, 0.044734, 52978.344226, 5.706511, 1.276793, 0.192751, 0.003641, 0.267588, 0.071581, 9.186956, 1.277835, 0.001262, 0.017120, 0.635458, 0.017071, 1.276780, 2.519848, 0.000025, 0.003641, 0.000979, 0.102773, 0.000001, 0.002652, 0.123068, 0.000160}; 
double EurekaRSFeatStd[] = {8.112059, 512.001677, 0.069726, 0.074891, 0.755830, 8.555961, 0.015696, 75940.629791, 34.828372, 0.293415, 0.113028, 0.049583, 0.790233, 0.371347, 48.128138, 7.209153, 0.002064, 0.069721, 5.705265, 0.069727, 0.293457, 10.106246, 0.000081, 0.049583, 0.001553, 0.050607, 0.000006, 0.007292, 0.485562, 0.001491}; 
int EurekaRSFeatID1[] = {40, 40, 40, 3, 19, 19, 3, 51, 40, 44, 3, 22, 51, 51, 22, 44, 8, 40, 52, 40, 44, 44, 10, 23, 46, 3, 35, 3, 35, 3}; 
int EurekaRSFeatID2[] = {63, 40, 4, 63, 51, 44, 47, 2, 52, 4, 23, 22, 10, 22, 2, 22, 26, 12, 52, 9, 9, 10, 26, 22, 26, 29, 26, 36, 45, 35}; 
double EurekaClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double EurekaClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int EurekaRSNumFeat = 30;
double KcnfsRSModel[] = {-0.102609, 0.967428, -0.147629, 2.971777, -1.132442, -0.119488, -1.107014, -0.525219, 1.295670, 0.090514, -0.695220, -0.108760, 3.031860, -9.588933, 0.021598, -1.143816, 1.528723, 0.218646, -1.506311, 3.431750, -0.337645, -0.035392, 0.045783, -1.219829, 1.758776, -0.314233, 0.832193, -2.256583, 3.036600, -17.353166, 0.350687, 0.387142, 0.359347, -0.103255, 0.488289, 9.666144, -0.705087, 5.085857, -0.085741, -2.087074, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.977392}; 
double KcnfsRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -2.428005, 1.774154, -0.070944, -4.449275, 0.833691, 0.045878, -0.020853, 0.441686, -2.740154, -1.159488, 2.609118, 1.692295, 2.228567, -0.236866, -0.439397, 0.002651, 5.723467, -1.295636, 2.690864, -2.222545, -1.056146, 1.127894, -3.798863, 2.988683, 0.053187, -1.589356, 0.137664, -0.085242, 1.728837, 1.312224, -0.323949, -3.380076, -0.070534, 1.300317, 0.007117, -0.098674, 0.054830, 3.189740}; 
double KcnfsRSFeatMean[] = {0.002735, 228.943213, 0.170836, 6.363383, 3.488411, 0.000413, 0.000622, 0.030317, 0.557210, 4.758231, 0.000601, 0.010540, 0.102773, 8.567662, 0.001699, 39.133037, 8.871535, 0.003611, 1056.239817, 10.215414, 0.001679, 5.651912, 0.005807, 0.154353, 63.545369, 0.325202, 0.022386, 38.430559, 4.010308, 851.176660, 0.000780, 5.157226, 0.121163, 0.209227, 36.570609, 616.841284, 0.213796, 10973.479215, 0.000240, 51.149259, 0.024229, 0.015711, 202.178096, 0.693743, 2.050300, 19.829653, 0.207613, 94.073523, 1.909942, 0.004912, 1.427472, 0.617261, 71.128437, 91.831457, 0.005123, 0.000311, 624707.207971, 18763.413248, 0.233401, 678.636232, 0.734405, 47.836232, 205817.855072, 309.631884, 0.001567, 6.372699, 0.005112, 0.004787, 0.005123, 6210.942663, 0.015790, 271830.371014, 1.586850, 21.998468, 0.000104, 0.283897, 95.280627}; 
double KcnfsRSFeatStd[] = {0.001552, 870.803993, 0.017175, 3.502183, 3.438891, 0.000667, 0.002189, 0.015320, 0.151064, 3.292165, 0.000437, 0.005863, 0.050607, 8.445582, 0.001806, 21.349436, 8.351780, 0.002887, 4723.460599, 9.832785, 0.001115, 4.945568, 0.009204, 0.061319, 23.788682, 0.177837, 0.073976, 19.295640, 3.067341, 1994.905000, 0.000477, 1.186845, 0.078378, 0.056981, 24.491013, 1510.634024, 0.075403, 13528.034047, 0.000341, 48.980092, 0.014933, 0.012823, 147.621827, 0.369024, 0.726082, 23.458838, 0.276268, 40.874131, 1.278480, 0.002820, 0.942657, 0.402838, 31.252875, 59.514033, 0.002856, 0.000855, 689955.660153, 26032.374937, 0.168878, 405.460641, 0.194694, 23.910831, 209668.905185, 155.470728, 0.000809, 4.125286, 0.003178, 0.008899, 0.002856, 7992.862324, 0.010342, 276230.213187, 0.540608, 19.177515, 0.000166, 0.170384, 58.366480}; 
int KcnfsRSFeatID1[] = {7, 40, 54, 39, 51, 23, 13, 23, 24, 39, 17, 23, 29, 51, 32, 3, 51, 58, 40, 39, 27, 40, 52, 29, 58, 23, 13, 42, 51, 39, 24, 28, 62, 15, 17, 51, 29, 1, 40, 39, 33, 33, 50, 20, 55, 36, 39, 45, 45, 20, 43, 20, 63, 45, 20, 33, 55, 39, 20, 55, 43, 33, 43, 45, 59, 39, 20, 36, 20, 39, 33, 45, 43, 39, 12, 20, 43}; 
int KcnfsRSFeatID2[] = {3, 44, 14, 62, 17, 26, 11, 49, 44, 52, 24, 30, 3, 29, 3, 44, 14, 27, 1, 29, 3, 51, 30, 62, 44, 59, 58, 44, 42, 39, 3, 28, 62, 62, 44, 51, 29, 39, 26, 28, 0, 15, 55, 0, 24, 2, 36, 63, 32, 11, 32, 20, 43, 50, 9, 36, 55, 55, 63, 0, 24, 2, 55, 0, 24, 63, 27, 59, 4, 43, 20, 55, 27, 0, 27, 59, 59}; 
double KcnfsClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double KcnfsClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int KcnfsRSNumFeat = 77;
double MarchRSModel[] = {0.048605, 2.113197, 0.082689, -0.849321, 1.049080, -0.461855, -0.084155, 0.727905, -1.065976, -1.662293, -2.000224, 0.441260, -0.009564, 1.568682, -0.396584, 1.170463, -0.303135, -1.548105, -0.184647, -1.447882, 0.907952, 0.031989, -2.410384, 1.076795, -3.604256, 0.918343, 0.410016, 2.944369, -0.136779, -0.948972, 2.417081, -0.664219, -0.655124, 0.089271, -0.839695, 1.127249, -1.790996, 1.092416, 0.651663, -1.502594, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.201213}; 
double MarchRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.481497, 0.555936, -0.220550, 0.752108, -0.502992, -0.931800, 0.365046, -0.465386, 2.075229, -1.064839, 1.928773, -0.284467, 0.206076, 0.206446, -0.056967, -0.446460, -0.143655, 0.459707, -1.304673, 1.413431, 7.810250, 0.254554, -0.448631, 0.411910, 0.160725, -10.918056, 0.089613, 0.197178, 0.022994, -0.067347, 0.024530, -0.161800, 0.155308, 0.204991, -0.028531, 3.165978}; 
double MarchRSFeatMean[] = {0.143512, 5.330332, 0.103404, 0.064229, 0.002921, 0.001993, 4.083835, 98.345133, 0.307261, 15.843221, 0.030317, 0.528347, 0.008549, 1717.557971, 431.618841, 0.097833, 0.186348, 0.275377, 0.019311, 0.837316, 0.008223, 0.002841, 616.841284, 0.006896, 0.039900, 1.738571, 0.005023, 0.066958, 0.170836, 0.481718, 0.071121, 0.283294, 0.034874, 0.003362, 0.053316, 0.097181, 0.028414, 0.082495, 0.448490, 0.010853, 0.059941, 11.493941, 0.001421, 0.000060, 0.035997, 0.042924, 0.051001, 18.697101, 657.266684, 0.004453, 0.005059, 0.207612, 0.734949, 0.059784, 0.000137, 0.002430, 0.260604, 0.000018, 0.002085, 1409.416939, 0.007856, 0.016744, 119701.686232, 7.787039, 0.178133, 0.000898, 0.451911, 0.133758, 0.013874, 2.215136, 0.000004, 220302.901449, 0.108574, 0.867442, 0.177134}; 
double MarchRSFeatStd[] = {0.143978, 3.495585, 0.014025, 0.016340, 0.008322, 0.006947, 2.862464, 281.344984, 0.042891, 17.859218, 0.015320, 0.088533, 0.002976, 1119.198534, 171.136586, 0.046320, 0.068742, 0.060752, 0.004579, 0.463165, 0.002943, 0.003209, 1510.634024, 0.003651, 0.025121, 1.201683, 0.005312, 0.043185, 0.017175, 0.338981, 0.065620, 0.137522, 0.098582, 0.006036, 0.047249, 0.024547, 0.016688, 0.024381, 0.243674, 0.030161, 0.036717, 9.625950, 0.001036, 0.000269, 0.029279, 0.017743, 0.018626, 23.058382, 439.806621, 0.003269, 0.012420, 0.071052, 0.555739, 0.042418, 0.000171, 0.010374, 0.080652, 0.000078, 0.009122, 2399.757079, 0.022811, 0.021763, 97064.921719, 3.032483, 0.207571, 0.006290, 0.318166, 0.134008, 0.014267, 1.254283, 0.000020, 200504.409942, 0.042854, 0.640775, 0.164256}; 
int MarchRSFeatID1[] = {63, 63, 42, 42, 61, 17, 51, 2, 54, 51, 49, 15, 49, 2, 2, 49, 15, 15, 61, 63, 61, 25, 51, 49, 42, 8, 23, 54, 54, 8, 50, 54, 13, 36, 3, 29, 15, 54, 15, 42, 51, 15, 31, 19, 30, 61, 42, 32, 50, 31, 59, 64, 61, 21, 7, 19, 15, 19, 42, 64, 64, 32, 1, 53, 39, 6, 39, 32, 39, 56, 19, 56, 50, 61, 56}; 
int MarchRSFeatID2[] = {63, 51, 14, 50, 13, 36, 52, 13, 60, 23, 23, 60, 3, 23, 3, 21, 50, 29, 14, 21, 3, 32, 51, 31, 5, 23, 32, 5, 14, 5, 3, 23, 60, 50, 3, 42, 61, 42, 16, 13, 24, 51, 27, 11, 21, 0, 42, 2, 2, 33, 11, 54, 51, 33, 27, 64, 59, 24, 19, 2, 11, 21, 43, 7, 11, 9, 33, 51, 26, 32, 26, 1, 54, 39, 26}; 
double MarchClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double MarchClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int MarchRSNumFeat = 75;
double MinisatRSModel[] = {-1.061468, 1.483815, 0.090750, 1.218714, -0.122864, 19.165207, -0.660762, -0.142118, 0.153254, -1.015755, 2.517337, 0.008945, -1.750137, 0.006377, -2.378514, 0.882267, -2.155499, -19.359901, 0.893443, 0.471195, -3.969740, 2.724118, -2.063443, -0.516690, 0.002701, 0.118897, 0.954842, -0.281505, -0.034857, -1.561074, 5.800444, 0.712183, -1.178431, 0.491095, 0.066839, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.453138}; 
double MinisatRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.142249, -0.103116, 3.083032, 0.083130, 0.125329, -1.257835, -0.588359, -2.181281, -1.880883, 0.274658, -1.116467, 0.574248, 0.830183, -8.185559, -0.584418, 0.171186, -0.021458, 1.252402, -5.386362, -3.493567, 1.548102, 5.729999, 0.579039, 0.015793, -0.190891, 1.473410, 0.432794, -0.559432, -4.742198, -0.756299, 0.668826, -0.052378, -7.970423, 0.012674, -0.151259, -2.676822, -2.062526, -0.486472, 25.950316, -0.594639, 3.368785}; 
double MinisatRSFeatMean[] = {1.286102, 0.005951, 0.002370, 0.065446, 47.836232, 0.000946, 0.001463, 0.305083, 0.070321, 0.014526, 0.017369, 0.000601, 0.000292, 0.069025, 0.000318, 3.129380, 851.176660, 0.001004, 0.032175, 4.794461, 0.019558, 0.000348, 0.000590, 1.218327, 0.012573, 0.005151, 0.003263, 0.002710, 0.013898, 0.003303, 0.002694, 0.002085, 0.000881, 0.005151, 0.003263, 12.479911, 0.000311, 0.016012, 71.128437, 2.139640, 1.427472, 0.003799, 0.000590, 0.023717, 0.005255, 0.025105, 120.284410, 0.000197, 0.011893, 385.501370, 0.002893, 0.005023, 2.830285, 0.000862, 222.742618, 315.267130, 0.000461, 0.000810, 156.451590, 0.702238, 72.932963, 362.440304, 51.359313, 0.009920, 0.000198, 2.215136, 214.692695, 0.010321, 0.005573, 0.283294, 0.003209, 0.010129, 3.881856, 0.007856, 212.717631}; 
double MinisatRSFeatStd[] = {5.426274, 0.023912, 0.001536, 0.263477, 23.910831, 0.003218, 0.001171, 0.055979, 0.366815, 0.011539, 0.017891, 0.000437, 0.000815, 0.073564, 0.002288, 3.085426, 1994.905000, 0.003390, 0.027514, 3.983122, 0.083570, 0.000887, 0.001061, 5.576576, 0.004192, 0.007173, 0.004297, 0.007741, 0.004599, 0.004329, 0.023552, 0.009122, 0.003069, 0.007173, 0.004297, 4.258099, 0.000855, 0.013261, 31.252875, 0.747336, 0.942657, 0.001740, 0.001061, 0.040252, 0.003524, 0.013993, 52.259316, 0.000328, 0.027492, 226.024111, 0.002106, 0.005312, 2.141971, 0.003499, 361.238211, 442.483248, 0.000973, 0.001183, 96.828755, 0.061591, 107.008499, 193.120126, 28.379041, 0.010079, 0.000328, 1.254283, 117.026294, 0.024893, 0.015272, 0.137522, 0.010507, 0.024337, 2.246722, 0.022811, 118.151681}; 
int MinisatRSFeatID1[] = {40, 13, 50, 40, 2, 13, 17, 16, 22, 64, 16, 17, 32, 47, 22, 18, 39, 13, 16, 47, 28, 30, 30, 40, 49, 4, 50, 52, 61, 50, 22, 19, 13, 14, 50, 57, 33, 63, 63, 53, 43, 24, 33, 58, 33, 64, 64, 37, 11, 1, 63, 23, 1, 11, 53, 57, 30, 33, 53, 60, 43, 64, 43, 64, 38, 56, 63, 48, 36, 23, 11, 11, 53, 64, 64}; 
int MinisatRSFeatID2[] = {16, 17, 27, 49, 33, 4, 9, 14, 39, 33, 33, 24, 32, 52, 61, 39, 39, 12, 61, 39, 19, 32, 33, 25, 50, 14, 9, 6, 25, 12, 62, 42, 6, 9, 4, 30, 36, 49, 43, 24, 32, 0, 30, 49, 47, 49, 43, 26, 0, 23, 27, 32, 32, 49, 52, 52, 30, 33, 3, 60, 52, 53, 3, 30, 26, 32, 53, 11, 58, 54, 47, 60, 32, 11, 56}; 
double MinisatClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double MinisatClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int MinisatRSNumFeat = 75;
double RsatRSModel[] = {-3.430970, 0.796390, -0.095692, -3.699202, -0.211871, -0.403257, 0.474756, 0.295167, 0.673247, -2.448727, -0.235273, 0.000548, 0.928761, -9.976444, -0.158615, -1.274471, -0.471943, 1.492193, -4.895733, 0.536902, -0.566353, 0.692293, 3.159239, 1.853883, -0.659498, 1.176214, 0.422225, -0.081769, 0.092008, 7.971071, 2.469053, -0.629494, -0.373260, 0.168100, 0.506533, -0.118118, 0.022765, 1.964355, -0.206096, 0.974927, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.319829}; 
double RsatRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 12.011537, -0.021297, -7.449134, 1.231321, -1.827197, -0.145168, -0.092084, 0.760295, -0.061720, -0.070844, -0.494410, 0.802966, -5.890618, 0.530014, 3.078265, -4.984018, 1.503219, 0.660887, -1.043748, 0.340041, 4.521169, 2.331062, 0.438997, -0.021913, 0.081132, 0.141422, -2.961617, 0.049704, 0.327555, -0.420607, 0.777833, 0.041612, 0.216780, 0.381121, -0.507179, 0.127366, -0.152813, 0.515438, -0.860602, -0.539898, 3.665974}; 
double RsatRSFeatMean[] = {2.097353, 10.726542, 2.078067, 851.176660, 98.528858, 0.002533, 0.002786, 19.829653, 48.123487, 0.000612, 62162.728370, 0.856326, 0.001270, 0.001388, 120008.020290, 0.004527, 0.207613, 0.007715, 0.000086, 0.023030, 0.000067, 1.401201, 0.002623, 0.000619, 14805599.094203, 2511.244928, 4.761553, 16.447826, 0.007767, 0.001377, 2.238054, 0.000333, 0.003872, 16.295109, 8.691910, 1047.528501, 0.220408, 0.001506, 1056.239817, 0.001377, 140.713109, 0.217437, 214.692695, 706.936242, 213.083039, 0.097181, 0.136259, 2.609632, 0.019070, 246.989336, 220302.901449, 5.330332, 215540.108696, 110.249635, 591010.845728, 50.813011, 599.187499, 7.787039, 312.764050, 0.010451, 1999.892300, 18.545697, 0.207612, 15.141799, 5.651912, 0.042924, 0.065446, 0.001081, 528.661468, 0.856326, 2.048420, 4.014056, 8.231241, 503.096805, 2.744264, 113.699900, 0.005492, 15.843221, 312.715970, 362.440304}; 
double RsatRSFeatStd[] = {9.668137, 6.795797, 0.415497, 1994.905000, 512.001677, 0.004993, 0.007285, 23.458838, 59.990802, 0.000371, 87355.894161, 3.748726, 0.000778, 0.000918, 113012.789434, 0.002522, 0.276268, 0.002674, 0.000882, 0.107436, 0.000052, 6.515480, 0.023662, 0.000413, 82478627.233412, 2917.461848, 3.573820, 10.133551, 0.034808, 0.000897, 9.677588, 0.002435, 0.044504, 4.719025, 7.548820, 1352.587588, 0.049020, 0.022929, 4723.460599, 0.000897, 74.292640, 0.065276, 117.026294, 418.754804, 138.368087, 0.024547, 0.036621, 2.631854, 0.031929, 138.592576, 200504.409942, 3.495585, 152852.116438, 81.268069, 481282.704948, 62.829516, 354.194815, 3.032483, 194.166884, 0.006816, 1639.220317, 16.531621, 0.071052, 8.204353, 4.945568, 0.017743, 0.263477, 0.000700, 276.187926, 3.748726, 8.985141, 4.542912, 3.992434, 306.310521, 0.764785, 63.100829, 0.003012, 17.859218, 166.169530, 193.120126}; 
int RsatRSFeatID1[] = {40, 39, 11, 39, 40, 36, 36, 2, 39, 31, 39, 40, 31, 5, 45, 64, 39, 27, 22, 40, 27, 40, 22, 5, 2, 2, 39, 2, 40, 5, 40, 22, 22, 61, 39, 2, 47, 22, 40, 5, 1, 14, 53, 53, 23, 42, 54, 51, 36, 53, 1, 63, 1, 53, 41, 21, 53, 53, 2, 49, 21, 51, 64, 61, 51, 61, 49, 12, 64, 54, 60, 1, 33, 57, 41, 41, 23, 23, 57, 64}; 
int RsatRSFeatID2[] = {64, 64, 45, 39, 40, 47, 37, 36, 8, 24, 2, 54, 11, 12, 45, 27, 36, 0, 9, 27, 27, 62, 54, 24, 2, 0, 42, 27, 24, 9, 0, 49, 64, 1, 58, 59, 0, 37, 1, 4, 63, 29, 63, 0, 41, 29, 54, 18, 8, 54, 56, 51, 1, 18, 2, 51, 48, 7, 18, 42, 53, 0, 54, 56, 40, 0, 40, 18, 57, 40, 40, 36, 56, 14, 7, 29, 9, 51, 63, 53}; 
double RsatClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double RsatClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int RsatRSNumFeat = 80;
double VallstRSModel[] = {0.061547, 0.354518, 0.758215, -0.194872, -0.114126, -1.403538, -0.241262, -0.384351, 0.138402, -0.264973, -4.299772, 1.110367, 1.149758, -0.254434, -0.000578, -0.935158, 0.415665, 1.083752, 0.268965, 0.081708, -1.258096, -0.029897, -0.496232, -0.029265, -0.834415, -0.127058, -0.247228, 0.033707, 0.129162, -0.016410, -0.073747, -0.137246, -0.084840, 10.083563, -42.109529, -5.316763, -5.316763, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.277348}; 
double VallstRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.018610, -0.024101, 0.048037, 0.001694, -0.043809, 3.250577}; 
double VallstRSFeatMean[] = {1.286102, 98.528858, 1.401201, 0.013898, 0.007176, 2.238054, 0.002431, 0.048513, 0.082820, 0.014269, 0.007068, 0.002686, 0.673861, 0.000050, 0.000240, 0.448490, 0.000595, 0.042924, 667.281272, 0.002304, 0.002089, 0.017543, 616.841284, 63.978405, 0.015583, 494.851658, 0.000049, 0.000088, 0.006996, 0.724202, 0.011829, 0.504643, 0.315674, 0.002694, 0.002502, 0.003641, 0.003641, 0.000004, 0.008236, 0.000067, 0.000461, 0.001265}; 
double VallstRSFeatStd[] = {5.426274, 512.001677, 6.515480, 0.004599, 0.030814, 9.677588, 0.025354, 0.043696, 0.042964, 0.004277, 0.062069, 0.024393, 0.225008, 0.000082, 0.000341, 0.243674, 0.000834, 0.017743, 523.825281, 0.002363, 0.008763, 0.004171, 1510.634024, 39.059492, 0.013702, 314.202058, 0.000082, 0.000336, 0.032153, 0.507432, 0.012538, 0.390371, 0.218341, 0.023552, 0.033259, 0.049583, 0.049583, 0.000020, 0.034626, 0.000310, 0.000973, 0.005362}; 
int VallstRSFeatID1[] = {40, 40, 40, 25, 13, 40, 22, 63, 18, 62, 22, 22, 16, 49, 40, 15, 15, 61, 8, 49, 13, 29, 51, 45, 63, 29, 61, 13, 13, 63, 51, 16, 8, 22, 22, 22, 22, 19, 19, 19, 30, 19}; 
int VallstRSFeatID2[] = {16, 40, 62, 61, 38, 0, 52, 18, 16, 49, 15, 25, 0, 26, 26, 16, 26, 0, 45, 49, 18, 61, 51, 38, 61, 57, 26, 26, 23, 8, 26, 16, 18, 62, 63, 23, 22, 26, 0, 30, 30, 19}; 
double VallstClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double VallstClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int VallstRSNumFeat = 42;
double ZchaffRSModel[] = {0.191239, 0.747771, 1.246568, -0.251174, -0.635958, 1.566679, -0.992587, -0.337732, 0.434551, 0.047005, 0.026290, -0.100965, -0.378022, -0.025585, -0.036161, 0.023846, 0.229720, -0.196297, -2.939295, 0.020773, -0.471640, 0.263710, -0.794090, 0.529574, -0.037728, -0.230717, -0.052735, -0.012612, 0.076518, 0.000000, 2.972836}; 
double ZchaffRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.000001, 3.255261}; 
double ZchaffRSFeatMean[] = {1.286102, 98.528858, 2.097353, 0.013736, 0.024112, 0.313501, 0.082472, 0.010613, 0.504643, 5.154938, 0.000072, 616.841284, 0.351631, 0.141459, 0.176618, 0.000046, 9254.640989, 0.028414, 2.238054, 5.706511, 0.213796, 0.017543, 6.321220, 1.401201, 0.006946, 5.024966, 0.000619, 0.001158, 5.346913, 0.007715}; 
double ZchaffRSFeatStd[] = {5.426274, 512.001677, 9.668137, 0.004283, 0.017605, 0.161400, 0.041525, 0.031026, 0.390371, 3.421600, 0.000095, 1510.634024, 0.107851, 0.050085, 0.239002, 0.000323, 11649.863180, 0.016688, 9.677588, 34.828372, 0.075403, 0.004171, 5.553639, 6.515480, 0.003996, 21.917178, 0.000413, 0.007767, 2.938025, 0.002674}; 
int ZchaffRSFeatID1[] = {40, 40, 40, 62, 18, 18, 18, 52, 16, 8, 5, 51, 64, 47, 51, 18, 51, 61, 40, 40, 29, 61, 51, 40, 49, 40, 5, 13, 62, 27}; 
int ZchaffRSFeatID2[] = {16, 40, 64, 61, 18, 28, 15, 13, 16, 8, 26, 51, 15, 15, 36, 35, 1, 15, 0, 52, 29, 29, 25, 62, 5, 8, 24, 36, 51, 0}; 
double ZchaffClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double ZchaffClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int ZchaffRSNumFeat = 30;
double EurekaWPRSModel[] = {0.998908, 0.366853, -1.758564, -0.590195, -0.228801, -0.342554, -0.188669, 0.532012, -0.488945, -0.137309, -0.384107, -1.318139, 2.218259, 0.131462, 0.498063, -0.565452, 0.489640, -1.090574, 0.001562, 0.653141, -0.834274, 0.457085, -0.028930, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 4.097623}; 
double EurekaWPRUModel[] = {0.000000, -0.746455, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.064261, -0.014575, -0.300651, -0.141335, 1.439404, 0.961813, 0.161818, 0.652654, 0.263409, 0.039243, 0.750483, 0.872059, 0.760628, -0.400261, 0.379516, 1.341468, -0.140153, 0.118684, -0.768729, -1.407075, 0.224578, -0.032842, -0.001140, -0.363734, 0.230370, -1.315072, 0.809652, 3.978209}; 
double EurekaWPRSFeatMean[] = {1.286102, 98.528858, 2.097353, 2608.950942, 0.504643, 0.008549, 0.051572, 1.509823, 0.002362, 0.072959, 0.376554, 4793.371014, 851.176660, 5.668874, 14805599.094203, 0.004666, 0.004891, 0.005099, 0.324102, 0.001779, 6057.818274, 6187.628322, 5.157226, 1.918191, 0.000197, 0.001126, 0.006596, 0.070007, 4.394079, 0.123787, 0.302130, 2.097353, 0.003182, 2.045489, 0.985166, 2.238054, 5.706511, 0.023030, 0.635458, 0.069025, 0.000278, 0.007767, 0.287468, 0.000437, 0.000240, 0.000005, 0.017407, 0.042414, 0.065446, 0.037010}; 
double EurekaWPRSFeatStd[] = {5.426274, 512.001677, 9.668137, 9437.911570, 0.390371, 0.002976, 0.027953, 0.685750, 0.001649, 0.015308, 0.173727, 6438.296172, 1994.905000, 3.669003, 82478627.233412, 0.004669, 0.013450, 0.002666, 1.553714, 0.001136, 8919.542872, 5476.930925, 1.186845, 0.252879, 0.000328, 0.001101, 0.002403, 0.328287, 18.514128, 0.037881, 1.175131, 9.668137, 0.001337, 8.952046, 4.324754, 9.677588, 34.828372, 0.107436, 5.705265, 0.073564, 0.000431, 0.034808, 1.091336, 0.000615, 0.000341, 0.000039, 0.028188, 0.085179, 0.263477, 0.166982}; 
int EurekaWPRSFeatID1[] = {40, 40, 40, 40, 16, 3, 18, 16, 31, 62, 64, 39, 39, 40, 2, 50, 40, 18, 40, 18, 28, 21, 28, 28, 37, 49, 27, 33, 28, 64, 42, 64, 27, 40, 40, 40, 52, 27, 52, 52, 33, 24, 40, 33, 26, 11, 7, 28, 49, 7}; 
int EurekaWPRSFeatID2[] = {16, 40, 64, 2, 16, 49, 58, 21, 7, 42, 16, 44, 39, 39, 2, 7, 6, 61, 37, 7, 2, 2, 28, 48, 26, 33, 48, 40, 40, 42, 40, 40, 59, 48, 59, 0, 40, 40, 52, 47, 11, 40, 47, 7, 40, 35, 0, 7, 40, 40}; 
double EurekaWPClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double EurekaWPClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int EurekaWPRSNumFeat = 50;
double KcnfsWPRSModel[] = {-0.545608, 0.279194, -0.992882, 1.148745, -0.390534, -1.429424, 0.241957, 0.221844, 1.510351, 20.532626, -0.414371, -0.148841, 2.109532, -0.772473, -0.521025, 0.619906, -1.362829, -5.494306, 0.221523, 1.008290, -0.843444, 0.792767, -3.982450, 0.361347, -0.771481, 0.670275, 0.052365, 2.059152, -26.125467, -1.010646, -1.520191, -0.497452, 0.449481, 2.091987, -1.872368, -2.550378, 6.542291, 4.483374, -0.026396, 0.186434, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.811772}; 
double KcnfsWPRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.038106, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.327976, 5.013667, 2.991398, 0.877177, -0.045324, 1.707610, 5.319122, -4.263658, 0.012649, -0.878382, -2.306950, -0.369760, -0.866912, -0.192832, 0.716322, -0.012146, 2.408855, -5.461077, 0.349530, 0.606499, 0.128317, 0.821793, 2.408643, 0.076017, 0.052913, -0.040420, 0.006595, 0.024317, 3.745426, -3.024403, 1.911089, -3.494494, -2.406919, -0.417289, 0.107345, 0.197065, 1.361262, -0.018023, -2.533484, 4.162383}; 
double KcnfsWPRSFeatMean[] = {0.002651, 1056.239817, 0.005548, 0.000075, 0.086711, 0.000946, 0.001263, 4.083835, 6.363383, 616.841284, 0.029092, 0.000413, 0.000102, 0.001054, 0.177543, 0.137868, 152.730821, 18.545697, 0.000137, 0.005023, 0.018255, 0.275377, 0.000052, 0.006996, 5.706511, 0.161571, 0.000001, 0.282090, 723.413837, 0.009319, 8.988725, 5.239195, 4.154862, 0.000049, 0.000050, 18763.413248, 10973.479215, 6.647382, 0.000172, 276.738594, 0.015474, 0.633001, 209.973856, 0.048168, 0.004353, 0.123787, 231.468534, 0.413572, 0.002601, 0.025105, 0.039587, 0.004527, 0.106289, 0.001567, 0.001421, 123.891911, 189.735258, 123.250416, 4.761553, 146.763197, 40.497443, 215540.108696, 67.696760, 0.076794, 0.151059, 16.532333, 0.075141, 0.310781, 71983.451463, 1034046.411594, 436984.863768, 120008.020290, 162412.708987, 1.205243, 6.321220, 0.975516, 122552.139969, 7.595289, 52.162780}; 
double KcnfsWPRSFeatStd[] = {0.001432, 4723.460599, 0.003190, 0.000122, 0.050514, 0.003218, 0.000630, 2.862464, 3.502183, 1510.634024, 0.014723, 0.000667, 0.000163, 0.001058, 0.139000, 0.052708, 54.103997, 16.531621, 0.000171, 0.005312, 0.004290, 0.060752, 0.000101, 0.032153, 34.828372, 0.469173, 0.000006, 0.240237, 1735.307301, 0.021981, 8.644182, 1.282690, 4.023151, 0.000082, 0.000082, 26032.374937, 13528.034047, 5.841938, 0.003983, 196.369825, 0.009328, 0.113582, 150.911553, 0.040085, 0.008430, 0.037881, 98.856601, 0.166381, 0.005086, 0.013993, 0.023595, 0.002522, 0.082663, 0.000809, 0.001036, 91.290973, 98.113046, 53.055527, 3.573820, 77.053466, 51.554876, 152852.116438, 35.138420, 0.052882, 0.040523, 17.621955, 0.019136, 0.285489, 67384.987217, 720163.566897, 361271.429372, 113012.789434, 161952.598968, 0.411132, 5.553639, 0.254791, 98855.355788, 7.528634, 26.537183}; 
int KcnfsWPRSFeatID1[] = {62, 40, 23, 7, 17, 13, 62, 51, 39, 51, 23, 23, 27, 17, 59, 62, 1, 51, 7, 23, 29, 15, 24, 13, 40, 52, 26, 39, 51, 15, 39, 1, 17, 26, 49, 39, 1, 51, 40, 55, 8, 15, 50, 31, 36, 42, 1, 15, 36, 64, 31, 64, 31, 59, 31, 50, 15, 64, 39, 15, 8, 1, 45, 31, 59, 39, 42, 53, 41, 2, 2, 45, 44, 44, 51, 45, 1, 51, 42}; 
int KcnfsWPRSFeatID2[] = {27, 1, 12, 24, 29, 9, 24, 52, 62, 51, 61, 26, 9, 32, 59, 59, 54, 0, 27, 32, 49, 29, 11, 23, 52, 62, 35, 7, 39, 9, 59, 7, 39, 61, 26, 55, 39, 54, 34, 59, 27, 0, 53, 31, 54, 64, 64, 15, 42, 49, 42, 27, 64, 24, 27, 56, 45, 41, 42, 41, 51, 1, 42, 59, 54, 20, 25, 26, 41, 1, 44, 45, 53, 27, 25, 24, 41, 59, 41}; 
double KcnfsWPClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double KcnfsWPClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int KcnfsWPRSNumFeat = 79;
double MarchWPRSModel[] = {-0.288114, 0.656578, 1.285870, -0.467969, -1.208629, 1.262803, -1.193694, -1.334426, -0.848495, 1.220049, -1.020555, 1.103156, -0.306547, -0.589952, 0.369042, -0.390401, -0.832577, 0.082408, -0.264145, 0.450301, -0.326297, -0.076037, -0.064954, 0.270791, 0.291399, -0.056134, -0.352084, 0.157600, -0.232784, 0.894739, 0.475176, -0.343845, -0.983572, 0.115599, 0.071644, 0.425072, 2.108242, -1.449313, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.265579}; 
double MarchWPRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.031300, 0.654443, -0.036206, 4.749511, 0.170404, -1.037079, -0.554042, -0.057442, 2.119003, 0.047528, -1.277956, 0.227273, 2.640611, -1.020280, 0.392646, -4.040000, 1.246906, 1.126123, 1.512209, -0.214528, -0.515419, 1.243030, -2.806604, -1.627504, -1.144864, 1.418826, 0.813102, 0.243898, -0.058477, -1.060595, -0.186028, 0.039243, -0.447055, -0.021441, 0.285308, 0.029319, 0.078227, -0.004911, 1.387797, -0.905019, 3.834760}; 
double MarchWPRSFeatMean[] = {0.009195, 0.164965, 10.559502, 0.014347, 0.000001, 0.412431, 0.500108, 0.003863, 0.001971, 0.160740, 0.071140, 0.003553, 0.000407, 0.011449, 0.002956, 0.000197, 0.007052, 0.006342, 0.018462, 0.198241, 0.002157, 0.059784, 0.000413, 0.000652, 0.001866, 0.000002, 0.000325, 0.000001, 0.292779, 0.001982, 0.000352, 0.000225, 0.001091, 0.056491, 0.002529, 0.000292, 0.024229, 0.011242, 0.377354, 624707.207971, 0.016744, 263.240936, 0.123787, 0.911220, 202.178096, 0.000311, 0.011011, 0.122658, 143.288237, 0.574490, 657.266684, 0.028414, 0.289742, 146.763197, 6373.732454, 0.093930, 84.431080, 791.660134, 10973.479215, 50.573330, 413.848638, 0.082153, 1780670.693820, 92.870278, 237.652590, 0.867442, 168.979465, 0.742203, 248.183559, 0.003362, 427.520577, 0.000058, 0.684983, 5392.320635, 215540.108696, 0.207613, 209.973856, 155.051416}; 
double MarchWPRSFeatStd[] = {0.005130, 0.316260, 9.713563, 0.017625, 0.000016, 0.293551, 0.341941, 0.005557, 0.009823, 0.160821, 0.042185, 0.005451, 0.000958, 0.035034, 0.004318, 0.000328, 0.011109, 0.012791, 0.009450, 0.080730, 0.002392, 0.042418, 0.000667, 0.003590, 0.002493, 0.000005, 0.002537, 0.000006, 0.148875, 0.009828, 0.000469, 0.000337, 0.001096, 0.049811, 0.004360, 0.000815, 0.014933, 0.005752, 0.271678, 689955.660153, 0.021763, 97.790420, 0.037881, 0.510054, 147.621827, 0.000855, 0.011771, 0.057915, 76.096277, 0.410197, 439.806621, 0.016688, 0.865074, 77.053466, 8196.004981, 0.044742, 48.299942, 431.638363, 13528.034047, 39.485042, 297.047689, 0.064500, 1630012.199481, 69.323533, 158.160218, 0.640775, 122.113004, 0.462170, 161.738024, 0.006036, 251.273739, 0.000332, 0.402009, 7078.260971, 152852.116438, 0.276268, 150.911553, 130.532167}; 
int MarchWPRSFeatID1[] = {7, 52, 14, 52, 33, 8, 21, 7, 10, 39, 39, 7, 33, 10, 52, 37, 32, 52, 59, 14, 61, 33, 26, 21, 28, 26, 35, 35, 58, 10, 59, 52, 33, 38, 37, 32, 33, 14, 33, 55, 32, 15, 42, 21, 50, 36, 15, 50, 15, 31, 50, 61, 39, 15, 39, 61, 43, 2, 39, 31, 31, 61, 53, 1, 53, 61, 56, 50, 55, 50, 15, 19, 8, 41, 1, 39, 50, 31}; 
int MarchWPRSFeatID2[] = {23, 58, 39, 49, 34, 37, 37, 38, 37, 32, 24, 37, 32, 8, 32, 26, 15, 7, 49, 58, 61, 21, 23, 35, 26, 26, 23, 26, 23, 38, 26, 26, 61, 37, 32, 32, 0, 33, 51, 55, 21, 1, 64, 25, 55, 33, 30, 59, 43, 21, 2, 15, 10, 41, 41, 21, 25, 25, 1, 41, 2, 8, 2, 31, 62, 39, 59, 21, 25, 36, 53, 36, 62, 51, 1, 36, 53, 53}; 
double MarchWPClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double MarchWPClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int MarchWPRSNumFeat = 78;
double MinisatWPRSModel[] = {-6.610837, 2.121290, -0.796904, 0.025424, 0.313113, -7.873550, -0.865282, -0.759970, -0.527745, 7.996347, -6.248579, 9.085218, 0.836487, -0.144176, -1.165850, -4.373871, 2.086339, -2.797525, 3.331318, -0.489151, 3.228571, -2.895964, 0.198469, -0.031546, -0.021708, -0.027523, 0.672710, 0.015147, -1.740366, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.683719}; 
double MinisatWPRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.993356, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.122336, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.173278, 0.000567, 0.106035, 0.389994, 2.559398, -0.487351, 3.623703, -0.185659, 0.439947, -0.545270, 0.192971, -1.704104, 5.232210, 1.215339, 0.419117, 1.410958, -0.086899, -0.429028, -1.010553, -0.318150, -0.564444, 0.021687, -0.000666, 1.123215, -0.339583, 0.528768, 0.092750, -4.144548, 0.829409, -4.697728, -1.338363, -0.476269, 0.787352, 3.239664, 1.772064, -1.378559, 1.151539, -1.756369, 4.444086}; 
double MinisatWPRSFeatMean[] = {1.306309, 8.988789, 11.231084, 0.002651, 0.023030, 0.413572, 0.008319, 0.000060, 0.000622, 0.633001, 2.097353, 2.048420, 0.123590, 0.001506, 0.224878, 616.841284, 5.346913, 18.545697, 1.110893, 0.017281, 6.383354, 0.007068, 0.011835, 455.530010, 0.002464, 0.000115, 0.152204, 0.324102, 3.921182, 1.169192, 0.176618, 0.093930, 1.248000, 0.000810, 0.059941, 152.730821, 0.005255, 1.918191, 0.097833, 0.008736, 68781.194928, 233.849275, 4057.914358, 0.198241, 71983.451463, 33.362790, 62.288442, 3.610831, 0.018499, 91.364565, 0.229939, 1.766135, 0.007124, 63.545369, 6.647382, 0.688665, 197.795270, 122552.139969, 84.116080, 215540.108696, 119701.686232, 1.205243, 239.597282, 3.039461, 0.015474, 15.754977, 9254.640989}; 
double MinisatWPRSFeatStd[] = {5.579324, 5.762505, 44.349367, 0.001432, 0.107436, 0.166381, 0.021664, 0.000269, 0.002189, 0.113582, 9.668137, 8.985141, 0.077823, 0.022929, 0.048783, 1510.634024, 2.938025, 16.531621, 4.837506, 0.006269, 28.375053, 0.062069, 0.034369, 538.757851, 0.005025, 0.000581, 0.193689, 1.553714, 22.363544, 0.211389, 0.239002, 0.044742, 0.319753, 0.001183, 0.036717, 54.103997, 0.003524, 0.252879, 0.046320, 0.006297, 65645.661841, 118.811487, 5566.482772, 0.080730, 67384.987217, 21.409375, 29.114863, 1.411973, 0.010449, 39.158887, 0.221887, 0.477753, 0.004532, 23.788682, 5.841938, 0.493872, 98.611633, 98855.355788, 39.001247, 152852.116438, 97064.921719, 0.411132, 120.821150, 0.893848, 0.009328, 14.351766, 11649.863180}; 
int MinisatWPRSFeatID1[] = {40, 51, 13, 62, 40, 15, 15, 19, 13, 15, 40, 40, 51, 22, 14, 51, 51, 51, 40, 28, 19, 15, 40, 2, 11, 19, 51, 40, 22, 44, 36, 21, 64, 33, 51, 1, 33, 48, 21, 61, 43, 43, 44, 58, 41, 44, 44, 33, 21, 64, 1, 41, 8, 44, 51, 44, 48, 1, 54, 1, 1, 44, 41, 1, 8, 48, 1}; 
int MinisatWPRSFeatID2[] = {15, 64, 56, 27, 27, 15, 11, 11, 11, 0, 64, 60, 27, 37, 14, 51, 62, 0, 14, 27, 55, 22, 13, 37, 37, 37, 11, 37, 55, 11, 51, 61, 28, 33, 24, 54, 47, 28, 49, 37, 43, 0, 51, 14, 41, 37, 54, 44, 27, 44, 26, 12, 24, 58, 54, 6, 43, 41, 41, 1, 43, 27, 0, 27, 27, 51, 51}; 
double MinisatWPClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double MinisatWPClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int MinisatWPRSNumFeat = 67;
double RsatWPRSModel[] = {1.280922, 0.005031, -40.521787, -0.097141, 0.095064, 40.249342, 2.310402, 0.619732, -1.427395, -1.374750, 0.565444, -1.255544, -0.767666, -0.299565, -0.570809, 1.499576, -3.635424, 0.324599, -1.985667, 0.355361, 1.354948, 1.594103, -0.637741, 0.641520, -0.601223, -6.950249, -0.837446, 0.138303, -0.053824, 6.510203, -0.150955, 0.344376, -0.560567, 0.175967, -0.039710, 0.266055, 0.038846, 0.267565, 1.173142, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 3.782040}; 
double RsatWPRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 5.141897, -1.014253, -1.085500, -0.319312, -1.323167, 0.343011, -0.193570, 0.159045, -0.400196, 0.689849, 1.726452, -0.185762, -0.131434, -0.746546, 0.340627, -0.583397, -0.402616, -0.194423, -0.221155, 0.097796, -0.007022, 1.400829, -0.268046, 0.784538, -0.669132, 0.567269, 4.216536, 0.131141, -0.424594, -0.802050, 0.715011, 0.581977, -0.413429, -0.357867, -1.021235, 0.406969, -1.145205, -3.059045, 0.129209, -0.008307, 5.175321}; 
double RsatWPRSFeatMean[] = {1.286102, 0.013736, 0.180316, 0.000406, 0.045347, 0.182919, 1512.474867, 0.011449, 0.014269, 156.011516, 0.053316, 0.010451, 863.081765, 0.065446, 624707.207971, 228.656256, 0.039900, 0.001441, 0.800287, 0.082495, 1.738571, 0.006946, 0.017307, 0.065435, 648843.693197, 2.238054, 5.024966, 0.218750, 0.015314, 2.184351, 0.000067, 0.002652, 0.000531, 0.001158, 0.000536, 0.000111, 0.003815, 0.044567, 0.222630, 140.713109, 0.768276, 156.011516, 0.018255, 24275.755213, 0.017604, 0.010373, 0.001699, 0.030317, 0.121369, 2.139640, 674860.298007, 2.215136, 0.789532, 0.002284, 0.557210, 20.743354, 0.001675, 0.734949, 50.813011, 0.019070, 16550.693019, 3.588454, 6.660602, 38.130456, 2299.447239, 236447.881159, 2.745171, 155.051416, 398422.009878, 6.972425, 0.029092, 0.017543, 0.081404, 362.440304, 409.979680, 485.972729, 162412.708987, 6.647382, 0.176618}; 
double RsatWPRSFeatStd[] = {5.426274, 0.004283, 0.079751, 0.001379, 0.015028, 0.079621, 1297.109675, 0.035034, 0.004277, 134.781665, 0.047249, 0.006816, 3378.078634, 0.263477, 689955.660153, 154.300269, 0.025121, 0.001096, 0.386379, 0.024381, 1.201683, 0.003996, 0.057898, 0.266351, 711673.615823, 9.677588, 21.917178, 0.068439, 0.079668, 9.689035, 0.000052, 0.007292, 0.001289, 0.007767, 0.003678, 0.000345, 0.007044, 0.017845, 0.037935, 74.292640, 0.384879, 134.781665, 0.004290, 34736.824444, 0.009887, 0.007168, 0.001806, 0.015320, 0.036893, 0.747336, 736806.158765, 1.254283, 0.404358, 0.003295, 0.151064, 9.656491, 0.000641, 0.555739, 62.829516, 0.031929, 23574.449995, 2.661219, 3.112568, 19.970887, 1960.510944, 234513.101836, 1.216405, 130.532167, 440017.974916, 3.330261, 0.014723, 0.004171, 0.025449, 193.120126, 162.544860, 365.682457, 161952.598968, 5.841938, 0.239002}; 
int RsatWPRSFeatID1[] = {40, 61, 3, 13, 3, 3, 55, 10, 49, 5, 3, 49, 40, 40, 55, 62, 42, 5, 23, 54, 23, 49, 13, 40, 55, 40, 40, 16, 40, 40, 27, 3, 61, 36, 36, 36, 62, 49, 42, 1, 46, 53, 29, 51, 23, 47, 32, 23, 64, 53, 53, 32, 23, 32, 44, 33, 47, 51, 51, 36, 51, 51, 44, 57, 8, 57, 56, 53, 53, 44, 23, 29, 47, 64, 1, 21, 53, 51, 51}; 
int RsatWPRSFeatID2[] = {16, 62, 60, 27, 42, 48, 8, 8, 62, 53, 3, 42, 55, 49, 55, 55, 5, 27, 0, 42, 8, 5, 13, 61, 53, 0, 8, 62, 36, 23, 27, 36, 36, 13, 36, 27, 36, 0, 0, 63, 23, 5, 49, 57, 33, 49, 3, 49, 47, 24, 53, 56, 23, 47, 24, 57, 27, 61, 21, 8, 53, 3, 61, 61, 57, 44, 27, 31, 56, 49, 61, 61, 54, 53, 46, 44, 44, 54, 36}; 
double RsatWPClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double RsatWPClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int RsatWPRSNumFeat = 79;
double VallstWPRSModel[] = {-4.678448, 0.394389, -0.670669, 1.065300, 0.289150, 0.215294, -0.368160, 2.648577, -0.309815, -0.004454, -0.620996, 0.138980, 0.493810, 0.326240, -0.830767, -1.778492, 0.374403, 0.966535, -0.009524, 0.003125, 0.898718, -0.519740, -0.053046, 0.148925, 0.357520, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 3.633145}; 
double VallstWPRUModel[] = {0.000000, -0.471488, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.529870, 0.000000, 0.000000, 0.000000, 0.000000, -0.034638, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.433101, 0.000000, 0.000000, 0.000000, 0.000000, 0.807230, -0.081921, -0.004191, -0.961316, 0.930340, -0.624223, 0.076753, -0.693801, 0.069209, -0.028935, -0.770912, 0.320662, -0.187940, -0.480883, -0.152445, 0.055073, 1.499456, -0.159790, -0.404586, 0.005034, -0.228875, -0.083312, -0.496500, -1.427440, 1.177811, 0.435316, -0.501142, -0.343781, -1.445548, 0.917451, 0.197925, -0.562496, 0.350965, -0.885997, 0.065314, 2.457368}; 
double VallstWPRSFeatMean[] = {2.097353, 98.528858, 0.000295, 0.011449, 0.037010, 0.444071, 0.072073, 2.238054, 0.001779, 5.706511, 0.003815, 0.002886, 0.019070, 0.127542, 0.011931, 851.176660, 0.141459, 3.129380, 0.033318, 0.224753, 1.401201, 0.000295, 0.351631, 13.541964, 0.006513, 0.684983, 5.652021, 0.011829, 0.837118, 139.965339, 0.024112, 616.841284, 1.054313, 3.464573, 0.176618, 0.023030, 0.000020, 0.000362, 4.394079, 0.037174, 5.651912, 0.049456, 567.431743, 1.110893, 2.184351, 0.596604, 5.024966, 6.647382, 0.122164, 5.346913, 0.170836, 2.045489, 1.029381, 379.877357, 0.286352, 0.467180, 0.856326, 5.157226, 0.007767, 0.001749}; 
double VallstWPRSFeatStd[] = {9.668137, 512.001677, 0.000806, 0.035034, 0.166982, 0.261320, 0.017889, 9.677588, 0.001136, 34.828372, 0.007044, 0.007308, 0.031929, 0.214195, 0.022354, 1994.905000, 0.050085, 3.085426, 0.032912, 0.408255, 6.515480, 0.000807, 0.107851, 11.051596, 0.022714, 0.402009, 24.364347, 0.012538, 0.472293, 95.692787, 0.017605, 1510.634024, 0.152286, 3.952844, 0.239002, 0.107436, 0.000050, 0.000449, 18.514128, 0.097892, 4.945568, 0.037986, 2294.616471, 4.837506, 9.689035, 2.782103, 21.917178, 5.841938, 0.035798, 2.938025, 0.017175, 8.952046, 4.845400, 274.021867, 0.087016, 0.163552, 3.748726, 1.186845, 0.034808, 0.000678}; 
int VallstWPRSFeatID1[] = {40, 40, 10, 10, 40, 47, 62, 40, 18, 40, 62, 38, 8, 39, 15, 39, 47, 39, 18, 15, 40, 10, 64, 39, 64, 8, 21, 51, 21, 56, 18, 51, 14, 56, 51, 40, 32, 26, 40, 28, 51, 62, 56, 40, 40, 40, 8, 51, 62, 51, 54, 40, 40, 56, 62, 3, 40, 28, 40, 24}; 
int VallstWPRSFeatID2[] = {64, 40, 9, 8, 7, 8, 47, 0, 7, 52, 36, 36, 36, 6, 7, 39, 15, 18, 38, 52, 62, 4, 15, 15, 6, 62, 40, 26, 62, 62, 18, 51, 28, 36, 36, 27, 26, 14, 28, 10, 40, 18, 40, 14, 23, 18, 40, 54, 54, 62, 14, 48, 3, 23, 48, 28, 54, 28, 24, 14}; 
double VallstWPClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double VallstWPClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int VallstWPRSNumFeat = 60;
double ZchaffWPRSModel[] = {2.184802, -0.301586, -25.710773, -0.276444, -0.104374, 24.847546, 2.122171, 3.179238, -4.437065, 5.913916, -0.860485, 6.974558, -5.012154, 7.466336, -0.083200, -0.355245, 0.569055, 0.091451, 0.470298, 0.696316, -0.654481, 10.715886, -5.890156, -3.071136, -3.339918, -0.627108, -0.970121, -0.821754, -4.438132, 1.498157, 6.819080, 9.896587, -39.615485, 0.376696, -0.344872, -1.895972, -6.047616, 0.181967, -27.450497, -0.157905, 1.732847}; 
double ZchaffWPRUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.000001, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 3.254995}; 
double ZchaffWPRSFeatMean[] = {1.286102, 0.124295, 0.000456, 2.609632, 98.528858, 2.238054, 15832.831899, 1.401201, 0.017307, 0.018300, 0.017120, 0.633001, 616.841284, 0.002089, 0.002357, 0.004527, 0.000271, 0.070007, 13.816771, 0.017071, 0.000058, 0.001096, 0.000959, 0.001013, 0.000955, 0.001010, 0.000951, 0.000901, 0.000936, 0.000898, 0.000862, 1.306309, 2.154213, 0.000527, 0.037010, 0.218750, 0.413572, 0.003192, 0.002502, 0.000021}; 
double ZchaffWPRSFeatStd[] = {5.426274, 0.096612, 0.006285, 2.631854, 512.001677, 9.677588, 22400.198804, 6.515480, 0.057898, 0.049053, 0.069721, 0.113582, 1510.634024, 0.008763, 0.002311, 0.014751, 0.000313, 0.328287, 15.052171, 0.069727, 0.000064, 0.006778, 0.006438, 0.006607, 0.006438, 0.006607, 0.006438, 0.006290, 0.006457, 0.006290, 0.006145, 5.579324, 9.694543, 0.000604, 0.166982, 0.068439, 0.166381, 0.002186, 0.033259, 0.000074}; 
int ZchaffWPRSFeatID1[] = {40, 62, 18, 51, 40, 40, 55, 40, 13, 16, 40, 15, 51, 18, 6, 40, 20, 40, 51, 40, 18, 7, 12, 7, 12, 7, 9, 6, 6, 6, 6, 40, 40, 18, 40, 62, 15, 33, 63, 6}; 
int ZchaffWPRSFeatID2[] = {16, 63, 22, 18, 40, 0, 51, 62, 13, 10, 12, 0, 51, 13, 20, 10, 26, 33, 20, 9, 26, 7, 12, 12, 9, 9, 9, 12, 7, 9, 6, 15, 20, 6, 7, 16, 15, 18, 22, 26}; 
double ZchaffWPClassCoeffRS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double ZchaffWPClassCoeffRU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int ZchaffWPRSNumFeat = 40;

double EurekaCSModel[] = {-0.095125, -0.499927, -0.215105, 0.264499, -0.335554, 0.406874, 0.254030, 0.801678, -0.477700, -0.095006, -0.498582, 0.465440, -0.715599, -0.305314, 0.174394, -0.628945, -0.957537, 6.202914, -0.301938, -0.564148, -0.201143, -0.361846, 0.082125, -0.154088, 0.363682, -5.294674, 0.498667, 0.604877, 0.256283, 0.098596, -0.460993, -0.220961, -0.386295, -0.352431, -0.616384, -0.212928, -0.387518, -0.328251, -0.016986, 0.018330, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.755337}; 
double EurekaCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.123776, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.177725, 0.392598, -0.424877, 1.373213, 0.397350, 1.156984, -0.180604, -1.570846, -1.368273, 0.205555, 0.416659, -0.337689, -0.669624, 0.004071, -0.529834, -0.171002, 0.499665, 0.491089, -0.184774, -0.665025, -0.039368, -0.288706, 0.073759, 0.098382, 0.102858, 0.314966, 0.186416, -1.051648, 0.206054, -0.758973, 0.780354, -0.792734, 0.013655, 0.151746, 0.257857, -1.124921, 0.830519, 0.207673, -0.126828, 2.290858}; 
double EurekaCSFeatMean[] = {0.131555, 0.239877, 0.000051, 0.310957, 0.041826, 0.837933, 45624.755221, 0.000627, 0.034800, 0.037914, 1.483515, 428.849094, 0.000490, 3698.338709, 4.664632, 0.040338, 0.403394, 0.158662, 3.794852, 0.000853, 11086.051189, 0.046512, 1.924372, 719.019680, 0.001693, 0.152403, 0.044015, 0.407079, 145.001966, 0.000166, 0.589891, 0.003180, 0.002506, 0.004976, 1.887816, 0.245378, 0.381339, 8624.881649, 0.001040, 0.043268, 1.097848, 0.000694, 0.643456, 0.000606, 0.001799, 0.000610, 0.073855, 0.001004, 1.642841, 0.250850, 0.198667, 0.205950, 0.165549, 5105.948367, 2.047823, 0.444228, 0.486388, 1189.453709, 0.033410, 0.000144, 48.444808, 6.383595, 0.005253, 0.171642, 0.005744, 0.213384, 0.434466, 0.239132, 0.239713, 388.330667, 0.271568, 0.000079, 813.386295, 128.620481, 5038.663119, 0.003046, 1.674386, 334.364136, 0.001322}; 
double EurekaCSFeatStd[] = {0.249520, 0.279317, 0.000107, 0.473643, 0.089307, 0.927767, 160543.485834, 0.001165, 0.099252, 0.049771, 1.592590, 791.033489, 0.000984, 9997.591569, 3.641398, 0.043051, 0.349696, 0.314798, 21.675856, 0.001188, 57312.190627, 0.044459, 2.101170, 1481.136324, 0.004200, 0.306158, 0.064637, 0.342285, 1421.514690, 0.000610, 0.383807, 0.010603, 0.004586, 0.008473, 1.263385, 0.323142, 0.262510, 13173.852729, 0.001668, 0.114002, 0.960293, 0.001480, 0.378966, 0.000956, 0.002076, 0.001083, 0.119187, 0.001703, 2.742621, 0.396269, 0.227582, 0.649828, 0.114780, 12185.196441, 1.590429, 0.353237, 0.420826, 2081.379734, 0.097531, 0.000567, 127.973055, 23.409145, 0.013749, 0.195801, 0.007771, 0.118029, 1.255918, 0.353286, 0.335261, 1405.282925, 0.224339, 0.000143, 1572.195129, 307.274909, 52721.296355, 0.003814, 1.559497, 894.732546, 0.002389}; 
int EurekaCSFeatID1[] = {7, 18, 33, 13, 50, 8, 2, 50, 13, 3, 28, 18, 14, 2, 55, 62, 60, 17, 51, 5, 2, 50, 55, 7, 7, 19, 18, 8, 19, 27, 28, 18, 32, 5, 8, 18, 60, 28, 13, 5, 32, 18, 50, 31, 30, 42, 50, 32, 21, 5, 25, 7, 50, 8, 25, 23, 50, 64, 21, 30, 36, 40, 40, 23, 31, 50, 40, 23, 22, 18, 63, 32, 23, 36, 28, 31, 5, 22, 27}; 
int EurekaCSFeatID2[] = {28, 28, 24, 17, 19, 54, 48, 32, 19, 3, 13, 55, 26, 3, 9, 3, 17, 19, 61, 24, 19, 3, 24, 2, 19, 19, 54, 62, 51, 27, 62, 19, 0, 9, 0, 8, 54, 55, 24, 19, 1, 4, 28, 32, 54, 32, 22, 54, 5, 63, 22, 46, 64, 1, 28, 15, 8, 1, 35, 4, 44, 40, 30, 42, 27, 15, 37, 22, 15, 1, 15, 18, 44, 1, 51, 4, 28, 44, 22}; 
double EurekaClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double EurekaClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int EurekaCSNumFeat = 79;
double KcnfsCSModel[] = {-1.145551, -0.387624, 0.308222, -0.508501, 0.105608, -0.471778, 0.367859, 0.041602, 0.191316, 2.341584, 0.069978, 0.233034, -0.065591, 0.729771, -0.355710, -2.020447, -0.304886, 0.036498, 0.454156, 0.139582, -0.149800, 0.074476, -0.259093, 0.087091, 0.518377, 0.017782, -0.310996, 0.580131, -0.818596, -0.537141, 0.229209, 0.082516, -0.068420, -0.044616, -0.053354, 0.337809, 0.091353, 0.278022, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.439000}; 
double KcnfsCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.154137, 0.103754, 0.305539, -0.368833, 0.222869, 0.332658, -0.360926, 0.168800, 0.100519, 0.125897, -0.437353, -0.174006, 0.146194, 0.508664, -0.170364, -0.250154, 0.220807, -0.194715, -0.094538, 0.053891, 0.140269, -0.203294, 0.064098, -0.570297, -0.180920, 0.153921, 0.110976, -0.052773, 0.064672, -0.041401, -0.059586, -1.243159, 0.103349, -0.039047, 0.077783, 0.120583, -0.033874, -0.116495, -0.523999, 0.013109, 2.896731}; 
double KcnfsCSFeatMean[] = {0.002360, 0.274700, 0.644973, 0.072497, 1.887816, 0.471348, 0.002366, 0.711794, 0.271611, 0.010371, 14.282045, 0.182571, 10847780.505376, 3811.081252, 3712.503774, 0.003721, 1403.725722, 0.557271, 0.434037, 0.733703, 0.556535, 334.364136, 815.176949, 0.419380, 0.153468, 1900.944750, 1.053016, 0.509319, 0.695175, 0.607406, 0.293242, 0.024723, 1.325993, 816.753999, 2.171407, 0.691940, 0.239713, 2.031288, 0.000193, 0.000520, 0.123123, 0.493102, 0.611863, 0.152972, 0.585795, 0.285824, 0.636737, 0.004970, 0.002764, 0.002061, 0.084769, 0.177253, 0.367072, 0.270573, 0.373590, 1.437694, 100.902551, 0.075297, 16.213814, 43.218447, 0.276821, 0.000726, 0.000640, 0.033137, 0.001527, 447.857615, 0.188316, 11.012854, 0.407079, 257321398.525472, 0.000431, 0.002771, 0.052716, 17.537666, 0.008219, 0.073559, 0.548482, 0.034096}; 
double KcnfsCSFeatStd[] = {0.003828, 0.287011, 0.263874, 0.463543, 1.263385, 0.266504, 0.004630, 1.814712, 0.230013, 0.039413, 11.934548, 0.275264, 28292525.714125, 5421.913667, 6695.447579, 0.018572, 3352.279770, 0.389081, 0.451373, 1.199962, 0.575559, 894.732546, 1930.124087, 1.298012, 1.081818, 3588.941522, 1.809804, 0.777745, 1.019771, 1.233827, 0.371861, 0.082825, 4.970332, 1411.186695, 2.866433, 0.758463, 0.335261, 3.260169, 0.001000, 0.001638, 0.144246, 0.577305, 0.417634, 0.118633, 0.315231, 0.293883, 0.947985, 0.010289, 0.005505, 0.008380, 0.113941, 0.296591, 0.743772, 0.349983, 0.329954, 3.137425, 238.594158, 0.091983, 50.256333, 52.322975, 0.285414, 0.002180, 0.001011, 0.049194, 0.007356, 992.025469, 0.188303, 46.401675, 0.342285, 4119408543.389120, 0.000812, 0.006298, 0.074258, 32.782892, 0.021528, 0.126391, 0.452478, 0.158380}; 
int KcnfsCSFeatID1[] = {29, 23, 15, 61, 8, 15, 13, 52, 5, 15, 12, 64, 44, 48, 23, 12, 22, 23, 15, 25, 64, 22, 59, 52, 61, 59, 13, 64, 15, 59, 23, 52, 8, 64, 8, 13, 15, 8, 11, 24, 17, 8, 23, 62, 60, 17, 31, 52, 8, 34, 10, 17, 10, 22, 23, 46, 18, 18, 46, 2, 47, 11, 47, 58, 34, 47, 42, 46, 8, 51, 10, 40, 23, 2, 36, 62, 23, 11}; 
int KcnfsCSFeatID2[] = {11, 13, 15, 25, 0, 64, 11, 48, 29, 11, 57, 22, 57, 57, 57, 12, 57, 48, 59, 59, 25, 44, 45, 59, 52, 57, 13, 5, 5, 59, 59, 12, 52, 45, 25, 0, 22, 5, 24, 22, 10, 10, 0, 64, 64, 64, 40, 27, 32, 10, 10, 22, 40, 0, 64, 62, 44, 20, 40, 30, 20, 22, 32, 33, 62, 44, 20, 52, 62, 51, 24, 24, 18, 32, 18, 22, 23, 8}; 
double KcnfsClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double KcnfsClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int KcnfsCSNumFeat = 78;
double MarchCSModel[] = {0.875144, -0.340363, -2.224549, 0.171636, -0.134761, -0.170927, 0.712068, -1.609301, 0.128655, -0.289777, 2.161312, 0.224973, 0.045278, -0.120512, -0.164707, -0.102795, 0.080439, -0.149741, -0.074287, 0.027315, 0.289729, -0.171846, -1.870759, -1.124527, -0.586428, 0.289800, -0.395311, 0.166629, -0.166076, -0.751224, 2.654605, 0.234948, -0.257553, -0.564281, 0.422204, -0.171656, 0.184235, -0.118841, 0.386183, 0.029612, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.066181}; 
double MarchCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.210511, -2.381042, -0.025628, 0.321793, 1.566218, 0.530012, -0.340993, 0.252539, -0.109580, -0.019279, -2.857253, 7.666498, -0.239126, 0.050323, -4.243916, 0.592232, 0.822449, -0.132337, -0.459766, 0.399071, -0.440033, -0.791124, -0.481688, 0.232620, 0.197939, -0.115100, 0.052331, -0.317973, 0.396385, 0.245969, 0.163286, -0.061616, 0.205063, 0.090518, -0.148912, -0.109793, -0.259095, -0.054250, -0.188068, -0.017293, 2.616477}; 
double MarchCSFeatMean[] = {0.004215, 0.084027, 4187.296595, 0.142371, 2.456993, 0.006200, 0.227193, 0.245102, 3.534020, 1250.247278, 0.931749, 3.301928, 113450421.327957, 0.000762, 0.276821, 0.931369, 0.001716, 1075.298701, 2.803744, 0.000043, 0.093959, 0.007597, 0.861666, 0.000769, 0.002442, 0.002366, 0.001473, 0.185346, 2432.674593, 1403.725722, 3558.089967, 1145.871507, 2012.078705, 0.188316, 0.293829, 0.763535, 809.148411, 1647.770521, 2380.747264, 1.115788, 0.611377, 0.001438, 0.014067, 31621554.802867, 0.344521, 0.000610, 6.797451, 0.400946, 1189.453709, 0.000553, 0.004323, 0.015489, 0.000832, 0.004326, 0.019677, 0.000047, 0.001440, 0.031956, 0.001573, 11248380.679211, 403.162788, 0.179943, 0.293242, 0.112157, 388.117685, 0.001322, 11086.051189, 23.352437, 10619.049571, 0.098417, 1.269686, 15951.040392, 0.084769, 666.821052, 0.142371, 5934758.030466, 10.580621, 0.039734, 0.001693, 1152.112680}; 
double MarchCSFeatStd[] = {0.005061, 0.080759, 6870.087404, 0.192238, 1.068956, 0.007682, 0.339182, 0.370914, 17.636880, 2212.365996, 0.787955, 2.941628, 771872402.340932, 0.001516, 0.285414, 0.710716, 0.003908, 2885.376291, 2.207563, 0.000127, 0.098649, 0.015877, 0.758056, 0.001483, 0.003755, 0.004630, 0.001695, 0.233252, 4118.183572, 3352.279770, 5647.795563, 2722.722054, 3899.648899, 0.188303, 0.188349, 0.623881, 1263.149473, 2809.337756, 3644.457400, 1.949926, 0.272707, 0.003019, 0.033874, 72064322.353762, 0.247706, 0.001083, 12.799666, 0.243143, 2081.379734, 0.001410, 0.019370, 0.044807, 0.001739, 0.005874, 0.047125, 0.000109, 0.003649, 0.064510, 0.004358, 29932269.918289, 764.069381, 0.222037, 0.371861, 0.194951, 943.978012, 0.002389, 57312.190627, 32.864305, 29700.099301, 0.282678, 0.536027, 57503.457778, 0.113941, 1487.611261, 0.192238, 16135446.325175, 10.142615, 0.092437, 0.004200, 3669.779746}; 
int MarchCSFeatID1[] = {30, 3, 55, 13, 1, 12, 13, 10, 52, 57, 25, 55, 1, 42, 20, 45, 20, 55, 1, 30, 10, 52, 60, 3, 20, 13, 31, 10, 13, 57, 55, 52, 25, 20, 42, 41, 10, 60, 55, 25, 64, 63, 38, 55, 63, 32, 2, 54, 64, 59, 12, 12, 38, 23, 64, 27, 19, 10, 33, 55, 64, 63, 23, 22, 59, 22, 2, 2, 2, 19, 1, 2, 10, 22, 22, 45, 12, 19, 19, 1}; 
int MarchCSFeatID2[] = {0, 20, 0, 22, 11, 31, 42, 13, 52, 54, 0, 30, 1, 24, 47, 24, 6, 52, 30, 30, 54, 33, 25, 11, 30, 11, 11, 31, 57, 22, 60, 57, 45, 42, 0, 6, 57, 41, 20, 13, 0, 24, 7, 1, 0, 42, 26, 0, 1, 26, 7, 63, 24, 27, 12, 24, 27, 36, 19, 44, 44, 63, 59, 59, 44, 27, 19, 24, 38, 59, 24, 59, 10, 45, 13, 44, 1, 42, 7, 42}; 
double MarchClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double MarchClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int MarchCSNumFeat = 80;
double MinisatCSModel[] = {-2.064013, -0.154961, -1.268104, 3.652600, -0.504801, -0.662258, 0.234125, -0.348822, 0.492417, -0.012890, 5.373373, 0.900602, 0.350851, -1.153186, -0.429351, -0.588748, -7.885956, 0.755638, -0.290311, -0.030036, 0.910838, 0.093807, 0.445743, 0.481537, 3.138785, 0.721410, -0.437143, -0.347494, -0.187222, -0.196604, -0.353250, -0.598227, -0.367800, 0.237035, 0.270072, -0.065313, 0.104469, -0.242041, 0.179043, -2.323796, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.348246}; 
double MinisatCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -4.146001, 0.256507, -0.808758, 0.425516, -0.185324, 0.870385, -0.522552, -0.121200, -0.597821, 1.563166, -0.206928, -0.160810, -0.906004, 0.488784, -0.730675, -0.553565, 0.224353, -0.196331, 0.262711, 0.127788, -0.611751, -0.407472, 0.688401, -0.155462, -0.236745, 0.347238, -1.688313, -1.513508, -0.109028, 0.548514, 0.188064, 1.108693, 3.977134, 0.585023, -0.641212, -0.218120, 0.572282, -0.499421, 0.307436, -0.136858, 2.368960}; 
double MinisatCSFeatMean[] = {0.001182, 0.142371, 0.004672, 0.000694, 0.277651, 0.001054, 1.325993, 8597.585251, 0.123672, 1.610679, 3698.338710, 0.000295, 10.445460, 22.966385, 1.483515, 0.504300, 3447.694142, 0.006684, 0.000020, 0.607406, 44.506922, 0.069678, 1373.107933, 0.763535, 8174.774777, 0.002366, 0.000200, 0.002367, 92287297.458781, 651.820470, 0.000541, 5105.948367, 224.178632, 6.163592, 102.820025, 0.026646, 1237.616727, 139088588.301539, 9.877661, 0.000693, 0.002017, 0.043543, 0.643456, 386.046381, 0.026709, 0.090010, 78.735161, 0.002352, 0.014243, 0.007527, 0.001486, 0.002598, 0.000520, 4510.548355, 0.037879, 2.605666, 1051.039044, 6236.115340, 30.066615, 0.000099, 1.562306, 0.985242, 0.177893, 0.006200, 0.032850, 0.014018, 0.003036, 0.001054, 0.046512, 0.000759, 1.146206, 0.000007, 0.002906, 1.421779, 0.285185, 0.379897, 0.004978, 0.005689, 0.000995, 0.000043}; 
double MinisatCSFeatStd[] = {0.002000, 0.192238, 0.005870, 0.001480, 0.206788, 0.001594, 4.970332, 12854.490595, 0.107325, 1.428528, 9997.591574, 0.000431, 9.187805, 68.893415, 1.592590, 0.419781, 9913.290022, 0.007796, 0.000112, 1.233827, 140.624246, 0.228876, 3334.865266, 0.623881, 20081.818168, 0.004630, 0.000416, 0.002786, 467882570.173650, 1579.012757, 0.002244, 12185.196441, 637.999844, 12.716223, 295.975982, 0.060159, 2693.804427, 513095454.051497, 25.421052, 0.001478, 0.006579, 0.054600, 0.378966, 688.791236, 0.044447, 0.086787, 202.522610, 0.005915, 0.025821, 0.013016, 0.006440, 0.004055, 0.001638, 9906.946699, 0.075365, 2.403527, 3085.735138, 29179.407104, 72.129058, 0.000217, 1.341563, 1.362608, 0.183608, 0.007682, 0.104863, 0.025854, 0.003788, 0.002485, 0.044459, 0.000973, 1.285797, 0.000035, 0.006918, 1.402512, 0.304836, 0.366045, 0.023369, 0.024053, 0.003124, 0.000127}; 
int MinisatCSFeatID1[] = {18, 13, 21, 18, 60, 62, 8, 28, 59, 1, 1, 18, 53, 35, 13, 44, 60, 8, 35, 59, 35, 8, 22, 6, 28, 13, 13, 59, 44, 59, 22, 8, 49, 41, 49, 18, 21, 2, 56, 18, 6, 3, 50, 1, 3, 63, 55, 28, 30, 12, 50, 17, 22, 55, 3, 56, 22, 56, 7, 3, 28, 31, 63, 12, 7, 7, 31, 26, 3, 6, 56, 26, 50, 8, 63, 64, 34, 34, 22, 30}; 
int MinisatCSFeatID2[] = {12, 22, 30, 4, 42, 30, 52, 53, 62, 6, 0, 30, 12, 41, 28, 24, 1, 30, 26, 59, 53, 35, 53, 41, 1, 11, 26, 30, 2, 41, 6, 1, 53, 27, 41, 22, 44, 41, 27, 9, 50, 17, 28, 38, 38, 50, 7, 26, 58, 17, 34, 4, 24, 31, 22, 9, 56, 58, 56, 26, 23, 25, 31, 31, 7, 23, 9, 0, 50, 31, 24, 26, 4, 31, 25, 31, 23, 15, 30, 30}; 
double MinisatClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double MinisatClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int MinisatCSNumFeat = 80;
double RsatCSModel[] = {-0.916838, -0.752878, -0.953658, 0.294881, -0.931330, -0.276097, 0.850596, 0.166812, -0.253658, -1.198084, -1.077810, -1.561755, 0.483850, 0.279777, -0.182696, -0.161897, 2.244198, -6.389127, 6.212662, -0.033537, -0.138605, 1.138981, -1.312646, -0.220436, 0.096090, 0.163320, 0.140096, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.264149}; 
double RsatCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.293808, -0.506344, -0.066141, 0.748180, 1.267659, 0.076375, 0.735488, -0.601716, -0.292838, 0.852952, -0.324252, 0.689304, -0.623924, -0.372919, -1.048075, -1.721400, 0.375946, 0.488431, -0.831641, -0.154387, 0.227514, -0.051508, 0.440160, 0.376121, -1.088108, 1.176707, -0.113091, 0.267139, -0.441547, -0.033966, 0.478498, -1.036720, -0.336635, 0.577195, -0.275738, -0.392926, 0.711299, -0.175005, -0.241557, -0.112233, 2.270875}; 
double RsatCSFeatMean[] = {0.004672, 0.239877, 0.000051, 4367.927255, 0.507868, 1.483515, 0.000079, 1646.596999, 0.065152, 0.001473, 2.524481, 0.000207, 0.006684, 0.030002, 0.000553, 0.000027, 1.154459, 3698.338710, 3447.694142, 0.001664, 0.000170, 0.001063, 1.012512, 1.330457, 0.607406, 4097.211931, 0.215222, 0.000237, 0.043543, 0.020879, 0.179943, 0.132697, 8.412076, 0.023053, 0.010197, 0.124398, 610.172844, 2.611238, 0.013472, 0.121747, 0.000422, 5.697295, 0.013072, 0.005253, 0.000130, 0.000520, 816.753999, 0.001822, 0.000099, 0.052307, 3.398946, 0.200040, 0.007132, 0.000021, 0.045154, 0.002771, 0.009467, 0.246418, 0.570226, 0.354722, 0.759240, 0.007527, 0.082412, 0.117930, 1.041802, 0.001493, 0.000343}; 
double RsatCSFeatStd[] = {0.005870, 0.279317, 0.000107, 6460.981208, 0.458230, 1.592590, 0.000143, 22498.360713, 0.177952, 0.001695, 3.973820, 0.000626, 0.007796, 0.065267, 0.001410, 0.000113, 10.052865, 9997.591574, 9913.290022, 0.003275, 0.000291, 0.001312, 1.331720, 1.059685, 1.233827, 6718.096621, 0.261924, 0.001008, 0.054600, 0.039368, 0.222037, 0.097534, 8.559596, 0.063318, 0.024733, 0.062572, 994.360395, 2.411333, 0.049699, 0.190346, 0.000983, 5.719669, 0.033366, 0.013749, 0.000575, 0.001638, 1411.186695, 0.006220, 0.000217, 0.073166, 4.352805, 0.234570, 0.010746, 0.000062, 0.048516, 0.006298, 0.017534, 0.951606, 1.669100, 0.442608, 1.685749, 0.013016, 0.060877, 0.222343, 1.109708, 0.004123, 0.000623}; 
int RsatCSFeatID1[] = {21, 18, 24, 45, 32, 28, 18, 39, 39, 31, 28, 7, 8, 5, 59, 32, 48, 1, 60, 21, 31, 50, 48, 60, 59, 28, 26, 12, 3, 3, 63, 42, 1, 35, 4, 50, 53, 56, 36, 42, 23, 12, 35, 30, 22, 22, 64, 3, 3, 50, 12, 37, 12, 32, 42, 40, 12, 36, 22, 1, 17, 12, 42, 22, 23, 32, 3}; 
int RsatCSFeatID2[] = {30, 28, 33, 28, 41, 13, 32, 5, 32, 11, 48, 32, 30, 49, 26, 32, 49, 0, 1, 32, 26, 30, 0, 21, 59, 41, 41, 24, 17, 37, 63, 14, 27, 23, 40, 14, 63, 4, 35, 42, 26, 45, 14, 40, 26, 24, 45, 35, 26, 37, 44, 0, 29, 24, 37, 24, 14, 40, 40, 26, 40, 17, 50, 63, 8, 23, 24}; 
double RsatClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double RsatClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int RsatCSNumFeat = 67;
double VallstCSModel[] = {-3.531693, 0.432596, -0.494989, -0.265603, -0.373137, 3.119713, -2.719018, 0.730227, 0.008839, 0.029173, -1.399918, 0.650783, -0.508967, -7.893293, 0.172613, 0.293153, 0.324867, 0.168565, 0.817197, -0.256425, -0.379302, -0.708260, -0.302792, -0.647720, -0.208963, 0.117941, 0.047438, 7.121388, 0.407975, -0.103508, 0.005392, -0.009844, -0.137668, -0.485561, 0.101789, 0.275785, 3.338143, 0.474164, -0.011290, 0.104120, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.661170}; 
double VallstCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.126413, -0.167721, -0.676279, -0.616742, 0.311985, -0.357882, 0.008852, 0.414596, 0.164043, 1.364970, -0.699521, 0.281667, 0.383510, 0.228492, -0.164367, -0.192921, -0.385414, 0.240406, 0.472262, 0.086555, 0.112607, -1.032157, -0.132898, 0.226661, 0.759126, -0.363094, -0.678820, 0.444604, -0.288295, 0.041949, 0.670123, -0.594602, 0.337155, 0.290229, -0.109591, 0.095449, -0.126643, -0.051831, 0.057784, -0.064818, 2.813728}; 
double VallstCSFeatMean[] = {0.002598, 0.933917, 0.000295, 0.090845, 0.908984, 0.195478, 0.258677, 0.028383, 1.819118, 0.116697, 0.000099, 1.962662, 0.009698, 0.403394, 0.004113, 2579.770755, 0.002352, 1.522991, 0.932805, 4.826232, 9.877661, 0.043543, 0.168726, 1.169108, 23.352437, 2.456993, 26897778949.055557, 0.414660, 4.054502, 0.073855, 136.142769, 3771053.320789, 86.809978, 0.001110, 0.000642, 0.001389, 0.002595, 0.001885, 283.865162, 2.611238, 0.010197, 0.043543, 0.000694, 0.000627, 0.000051, 0.486388, 0.123123, 0.000769, 2627.200351, 0.094255, 0.221011, 4.242737, 1207.329692, 0.000456, 0.003407, 1403.227821, 0.002745, 0.015304, 0.378017, 0.000067, 0.004316, 0.056082, 0.027650, 0.003859, 0.033137, 0.000924, 1.279384, 0.002523, 0.001060, 671.993801, 1.390790, 5.157129, 0.149216, 8.322958, 0.102168, 0.000079, 0.001367, 0.023053, 627.359513, 463.509596}; 
double VallstCSFeatStd[] = {0.004055, 0.191963, 0.000431, 0.070227, 0.584428, 0.340347, 0.343140, 0.029191, 1.721104, 0.132796, 0.000217, 2.086234, 0.025183, 0.349696, 0.005348, 6184.349457, 0.005915, 1.027456, 1.117630, 3.558603, 25.421052, 0.054600, 0.201644, 1.040805, 32.864305, 1.068956, 267095671825.614900, 0.350493, 2.093082, 0.119187, 642.037667, 12716042.909721, 612.366030, 0.001290, 0.001450, 0.001639, 0.004050, 0.003555, 608.554963, 2.411333, 0.024733, 0.054600, 0.001480, 0.001165, 0.000107, 0.420826, 0.144246, 0.001483, 3548.931879, 0.111032, 0.254809, 3.611777, 2468.881086, 0.003749, 0.007987, 2264.158496, 0.010091, 0.028032, 0.610046, 0.000291, 0.009385, 0.072983, 0.037053, 0.007601, 0.049194, 0.001934, 3.031436, 0.004194, 0.001834, 1688.319810, 1.337340, 5.518858, 0.192136, 20.025163, 0.102830, 0.000143, 0.002159, 0.063318, 1054.374376, 775.935178}; 
int VallstCSFeatID1[] = {17, 60, 18, 50, 60, 22, 60, 10, 56, 42, 3, 53, 49, 60, 60, 53, 28, 64, 8, 53, 56, 17, 17, 64, 2, 1, 2, 17, 1, 22, 2, 44, 2, 42, 3, 30, 17, 17, 42, 56, 40, 3, 4, 32, 33, 8, 10, 3, 57, 10, 37, 57, 43, 33, 58, 57, 35, 37, 37, 33, 8, 33, 63, 33, 33, 24, 10, 11, 10, 43, 8, 8, 16, 21, 50, 32, 24, 23, 56, 57}; 
int VallstCSFeatID2[] = {4, 0, 30, 50, 60, 22, 22, 3, 30, 17, 26, 24, 3, 17, 30, 47, 26, 28, 17, 9, 27, 3, 47, 8, 24, 11, 2, 0, 4, 50, 4, 44, 6, 30, 6, 47, 9, 30, 44, 4, 4, 17, 18, 50, 24, 50, 17, 11, 20, 63, 16, 11, 20, 35, 26, 50, 18, 18, 8, 34, 24, 46, 18, 37, 58, 17, 58, 20, 30, 59, 20, 8, 18, 46, 17, 18, 59, 35, 59, 18}; 
double VallstClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double VallstClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int VallstCSNumFeat = 80;
double ZchaffCSModel[] = {-0.321019, -1.034937, -0.683013, -0.982565, -0.595747, 0.917769, 0.026154, 1.374353, -0.380429, 0.187298, -0.151489, 1.160148, 1.006604, -21.990112, 0.361212, 0.226538, 2.110262, -0.062183, -0.207187, -0.115770, -1.596039, 0.427224, -0.455964, -0.177583, -0.834969, 2.916060, 0.108387, -1.135860, 0.747376, -0.106680, 0.396286, 0.091726, -2.179045, 0.078464, -0.051740, -0.279718, 0.135727, -0.226004, 20.397149, 0.489468, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.782317}; 
double ZchaffCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.784198, 0.966169, -0.469270, 0.257144, 0.648919, -0.905007, 1.754549, -0.847224, -0.141396, -2.184101, 1.745396, 0.596070, 0.160942, 0.652699, -1.314393, -0.460811, -0.306836, 0.261332, 0.203324, -0.062765, -0.419947, -0.429938, -0.346102, -0.295538, -1.051594, 1.013516, 0.149690, -0.332691, -0.287719, 0.108285, -0.156942, 0.098135, -0.280429, -0.116553, 0.099109, 0.213911, -0.089604, 0.054710, -0.076715, 0.034388, 2.438167}; 
double ZchaffCSFeatMean[] = {0.131555, 0.045762, 0.006503, 1.483515, 0.507868, 0.837933, 0.016635, 30676.268814, 0.219770, 285.175101, 1647.770521, 1.240199, 0.000027, 44104.044013, 1.146206, 0.017351, 1.396768, 0.004316, 0.005744, 0.142371, 2.711898, 0.195478, 2.171407, 0.198667, 0.341898, 1.681691, 23.352437, 1.343757, 0.445117, 17.537666, 41433.599283, 187569255.134409, 1.330457, 13790549.995468, 3030.096793, 2813.664682, 0.000079, 0.158464, 45038.983871, 0.908984, 0.277242, 0.176879, 1.734740, 0.005638, 0.000606, 0.126551, 0.004438, 0.000520, 0.014243, 0.206238, 0.024136, 1.066265, 0.098608, 0.013472, 0.013072, 0.002363, 0.004899, 0.000150, 164.911953, 6.785453, 0.295442, 0.611863, 0.001415, 0.708723, 0.000027, 0.000021, 0.058633, 0.273921, 1.421779, 0.001063, 1.041802, 0.389815, 0.009613, 0.092988, 0.378017, 0.075353, 0.000020, 0.223649, 0.980976, 0.000024}; 
double ZchaffCSFeatStd[] = {0.249520, 0.064713, 0.009794, 1.592590, 0.458230, 0.927767, 0.020605, 155144.741477, 0.276440, 669.784124, 2809.337756, 0.740780, 0.000113, 157967.063610, 1.285797, 0.026122, 1.065759, 0.009385, 0.007771, 0.192238, 2.992874, 0.340347, 2.866433, 0.227582, 0.503444, 2.519728, 32.864305, 2.105380, 0.621108, 32.782892, 118436.177705, 790675924.214625, 1.059685, 40631223.202542, 8240.933253, 6884.751021, 0.000143, 0.405941, 157841.431439, 0.584428, 0.242804, 0.154675, 2.393212, 0.010069, 0.000956, 0.088192, 0.012284, 0.001638, 0.025821, 0.494269, 0.049304, 1.076981, 0.281114, 0.049699, 0.033366, 0.004675, 0.007913, 0.000591, 395.460374, 5.471407, 0.237579, 0.417634, 0.003475, 1.520503, 0.000068, 0.000062, 0.167177, 0.125860, 1.402512, 0.001312, 1.109708, 0.760076, 0.013739, 0.197187, 0.610046, 0.329891, 0.000112, 0.163575, 1.626613, 0.000236}; 
int ZchaffCSFeatID1[] = {28, 18, 28, 13, 41, 8, 13, 2, 54, 18, 60, 16, 32, 60, 56, 18, 21, 8, 31, 13, 8, 22, 8, 22, 13, 13, 2, 13, 25, 2, 2, 2, 60, 41, 31, 56, 18, 7, 2, 60, 31, 50, 25, 32, 31, 50, 22, 22, 30, 8, 7, 21, 35, 36, 35, 23, 50, 35, 57, 28, 31, 23, 32, 40, 30, 32, 40, 50, 31, 50, 8, 50, 12, 22, 8, 40, 35, 42, 25, 32}; 
int ZchaffCSFeatID2[] = {7, 17, 24, 28, 32, 54, 49, 22, 54, 56, 41, 0, 32, 2, 24, 18, 0, 24, 27, 22, 16, 22, 25, 25, 54, 8, 24, 21, 54, 32, 16, 56, 21, 41, 56, 25, 32, 21, 0, 60, 29, 23, 21, 28, 32, 29, 12, 24, 58, 7, 14, 20, 28, 35, 14, 30, 12, 30, 36, 28, 14, 0, 63, 29, 24, 24, 7, 0, 8, 30, 23, 40, 20, 37, 37, 35, 26, 15, 40, 34}; 
double ZchaffClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double ZchaffClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int ZchaffCSNumFeat = 80;
double EurekaWPCSModel[] = {1.004378, -0.896260, -1.176738, -0.348568, 0.491695, -0.635167, -3.048429, -1.416128, 3.177031, 0.582228, 0.458486, 0.577684, -3.386282, 1.164606, 1.676264, -1.079680, 0.516121, -0.357511, 1.006260, -2.920126, -0.100884, -0.468431, 0.529595, 0.716573, -0.336550, 0.270331, -0.425487, 0.720601, -0.543966, -2.656436, -0.946330, 0.905539, 1.584411, -0.053431, 0.096910, 0.610391, -0.434603, -0.322743, -0.063236, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.737487}; 
double EurekaWPCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.892514, -2.299325, -1.152663, 3.295949, 0.139549, -1.524002, 0.787898, 0.938592, -0.549128, 1.154016, -2.806057, 0.258588, -0.814455, -0.221614, -2.068118, -0.392616, -0.599201, 0.204775, -0.166588, 0.172904, -0.040419, -0.100053, 1.140192, 0.037762, 0.166034, 1.885920, -0.856097, 0.246271, 0.468125, 2.861630, 0.464112, -0.742613, 0.304352, 0.642374, -0.442401, 0.242802, -0.141716, -0.394577, -0.161318, 0.229638, 2.756141}; 
double EurekaWPCSFeatMean[] = {1.373760, 0.448017, 0.304055, 1.116266, 0.298289, 0.021486, 0.001262, 0.440063, 1.169108, 5.037999, 0.000965, 424.228068, 1900.761117, 4097.211931, 0.118216, 0.053290, 0.002218, 0.152972, 13790549.995468, 1.887816, 0.039734, 0.076102, 2579.770755, 0.001191, 0.618876, 743.966195, 0.227193, 0.053083, 0.961605, 1.330457, 0.031659, 0.000610, 1.396768, 2502.838776, 0.016635, 0.407079, 6.785453, 0.000702, 0.051874, 0.102168, 0.001004, 0.000610, 0.294568, 0.177893, 0.031239, 0.008168, 0.002568, 0.142683, 0.561871, 0.414660, 0.116697, 0.003046, 0.003353, 0.001800, 8393.432649, 0.001183, 0.058633, 0.033410, 0.031956, 0.000150, 2.636088, 0.000606, 0.000027, 0.126227, 0.001110, 1.041802, 1749.171056, 2.558363, 0.002506, 0.170047, 0.000938, 1596.562613, 0.000312, 0.002598, 0.020372, 0.003483, 0.338198, 0.121747, 0.506815}; 
double EurekaWPCSFeatStd[] = {1.248785, 0.300648, 0.864618, 0.603461, 0.296969, 0.028433, 0.001742, 0.529883, 1.040805, 4.649581, 0.001433, 762.993879, 3193.106551, 6718.096621, 0.241010, 0.064578, 0.002998, 0.118633, 40631223.202542, 1.263385, 0.092437, 0.071382, 6184.349457, 0.003845, 1.254423, 1380.307264, 0.339182, 0.076252, 0.842644, 1.059685, 0.135374, 0.001083, 1.065759, 5951.961105, 0.020605, 0.342285, 5.471407, 0.001443, 0.139814, 0.102830, 0.001703, 0.001083, 0.330279, 0.183608, 0.078785, 0.015888, 0.003944, 0.357387, 0.524797, 0.350493, 0.132796, 0.003814, 0.004646, 0.003002, 30805.033187, 0.001747, 0.167177, 0.097531, 0.064510, 0.000591, 6.318695, 0.000956, 0.000113, 0.143288, 0.001290, 1.109708, 3630.929704, 7.587463, 0.004586, 0.188799, 0.002446, 3057.336729, 0.001263, 0.004055, 0.042574, 0.012970, 0.258479, 0.190346, 0.573472}; 
int EurekaWPCSFeatID1[] = {21, 64, 8, 28, 21, 18, 14, 64, 64, 8, 13, 18, 41, 28, 14, 18, 62, 64, 41, 8, 42, 62, 53, 60, 53, 13, 13, 18, 28, 60, 28, 42, 21, 41, 49, 8, 28, 62, 51, 50, 32, 32, 17, 31, 7, 63, 32, 21, 29, 17, 42, 31, 25, 29, 46, 25, 40, 35, 36, 30, 40, 31, 32, 42, 42, 23, 31, 46, 32, 17, 16, 23, 27, 17, 7, 40, 50, 42, 16}; 
int EurekaWPCSFeatID2[] = {48, 64, 19, 14, 62, 62, 24, 13, 8, 28, 32, 53, 0, 41, 19, 64, 27, 62, 41, 0, 19, 62, 47, 26, 26, 41, 42, 47, 47, 21, 6, 32, 0, 21, 13, 62, 28, 32, 32, 17, 54, 42, 17, 63, 42, 33, 16, 19, 21, 0, 17, 4, 30, 30, 41, 32, 7, 21, 10, 35, 8, 32, 32, 54, 30, 8, 41, 19, 0, 54, 26, 41, 4, 4, 52, 32, 16, 42, 17}; 
double EurekaWPClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double EurekaWPClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int EurekaWPCSNumFeat = 79;
double KcnfsWPCSModel[] = {0.652210, -0.971761, 0.826295, -0.373666, 0.389800, 0.210483, -1.326934, 0.369413, -0.381061, -0.903757, -4.753867, -2.614805, -0.750203, 0.467619, -0.504794, 0.972792, 0.734665, 0.000630, -0.547541, -0.146047, -0.519171, 0.212759, -0.144295, 0.076623, 0.251993, 0.308333, -0.212641, 0.735681, -0.674445, 0.653470, 0.083247, 0.118789, -0.387507, 0.265948, -0.516476, 0.376193, 0.066807, -0.168966, 0.255450, 0.136316, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.504005}; 
double KcnfsWPCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.283076, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.222548, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.540026, 0.665956, -0.237954, -0.170146, -0.471379, 0.595502, -0.624987, -0.595956, -0.361137, -0.289111, 0.022027, 0.419504, 0.112566, 0.858814, 0.044497, -0.530160, -1.533216, -0.440235, -0.222603, 0.415678, -0.163530, -0.253358, -0.236734, 0.875556, -0.155167, 0.036298, 0.017819, 0.105201, -1.402421, 0.482298, 0.323754, -0.282142, 0.297174, 0.281514, -0.025421, 0.232188, -0.026272, -0.770410, 3.399984}; 
double KcnfsWPCSFeatMean[] = {0.002160, 0.274700, 0.185346, 14464.839242, 780.154794, 0.493102, 0.585795, 452.600639, 0.504300, 0.000043, 0.001493, 0.000021, 0.101369, 0.118670, 19.803068, 0.000868, 0.150418, 77.913223, 5.037999, 0.229255, 21045765.450717, 463.509596, 91.536037, 199.663522, 0.026646, 0.548482, 3698.338709, 0.673538, 0.165581, 0.001191, 0.003483, 10847780.505376, 0.050085, 0.135303, 2.270200, 6.634958, 5997633.060036, 4.187258, 0.344521, 0.900025, 0.000237, 0.001799, 0.000036, 0.052716, 0.000018, 33581.543173, 0.134928, 1.562306, 0.000207, 0.839077, 0.004978, 0.063321, 17.537666, 92287297.458781, 0.380589, 0.509841, 0.000127, 0.001390, 0.000978, 0.347886, 0.270573, 2.177185, 0.001322, 0.007592, 0.000272, 0.000285, 0.008219, 0.004304, 0.000271, 0.053976, 0.004790, 0.005013, 0.052619, 3.957133, 3.398946, 5309.617210, 0.112157, 4373.633733}; 
double KcnfsWPCSFeatStd[] = {0.003582, 0.287011, 0.233252, 45449.348911, 1526.947150, 0.577305, 0.315231, 1019.845107, 0.419781, 0.000127, 0.004123, 0.000062, 0.140000, 0.191523, 84.132979, 0.002745, 0.223318, 327.261995, 4.649581, 0.577366, 61494279.189524, 775.935178, 180.601057, 468.189146, 0.060159, 0.452478, 9997.591569, 0.771884, 0.227590, 0.003845, 0.012970, 28292525.714125, 0.079107, 0.245869, 5.932006, 15.037980, 18516390.251626, 14.926410, 0.247706, 1.082046, 0.001008, 0.002076, 0.000159, 0.074258, 0.000060, 129654.157096, 0.492069, 1.341563, 0.000626, 1.086598, 0.023369, 0.168557, 32.782892, 467882570.173650, 0.421719, 0.464871, 0.000567, 0.002501, 0.002100, 0.364555, 0.349983, 6.576646, 0.002389, 0.009791, 0.000635, 0.000626, 0.021528, 0.010165, 0.000634, 0.120756, 0.014253, 0.018087, 0.121239, 9.303008, 4.352805, 19960.134280, 0.194951, 20989.866558}; 
int KcnfsWPCSFeatID1[] = {24, 23, 31, 47, 43, 8, 60, 56, 44, 30, 23, 24, 31, 5, 61, 37, 23, 61, 8, 13, 43, 57, 44, 56, 18, 23, 2, 8, 5, 60, 40, 57, 52, 52, 37, 46, 43, 46, 63, 8, 12, 54, 34, 23, 27, 52, 7, 23, 7, 5, 34, 22, 32, 44, 23, 44, 32, 23, 27, 32, 22, 52, 22, 23, 4, 27, 36, 49, 33, 7, 12, 7, 5, 27, 12, 36, 59, 44}; 
int KcnfsWPCSFeatID2[] = {64, 13, 10, 2, 13, 10, 64, 52, 24, 30, 32, 32, 37, 37, 44, 32, 37, 57, 28, 52, 56, 18, 37, 37, 22, 23, 3, 63, 22, 26, 32, 44, 3, 42, 46, 0, 44, 22, 0, 47, 24, 30, 49, 18, 26, 2, 58, 28, 32, 0, 23, 36, 2, 2, 5, 6, 9, 24, 36, 44, 0, 28, 27, 33, 33, 33, 18, 22, 9, 64, 36, 36, 36, 44, 44, 2, 22, 58}; 
double KcnfsWPClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double KcnfsWPClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int KcnfsWPCSNumFeat = 78;
double MarchWPCSModel[] = {-0.574545, 0.257627, 0.659332, 0.305827, 0.793248, -0.269149, 2.725458, -0.360602, 0.152622, -0.619916, 0.748963, -0.172069, 0.382225, -0.115927, -0.071533, -1.741348, -1.042983, 0.610736, -0.664233, 0.039730, 0.361339, -0.349053, 0.063375, 0.197211, -0.250164, 0.842420, -0.056996, 0.589688, -0.283371, -1.177843, -0.509325, 0.169802, 0.488887, -1.066289, 0.262424, 0.432464, 0.065107, -0.382911, -0.043999, 0.177237, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 2.250966}; 
double MarchWPCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.738233, -0.220802, -0.303643, -0.062886, 1.964269, 0.050283, -1.298615, 1.116159, 0.222140, -0.006927, -1.370326, -0.796858, 1.027797, 1.816834, 0.591763, -0.499502, -0.004366, 0.433904, 0.863907, -0.884506, 0.635421, -1.029777, -0.329211, -0.516593, 0.975378, -0.538262, 0.514191, 0.355865, -0.080366, 0.271018, -0.250549, -0.162510, 0.260130, -0.439426, -4.480149, 0.189954, 4.132039, 0.303597, -0.091011, -0.054841, 3.016125}; 
double MarchWPCSFeatMean[] = {0.004215, 0.084027, 2471.149148, 0.507207, 0.001060, 0.002836, 0.931749, 0.434076, 28345.710756, 0.001642, 0.016635, 35.735972, 10.056058, 0.177029, 14.282045, 0.144432, 0.653304, 0.074040, 0.002037, 113450421.327957, 1.146206, 0.423602, 0.024723, 0.002679, 0.001473, 2702.028678, 4.242737, 84.737758, 0.050085, 3827.864356, 0.023136, 171.067650, 0.001799, 0.009703, 0.135110, 0.005150, 938.762728, 0.272576, 0.084769, 226.944188, 0.003604, 0.261286, 1403.725722, 17.537666, 0.002662, 0.143189, 0.000476, 0.031305, 0.611377, 0.000042, 0.004323, 0.000520, 0.344521, 227587753.917563, 0.003353, 0.045210, 0.001909, 2.525680, 0.400946, 0.103893, 0.098120, 11086.051189, 110.994589, 0.211294, 0.270573, 0.182571, 0.067616, 0.000155, 0.005013, 0.004790, 0.000294, 653.108513, 0.009110, 0.415162, 0.002456, 0.094205, 0.002247, 719.019680, 0.014067, 0.692914}; 
double MarchWPCSFeatStd[] = {0.005061, 0.080759, 5079.324799, 1.512050, 0.001834, 0.005693, 0.787955, 0.390794, 117971.572319, 0.002396, 0.020605, 84.899179, 9.328212, 0.371889, 11.934548, 0.161430, 0.698612, 0.165580, 0.002940, 771872402.340932, 1.285797, 0.342774, 0.082825, 0.003377, 0.001695, 6241.201275, 3.611777, 373.748525, 0.079107, 5367.278452, 0.037533, 388.084386, 0.002076, 0.015854, 0.104510, 0.009329, 2205.144419, 0.373635, 0.113941, 650.001541, 0.011797, 0.201159, 3352.279770, 32.782892, 0.011306, 0.125589, 0.001139, 0.070932, 0.272707, 0.000269, 0.019370, 0.001638, 0.247706, 800580203.968043, 0.004646, 0.108948, 0.003260, 2.461197, 0.243143, 0.182983, 0.259155, 57312.190627, 182.506181, 0.225454, 0.349983, 0.275264, 0.114901, 0.000577, 0.018087, 0.014253, 0.000458, 1488.520710, 0.020282, 0.515148, 0.011409, 0.097439, 0.011394, 1481.136324, 0.033874, 1.749106}; 
int MarchWPCSFeatID1[] = {30, 3, 60, 52, 10, 60, 25, 20, 31, 3, 13, 44, 55, 52, 12, 3, 20, 7, 31, 1, 56, 47, 52, 10, 31, 47, 57, 55, 3, 60, 31, 10, 54, 12, 3, 13, 31, 25, 10, 55, 38, 64, 57, 2, 38, 54, 7, 63, 64, 34, 12, 22, 63, 2, 25, 54, 23, 57, 54, 36, 19, 2, 2, 54, 22, 64, 36, 36, 7, 12, 25, 57, 27, 25, 36, 54, 36, 2, 38, 52}; 
int MarchWPCSFeatID2[] = {0, 20, 56, 20, 30, 24, 0, 31, 2, 12, 49, 49, 12, 47, 57, 25, 25, 0, 30, 1, 24, 0, 12, 61, 11, 57, 11, 61, 52, 57, 49, 44, 30, 13, 60, 4, 44, 10, 10, 49, 9, 54, 22, 32, 6, 63, 30, 7, 0, 9, 7, 24, 0, 57, 30, 7, 11, 6, 0, 0, 22, 19, 27, 23, 0, 22, 25, 26, 36, 36, 26, 38, 25, 17, 9, 38, 11, 7, 7, 0}; 
double MarchWPClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double MarchWPClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int MarchWPCSNumFeat = 80;
double MinisatWPCSModel[] = {-0.347590, -0.823553, -0.373015, -0.480510, -0.591225, 0.811113, 0.131428, 0.331283, 0.143912, 0.735979, 0.134244, 0.020363, -0.229000, -1.201138, -0.856803, 1.923021, -0.308810, 0.589828, -0.193925, -0.468800, -0.437122, -1.039947, 0.085225, -0.121234, 0.097289, -0.347095, 0.543521, 0.000685, -0.353192, 0.169914, -1.578561, 0.242802, 0.303625, 1.117378, 0.288137, -0.403526, 0.371040, 0.158711, 0.235204, 0.116498, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.345757}; 
double MinisatWPCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.448194, -0.153938, 1.235019, -0.896344, -0.137608, 1.989195, -1.031073, -2.070723, 0.497568, -0.563324, 0.705676, -0.908095, 0.482954, -0.258536, 0.075223, 0.056817, 0.680564, -0.481712, -0.981580, 0.109569, 0.122017, 0.425860, -0.071779, 0.117596, -0.243680, -0.118551, -0.976415, 0.825708, 0.507889, 0.486350, -0.472281, -0.005880, 0.310410, 0.071940, -0.080974, 0.045448, 0.399712, 0.302967, 0.090143, -0.145013, 2.597297}; 
double MinisatWPCSFeatMean[] = {0.004672, 0.045762, 0.000170, 0.274700, 0.004113, 1075.255627, 0.754257, 1.325993, 37290.001772, 0.123672, 1.146206, 0.000079, 0.222481, 0.000276, 6235.040194, 3030.096793, 0.598055, 0.354722, 0.000051, 64646969.297939, 33581.543173, 2413.340464, 209.177798, 0.003815, 1.487917, 0.578365, 0.002764, 233626633.400538, 0.548482, 0.034393, 0.000021, 15951.040392, 17.537666, 0.000010, 0.004970, 0.002516, 0.001440, 285.175101, 0.294070, 0.131030, 0.002017, 0.037879, 292.785593, 1.209355, 0.073855, 0.117930, 0.001389, 0.182571, 0.282574, 0.000165, 0.198667, 0.165581, 0.001142, 0.000256, 732.001791, 1250.247278, 0.000422, 0.002352, 0.031239, 0.224009, 1527.295311, 0.143189, 0.145243, 10847780.505376, 1.041802, 0.147562, 2.031288, 0.140331, 0.606028, 0.014018, 377.420034, 1486.466956, 123.684351, 0.058633, 2.636088, 366.081028, 2.803744, 0.239713, 0.939893, 0.074678}; 
double MinisatWPCSFeatStd[] = {0.005870, 0.064713, 0.000291, 0.287011, 0.005348, 1963.713081, 0.845785, 4.970332, 260662.372638, 0.107325, 1.285797, 0.000143, 0.119395, 0.000751, 9504.183595, 8240.933253, 1.470163, 0.442608, 0.000107, 183056590.232065, 129654.157096, 6406.643554, 417.421149, 0.004187, 2.309641, 0.522868, 0.005505, 820510163.177848, 0.452478, 0.098461, 0.000062, 57503.457778, 32.782892, 0.000033, 0.010289, 0.005470, 0.003649, 669.784124, 0.339895, 0.184497, 0.006579, 0.075365, 619.010700, 0.759024, 0.119187, 0.222343, 0.003157, 0.275264, 0.168867, 0.000298, 0.227582, 0.227590, 0.001895, 0.001062, 1334.027929, 2212.365996, 0.000983, 0.005915, 0.078785, 0.217459, 3224.462359, 0.125589, 0.179897, 28292525.714125, 1.109708, 0.185888, 3.260169, 0.235917, 0.649479, 0.025854, 5157.396239, 3150.587284, 1265.497771, 0.167177, 6.318695, 611.348779, 2.207563, 0.335261, 0.646039, 0.082545}; 
int MinisatWPCSFeatID1[] = {21, 18, 31, 23, 60, 17, 21, 52, 1, 59, 56, 18, 60, 17, 8, 56, 21, 1, 33, 55, 52, 56, 18, 27, 25, 59, 8, 2, 23, 18, 24, 59, 2, 30, 52, 21, 27, 18, 23, 18, 6, 3, 43, 43, 22, 22, 6, 22, 64, 5, 22, 22, 6, 7, 43, 54, 23, 28, 7, 3, 8, 63, 37, 57, 8, 44, 5, 3, 8, 7, 51, 5, 37, 7, 8, 37, 1, 22, 28, 37}; 
int MinisatWPCSFeatID2[] = {30, 17, 26, 13, 30, 55, 23, 8, 46, 62, 24, 32, 62, 26, 55, 31, 52, 26, 24, 55, 2, 5, 45, 14, 25, 0, 32, 55, 23, 52, 32, 2, 32, 26, 27, 24, 19, 56, 17, 25, 50, 22, 63, 30, 50, 63, 23, 64, 14, 26, 25, 5, 5, 24, 64, 57, 26, 26, 42, 8, 44, 54, 25, 44, 23, 26, 8, 5, 42, 23, 54, 41, 51, 40, 40, 57, 30, 15, 54, 54}; 
double MinisatWPClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double MinisatWPClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int MinisatWPCSNumFeat = 80;
double RsatWPCSModel[] = {-1.511163, -0.209722, -0.235293, 0.596226, -0.649140, 0.202466, -1.854316, 2.130483, -0.388768, -1.211638, -0.310360, 1.939379, -1.583183, 0.941691, -0.425630, -0.858176, -0.429536, 2.160295, -2.041196, 0.256025, 0.757935, -0.146996, -0.192761, 0.186515, 0.053074, -0.080797, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.278629}; 
double RsatWPCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -0.441547, -0.734537, 0.339235, 1.672775, -1.871091, -0.141820, -0.728076, 0.242682, -1.430373, -1.043626, -0.340327, 1.447935, -0.817327, 1.943857, -0.186646, 0.208653, 0.244261, -0.307102, 0.152486, 0.241677, 1.281752, -1.277142, 1.229662, -0.311705, 0.053697, 0.011475, -0.332835, 0.713995, 0.724854, -0.387581, -0.479744, -0.590477, 0.170793, -0.197376, 0.321694, -0.238256, 0.484108, -0.158176, 0.122147, -0.229705, 2.519360}; 
double RsatWPCSFeatMean[] = {0.004672, 0.239877, 0.004113, 2.456993, 0.110592, 4367.927255, 0.000051, 0.006684, 3087.498162, 0.933917, 125.437963, 0.018818, 3.600486, 8174.774777, 2.298869, 0.245378, 0.000295, 0.431895, 0.018188, 0.000244, 0.209205, 1.541564, 5105.948367, 6.785453, 0.008263, 1.539773, 0.002017, 0.073855, 3.299229, 0.153032, 0.206238, 0.250850, 0.579092, 0.063321, 0.165581, 1.493585, 0.000027, 1.674386, 0.779909, 0.085638, 0.002214, 0.014018, 0.001142, 0.047909, 0.046573, 0.172302, 1.053016, 0.228294, 0.344521, 0.000597, 0.121747, 0.548475, 0.270573, 0.000492, 2.270200, 0.004381, 0.057323, 0.000995, 0.009217, 0.000155, 0.000634, 0.001063, 0.082248, 0.301799, 0.321798, 0.075353}; 
double RsatWPCSFeatStd[] = {0.005870, 0.279317, 0.005348, 1.068956, 0.580483, 6460.981208, 0.000107, 0.007796, 9069.457172, 0.191963, 370.262913, 0.101541, 28.740353, 20081.818168, 1.122857, 0.323142, 0.000431, 3.221109, 0.084163, 0.000910, 0.277967, 0.964842, 12185.196441, 5.471407, 0.010076, 1.015389, 0.006579, 0.119187, 7.170333, 0.202336, 0.494269, 0.396269, 0.833271, 0.168557, 0.227590, 1.156688, 0.000113, 1.559497, 1.251877, 0.126498, 0.005972, 0.033166, 0.001895, 0.107191, 0.081632, 0.298386, 1.809804, 0.180857, 0.247706, 0.001877, 0.190346, 1.156097, 0.349983, 0.002106, 5.932006, 0.023062, 0.140119, 0.003124, 0.024180, 0.000577, 0.005003, 0.001312, 0.255196, 0.519314, 0.433434, 0.329891}; 
int RsatWPCSFeatID1[] = {21, 18, 60, 1, 48, 28, 33, 8, 1, 60, 1, 60, 49, 1, 60, 18, 18, 21, 21, 18, 18, 45, 1, 28, 60, 30, 6, 22, 46, 22, 7, 63, 28, 22, 22, 31, 32, 28, 22, 22, 22, 31, 6, 13, 31, 5, 13, 10, 63, 63, 42, 28, 22, 32, 46, 22, 38, 22, 10, 26, 34, 50, 31, 42, 42, 40}; 
int RsatWPCSFeatID2[] = {30, 28, 30, 11, 7, 45, 24, 30, 15, 0, 49, 6, 49, 28, 28, 8, 30, 49, 11, 6, 21, 11, 8, 28, 27, 45, 50, 50, 63, 31, 8, 5, 37, 36, 5, 28, 32, 5, 28, 10, 61, 61, 5, 36, 36, 38, 13, 0, 0, 26, 42, 19, 0, 36, 37, 34, 36, 30, 35, 36, 34, 30, 7, 5, 40, 35}; 
double RsatWPClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double RsatWPClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int RsatWPCSNumFeat = 66;
double VallstWPCSModel[] = {-1.426178, -0.285767, -0.276159, -1.386101, -0.790492, -1.783586, 0.028719, -0.203730, -1.105674, 1.463584, 2.972084, -2.984420, -0.768886, 0.700006, 4.353467, 2.145280, -0.840040, -0.869052, 0.326775, 0.882850, -1.331769, -1.757511, 0.520480, -0.436313, -0.913101, 0.075553, 0.386913, -0.609670, 0.284274, -0.928327, -0.239954, 0.693440, -0.705699, 0.713468, -1.018184, -0.452753, 0.961054, 6.670888, 0.391442, -6.485655, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.073577}; 
double VallstWPCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.820555, -1.983035, 1.313290, 1.198706, -1.587304, 0.436189, -1.196581, 1.617844, -1.262505, 0.432558, 0.454973, 0.197608, 0.333479, -0.500088, -0.085762, 0.097563, 0.968156, 0.359119, 0.657524, 0.145516, 0.567292, -0.289040, -0.214704, -0.639929, 0.211222, 0.253972, -0.360187, -0.071562, 0.256868, -0.408053, 0.027213, -0.136852, 0.192130, 0.033676, -0.395211, 0.587618, -0.139481, -0.370450, -0.027631, 0.188291, 3.033264}; 
double VallstWPCSFeatMean[] = {0.002595, 0.933917, 0.045762, 0.000051, 666.821052, 0.002657, 0.304055, 0.041826, 3023.885889, 217.874711, 0.000924, 0.001166, 505.962818, 0.000693, 0.137800, 644.362714, 588.771892, 0.380589, 0.017000, 0.187711, 0.126551, 0.180482, 0.052716, 0.001101, 0.079162, 0.000843, 0.453996, 0.047307, 675.094890, 0.000252, 0.009190, 0.000294, 0.152403, 0.486388, 5.157129, 0.002362, 0.007592, 0.258271, 0.131030, 0.270573, 0.206238, 0.001493, 0.008168, 0.000514, 1.240199, 0.002363, 0.092349, 0.785962, 0.440063, 0.085502, 1.732851, 0.116697, 366.081028, 1.539773, 0.001110, 0.058633, 1.053016, 1.224732, 0.344521, 0.000285, 1400.647751, 0.548482, 1.814952, 2432.674593, 7045.627823, 0.126268, 0.000938, 2.636088, 0.069617, 0.200040, 0.003859, 0.001777, 78.735161, 0.002598, 0.005412, 0.006684, 0.002218, 0.792496, 0.227193, 0.045154}; 
double VallstWPCSFeatStd[] = {0.004050, 0.191963, 0.064713, 0.000107, 1487.611261, 0.004360, 0.864618, 0.089307, 6491.843647, 538.578539, 0.001934, 0.001775, 1125.854484, 0.001478, 0.269067, 1557.879210, 865.484418, 0.421719, 0.030201, 0.120704, 0.088192, 0.332096, 0.074258, 0.002462, 0.080955, 0.001587, 0.417753, 0.100139, 1192.797073, 0.000743, 0.016261, 0.000458, 0.306158, 0.420826, 5.518858, 0.008089, 0.009791, 0.343575, 0.184497, 0.349983, 0.494269, 0.004123, 0.015888, 0.001582, 0.740780, 0.004675, 0.105921, 0.734596, 0.529883, 0.091031, 1.719492, 0.132796, 611.348779, 1.015389, 0.001290, 0.167177, 1.809804, 0.799890, 0.247706, 0.000626, 3655.158422, 0.452478, 1.833276, 4118.183572, 9436.977806, 0.122437, 0.002446, 6.318695, 0.049325, 0.234570, 0.007601, 0.006647, 202.522610, 0.004055, 0.006101, 0.007796, 0.002998, 0.740365, 0.339182, 0.048516}; 
int VallstWPCSFeatID1[] = {17, 60, 18, 33, 45, 9, 8, 50, 8, 18, 17, 29, 17, 18, 29, 43, 1, 23, 23, 62, 29, 23, 18, 17, 18, 5, 25, 62, 45, 19, 48, 25, 19, 8, 8, 33, 23, 48, 18, 22, 7, 32, 33, 32, 16, 23, 62, 16, 13, 62, 32, 42, 37, 30, 30, 7, 13, 11, 63, 33, 56, 23, 56, 57, 8, 62, 16, 8, 62, 37, 33, 8, 7, 17, 16, 8, 62, 21, 42, 37}; 
int VallstWPCSFeatID2[] = {9, 0, 17, 24, 22, 23, 19, 19, 43, 43, 24, 24, 43, 9, 19, 22, 62, 5, 49, 15, 50, 19, 23, 6, 15, 32, 23, 19, 50, 26, 27, 26, 19, 50, 8, 33, 33, 22, 25, 0, 8, 23, 63, 10, 0, 30, 17, 20, 64, 63, 57, 17, 57, 45, 42, 40, 13, 43, 0, 27, 13, 23, 11, 13, 57, 13, 26, 40, 42, 0, 37, 26, 55, 4, 30, 30, 27, 64, 13, 42}; 
double VallstWPClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double VallstWPClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int VallstWPCSNumFeat = 80;
double ZchaffWPCSModel[] = {0.004186, 0.351499, -0.511994, -0.435751, 2.029924, 0.104921, 0.110401, 0.350579, -0.810566, -0.237387, -0.070652, 0.286785, -1.436542, -1.279194, 0.535416, -0.760096, -0.518265, 0.202425, -0.750432, 0.459211, 0.090360, -0.126405, 0.173823, 0.038402, 0.380978, 0.314658, 0.036596, -0.102568, -0.026022, 0.327150, -1.304217, -0.193868, -0.089849, -0.273347, -0.291557, 0.325334, -0.056836, 0.425684, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.935431}; 
double ZchaffWPCUModel[] = {0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, -1.276780, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 1.502866, -0.421202, -0.805147, -0.839963, 0.792654, -0.851290, 1.101627, -0.230041, -1.515945, -0.448816, -0.446048, 0.035330, 0.482363, 1.126076, 1.371852, -0.674792, 0.577707, 0.004634, 0.684038, -0.008085, 0.359154, 1.515922, -0.318476, 1.124395, -0.622824, -0.179000, 0.668566, -1.591029, 0.938304, -1.324729, -1.171906, 1.187204, -0.356659, 1.004323, -0.632810, -1.253331, -0.477758, 0.549874, 0.312056, 2.829605}; 
double ZchaffWPCSFeatMean[] = {0.001389, 0.239877, 0.585795, 1.483515, 1.169108, 13790549.995468, 285.175101, 0.002516, 0.002037, 0.507868, 6.785453, 0.223649, 0.053290, 5.037999, 1182.095104, 1624.086249, 0.170260, 0.005744, 0.002740, 0.000627, 209.177798, 0.090845, 0.124240, 0.000079, 0.243503, 0.007035, 1.079237, 0.009110, 1.396768, 0.008263, 0.000825, 0.277651, 0.751763, 0.471348, 0.511834, 0.493808, 2238.213463, 9.877661, 0.277242, 0.176879, 1.734740, 0.001004, 0.001110, 0.031239, 0.250850, 0.000159, 1.493585, 0.000272, 0.005002, 0.000615, 0.019949, 0.085884, 0.016697, 0.006797, 0.020044, 0.094205, 0.939893, 0.000067, 0.453153, 0.673538, 6504.436569, 4035.686850, 719.019680, 0.265359, 0.209205, 1.041802, 0.754257, 0.421346, 0.074678, 0.200040, 0.001418, 0.038808, 0.052328, 0.016294, 0.211294, 0.250485, 0.217643}; 
double ZchaffWPCSFeatStd[] = {0.001639, 0.279317, 0.315231, 1.592590, 1.040805, 40631223.202542, 669.784124, 0.005470, 0.002940, 0.458230, 5.471407, 0.163575, 0.064578, 4.649581, 2973.357563, 2747.955964, 0.120544, 0.007771, 0.004074, 0.001165, 417.421149, 0.070227, 0.124817, 0.000143, 0.224771, 0.038002, 1.251768, 0.020282, 1.065759, 0.010076, 0.001493, 0.206788, 0.565554, 0.266504, 0.747867, 1.767480, 4813.442068, 25.421052, 0.242804, 0.154675, 2.393212, 0.001703, 0.001290, 0.078785, 0.396269, 0.000528, 1.156688, 0.000635, 0.008566, 0.002719, 0.023934, 0.093615, 0.051498, 0.018007, 0.071374, 0.097439, 0.646039, 0.000291, 0.661605, 0.771884, 34443.917721, 8626.696427, 1481.136324, 0.243712, 0.277967, 1.109708, 0.845785, 0.444938, 0.082545, 0.234570, 0.003091, 0.058547, 0.127574, 0.052476, 0.225454, 0.236467, 0.288352}; 
int ZchaffWPCSFeatID1[] = {47, 18, 60, 13, 8, 41, 18, 21, 31, 41, 28, 42, 18, 28, 64, 41, 64, 27, 24, 50, 18, 50, 50, 18, 64, 18, 56, 27, 21, 60, 47, 60, 41, 64, 47, 47, 56, 56, 31, 50, 25, 32, 42, 7, 5, 35, 31, 33, 5, 34, 27, 31, 63, 50, 25, 38, 28, 34, 38, 8, 2, 21, 7, 63, 21, 23, 23, 21, 37, 37, 38, 28, 8, 38, 23, 20, 21}; 
int ZchaffWPCSFeatID2[] = {30, 28, 64, 28, 64, 41, 56, 24, 30, 32, 28, 15, 64, 8, 56, 48, 42, 31, 0, 32, 45, 50, 47, 32, 47, 49, 6, 25, 0, 27, 24, 42, 24, 15, 25, 48, 15, 27, 29, 23, 21, 54, 30, 42, 63, 4, 28, 4, 4, 18, 28, 18, 35, 35, 35, 54, 54, 33, 8, 63, 18, 1, 2, 64, 18, 8, 21, 63, 54, 0, 30, 33, 33, 35, 54, 54, 37}; 
double ZchaffWPClassCoeffCS[] = {0.000000, 0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
double ZchaffWPClassCoeffCU[] = {0.000000, -0.500000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000}; 
int ZchaffWPCSNumFeat = 77;
#endif
