LP_SOLVE(1)                                           LP_SOLVE(1)



NNAAMMEE
       lp_solve  - solve (mixed integer) linear programming prob
       lems

SSYYNNOOPPSSIISS
       llpp__ssoollvvee [_o_p_t_i_o_n_s] [[<] _i_n_p_u_t_-_f_i_l_e]

OOPPTTIIOONNSS
       -v_l_e_v_e_l     Set verbosity:
                      -v1: CRITICAL
                      -v2: SEVERE
                      -v3: IMPORTANT (default)
                      -v4: NORMAL
                      -v5: DETAILED
                      -v6: FULL
                   If level not provided (-v) then  -v4  (NORMAL)
                   is assumed.

       -time       Print CPU time to parse input and to calculate
                   result.

       -timeout _s_e_c
                   Timeout after _s_e_c seconds  when  not  solution
                   found.

       -S_d_e_t_a_i_l    Print solution. If _d_e_t_a_i_l omitted, then -S2 is
                   used.
                      -S0: Print nothing
                      -S1: Only objective value
                      -S2: Obj value+variables (default)
                      -S3: Obj value+variables+constraints
                      -S4: Obj value+variables+constraints+duals
                      -S5: Obj value+variables+constraints+duals+lp model
                      -S6: Obj value+variables+constraints+duals+lp model+scales

       -h          Help mode, prints the usage.

       -d          Debug  mode,  all  intermediate  results   are
                   printed, and the branch-and-bound decisions in
                   case of (mixed) integer problems.

       -min        Minimize the objective function. This  is  the
                   default for MPS input.  In lp_solve format you
                   can specify minimization  or  maximization  in
                   the  input  file  as  well.  The  command line
                   option overrides.

       -max        Maximize the objective function. This  is  the
                   default   for   lp_solve   format  input.   In
                   lp_solve format you can  specify  minimization
                   or maximization in the input file as well. The
                   command line option overrides.

       -p          Only functional for pure  LP  problems.  Print
                   the  values  of  the  dual variables. They are
                   named r_1 until r_XXXXX  unless  specified  by
                   the  user.   Note  that bounds (constraints on
                   just  one  variable)  also  have  dual  values
                   though they are not given a row in the matrix.

       -b _b_o_u_n_d    Specify an upper (when  minimizing)  or  lower
                   (when  maximizing)  limit for the value of the
                   objective function to the program. Only useful
                   for   (mixed)   integer  problems.   If  close
                   enough, may speed  up  the  calculations.  The
                   same result can be obtained by adding an extra
                   constraint to the problem.

       -c          When branching  in  MILP  problems,  take  the
                   ceiling  of  the selected non-integer variable
                   first instead of the floor. This can influence
                   the speed of MILP problems.

       -ca         When branching in MILP problems, let the algo
                   rithm decide if it should take  the  floor  or
                   ceiling  value  first.  This can influence the
                   speed of MILP problems.

       -B_r_u_l_e      Specify branch-and-bound rule:
                      -B0: Select Lowest indexed non-integer column (default)
                      -B1: Select Random non-integer column
                      -B2: Select Largest deviation from an integer value
                      -B3: Select Best ???
                      -B4: Select Median value deviation from an integer value
                      -B5: Select Greedy ???

       -e _v_a_l_u_e    _v_a_l_u_e is the tolerance of the test for whether
                   the  value  of  a  variable is really integer.
                   _v_a_l_u_e must be between 0 and 0.5. Default value
                   is  1e-6  and  should  be OK for most applica
                   tions. Of course only useful  for  MILP  prob
                   lems.

       -i          Print  all  intermediate  valid solutions. Can
                   give you useful solutions even  if  the  total
                   run time is too long.  Only useful for (mixed)
                   integer problems.

       -s[_m_o_d_e]    Use automatic problem scaling:
                          -s:
                         -s0: Numerical range-based scaling
                         -s1: Geometric scaling
                         -s2: Curtis-reid scaling
                   This might improve the numerical stability  of
                   your problem.

       -sp         Also do power scaling.

       -sl         Also do Lagrange scaling.

       -si         Also do Integer scaling.

       -I          Print info after reinverting.

       -t          Trace pivot selection.

       -lp         Read from LP file (default).

       -mps        Read  from  MPS file instead of lp file. For a
                   short     introduction     to     MPS      see
                   http://users.iems.nwu.edu/~neos/mps_format.txt

       -parse_only Parse input file  but  do  not  calculate  (ie
                   check).

       -presolve   Presolve problem before optimizing.

       -improve_l_e_v_e_l
                   Iterative improvement level:
                         -improve0: none (default)
                         -improve1: FTRAN only
                         -improve2: BTRAN only
                         -improve3: FTRAN + BTRAN

       -degen      Use random perturbations to reduce degeneracy,
                   can increase numerical instability.

       -trej _T_r_e_j  Set minimum pivot value to _T_r_e_j.

DDEESSCCRRIIPPTTIIOONN
       The linear programming problem can be formulated as: Solve
       A.x >= V1, with V2.x maximal. A is a matrix, x a vector of
       (nonnegative) variables, V1 a vector called the right hand
       side, and V2 a vector specifying the objective function.
       Any number of the variables may be specified to be of type
       integer.
       This program solves problems of this kind. It is  slightly
       more  general than the above problem, in that every row of
       A (specifying one constraint) can have its own  (in)equal
       ity,  <=,  >=  or  =.  The result specifies values for all
       variables.
       Uses a 'Simplex' algorithm and sparse matrix methods,  for
       pure  LP  problems.   If  one  or more of the variables is
       declared integer, the Simplex algorithm is iterated with a
       branch  and  bound  algorithm,  until  the desired optimal
       solution is found.
       The "-i" option will print all  intermediate  valid  solu
       tions.

IINNPPUUTT SSYYNNTTAAXX
       The default input syntax is a set of algebraic expressions
       and "int" declarations in the following order:

       <objective function>
       <constraint>*
       <declaration>*

       where:

       - <objective function> is a linear  combination  of  vari
         ables,  ending  with a semicolon, optionally preceded by
         "max: " or "min: " to indicate whether you want it to be
         minimized  or  maximized.  The  case  is  not important,
         "Max:" or "MAX:" will work as well. Maximization is  the
         default. Alternatives are minimise, minimize, maximise,
         Maximize

       - <constraint>  is an optional constraint name followed by
         a colon plus a linear combination of variables and  con
         stants or (just one) constraint name followed by a colon
         (a range) or (just one) variable name without a colon (a
         bound),  followed  by  a  relational  operator, followed
         again by a linear  combination  of  variables  and  con
         stants, ending with a semicolon. The relational operator
         can be any of the following:  "<"  "<="  "="  ">"  ">=".
         There is no semantic difference between "<" and "<=" nor
         between ">" and ">=" (even for integer variables!).

       - <declaration> is of one of the forms:
         To define variables as integer:
          "int"
          var [","] var [","] var ... ";"

         To define variables as semi-cont:
          "sec"
          var [","] var [","] var ... ";"

         To define Special Ordered Sets (SOS):
          "sos"
          [sosdescr:] [","] var[:weight] [","] var[:weight] [","] var[:weight] ... "<[=]" sostype[:sosorder] ";" ...
         or:
          "sosx"
          [sosdescr:] var[:weight] [","] var[:weight] [","] var[:weight] ... ";" ...

       - A  _v_a_r  must  start with a letter (either upper or lower
         case), and may contain any number of additional letters,
         numerals, or characters from this list: _[]{}/.&#$%~'@^

         So, the simplest linear problem consists of an objective
         function.

       - Comments can be used with the /* */ syntax, just like in C.
         It can be put anywhere in the file and even over multiple lines.
         lp_solve 4.0.1.11 and newer also supports the C++ line comment //

       - Empty lines are also allowed.

EEXXAAMMPPLLEE
       The simple problem:

       x1 >= 1
       x2 >= 1
       x1 + x2 >= 2
       minimize x1 + x2 (= maximize -(x1 + x2)), with x1 integer

       can be written as follows:

       -x1 -x2;
       (or min: x1 + x2;)
       x1 > 1;
       x2 > 1;
       x1 + x2 > 2;
       int x1;

       The correct result for (x1, x2) is of course (1, 1).
       With the -mps option, llpp__ssoollvvee will accept  MPS  as  input
       format.

BBUUGGSS
       -      Sometimes  problems  are  numerically unstable, and
              the unavoidable  rounding  errors  inside  llpp__ssoollvvee
              will  cause aborts. It is very hard to give general
              solutions to this problem, but try to keep all val
              ues  in your problem in the order of magnitude of 1
              by proper scaling. This  is  almost  always  better
              than  using  llpp__ssoollvvees  built-in scaling (with -s).
              Almost parallel constraints are also not very  good
              for  numerical  stability.  Use  "lp_solve  -v" and
              observe the values of the pivots to  see  if  there
              are any dangerously large or low numbers there.
              Building  llpp__ssoollvvee with long doubles (see the Make
              file) can help to increase numerical stability, but
              will also increase the run time considerably.
              You can consult the author as well if you encounter
              numerical problems, but please remember that it  is
              very easy to formulate an infeasible LP problem, so
              be sure there is a solution.

SSEEEE AALLSSOO
       The implementation of the simplex kernel was mainly  based
       on:
       W.  Orchard-Hays:  "Advanced  Linear Programming Computing
       Techniques", McGraw-Hill 1968
       The mixed integer branch and bound part was inspired by:
       section 6.4 of "An Introduction to Linear Programming  and
       Game  Theory" by Paul R. Thie, second edition published by
       John Wiley and Sons in 1988.
       This book refers to:
       Dakin, R.J., "A Tree Search Algorithm for MILP  Problems",
       Comput. J., 8 (1965) pp. 250-255

AACCKKNNOOWWLLEEDDGGEEMMEENNTTSS
       The  work  of  Jeroen  Dirks  made the transition from the
       basic version 1.5 to the full  version  2.0  possible.  He
       contributed  the  procedural  interface,  a  built-in  MPS
       reader, and many fixes and enhancements to the code.  Most
       of the changes between 3.2 and 4.0 were done by Kjell Eik
       land and Peter Notebaert.

CCOONNTTRRIIBBUUTTEEDD BBYY
       M.R.C.M. Berkelaar
       Eindhoven University of Technology
       Design Automation Section
       P.O. Box 513
       NL-5600 MB Eindhoven, The Netherlands
       phone +31-40-2474792
       E-mail: michel@es.ele.tue.nl

SSTTAATTUUSS
       Use at own risk. Bug reports are welcome, as well as  suc
       cess stories.



                           June 1, 2003               LP_SOLVE(1)
