import java.io.*;
import java.net.*;
import java.util.*;
import org.xml.sax.*;

public class PDBFetch {

    private File data_dir;
    private String pdbid;
    private Vector files;
    private InputStream finput;

    private PDBFetch(File ddir) {
	data_dir = ddir;
	fetchFiles();
    }

    private PDBFetch(String id) {
	pdbid = id;
	fetchFile();
    }

    private void fetchFile(){
	String Line;
	
	System.out.println("Downloading "+pdbid+".pdb");
	try{
	    URL furl = new URL("http://www.rcsb.org/pdb/cgi/export.cgi/"+pdbid+".pdb?format=PDB&pdbId="+pdbid+"&compression=None");
	    
	    BufferedReader txtFile = new BufferedReader(new InputStreamReader(furl.openStream()));
	    
	    PrintWriter fileOut = new PrintWriter(new FileWriter(pdbid+".brk"));
		
	    while((Line = txtFile.readLine()) != null){
		//if(((Line.substring(0,6)).trim()).equals(new String("ATOM"))&&((Line.substring(12,16)).trim()).equals(new String("CA"))){
		if(((Line.substring(0,6)).trim()).equals(new String("ATOM"))){
		    Atom a = new Atom(Integer.parseInt(Line.substring(22,26).trim()),Line.charAt(21),Line.substring(12,16).trim(),Line.substring(17,20).trim(),Double.parseDouble(Line.substring(30,38).trim()),Double.parseDouble(Line.substring(38,46).trim()),Double.parseDouble(Line.substring(46,54).trim()));
		    fileOut.println(a.toString());
		    //fileOut.println(Line);
		}
	    }
	    fileOut.close();
		
	}catch(UnknownHostException e){System.out.println(e);}
	catch(MalformedURLException e){System.out.println(e);}
	catch(IOException e){System.out.println(e);}
	System.out.println("Completed");
	
    }

    private void fetchFiles(){
	String dataLine;
	
	for(int i=0;i<data_dir.list().length;i++){
	    String name = data_dir.list()[i].substring(0,4);

	    File file = new File(data_dir.list()[i].substring(0,4)+".brk");

	    if(!file.isFile()){
		System.out.println("Downloading "+name+".brk");
		try{
		    URL furl = new URL("http://www.rcsb.org/pdb/cgi/export.cgi/"+name+".pdb?format=PDB&pdbId="+name+"&compression=None");
		    
		    BufferedReader txtFile = new BufferedReader(new InputStreamReader(furl.openStream()));
		    
		    PrintWriter fileOut = new PrintWriter(new FileWriter((data_dir.list()[i]).substring(0,4)+".brk"));
		    
		    while((dataLine = txtFile.readLine()) != null){
			fileOut.println(dataLine);
		    }
		    
		    fileOut.close();
		    
		}catch(UnknownHostException e){System.out.println(e);}
		catch(MalformedURLException e){System.out.println(e);}
		catch(IOException e){System.out.println(e);}
		catch(Exception e){System.out.println(e);}
		System.out.println("Completed.");
	    }else
		System.out.println("File "+name+".brk exists.");
	}
    }

    public void convert2xml(){
	try{
	//BufferedReader pdbin = new BufferedReader( new InputStreamReader( new FileInputStream("1a00.brk")));
	InputSource pdbinput = new InputSource(new FileReader("1a00.brk"));
	//PdbSAXParser pdbSAX = new PdbSAXParser();
	//pdbSAX.parse(pdbinput);
	}catch(IOException e){System.out.println(e);}
	//catch(SAXException e){System.out.println(e);}
    }

    public static void main(String[] args) {
	PDBFetch pdbf;

	if (args.length!=2){
	    System.out.println("Usage: java [-f PDBID] [-d DIR]");    	    	   
	    System.out.println("Fetches atomic coord. file entries from PDB");
	    System.out.println("-i PDBID, Single query");
	    System.out.println("-d DIR, Batch query for all the .src files within DIR");
	    System.exit(0);
	}

	if((args[0]).charAt(0)=='-'&&args[0].charAt(1)=='i'){

	    pdbf = new PDBFetch(args[1]);
	    
	}else if((args[0]).charAt(0)=='-'&&args[0].charAt(1)=='d'){

	    pdbf = new PDBFetch(new File(args[1]));

	}else{
	    System.out.println("Usage: java [-i PDBID] [-d DIR]");    	    	   
	    System.out.println("Fetches atomic coord. file entries from PDB");
	    System.out.println("-i PDBID, Single query");
	    System.out.println("-d DIR, Batch query for all the .src files within DIR");
	    System.exit(0);
	}
	
	System.out.println("Download Finished");
	
    }
}
