/*
 * Decompiled with CFR 0.152.
 */
package jsc.util;

import jsc.util.Sort;

public class Rank {
    private int n;
    private int s;
    private int t;
    private final int[] r;
    private final double[] rank;

    public Rank(double[] dArray, double d) {
        this(dArray.length, dArray, d);
    }

    public Rank(int n, double[] dArray, double d) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("No data to rank");
        }
        this.n = n;
        double[] dArray2 = new double[n];
        this.r = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.r[n3] = n3;
            ++n3;
        }
        this.s = 0;
        this.t = 0;
        double[] dArray3 = new double[n];
        n3 = 0;
        while (n3 < n) {
            dArray3[n3] = dArray[n3];
            ++n3;
        }
        Sort.sort(dArray3, this.r, 0, n - 1, true);
        dArray2[n - 1] = n - 1;
        --n;
        n3 = 0;
        while (n3 < n) {
            if (Math.abs(dArray3[n3] - dArray3[n3 + 1]) > d) {
                dArray2[n3] = n3;
            } else {
                int n4 = 1;
                n2 = n3 + 1;
                while (n2 < n) {
                    if (!(Math.abs(dArray3[n2] - dArray3[n2 + 1]) <= d)) break;
                    ++n4;
                    ++n2;
                }
                double d2 = (double)n3 + 0.5 * (double)n4;
                int n5 = 0;
                while (n5 <= n4) {
                    dArray2[n3 + n5] = d2;
                    ++n5;
                }
                int n6 = n4 * (n4 + 1);
                this.s += n6;
                this.t += n6 * (n4 + 2);
                n3 += n4;
            }
            ++n3;
        }
        this.rank = new double[++n];
        n2 = 0;
        while (n2 < n) {
            this.rank[this.r[n2]] = dArray2[n2] + 1.0;
            ++n2;
        }
    }

    public int getCorrectionFactor1() {
        return this.t;
    }

    public int getCorrectionFactor2() {
        return this.s;
    }

    public int getN() {
        return this.n;
    }

    public double getRank(int n) {
        return this.rank[n];
    }

    public double[] getRanks() {
        return this.rank;
    }

    public int getSortIndex(int n) {
        return this.r[n];
    }

    public int[] getSortIndexes() {
        return this.r;
    }

    public boolean hasTies() {
        return this.t > 0;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{5.0, 3.0, 0.0, 7.0, 5.0, 8.0, 9.0, 1.0, 5.0, 4.0};
            Rank rank = new Rank(dArray, 0.0);
            double[] dArray2 = rank.getRanks();
            int[] nArray = rank.getSortIndexes();
            int n = 0;
            while (n < rank.getN()) {
                System.out.println("Rank of " + dArray[n] + " is " + dArray2[n]);
                ++n;
            }
            n = 0;
            while (n < rank.getN()) {
                System.out.println("Rank " + n + ": " + dArray2[nArray[n]]);
                ++n;
            }
        }
    }
}

