/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot;

import jsc.swt.plot.AxisModel;
import jsc.swt.text.PatternFormat;
import jsc.swt.text.RealFormat;
import jsc.util.Scale;

public class LinearAxisModel
implements AxisModel {
    String label;
    private Scale scale;
    private RealFormat tickLabelFormatter;

    public LinearAxisModel(String string, Scale scale, String string2) {
        this(string, scale, new PatternFormat(string2));
    }

    public LinearAxisModel(String string, Scale scale, RealFormat realFormat) {
        this.label = string;
        this.scale = scale;
        this.tickLabelFormatter = realFormat;
    }

    public LinearAxisModel() {
        this("", new Scale(), "");
    }

    public Object clone() {
        return this.copy();
    }

    public LinearAxisModel copy() {
        LinearAxisModel linearAxisModel = new LinearAxisModel(this.label, this.scale, this.tickLabelFormatter);
        return linearAxisModel;
    }

    public double getLength() {
        return this.scale.getLength();
    }

    public double getMin() {
        return this.scale.getMin();
    }

    public double getMax() {
        return this.scale.getMax();
    }

    public int getTickCount() {
        return this.scale.getNumberOfTicks();
    }

    public double getFirstTickValue() {
        return this.scale.getFirstTickValue();
    }

    public double getLastTickValue() {
        return this.scale.getLastTickValue();
    }

    public String getTickLabel(int n) {
        double d = this.scale.getTickValue(n);
        if (d == 0.0) {
            return "0";
        }
        String string = this.tickLabelFormatter.format(d);
        return string;
    }

    public double getTickValue(int n) {
        return this.scale.getTickValue(n);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public double getStep() {
        return this.scale.getStep();
    }

    public void setTickLabelFormat(RealFormat realFormat) {
        this.tickLabelFormatter = realFormat;
    }
}

